/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum RepeatMode {
    NONE("n"),
    MINUTE("mi"),
    HOUR("h"),
    DAY("d"),
    WEEK("w"),
    MONTH("m"),
    YEAR("y");

    private final String value;
    private static final Map<String, RepeatMode> map;

    private RepeatMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static RepeatMode forValue(String value) {
        return map.getOrDefault(value, NONE);
    }

    static {
        map = Maps.newHashMapWithExpectedSize((int)7);
        for (RepeatMode value : RepeatMode.values()) {
            map.put(value.getValue(), value);
        }
    }
}

