/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum RunningState {
    PREPARE("prepare"),
    RUNNING("running"),
    COMPLETED("completed"),
    SUSPEND("suspend"),
    AUTO("auto"),
    ERROR("error");

    private final String value;
    public static final Map<String, String> foreColorMap;

    private RunningState(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static String getForeColor(String status) {
        return foreColorMap.get(status);
    }

    static {
        foreColorMap = Maps.newHashMapWithExpectedSize((int)3);
        foreColorMap.put(COMPLETED.getValue(), "#26B175");
        foreColorMap.put(RUNNING.getValue(), "#55A0F5");
        foreColorMap.put(ERROR.getValue(), "#E1453E");
    }
}

