/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.helper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.mvc.SessionManager;
import kd.bos.service.metadata.MetadataServiceImpl;

public class FormServiceHelper {
    private static final Log log = LogFactory.getLog(FormServiceHelper.class);
    private static final String FORM_ID = "formId";

    public static IFormView getFormView(Map<String, Object> formParams) {
        if (formParams == null) {
            log.warn("FormServiceHelper--> \u754c\u9762\u53c2\u6570\u4e3anull");
            return null;
        }
        if (!formParams.containsKey(FORM_ID)) {
            log.warn("FormServiceHelper--> \u754c\u9762\u53c2\u6570\u4e0d\u5305\u542bformId");
            return null;
        }
        FormServiceImpl formService = new FormServiceImpl();
        String configStr = formService.getConfig(formParams);
        if (!FormServiceHelper.validateInvokeAction(configStr)) {
            return null;
        }
        Map config = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        MetadataServiceImpl metadataService = new MetadataServiceImpl();
        String formId = (String)config.get(FORM_ID);
        String metaStr = metadataService.loadFormMeta((String)config.get(FORM_ID));
        if (StringUtils.isBlank((CharSequence)metaStr)) {
            log.warn("FormServiceHelper--> \u8bfb\u53d6\u8868\u5355UI\u5143\u6570\u636e\u4e3a\u7a7a, formId: {}", (Object)formId);
            return null;
        }
        String currentPageId = (String)config.get("pageId");
        SessionManager.getCurrent().setRequestThread(true);
        IFormView formView = SessionManager.getCurrent().getView(currentPageId);
        if (!FormServiceHelper.loadData((FormService)formService, formView)) {
            return null;
        }
        return formView;
    }

    private static boolean loadData(FormService formService, IFormView formView) {
        String response = formService.invokeAction(formView.getPageId(), "", "loadData", new Object[0], Collections.emptyList());
        List responseList = (List)SerializationUtils.fromJsonString((String)response, List.class);
        for (Object responseObj : responseList) {
            Map firstParam;
            Map responseMap = (Map)responseObj;
            String action = (String)responseMap.get("a");
            List params = (List)responseMap.get("p");
            if ("showErrMsg".equalsIgnoreCase(action)) {
                firstParam = (Map)params.get(0);
                log.warn("FormServiceHelper--> loadData--> {}, {}", firstParam.get("errorTitle"), firstParam.get("errorInfo"));
                return false;
            }
            if (!"showForm".equals(action)) continue;
            firstParam = (Map)params.get(0);
            String innerPageId = (String)firstParam.get("pageId");
            formService.invokeAction(innerPageId, "", "loadData", new Object[0], Collections.emptyList());
        }
        return true;
    }

    private static boolean validateInvokeAction(String actionResult) {
        List lstActRet;
        if ((actionResult.contains("\"errorTitle\":") || actionResult.contains("\"ShowNotificationMsg\":")) && (lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class)) != null) {
            for (Object object : lstActRet) {
                Map itemMap = (Map)object;
                List para = (List)itemMap.get("p");
                if (((String)itemMap.get("a")).equalsIgnoreCase("showErrMsg")) {
                    Map firstParam = (Map)para.get(0);
                    log.warn("FormServiceHelper--> validateInvokeAction--> {}, {}", firstParam.get("errorTitle"), firstParam.get("errorInfo"));
                    return false;
                }
                if (!((String)itemMap.get("a")).equalsIgnoreCase("ShowNotificationMsg") || 0 == (Integer)((Map)para.get(0)).get("type")) continue;
                Map firstParam = (Map)para.get(0);
                log.warn("FormServiceHelper--> validateInvokeAction--> {}, {}", firstParam.get("type"), firstParam.get("content"));
                return false;
            }
        }
        return true;
    }
}

