/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.serviece.flow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.DealTypeEnum;

public class FlowDefineService {
    private static final String algo = FlowDefineService.class.getName();

    public static List<Long> getFlowDefineIdByLeaderId(Long userId) {
        if (userId == null || userId == 0L) {
            return null;
        }
        String sql = "select a.fid from t_phm_flowdefine a left join t_phm_flowleader b on a.fid = b.fid where fbasedataid = ?";
        ArrayList flowIds = Lists.newArrayListWithCapacity((int)10);
        try (DataSet ds = DB.queryDataSet((String)algo, (DBRoute)CommonConsts.ROUTE_PHM, (String)sql, (Object[])new Object[]{userId});){
            for (Row row : ds) {
                flowIds.add(row.getLong(0));
            }
        }
        return flowIds;
    }

    public static boolean isFlowDefineLeader(Long userId, Long flowDefineId) {
        QFilter filter = new QFilter("id", "=", (Object)flowDefineId);
        filter.and("flowleader.fbasedataid", "=", (Object)userId);
        int count = ORM.create().count("algo", "phm_flow_define", filter.toArray());
        return count > 0;
    }

    public static Set<Long> getNodeResource(String resourceType, Long processId, String nodeId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT B.fresourceid FROM t_phm_flownode A LEFT JOIN  t_phm_flowresource B ", new Object[0]);
        sqlBuilder.append("ON A.fentryid = b.fentryid WHERE ", new Object[0]);
        sqlBuilder.append("A.FID = ? AND A.fnodeid = ? ", new Object[]{processId, nodeId});
        sqlBuilder.append("AND B.fresourcetype = ? ", new Object[]{resourceType});
        sqlBuilder.append("AND B.fdealtype = ?", new Object[]{DealTypeEnum.MANUAL.getName()});
        HashSet<Long> resourceIds = new HashSet<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"queryNodeRoesource", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                resourceIds.add(row.getLong(0));
            }
        }
        return resourceIds;
    }
}

