/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.serviece.workbench;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessErrorTypeEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.common.serviece.workbench.impl.IDealPorcessErrorLog;
import kd.mmc.phm.common.util.datatemp.FixTempConfigParse;
import kd.mmc.phm.common.util.datatemp.MultiTempConfigParse;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import kd.mmc.phm.common.util.process.ProcessUpdateUtil;

public class DealProcessErrorDateTempLog
implements IDealPorcessErrorLog {
    private DynamicObject processHistory;
    private DynamicObject errorLog;
    private RequestContext requestContext;

    public DealProcessErrorDateTempLog(DynamicObject processHistory, DynamicObject errorLog, RequestContext requestContext) {
        this.processHistory = processHistory;
        this.errorLog = errorLog;
        this.requestContext = requestContext;
    }

    @Override
    public void dealError() {
        if (this.processHistory == null || this.errorLog == null) {
            return;
        }
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        String errorType = this.errorLog.getString("errortype");
        String dealType = this.errorLog.getString("dealtype");
        if (StringUtils.equals((CharSequence)errorType, (CharSequence)ProcessErrorTypeEnum.MANUAL_AUDIT_ERR.getValue())) {
            this.dealManualAuditError();
        } else if (StringUtils.equals((CharSequence)errorType, (CharSequence)ProcessErrorTypeEnum.AUTO_AUDIT_ERR.getValue())) {
            this.dealAutoAuditError();
        } else if (StringUtils.equals((CharSequence)errorType, (CharSequence)ProcessErrorTypeEnum.AUTO_UPDATE_ERR.getValue())) {
            this.dealAutoUpdateError();
        } else if (StringUtils.equals((CharSequence)errorType, (CharSequence)ProcessErrorTypeEnum.AUTO_LOAD_ERR.getValue())) {
            this.dealAutoLoadError();
        }
    }

    private void dealAutoLoadError() {
        long resourceId = this.errorLog.getLong("resource");
        long processHistoryId = this.processHistory.getLong("id");
        long entryNodeId = this.errorLog.getLong("node");
        DynamicObject templete = QueryServiceHelper.queryOne((String)"phm_billtemp", (String)"tempclassify,cellconf", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)resourceId)});
        if (templete == null) {
            return;
        }
        String tempclassify = templete.getString("tempclassify");
        long cellConfId = templete.getLong("cellconf");
        try {
            this.cleadErrorLog();
            if ("2".equals(tempclassify)) {
                MultiTempConfigParse.getDataBytempId(resourceId, processHistoryId, entryNodeId, null);
            } else if ("3".equals(tempclassify)) {
                FixTempConfigParse.getDataByCellConfId(cellConfId, processHistoryId, entryNodeId, null);
            }
        }
        catch (Exception e) {
            this.insertErrorMsg(ProcessErrorTypeEnum.AUTO_LOAD_ERR, DealTypeEnum.AUTO, e);
        }
    }

    private void dealAutoUpdateError() {
    }

    private void dealAutoAuditError() {
    }

    private void dealManualAuditError() {
        Long historyId = this.processHistory.getLong("id");
        Long nodeResourceId = this.errorLog.getLong("noderesource");
        Long nodeId = this.errorLog.getLong("node");
        Long resourceId = this.errorLog.getLong("resource");
        try (TXHandle th = TX.requiresNew();){
            try {
                boolean isFinish;
                this.cleadErrorLog();
                QFilter qFilter = new QFilter("id", "=", (Object)nodeResourceId);
                DynamicObject nodeResource = QueryServiceHelper.queryOne((String)"phm_process_resources", (String)"resource_data", (QFilter[])qFilter.toArray());
                Long dataTempHistroyId = nodeResource.getLong("resource_data");
                Long processId = this.processHistory.getLong("flowdefine_id");
                DynamicObject dataTempHistory = BusinessDataServiceHelper.loadSingle((Object)dataTempHistroyId, (String)"phm_filldata_history");
                dataTempHistory.set("status", (Object)StatusEnum.AUDIT.getValue());
                dataTempHistory.set("modifytime", (Object)new Date());
                SaveServiceHelper.update((DynamicObject)dataTempHistory);
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"phm_process_resources");
                nodeResource = new DynamicObject((DynamicObjectType)dt, (Object)nodeResourceId);
                nodeResource.set("resource_modifytime", (Object)new Date());
                nodeResource.set("resource_status", (Object)StatusEnum.AUDIT.getValue());
                SaveServiceHelper.update((DynamicObject)nodeResource);
                int isCheckNodeTaskFinish = ProcessUpdateUtil.updateTaskProgress(nodeId, resourceId, 1, "1");
                if (isCheckNodeTaskFinish != 0 && (isFinish = ProcessQueryUtil.queryNodeFinish(nodeId))) {
                    ProcessUpdateUtil.updateNodeStatusByNodeEntryId(nodeId, RunningState.COMPLETED.getValue());
                    DynamicObjectCollection nodeEntryList = ProcessQueryUtil.queryNodeEntry(historyId);
                    ProcessUpdateUtil.createNextNodeTask(nodeId, historyId, processId, nodeEntryList);
                }
            }
            catch (Exception e) {
                th.markRollback();
                new ProcessCalcLogService().insertErrorLog(ProcessErrorTypeEnum.MANUAL_AUDIT_ERR, DealTypeEnum.MANUAL, this.errorLog, e);
            }
        }
    }

    private void cleadErrorLog() {
        Long historyId = this.processHistory.getLong("id");
        Long nodeResourceId = this.errorLog.getLong("noderesource");
        Long nodeId = this.errorLog.getLong("node");
        Long resourceId = this.errorLog.getLong("resource");
        Long roleId = this.errorLog.getLong("roles.fbasedataid");
        ProcessCalcLogService.clearErrorLog(null, historyId, nodeId, nodeResourceId, resourceId, roleId);
    }

    private void insertErrorMsg(ProcessErrorTypeEnum errorType, DealTypeEnum dealTypeEnum, Exception exception) {
        new ProcessCalcLogService().insertErrorLog(errorType, dealTypeEnum, this.errorLog, exception);
    }
}

