/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.serviece.workbench;

import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.AutoSubmitParam;
import kd.mmc.phm.common.domian.process.ProcessCalcLogInfo;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessErrorTypeEnum;
import kd.mmc.phm.common.enums.RunningState;

public class ProcessCalcLogService {
    private ProcessCalcLogInfo calcLogInfo;

    public void createErrorLog(ProcessErrorTypeEnum errorType, DealTypeEnum dealType, Long historyId, Long nodeId, String nodeName, Long nodeResourceId, String resourceType, Long resourceId, String resourceName, String resourceVsion, String resourceNumber, List<Long> roles, String roleName, Long userId, String userName, String eventid, String errormsgTag, String endNodesId, String startNodeId) {
        this.calcLogInfo = new ProcessCalcLogInfo(errorType, dealType, historyId, nodeId, nodeName, nodeResourceId, resourceType, resourceId, resourceName, resourceVsion, resourceNumber, roles, roleName, userId, userName, eventid, errormsgTag, endNodesId, startNodeId);
        String errorMsg = this.createErrorMsg(this.calcLogInfo.getErrorType().getName(), this.calcLogInfo.getDealType().getValue(), this.calcLogInfo.getNodeName(), this.calcLogInfo.getResourceName(), this.calcLogInfo.getResourceVsion(), this.calcLogInfo.getResourceNumber(), this.calcLogInfo.getRoleName(), this.calcLogInfo.getUserName());
        this.calcLogInfo.setErrorMsg(errorMsg);
    }

    public DynamicObject coverToDynamicObject(ProcessCalcLogInfo calcLogInfo) {
        if (calcLogInfo == null) {
            return null;
        }
        DynamicObject errorLog = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_calclog"));
        errorLog.set("errormsg", (Object)calcLogInfo.getErrorMsg());
        errorLog.set("errormsg_tag", (Object)calcLogInfo.getErrormsgTag());
        errorLog.set("history_id", (Object)calcLogInfo.getHistoryId());
        errorLog.set("node_id", (Object)calcLogInfo.getNodeId());
        errorLog.set("resourcetype", (Object)calcLogInfo.getResourceType());
        errorLog.set("resource_id", (Object)calcLogInfo.getResourceId());
        errorLog.set("errortype", (Object)calcLogInfo.getErrorType().getValue());
        errorLog.set("dealtype", (Object)calcLogInfo.getDealType().getName());
        List<Long> roleIds = calcLogInfo.getRoles();
        if (roleIds != null && !roleIds.isEmpty()) {
            DynamicObjectCollection roles = errorLog.getDynamicObjectCollection("roles");
            for (Long roleId : roleIds) {
                DynamicObject roleEntry = roles.addNew();
                roleEntry.set(2, (Object)roleId);
            }
        }
        errorLog.set("handler_id", (Object)calcLogInfo.getUserId());
        errorLog.set("enable", (Object)EnableEnum.ENABLE.getValue());
        errorLog.set("noderesource", (Object)calcLogInfo.getNodeResourceId());
        errorLog.set("eventid", (Object)calcLogInfo.getEventid());
        errorLog.set("startnodeid", (Object)calcLogInfo.getStartNodeId());
        errorLog.set("endnodes", (Object)calcLogInfo.getEndNodesId());
        errorLog.set("createdate", (Object)new Date());
        return errorLog;
    }

    public void insertErrorLog() {
        DynamicObject errorLog = this.coverToDynamicObject(this.calcLogInfo);
        ProcessCalcLogService.addHistoryErrrMsg(this.calcLogInfo.getHistoryId(), this.calcLogInfo.getErrorMsg());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{errorLog});
    }

    public DynamicObjectCollection getCurrentErrorLogs() {
        String errorType = this.calcLogInfo.getErrorType().getValue();
        String dealType = this.calcLogInfo.getDealType().getName();
        Long historyId = this.calcLogInfo.getHistoryId();
        Long nodeId = this.calcLogInfo.getNodeId();
        Long nodeReourceId = this.calcLogInfo.getNodeResourceId();
        String resourceType = this.calcLogInfo.getResourceType();
        Long resourceId = this.calcLogInfo.getResourceId();
        QFilter filter = new QFilter("history", "=", (Object)historyId);
        if (nodeReourceId != null && nodeReourceId != 0L) {
            filter.and(new QFilter("noderesource", "=", (Object)nodeReourceId));
        } else {
            filter.and(new QFilter("node", "=", (Object)nodeId));
            filter.and(new QFilter("resourcetype", "=", (Object)resourceType));
            filter.and(new QFilter("resource", "=", (Object)resourceId));
        }
        filter.and(new QFilter("errortype", "=", (Object)errorType));
        filter.and(new QFilter("dealtype", "=", (Object)dealType));
        return QueryServiceHelper.query((String)"phm_process_calclog", (String)"id", (QFilter[])filter.toArray());
    }

    public void clearCurrentErrorLog() {
        DynamicObjectCollection errorLogs = this.getCurrentErrorLogs();
        if (errorLogs == null || errorLogs.isEmpty()) {
            return;
        }
        List<Object> errorLogIds = errorLogs.stream().map(item -> item.get(0)).collect(Collectors.toList());
        this.disableErrorLog(errorLogIds);
    }

    public void disableErrorLog(List<Object> ids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE t_phm_process_calclog  SET fenable = '0' WHERE ", new Object[0]);
        sqlBuilder.appendIn(" fid", ids);
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
    }

    public String createErrorMsg(String errorType, String dealType, String nodeName, String resourceName, String reoureceVersionNumber, String resourceNumber, String roleName, String userName) {
        StringBuilder errorMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"[%S][%s\u5904\u7406]\u8282\u70b9\uff1a[%S]\u8d44\u6e90\u540d\u79f0\uff1a[%s]", (String)"ProcessCalcLogService_0", (String)"mmc-phm-common", (Object[])new Object[0]), errorType, dealType, nodeName, resourceName));
        if (StringUtils.isEmpty((CharSequence)reoureceVersionNumber)) {
            reoureceVersionNumber = "";
        }
        errorMsg.append(ResManager.loadKDString((String)"\u8d44\u6e90\u7248\u672c\uff1a[", (String)"ProcessCalcLogService_1", (String)"mmc-phm-common", (Object[])new Object[0])).append(reoureceVersionNumber).append("]");
        errorMsg.append(ResManager.loadKDString((String)"\u8d44\u6e90\u7f16\u7801\uff1a[", (String)"ProcessCalcLogService_2", (String)"mmc-phm-common", (Object[])new Object[0])).append(resourceNumber).append("]");
        if (!StringUtils.isEmpty((CharSequence)roleName)) {
            errorMsg.append(ResManager.loadKDString((String)"\u89d2\u8272\uff1a[", (String)"ProcessCalcLogService_3", (String)"mmc-phm-common", (Object[])new Object[0])).append(roleName).append("]");
        }
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            errorMsg.append(ResManager.loadKDString((String)"\u5904\u7406\u4eba\uff1a[", (String)"ProcessCalcLogService_4", (String)"mmc-phm-common", (Object[])new Object[0])).append(userName).append("]");
        }
        return errorMsg.toString();
    }

    public void insertErrorLog(ProcessErrorTypeEnum errorType, DealTypeEnum dealType, AutoSubmitParam autoSubmitParam, Exception exception) {
        Long nodeId = autoSubmitParam.getEntryNodeId();
        String nodeName = ProcessCalcLogService.getNodeName(nodeId);
        Long historyId = autoSubmitParam.getProcessHistoryId();
        Long resourceId = autoSubmitParam.getResourceId();
        String resourceType = autoSubmitParam.getResourceType();
        QFilter resourceQfilter = new QFilter("id", "=", (Object)resourceId);
        DynamicObject resourceObj = QueryServiceHelper.queryOne((String)"phm_billtemp", (String)"name,number", (QFilter[])resourceQfilter.toArray());
        String resourceName = resourceObj == null ? "" : resourceObj.getString("name");
        String resourceNumber = resourceObj == null ? "" : resourceObj.getString("number");
        List<Long> roleIds = ProcessCalcLogService.getProcessResourceRoleIds(nodeId, resourceType, resourceId);
        this.createErrorLog(errorType, dealType, historyId, nodeId, nodeName, null, resourceType, resourceId, resourceName, null, resourceNumber, roleIds, null, null, null, null, ProcessCalcLogService.getExceptionMsg(exception), null, null);
        this.clearCurrentErrorLog();
        this.insertErrorLog();
    }

    public void insertErrorLog(ProcessErrorTypeEnum errorType, DealTypeEnum dealType, DynamicObject errorLog, Exception exception) {
        Long historyId = errorLog.getLong("history");
        Long nodeResourceId = errorLog.getLong("noderesource");
        Long nodeId = errorLog.getLong("node");
        Long resourceId = errorLog.getLong("resource");
        String resourceType = errorLog.getString("resourcetype");
        Long roleId = errorLog.getLong("roles.fbasedataid");
        ArrayList roleIds = Lists.newArrayList((Object[])new Long[]{roleId});
        Long userId = errorLog.getLong("handler");
        String errorMsg = errorLog.getString("errormsg");
        String errorMsgDetail = ProcessCalcLogService.getExceptionMsg(exception);
        this.createErrorLog(errorType, dealType, historyId, nodeId, null, nodeResourceId, resourceType, resourceId, null, null, null, roleIds, null, userId, null, null, errorMsgDetail, null, null);
        this.clearCurrentErrorLog();
        this.calcLogInfo.setErrorMsg(errorMsg);
        this.insertErrorLog();
    }

    public static String getExceptionMsg(Exception exception) {
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getNodeName(Long nodeId) {
        QFilter nodeQfilter = new QFilter("id", "=", (Object)nodeId);
        DynamicObject nodeObj = QueryServiceHelper.queryOne((String)"phm_process_node", (String)"node_name", (QFilter[])nodeQfilter.toArray());
        return nodeObj != null ? nodeObj.getString("node_name") : "";
    }

    public static List<Long> getProcessResourceRoleIds(Long nodeId, String resourceType, Long resourceId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fbasedataid from t_phm_node_task a left join t_phm_task_roles b on a.fdetailid = b.fdetailid where ", new Object[0]);
        sqlBuilder.append(" a.fentryid = ? and a.fresourceid = ? and a.fresourcetype = ? ", new Object[]{nodeId, resourceId, resourceType});
        try (DataSet ds = DB.queryDataSet((String)"ProcessCaclLogSerrvice", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            if (ds.hasNext()) {
                ArrayList roleIds = Lists.newArrayListWithCapacity((int)4);
                for (Row row : ds) {
                    roleIds.add(row.getLong(0));
                }
                ArrayList arrayList = roleIds;
                return arrayList;
            }
        }
        return null;
    }

    public static void clearErrorLog(String errorType, Long historyId, Long nodeId, Long nodeResourceId, Long resourceId, Long roleId) {
        SqlBuilder errorSql = new SqlBuilder();
        errorSql.append("select distinct a.fid from t_phm_process_calclog a left join t_phm_calclogrole b on a.fid = b.fid where ", new Object[0]);
        errorSql.append("a.fhistoryid = ? and a.fnodeid = ? ", new Object[]{historyId, nodeId});
        if (nodeResourceId != null && nodeResourceId != 0L) {
            errorSql.append(" and a.fnoderesourceid = ? ", new Object[]{nodeResourceId});
        } else {
            if (resourceId != null && resourceId != 0L) {
                errorSql.append(" and a.fresource = ?", new Object[]{resourceId});
            }
            if (roleId != null) {
                errorSql.append(" and b.fbasedataid = ?", new Object[]{roleId});
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errorType)) {
            if (StringUtils.equals((CharSequence)ProcessErrorTypeEnum.MANUAL_SUBMIT_ERR.getValue(), (CharSequence)errorType)) {
                errorSql.append(" and (ferrortype = ? or ferrortype = ?)", new Object[]{errorType, ProcessErrorTypeEnum.MANUAL_SAVE_ERR.getValue()});
            } else {
                errorSql.append(" and ferrortype = ?", new Object[]{errorType});
            }
        }
        try (DataSet ds = DB.queryDataSet((String)"ProcessCalcLogService", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)errorSql);){
            if (ds.hasNext()) {
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)10);
                for (Row row : ds) {
                    ids.add(row.get(0));
                }
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("UPDATE t_phm_process_calclog  SET fenable = '0' WHERE ", new Object[0]);
                sqlBuilder.appendIn("fid", (List)ids);
                DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
            }
        }
    }

    public static void addHistoryErrrMsg(Long historyId, String errorMsg) {
        String updateSql = "UPDATE T_PHM_PROCESS_HISTORY SET FSTATUS = ?, FEXCEPTIONDESC = ? WHERE FID = ?";
        DB.update((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{RunningState.ERROR.getValue(), errorMsg, historyId});
    }

    public static void clearProcessError(Long historyId) {
        SqlBuilder countErrorMsg = new SqlBuilder();
        countErrorMsg.append("SELECT COUNT(1) FROM t_phm_process_calclog WHERE fhistoryid = ? and fenable = '1'", new Object[]{historyId});
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"ProcessCalcLogService", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)countErrorMsg);){
            for (Row row : ds) {
                count = row.getInteger(0);
            }
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"parentid,copystatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)historyId)});
        if (dynamicObject == null) {
            return;
        }
        long parentId = dynamicObject.getLong("parentid");
        String copyStatus = dynamicObject.getString("copystatus");
        if (count > 0) {
            return;
        }
        SqlBuilder clearErrorMsg = new SqlBuilder();
        clearErrorMsg.append("UPDATE t_phm_process_history  SET fexceptiondesc = ? ,", new Object[]{""});
        if (parentId == 0L) {
            clearErrorMsg.append(" fstatus = ? ", new Object[]{RunningState.RUNNING.getValue()});
        } else if (StringUtils.equals((CharSequence)RunningState.ERROR.getValue(), (CharSequence)copyStatus)) {
            clearErrorMsg.append(" fstatus = ? ", new Object[]{RunningState.RUNNING.getValue()});
        } else {
            clearErrorMsg.append(" fstatus = fcopystatus ", new Object[0]);
        }
        clearErrorMsg.append(" WHERE fid = ? ", new Object[]{historyId});
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)clearErrorMsg);
    }

    public static DynamicObjectCollection getRightErrorLogs(Long historyId, List<Long> roleIds) {
        QFilter filter = new QFilter("history", "=", (Object)historyId);
        if (roleIds != null && !roleIds.isEmpty()) {
            filter.and(new QFilter("roles.fbasedataid", "in", roleIds));
        }
        filter.and(new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()));
        return QueryServiceHelper.query((String)"phm_process_calclog", (String)"history,errortype,dealtype,node,noderesource,resourcetype,resource,roles.fbasedataid,handler,endnodes,startnodeid,errormsg", (QFilter[])filter.toArray());
    }

    public static void changeProcessManualUpdateStatus(Long historyId, int updatestatus) {
        if (historyId == null || historyId == 0L) {
            return;
        }
        SqlBuilder updateSql = new SqlBuilder();
        updateSql.append("UPDATE t_phm_process_history SET ", new Object[0]);
        if (updatestatus > 0) {
            updateSql.append("fupdatestatus = ? ", new Object[]{updatestatus});
        } else {
            updateSql.append("fupdatestatus = fupdatestatus - 1 ", new Object[0]);
        }
        updateSql.append("WHERE fid = ?", new Object[]{historyId});
        if (updatestatus == 0) {
            updateSql.append(" and fupdatestatus > 0", new Object[0]);
        }
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)updateSql);
        ProcessCalcLogService.clearProcessError(historyId);
    }

    public static int hasErrorLog(Long history, Long nodeId, Long nodeResourceId) {
        QFilter qFilter = new QFilter("history", "=", (Object)history);
        if (nodeId != null && nodeId != 0L) {
            qFilter.and(new QFilter("node", "=", (Object)nodeId));
        }
        if (nodeResourceId != null && nodeResourceId != 0L) {
            qFilter.and(new QFilter("noderesource", "not in", (Object)nodeResourceId));
        }
        qFilter.and(new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()));
        return ORM.create().count("ProcessCalcLogService", "phm_process_calclog", qFilter.toArray());
    }
}

