/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.spread;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;

public class SpreadPraseUtil {
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final ThreadLocal<DecimalFormat> decimalFormat = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat();
        }
    };

    public static Object getCellValue(Map<String, Object> dataTable, Integer colIndex, Integer rowIndex, int formatType) {
        Map cell;
        Map row = (Map)dataTable.get(String.valueOf(rowIndex));
        Map map = cell = row == null ? null : (Map)row.get(String.valueOf(colIndex));
        if (formatType == 1) {
            return SpreadPraseUtil.getCellValue(cell);
        }
        return SpreadPraseUtil.getCellFormatValue(cell);
    }

    public static Object getCellValue(Map<String, Object> cell) {
        if (cell == null) {
            return null;
        }
        Object value = cell.get("value");
        if (value == null) {
            return null;
        }
        if (value instanceof Integer || value instanceof BigDecimal || value instanceof String && !((String)value).contains("OADate")) {
            return value;
        }
        if (value instanceof String && ((String)value).contains("OADate")) {
            String datafmt;
            Map style = (Map)cell.get("style");
            Map autoFormatter = style == null ? null : (Map)style.get("autoFormatter");
            String string = datafmt = autoFormatter == null ? null : (String)autoFormatter.get("formatCached");
            if (datafmt != null) {
                dateFormat.get().applyPattern(datafmt);
            }
            return SpreadUtils.oaDateToDate((String)value);
        }
        return value;
    }

    public static String getCellFormatValue(Map<String, Object> cell) {
        if (cell == null) {
            return null;
        }
        Object value = cell.get("value");
        if (value == null) {
            return null;
        }
        try {
            String formatter;
            Map style = (Map)cell.get("style");
            String string = formatter = style == null ? null : (String)style.get("formatter");
            if (value instanceof BigDecimal || value instanceof Integer) {
                if (formatter != null) {
                    decimalFormat.get().applyPattern(formatter);
                    return decimalFormat.get().format(value);
                }
                return value.toString();
            }
            if (value instanceof String && ((String)value).contains("OADate")) {
                String datafmt;
                Map autoFormatter = style == null ? null : (Map)style.get("autoFormatter");
                String string2 = datafmt = autoFormatter == null ? null : (String)autoFormatter.get("formatCached");
                if (datafmt != null) {
                    dateFormat.get().applyPattern(datafmt);
                }
                return dateFormat.get().format(SpreadUtils.oaDateToDate((String)value));
            }
        }
        catch (Exception e) {
            return String.valueOf(value);
        }
        return value instanceof String ? (String)value : String.valueOf(value);
    }

    public static Set<Cell> getSelectCells(String spreadString) {
        Map<String, Object> spreadObject = SpreadPraseUtil.getSpreadObject(spreadString);
        return SpreadPraseUtil.getSelectCells(spreadObject);
    }

    public static Set<Cell> getSelectCells(Map<String, Object> spreadObject) {
        Map<String, Object> selections = SpreadPraseUtil.getSpreadSeletionObject(spreadObject);
        List<Map<String, Object>> spans = SpreadPraseUtil.getSpreadSpanObject(spreadObject);
        return SpreadPraseUtil.getSelectCells(selections, spans);
    }

    public static Map<String, Object> getSpreadObject(String spreadString) {
        String spreadJson = SpreadUtils.convertSpreadJson(spreadString);
        return (Map)SerializationUtils.fromJsonString((String)spreadJson, Map.class);
    }

    public static Map<String, Object> getSpreadSheetsObject(Map<String, Object> spreadObject) {
        return spreadObject == null ? null : (Map)spreadObject.get("sheets");
    }

    public static Map<String, Object> getSpreadSheet1Object(Map<String, Object> spreadObject) {
        Map<String, Object> spreadSheetsObject = SpreadPraseUtil.getSpreadSheetsObject(spreadObject);
        return spreadSheetsObject == null ? null : (Map)spreadSheetsObject.get("Sheet1");
    }

    public static Map<String, Object> getSpreadSeletionObject(Map<String, Object> spreadObject) {
        Map<String, Object> sheet1 = SpreadPraseUtil.getSpreadSheet1Object(spreadObject);
        return sheet1 == null ? null : (Map)sheet1.get("selections");
    }

    public static List<Map<String, Object>> getSpreadSpanObject(Map<String, Object> spreadObject) {
        Map<String, Object> sheet1 = SpreadPraseUtil.getSpreadSheet1Object(spreadObject);
        return sheet1 == null ? null : (List)sheet1.get("spans");
    }

    public static Map<String, Object> getSpreadDataTableObject(Map<String, Object> spreadObject) {
        Map<String, Object> sheet1 = SpreadPraseUtil.getSpreadSheet1Object(spreadObject);
        Map data = sheet1 == null ? null : (Map)sheet1.get("data");
        return data == null ? null : (Map)data.get("dataTable");
    }

    public static Set<Cell> getSelectCells(Map<String, Object> selections, List<Map<String, Object>> spans) {
        Integer colCount;
        Integer rowCount;
        Integer length;
        Integer n = length = selections == null ? null : (Integer)selections.get("length");
        if (length == null || length == 0) {
            return null;
        }
        HashSet selectCells = Sets.newHashSetWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            Map selectionMap = (Map)selections.get("" + i);
            if (selectionMap == null) continue;
            int row = (Integer)selectionMap.get("row");
            int col = (Integer)selectionMap.get("col");
            rowCount = (Integer)selectionMap.get("rowCount");
            colCount = (Integer)selectionMap.get("colCount");
            if (row == -1) {
                ++row;
            }
            if (col == -1) {
                ++col;
            }
            int rowMaxIndex = row + rowCount;
            int colMaxIndex = col + colCount;
            for (int rowIndex = row; rowIndex < rowMaxIndex; ++rowIndex) {
                for (int colIndex = col; colIndex < colMaxIndex; ++colIndex) {
                    selectCells.add(new Cell(rowIndex, colIndex));
                }
            }
        }
        if (spans != null) {
            for (Map<String, Object> span : spans) {
                Integer rowIndex = (Integer)span.get("row");
                Integer colIndex = (Integer)span.get("col");
                rowCount = (Integer)span.get("rowCount");
                colCount = (Integer)span.get("colCount");
                int rowRange = rowIndex + rowCount;
                int colRange = colIndex + colCount;
                for (int row = rowIndex.intValue(); row < rowRange; ++row) {
                    for (int col = colIndex.intValue(); col < colRange; ++col) {
                        if (row == rowIndex && col == colIndex) continue;
                        selectCells.remove(new Cell(row, col));
                    }
                }
            }
        }
        return selectCells;
    }
}

