/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.spread;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.FieldInfo;
import kd.mmc.phm.common.util.DBUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SpreadSyncHelper {
    private static final Log log = LogFactory.getLog(SpreadSyncHelper.class);
    private static final String PREFIX = "T_PHM_";
    private static final String algoKey = "SpreadSyncHelper.";
    private static final Pattern pattern = Pattern.compile("\\d+");

    public static void syncDataToDB(DynamicObject history) {
        Map<String, FieldInfo> col2FieldInfo = SpreadSyncHelper.getCol2FieldInfo(history);
        if (col2FieldInfo.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn("SpreadSyncHelper-> \u8868\u5217\u4fe1\u606f\u672a\u8bbe\u7f6e, historyId: {}", history.getPkValue());
            }
            return;
        }
        String number = history.getString("template.number");
        String tableName = PREFIX + number.replaceFirst("-", "");
        if (!DB.exitsTable((DBRoute)CommonConsts.ROUTE_PHM, (String)tableName)) {
            if (log.isWarnEnabled()) {
                log.warn("SpreadSyncHelper-> \u8868\u540d[{}]\u4e0d\u5b58\u5728, historyId: {}", (Object)tableName, history.getPkValue());
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"SpreadSyncHelper_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        String spreadJson = history.getString("spreadjson_tag");
        String convertSpreadJson = SpreadUtils.convertSpreadJson(spreadJson);
        if (StringUtils.isBlank((CharSequence)convertSpreadJson)) {
            if (log.isWarnEnabled()) {
                log.warn("SpreadSyncHelper-> spreadJson\u4e3a\u7a7a, historyId: {}", history.getPkValue());
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"SpreadSyncHelper_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, Map.class);
        Map sheets = (Map)spreadMap.get("sheets");
        Map sheetMap = (Map)sheets.get("Sheet1");
        Map data = (Map)sheetMap.get("data");
        Map rowMap = data.getOrDefault("dataTable", Collections.emptyMap());
        if (rowMap.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn("SpreadSyncHelper-> \u5355\u5143\u683c\u4e3a\u7a7a, historyId: {}", history.getPkValue());
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"SpreadSyncHelper_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        int rowCount = history.getInt("template.realrow");
        int rowSize = rowMap.size() - rowCount;
        ArrayList values = Lists.newArrayListWithExpectedSize((int)rowSize);
        long[] ids = ID.genLongIds((int)rowSize);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        long orgId = RequestContext.get().getOrgId();
        Date now = new Date();
        int fieldSize = col2FieldInfo.size() + 4;
        int count = 0;
        for (Map.Entry entry : rowMap.entrySet()) {
            int row = Integer.parseInt((String)entry.getKey());
            if (row < rowCount) continue;
            ArrayList value = Lists.newArrayListWithExpectedSize((int)fieldSize);
            value.add(ids[count++]);
            value.add(userId);
            value.add(now);
            value.add(orgId);
            Map colMap = (Map)entry.getValue();
            int nullSize = 0;
            for (Map.Entry<String, FieldInfo> fieldInfoEntry : col2FieldInfo.entrySet()) {
                Object cellValue;
                String colIndex = fieldInfoEntry.getKey();
                FieldInfo fieldInfo = fieldInfoEntry.getValue();
                Map map = (Map)colMap.get(colIndex);
                if (map == null) {
                    cellValue = fieldInfo.getDefaultValue();
                    ++nullSize;
                } else {
                    cellValue = map.get("value");
                    if (cellValue == null) {
                        cellValue = fieldInfo.getDefaultValue();
                        ++nullSize;
                    } else {
                        cellValue = SpreadSyncHelper.convertValue(cellValue, fieldInfo);
                    }
                }
                value.add(cellValue);
            }
            if (nullSize == fieldSize) continue;
            values.add(value.toArray());
        }
        String insertSql = SpreadSyncHelper.getInsertSql(tableName, col2FieldInfo);
        DBUtils.executeBatch(insertSql, values);
    }

    private static Object convertValue(Object value, FieldInfo fieldInfo) {
        FieldType type = fieldInfo.getType();
        if (type == FieldType.NVARCHAR) {
            return DataType.convertValue((DataType)DataType.StringType, (Object)value);
        }
        if (type == FieldType.DECIMAL) {
            return DataType.convertValue((DataType)DataType.BigDecimalType, (Object)value);
        }
        if (type == FieldType.BIGINT) {
            return DataType.convertValue((DataType)DataType.LongType, (Object)value);
        }
        String str = value.toString();
        if (str.startsWith("/OADate")) {
            return SpreadSyncHelper.convert2Date(str);
        }
        return value;
    }

    private static Date convert2Date(String str) {
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            double dateValue = Double.parseDouble(matcher.group());
            double mantissa = dateValue - (double)((long)dateValue);
            double hour = mantissa * 24.0;
            double min = (hour - (double)((long)hour)) * 60.0;
            double sec = (min - (double)((long)min)) * 60.0;
            try {
                Date baseDate = DateUtils.parseDate((String)"1899-12-30", (String[])new String[]{"yyyy-MM-dd"});
                Calendar c = Calendar.getInstance();
                c.setTime(baseDate);
                c.add(5, (int)dateValue);
                c.add(10, (int)hour);
                c.add(12, (int)min);
                c.add(13, (int)sec);
                return c.getTime();
            }
            catch (ParseException e) {
                log.error("SpreadSyncHelper: convert2Date error", (Throwable)e);
            }
        }
        return null;
    }

    private static String getInsertSql(String tableName, Map<String, FieldInfo> col2FieldInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(tableName);
        sb.append("(FID,FCREATORID,FCREATETIME,FCREATEORGID");
        col2FieldInfo.forEach((k, v) -> sb.append(',').append(v.getName()));
        sb.append(") VALUES (?,?,?,?");
        col2FieldInfo.forEach((k, v) -> sb.append(",?"));
        sb.append(')');
        return sb.toString();
    }

    private static Map<String, FieldInfo> getCol2FieldInfo(DynamicObject history) {
        LinkedHashMap<String, FieldInfo> col2FieldInfo = new LinkedHashMap<String, FieldInfo>();
        long templateId = history.getLong("template_id");
        QFilter qFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject tempConf = QueryServiceHelper.queryOne((String)"phm_billtemp", (String)"id,tempconf", (QFilter[])new QFilter[]{qFilter});
        long tempconfId = 0L;
        if (tempConf != null) {
            tempconfId = tempConf.getLong("id");
        }
        String selectFields = "fieldentryentity.cellcol, fieldentryentity.field, fieldentryentity.fieldtype";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)tempconfId)};
        String orderBy = "fieldentryentity.cellcol";
        StringBuilder sb = new StringBuilder();
        try (DataSet dataSet = ORM.create().queryDataSet("SpreadSyncHelper.querySetup", "phm_billtemp_set", selectFields, filters, orderBy, -1);){
            for (Row row : dataSet) {
                String col = row.getString(0);
                String field = row.getString(1);
                String type = row.getString(2);
                sb.append(field);
                String fieldName = sb.toString();
                col2FieldInfo.put(col, new FieldInfo(fieldName, FieldType.forValue(type)));
                sb.setLength(0);
            }
        }
        return col2FieldInfo;
    }
}

