/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.spread;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.phm.common.util.GZIPUtils;

public class SpreadUtils {
    private SpreadUtils() {
    }

    public static String convertSpreadJson(String spreadJson) {
        if (!spreadJson.startsWith("base64")) {
            return null;
        }
        spreadJson = spreadJson.substring(6);
        return GZIPUtils.decompress(spreadJson);
    }

    public static String convertCompressJson(String spreadJson) {
        String compressJson = GZIPUtils.compress(spreadJson);
        if (StringUtils.isBlank((CharSequence)compressJson)) {
            return null;
        }
        return "base64".concat(compressJson);
    }

    public static Map<String, Object> getRowData(String spreadJson, String sheetName) {
        Map<String, Object> sheetMap = SpreadUtils.getSheetData(spreadJson, sheetName);
        Map data = (Map)sheetMap.get("data");
        return data.getOrDefault("dataTable", Collections.emptyMap());
    }

    public static Map<String, Object> getRowData(String spreadJson) {
        return SpreadUtils.getRowData(spreadJson, "Sheet1");
    }

    public static Map<String, Object> getSheetData(String spreadJson) {
        return SpreadUtils.getSheetData(spreadJson, "Sheet1");
    }

    public static Map<String, Object> getSheetData(String spreadJson, String sheetName) {
        String convertSpreadJson = SpreadUtils.convertSpreadJson(spreadJson);
        if (convertSpreadJson == null) {
            return Collections.emptyMap();
        }
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, Map.class);
        Map sheets = (Map)spreadMap.get("sheets");
        return (Map)sheets.get(sheetName);
    }

    public static List<String> getDefaultLockToolbarItems() {
        ArrayList lockToolBarItems = Lists.newArrayListWithExpectedSize((int)14);
        lockToolBarItems.add("FontStyle");
        lockToolBarItems.add("FontDecoration");
        lockToolBarItems.add("ForeAndBackColor");
        lockToolBarItems.add("CellsBorder");
        lockToolBarItems.add("ClearCells");
        lockToolBarItems.add("TextAlign");
        lockToolBarItems.add("TextIndent");
        lockToolBarItems.add("LockCells");
        lockToolBarItems.add("MergeCells");
        lockToolBarItems.add("Undo");
        lockToolBarItems.add("VerticalAlign");
        lockToolBarItems.add("InsertRowAndCol");
        lockToolBarItems.add("FrozenSheets");
        lockToolBarItems.add("FormatPainter");
        lockToolBarItems.add("SwitchView");
        return lockToolBarItems;
    }

    public static List<String> getDefaultHiddenMenuItems() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)10);
        items.add("insertRows");
        items.add("hideRows");
        items.add("unhideRows");
        items.add("insertRowMany");
        items.add("insertColumns");
        items.add("hideColumns");
        items.add("unhideColumns");
        items.add("insertColMany");
        items.add("deleteColumns");
        items.add("clearContents");
        return items;
    }

    public static int pos2X(String pos) {
        int colAxisIndex = SpreadUtils.getColAxisIndex(pos);
        return SpreadUtils.pos2X(pos, colAxisIndex);
    }

    private static int pos2X(String pos, int colAxisIndex) {
        int count = -1;
        for (int i = 0; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    public static int pos2Y(String pos) {
        int colAxisIndex = SpreadUtils.getColAxisIndex(pos);
        return SpreadUtils.pos2Y(pos, colAxisIndex);
    }

    private static int pos2Y(String pos, int colAxisIndex) {
        int result = 0;
        int j = 1;
        for (int i = pos.length() - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"SpreadUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + pos);
            }
            result += (c - 48) * j;
            j *= 10;
        }
        return result - 1;
    }

    private static int getColAxisIndex(String pos) {
        Preconditions.checkArgument((pos.length() > 1 ? 1 : 0) != 0, (Object)(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"SpreadUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + pos));
        Preconditions.checkArgument((boolean)Character.isLetter(pos.charAt(0)), (Object)(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"SpreadUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + pos));
        if (!Character.isLetter(pos.charAt(1))) {
            return 1;
        }
        for (int index = 2; index < pos.length(); ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"SpreadUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + pos);
    }

    @Deprecated
    public static int[] pos2XY(String pos) {
        int[] xy = new int[2];
        int colAxisIndex = SpreadUtils.getColAxisIndex(pos);
        xy[0] = SpreadUtils.pos2X(pos, colAxisIndex);
        xy[1] = SpreadUtils.pos2Y(pos, colAxisIndex);
        return xy;
    }

    public static String xy2Pos(int x, int y) {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"SpreadUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        String xAxis = SpreadUtils.int2pos(x);
        return xAxis + (y + 1);
    }

    public static String int2pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int q = intVal / 26;
            int r = intVal % 26;
            if (r < 1) {
                r = 26;
                --q;
            }
            tmp[i--] = (char)(65 + r - 1);
            if (q == 0) break;
            intVal = q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static Date oaDateToDate(String date) {
        if (date == null) {
            return null;
        }
        String oaData = SpreadUtils.getOADate(date);
        BigDecimal time = new BigDecimal(oaData);
        time = time.multiply(new BigDecimal(86400000)).add(new BigDecimal("-2209190400000"));
        return new Date(time.longValue());
    }

    public static String getOADate(String date) {
        if (date == null) {
            return null;
        }
        String rgex = "(?<=\\/OADate\\().*?(?=\\)/)";
        Pattern pattern = Pattern.compile(rgex);
        Matcher matcher = pattern.matcher(date);
        String time = null;
        if (matcher.find()) {
            time = matcher.group();
        }
        return time;
    }
}

