/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.spread.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.mmc.phm.common.spread.model.Cell;

public class Sheet
implements Serializable {
    private static final long serialVersionUID = 2790922674544163130L;
    private String name;
    private final List<List<Cell>> table = new ArrayList<List<Cell>>();

    public Sheet() {
    }

    public Sheet(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addRow() {
        this.table.add(this.extendSameColCountAtOneRow());
    }

    private List<Cell> extendSameColCountAtOneRow() {
        int maxColumnCount = this.getMaxColumnCount();
        ArrayList<Cell> cols = new ArrayList<Cell>(maxColumnCount);
        if (maxColumnCount > 0) {
            for (int i = 0; i < maxColumnCount; ++i) {
                cols.add(this.createCell(false));
            }
        }
        return cols;
    }

    private Cell createCell(boolean isCreated) {
        return isCreated ? new Cell() : null;
    }

    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
    }

    public void addColumn() {
        for (List<Cell> columns : this.table) {
            columns.add(this.createCell(false));
        }
    }

    public void addColumns(int colCount) {
        for (int i = 0; i < colCount; ++i) {
            this.addColumn();
        }
    }

    public void addRange(int rowCount, int colCount) {
        this.addRows(rowCount);
        this.addColumns(colCount);
    }

    public void setCell(int row, int col, Cell cell) {
        this.ensureCapacity(row, col);
        this.table.get(row).set(col, cell);
    }

    public Cell getCell(int row, int col) {
        this.ensureCapacity(row, col);
        List<Cell> columns = this.table.get(row);
        Cell cell = columns.get(col);
        if (cell == null) {
            cell = this.createCell(true);
            columns.set(col, cell);
        }
        cell.setRowAndCol(row, col);
        return cell;
    }

    public void insertRow(int index) {
        int maxRowCount = this.getMaxRowCount();
        if (index > maxRowCount) {
            this.addRows(index - maxRowCount);
        }
        this.table.add(index, this.extendSameColCountAtOneRow());
    }

    public List<Cell> getRow(int index) {
        return this.table.get(index);
    }

    public void deleteRow(int index) {
        if (index > this.getMaxRowIndex()) {
            return;
        }
        this.table.remove(index);
    }

    public void deleteColumn(int index) {
        if (index > this.getMaxColumnIndex()) {
            return;
        }
        for (List<Cell> columns : this.table) {
            columns.remove(index);
        }
    }

    private void ensureCapacity(int row, int col) {
        int maxColIndex;
        int maxRowIndex = this.getMaxRowIndex();
        if (row > maxRowIndex) {
            this.addRows(row - maxRowIndex);
        }
        if (col > (maxColIndex = this.getMaxColumnIndex())) {
            this.addColumns(col - maxColIndex);
        }
    }

    public void iteratorCells(Consumer<Cell> consumer) {
        int rowIndex = 0;
        for (List<Cell> columns : this.table) {
            int colIndex = 0;
            for (Cell cell : columns) {
                if (cell != null) {
                    cell.setRowAndCol(rowIndex, colIndex);
                    consumer.accept(cell);
                }
                ++colIndex;
            }
            ++rowIndex;
        }
    }

    public void iteratorCellsByPredicate(Predicate<Cell> predicate) {
        int rowIndex = 0;
        for (List<Cell> columns : this.table) {
            int colIndex = 0;
            for (Cell cell : columns) {
                if (cell != null) {
                    cell.setRowAndCol(rowIndex, colIndex);
                    if (predicate.test(cell)) break;
                }
                ++colIndex;
            }
            ++rowIndex;
        }
    }

    public int getMaxRowCount() {
        return this.table.size();
    }

    public int getMaxRowIndex() {
        return this.getMaxRowCount() - 1;
    }

    public int getMaxColumnCount() {
        return this.table.size() > 0 ? this.table.get(0).size() : 0;
    }

    public int getMaxColumnIndex() {
        return this.getMaxColumnCount() - 1;
    }
}

