/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.task;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizModelCalculatTask
extends AbstractTask {
    private static final String ENTRY_PHM_BIZMODEL = "phm_bizmodel";
    private static final String ENTRY_MODELSCHEDULE = "phm_modelschedule";
    private static final String ENTRY_MODELSCHEDULEPLAN = "phm_modelscheduleplan";
    private static final String I_ICALCRUNTIMESERVICE = "ICalcRuntimeService";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        String modId = params.get("modelId").toString();
        if (StringUtils.isEmpty((CharSequence)modId)) {
            return;
        }
        DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((Object)modId, (String)ENTRY_PHM_BIZMODEL);
        if (bizModel != null) {
            try {
                Object edDate;
                if ("A".equals(bizModel.getString("releasestatus"))) {
                    return;
                }
                DynamicObject bizMod = BusinessDataServiceHelper.loadSingle((Object)modId, (String)ENTRY_MODELSCHEDULE);
                Object stDate = bizMod.get("startdate");
                if (!this.effectiveCheck(stDate, edDate = bizMod.get("enddate"))) {
                    return;
                }
                if ("0".equals(bizMod.getString("allowedrunstatus"))) {
                    return;
                }
                this.setStartInfo(modId);
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)I_ICALCRUNTIMESERVICE, (String)"cancelModelSnapshot", (Object[])new Object[]{modId, null});
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)I_ICALCRUNTIMESERVICE, (String)"startCalc", (Object[])new Object[]{bizModel});
                String status = "";
                do {
                    HashMap ret;
                    Object o;
                    if ((o = this.queryStatus(modId)) instanceof Map && (status = (ret = (HashMap)o).get("status").toString()).equals("C")) {
                        this.saveModelSnapShot(modId);
                        this.setEndInfo(modId);
                    }
                    TimeUnit.SECONDS.sleep(1L);
                } while (!status.equals("C") && !status.equals("D"));
            }
            catch (Exception e1) {
                throw new KDBizException((Throwable)e1, new ErrorCode("", ResManager.loadKDString((String)"\u6a21\u578b\u8fd0\u884c\u5f02\u5e38\uff1a%s", (String)"BizModelCalculatTask_0", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e1.getMessage()});
            }
        }
    }

    private boolean effectiveCheck(Object startDate, Object endDate) {
        if (endDate == null && startDate == null) {
            return true;
        }
        if (endDate == null) {
            return this.diff((Date)startDate, new Date());
        }
        if (startDate == null) {
            return this.diff(new Date(), (Date)endDate);
        }
        return this.diff((Date)startDate, new Date()) && this.diff(new Date(), (Date)endDate);
    }

    private boolean diff(Date dt1, Date dt2) {
        Long diff = dt2.getTime() - dt1.getTime();
        return diff >= 0L;
    }

    private void saveModelSnapShot(String modId) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)I_ICALCRUNTIMESERVICE, (String)"saveModelSnapshot", (Object[])new Object[]{modId, RequestContext.get().getUserId(), null});
    }

    private Object queryStatus(String modId) {
        return DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)I_ICALCRUNTIMESERVICE, (String)"queryLatestStatus", (Object[])new Object[]{modId});
    }

    private void setStartInfo(String modId) {
        String planId;
        DynamicObject bizModelP;
        DynamicObject bizModelM = BusinessDataServiceHelper.loadSingle((Object)modId, (String)ENTRY_MODELSCHEDULE);
        Date startTime = new Date();
        bizModelM.set("startruntime", (Object)startTime);
        SaveServiceHelper.update((DynamicObject)bizModelM);
        DynamicObject plan = bizModelM.getDynamicObject("scheduleplan");
        if (plan != null && this.firstJob(modId, bizModelP = BusinessDataServiceHelper.loadSingle((Object)(planId = plan.getString("id")), (String)ENTRY_MODELSCHEDULEPLAN))) {
            bizModelP.set("totalcount", (Object)(bizModelP.getInt("totalcount") + 1));
            bizModelP.set("startruntime", (Object)startTime);
            SaveServiceHelper.update((DynamicObject)bizModelP);
        }
    }

    private void setEndInfo(String modId) {
        DynamicObject bizModelM = BusinessDataServiceHelper.loadSingle((Object)modId, (String)ENTRY_MODELSCHEDULE);
        Date endTime = new Date();
        bizModelM.set("endruntime", (Object)endTime);
        SaveServiceHelper.update((DynamicObject)bizModelM);
        DynamicObject plan = bizModelM.getDynamicObject("scheduleplan");
        if (plan != null) {
            String planId = plan.getString("id");
            DynamicObject bizModelP = BusinessDataServiceHelper.loadSingle((Object)planId, (String)ENTRY_MODELSCHEDULEPLAN);
            bizModelP.set("endruntime", (Object)endTime);
            SaveServiceHelper.update((DynamicObject)bizModelP);
        }
    }

    private boolean firstJob(String modId, DynamicObject bizModelP) {
        DynamicObjectCollection entry = bizModelP.getDynamicObjectCollection("entryentity");
        DynamicObject row = (DynamicObject)entry.get(0);
        DynamicObject job = row.getDynamicObject("bizmodel");
        return modId.equals(job.getString("id"));
    }
}

