/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.mmc.phm.common.util.CalculationTreeNode;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CalculationTreeUtils {
    private static final String CLEARCONTROLDATA = "ClearControlData";
    private static final String VERTEX = "vertex";
    private static final String EDGE = "edge";
    private static final String ID = "id";
    private static final String VALUE = "value";
    private static final String MXGEOMETRY = "mxGeometry";
    private static final String MXCELL = "mxCell";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String X = "x";
    private static final String Y = "y";
    public static final String NODELIST = "nodelist";
    public static final String RELATIONS = "relations";
    public static final String NAME = "name";

    public static CalculationTreeNode getTreeNodeByXml(String xml) {
        Document document;
        if (StringUtils.isEmpty((String)xml)) {
            return null;
        }
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException ex) {
            throw new KDBizException(new ErrorCode("", ex.getMessage()), new Object[]{ex});
        }
        CalculationTreeNode rootNode = null;
        Element mxGraphModel = document.getRootElement();
        Element root = mxGraphModel.element("root");
        if (root == null) {
            root = mxGraphModel;
        }
        List mxCellElements = root.elements();
        Iterator iterator = mxCellElements.iterator();
        HashMap<String, CalculationTreeNode> id_nodeMap = new HashMap<String, CalculationTreeNode>();
        while (iterator.hasNext()) {
            Element mxCell = (Element)iterator.next();
            String vertex = mxCell.attributeValue(VERTEX);
            if (!"1".equals(vertex)) continue;
            String id = mxCell.attributeValue(ID);
            String name = mxCell.attributeValue(VALUE);
            Element mxGeometry = mxCell.element(MXGEOMETRY);
            String x = mxGeometry.attributeValue(X);
            String y = mxGeometry.attributeValue(Y);
            CalculationTreeNode treeNode = new CalculationTreeNode(id, name, x, y);
            id_nodeMap.put(id, treeNode);
        }
        ArrayList<String> sourceIDs = new ArrayList<String>();
        ArrayList<String> targetIDs = new ArrayList<String>();
        for (Element mxCell : mxCellElements) {
            String edge = mxCell.attributeValue(EDGE);
            if (!"1".equals(edge)) continue;
            String source = mxCell.attributeValue(SOURCE);
            String target = mxCell.attributeValue(TARGET);
            sourceIDs.add(source);
            targetIDs.add(target);
            ((CalculationTreeNode)id_nodeMap.get(source)).addNode((CalculationTreeNode)id_nodeMap.get(target));
        }
        sourceIDs.removeAll(targetIDs);
        if (sourceIDs.isEmpty()) {
            Iterator iterator2 = id_nodeMap.entrySet().iterator();
            if (iterator2.hasNext()) {
                rootNode = (CalculationTreeNode)iterator2.next().getValue();
            }
        } else {
            String topId = (String)sourceIDs.get(0);
            rootNode = (CalculationTreeNode)id_nodeMap.get(topId);
        }
        return rootNode;
    }

    public static String treeNodeToXml(CalculationTreeNode treeNode) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        String id = treeNode.getId();
        String name = treeNode.getName();
        String x = treeNode.getX();
        String y = treeNode.getY();
        CalculationTreeUtils.addVertex(root, id, name, x, y);
        List<CalculationTreeNode> childs = treeNode.getChilds();
        CalculationTreeUtils.bulidTreeNode(childs, root, id);
        return doc.asXML();
    }

    public static void insertTreeNode(CalculationTreeNode treeNode, CalculationTreeNode newTreeNode, String insertID) {
        if (treeNode == null || newTreeNode == null) {
            return;
        }
        String id = treeNode.getId();
        if (id.equals(insertID)) {
            treeNode.addChildNode(newTreeNode);
        } else {
            HashMap<String, CalculationTreeNode> newMap = new HashMap<String, CalculationTreeNode>();
            Map<String, CalculationTreeNode> calculationTreeNodeMap = CalculationTreeUtils.getCalculationTreeNodeIdMap(newMap, treeNode);
            CalculationTreeNode calculationTreeNode = calculationTreeNodeMap.get(insertID);
            if (calculationTreeNode != null) {
                calculationTreeNode.addChildNode(newTreeNode);
            }
        }
    }

    public static Map<String, CalculationTreeNode> getCalculationTreeNodeIdMap(Map<String, CalculationTreeNode> map, CalculationTreeNode treeNode) {
        HashMap<String, CalculationTreeNode> newMap = new HashMap<String, CalculationTreeNode>();
        String id = treeNode.getId();
        newMap.put(id, treeNode);
        List<CalculationTreeNode> childs = treeNode.getChilds();
        for (CalculationTreeNode calculationTreeNode : childs) {
            if (calculationTreeNode.getChilds() == null) continue;
            newMap.putAll(CalculationTreeUtils.getCalculationTreeNodeIdMap(newMap, calculationTreeNode));
        }
        return newMap;
    }

    public static Map<String, List<Map<String, String>>> getCalculationTreeNodeIdMapAndRelation(Map<String, List<Map<String, String>>> map, CalculationTreeNode treeNode) {
        HashMap<String, List<Map<String, String>>> newMap = new HashMap<String, List<Map<String, String>>>();
        ArrayList<Map<Object, Object>> nodelist = new ArrayList<Map<Object, Object>>(8);
        ArrayList<Map<Object, Object>> relations = new ArrayList<Map<Object, Object>>(8);
        newMap.put(NODELIST, nodelist);
        newMap.put(RELATIONS, relations);
        HashMap<String, String> node = new HashMap<String, String>();
        String name = treeNode.getName();
        String id = treeNode.getId();
        String x = treeNode.getX();
        String y = treeNode.getY();
        node.put(NAME, name);
        node.put(ID, id);
        node.put(X, x);
        node.put(Y, y);
        nodelist.add(node);
        List<CalculationTreeNode> childs = treeNode.getChilds();
        for (CalculationTreeNode calculationTreeNode : childs) {
            String childId = calculationTreeNode.getId();
            HashMap<String, String> relation = new HashMap<String, String>();
            relation.put(SOURCE, id);
            relation.put(TARGET, childId);
            relations.add(relation);
            if (calculationTreeNode.getChilds() == null) continue;
            Map<String, List<Map<String, String>>> calculationTreeNodeIdMapAndRelation = CalculationTreeUtils.getCalculationTreeNodeIdMapAndRelation(newMap, calculationTreeNode);
            List<Map<String, String>> nodelist1 = calculationTreeNodeIdMapAndRelation.get(NODELIST);
            nodelist.addAll(nodelist1);
            List<Map<String, String>> relations1 = calculationTreeNodeIdMapAndRelation.get(RELATIONS);
            relations.addAll(relations1);
        }
        return newMap;
    }

    public static void deleteTreeNodeById(CalculationTreeNode treeNode, String deleteID) {
        List<CalculationTreeNode> childs = treeNode.getChilds();
        Iterator<CalculationTreeNode> iterator = childs.iterator();
        while (iterator.hasNext()) {
            CalculationTreeNode calculationTreeNode = iterator.next();
            String id = calculationTreeNode.getId();
            if (id.equals(deleteID)) {
                iterator.remove();
                continue;
            }
            CalculationTreeUtils.deleteTreeNodeById(calculationTreeNode, deleteID);
        }
    }

    public static CalculationTreeNode getTreeNodeById(CalculationTreeNode treeNode, String targetId) {
        if (targetId.equals(treeNode.getId())) {
            return treeNode;
        }
        List<CalculationTreeNode> childs = treeNode.getChilds();
        Stack<CalculationTreeNode> stack = new Stack<CalculationTreeNode>();
        stack.push(treeNode);
        while (!stack.empty()) {
            CalculationTreeNode pop = (CalculationTreeNode)stack.pop();
            childs = pop.getChilds();
            if (childs.isEmpty()) continue;
            for (CalculationTreeNode child : childs) {
                String id = child.getId();
                if (id.equals(targetId)) {
                    return child;
                }
                stack.push(child);
            }
        }
        return null;
    }

    private static void bulidTreeNode(List<CalculationTreeNode> childs, Element root, String parentid) {
        if (childs != null && !childs.isEmpty()) {
            for (CalculationTreeNode treeNode : childs) {
                String id = treeNode.getId();
                String name = treeNode.getName();
                String x = treeNode.getX();
                String y = treeNode.getY();
                CalculationTreeUtils.addVertex(root, id, name, x, y);
                CalculationTreeUtils.addEdge(root, parentid, id);
                CalculationTreeUtils.bulidTreeNode(treeNode.getChilds(), root, id);
            }
        }
    }

    private static void addEdge(Element root, String parentid, String id) {
        Element addElement = root.addElement(MXCELL);
        addElement.addAttribute(ID, UUID.randomUUID().toString()).addAttribute(SOURCE, parentid).addAttribute(TARGET, id).addAttribute(EDGE, "1");
        addElement.addElement(MXGEOMETRY).addAttribute("relative", "1").addAttribute("as", "geometry");
    }

    private static void addVertex(Element root, String id, String name, String x, String y) {
        Element addElement = root.addElement(MXCELL);
        addElement.addAttribute(ID, id).addAttribute(VALUE, name).addAttribute(VERTEX, "1");
        addElement.addElement(MXGEOMETRY).addAttribute(X, x).addAttribute(Y, y).addAttribute("width", "100").addAttribute("height", "40").addAttribute("as", "geometry");
    }
}

