/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.common.util.JsonUtil;

public class ComponentUtil {
    private static final Map<ComponentType, String> nameMap = DesignerUtils.newHashMapWithExpectedSize(7);

    private ComponentUtil() {
    }

    public static Map<String, ComponentInfo> getComponentInfoMap(String pageId) {
        PageCache pageCache = new PageCache(pageId);
        String json = pageCache.get("componentInfo");
        HashMap<String, ComponentInfo> componentInfoMap = StringUtils.isBlank((CharSequence)json) ? new HashMap<String, ComponentInfo>(16) : (HashMap<String, ComponentInfo>)JsonUtil.fromJsonStringByComponentInfo(json);
        return componentInfoMap;
    }

    public static void putComponentInfoMapCache(Map<String, ComponentInfo> componentInfoMap, String pageId) {
        PageCache pageCache = new PageCache(pageId);
        pageCache.put("componentInfo", JsonUtil.toJsonString(componentInfoMap));
    }

    public static ComponentInfo getComponentInfo(String pageId, String componentId) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        return componentInfoMap.get(componentId);
    }

    public static List<ComponentInfo> getEigenvalueInfoList(String pageId, String elementId) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        ArrayList<ComponentInfo> eigenvalueInfoList = new ArrayList<ComponentInfo>();
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            ComponentInfo componentInfo = entry.getValue();
            if (ComponentType.EIGENVALUE != componentInfo.getComponentType() || !StringUtils.equals((CharSequence)elementId, (CharSequence)componentInfo.getElementId())) continue;
            eigenvalueInfoList.add(componentInfo);
        }
        return eigenvalueInfoList;
    }

    public static List<ComponentInfo> getAllComponentInfoByType(String pageId, ComponentType componentType) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        return componentInfoMap.values().stream().filter(componentInfo -> componentInfo.getComponentType() == componentType).collect(Collectors.toList());
    }

    public static List<ComponentInfo> getAllComponentInfoByType(long bizId, ComponentType componentType) {
        Map<String, ComponentInfo> componentInfoMap = DesignerUtils.wrapperComponentInfo(bizId);
        return componentInfoMap.values().stream().filter(componentInfo -> componentInfo.getComponentType() == componentType).collect(Collectors.toList());
    }

    public static List<ComponentInfo> getEigenInfoNotInElement(String pageId) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        ArrayList<ComponentInfo> componentInfoList = new ArrayList<ComponentInfo>();
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            ComponentInfo componentInfo = entry.getValue();
            if (componentInfo.getComponentType() != ComponentType.EIGENVALUE || !StringUtils.isBlank((CharSequence)componentInfo.getElementId())) continue;
            componentInfoList.add(componentInfo);
        }
        return componentInfoList;
    }

    public static List<ComponentInfo> getComponentInfoByIds(String pageId, List<String> componentIds) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        return componentInfoMap.entrySet().stream().filter(entry -> componentIds.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public static String refValidate(String pageId, List<ComponentInfo> componentInfos) {
        StringBuilder sb = new StringBuilder();
        String type = null;
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        for (ComponentInfo eigenvalueInfo : componentInfos) {
            if (ComponentType.EIGENVALUE != eigenvalueInfo.getComponentType()) continue;
            String eigenvalueId = eigenvalueInfo.getComponentId();
            String eigenvalueName = (String)eigenvalueInfo.getProperties().get("name");
            for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
                ComponentInfo componentInfo = entry.getValue();
                Map<String, Object> properties = componentInfo.getProperties();
                String name = (String)properties.get("name");
                String eigenComponentId = (String)properties.get("eigencomponent");
                ComponentType componentType = componentInfo.getComponentType();
                if (componentType == ComponentType.ADJUSTMENT && StringUtils.equals((CharSequence)eigenvalueId, (CharSequence)eigenComponentId)) {
                    type = ResManager.loadKDString((String)"\u8c03\u6574", (String)"ComponentUtil_7", (String)"mmc-phm-common", (Object[])new Object[0]);
                } else if (componentType == ComponentType.DETAIL && StringUtils.equals((CharSequence)eigenvalueId, (CharSequence)eigenComponentId)) {
                    type = ResManager.loadKDString((String)"\u660e\u7ec6", (String)"ComponentUtil_8", (String)"mmc-phm-common", (Object[])new Object[0]);
                } else if (componentType == ComponentType.QUERY && Objects.nonNull(eigenComponentId)) {
                    if (StringUtils.contains((CharSequence)eigenComponentId, (CharSequence)",")) {
                        List<String> list = Arrays.asList(eigenComponentId.substring(1, eigenComponentId.length() - 1).split(","));
                        if (list.contains(eigenvalueId)) {
                            type = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ComponentUtil_9", (String)"mmc-phm-common", (Object[])new Object[0]);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)eigenComponentId) && StringUtils.equals((CharSequence)eigenvalueId, (CharSequence)eigenComponentId.substring(1, eigenComponentId.length() - 1))) {
                        type = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ComponentUtil_9", (String)"mmc-phm-common", (Object[])new Object[0]);
                    }
                } else if (componentType == ComponentType.EIGENVALUE && StringUtils.equals((CharSequence)"model", (CharSequence)properties.get("source").toString()) && StringUtils.equals((CharSequence)eigenvalueId, (CharSequence)((String)properties.get("eigenid")))) {
                    type = ResManager.loadKDString((String)"\u7279\u5f81\u503c", (String)"ComponentUtil_10", (String)"mmc-phm-common", (Object[])new Object[0]);
                }
                if (!Objects.nonNull(type)) continue;
                sb.append(type).append(ResManager.loadKDString((String)"\u7ec4\u4ef6[", (String)"ComponentUtil_11", (String)"mmc-phm-common", (Object[])new Object[0])).append(name).append(ResManager.loadKDString((String)"]\u5f15\u7528\u4e86\u7279\u5f81\u503c\u7ec4\u4ef6[", (String)"ComponentUtil_12", (String)"mmc-phm-common", (Object[])new Object[0])).append(eigenvalueName).append("]\r\n");
                type = null;
            }
        }
        return sb.toString();
    }

    public static void removeComponentInfo(String pageId, String ... keys) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        for (String key : keys) {
            componentInfoMap.remove(key);
        }
        ComponentUtil.putComponentInfoMapCache(componentInfoMap, pageId);
    }

    public static void updateQueryComponent(String pageId, String componentId) {
        Map<String, ComponentInfo> componentInfoMap = ComponentUtil.getComponentInfoMap(pageId);
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            Map<String, Object> properties;
            String comparisonDataJson;
            ComponentInfo componentInfo = entry.getValue();
            if (componentInfo.getComponentType() != ComponentType.QUERY || !StringUtils.isNotBlank((CharSequence)(comparisonDataJson = (String)(properties = componentInfo.getProperties()).get("comparison_data_tag")))) continue;
            Map comparisonData = (Map)SerializationUtils.fromJsonString((String)comparisonDataJson, HashMap.class);
            comparisonData.entrySet().removeIf(next -> StringUtils.contains((CharSequence)((CharSequence)next.getKey()), (CharSequence)componentId));
            if (!comparisonData.isEmpty()) continue;
            properties.put("comparison_field", null);
            properties.put("comparison_data_tag", SerializationUtils.toJsonString((Object)comparisonData));
        }
        ComponentUtil.putComponentInfoMapCache(componentInfoMap, pageId);
    }

    public static DynamicObject getDetailFieldSet(Object bizModelId, String componentId) {
        try (DataSet dataSet = DesignerUtils.queryComponent(bizModelId, componentId);){
            if (dataSet.hasNext()) {
                Map properties = (Map)SerializationUtils.fromJsonString((String)dataSet.next().getString("data_tag"), HashMap.class);
                String dataJson = (String)properties.get("field_set_data_tag");
                if (StringUtils.isNotBlank((CharSequence)dataJson)) {
                    Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
                    DynamicObject dynamicObject = (DynamicObject)fieldSets[0];
                    return dynamicObject;
                }
            } else {
                String dataJson;
                QFilter filter = new QFilter("componentid", "=", (Object)componentId);
                QFilter[] filters = new QFilter[]{filter};
                DynamicObject detailFieldSet = QueryServiceHelper.queryOne((String)"phm_bizmodel_detail", (String)"field_set_data_tag", (QFilter[])filters);
                if (Objects.nonNull(detailFieldSet) && StringUtils.isNotBlank((CharSequence)(dataJson = detailFieldSet.getString("field_set_data_tag")))) {
                    Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
                    DynamicObject dynamicObject = (DynamicObject)fieldSets[0];
                    return dynamicObject;
                }
            }
            DynamicObject dynamicObject = null;
            return dynamicObject;
        }
    }

    public static Map<String, String> getNameFromDetailSet(Object bizModelId, String componentId) {
        DynamicObject detailFieldSet = ComponentUtil.getDetailFieldSet(bizModelId, componentId);
        LinkedHashMap<String, String> fieldNameMap = new LinkedHashMap<String, String>(16);
        if (null != detailFieldSet) {
            DynamicObjectCollection entryColls = detailFieldSet.getDynamicObjectCollection("field_entryentity");
            for (DynamicObject entryData : entryColls) {
                fieldNameMap.put(entryData.getString("field_name"), entryData.getString("field_alias"));
            }
        }
        return fieldNameMap;
    }

    public static List<ComponentInfo> getDetailFromEigenvalue(String pageId, String eigenValueId) {
        List<ComponentInfo> details = ComponentUtil.getAllComponentInfoByType(pageId, ComponentType.DETAIL);
        return details.stream().filter(componentInfo -> StringUtils.equals((CharSequence)eigenValueId, (CharSequence)((CharSequence)componentInfo.getProperties().get("eigencomponent")))).collect(Collectors.toList());
    }

    public static List<ComponentInfo> getDetailFromEigenvalueByBizId(long bizId, String eigenValueId) {
        Map<String, ComponentInfo> componentInfoMap = DesignerUtils.wrapperComponentInfo(bizId);
        List details = componentInfoMap.values().stream().filter(componentInfo -> componentInfo.getComponentType() == ComponentType.DETAIL).collect(Collectors.toList());
        return details.stream().filter(componentInfo -> StringUtils.equals((CharSequence)eigenValueId, (CharSequence)((CharSequence)componentInfo.getProperties().get("eigencomponent")))).collect(Collectors.toList());
    }

    public static List<String> mustValidate(String pageId) {
        return ComponentUtil.mustValidate(ComponentUtil.getComponentInfoMap(pageId));
    }

    public static List<String> mustValidate(Map<String, ComponentInfo> componentInfoMap) {
        ArrayList<String> list = new ArrayList<String>();
        if (componentInfoMap.isEmpty()) {
            list.add(ResManager.loadKDString((String)"\u6a21\u578b\u7ec4\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComponentUtil_13", (String)"mmc-phm-common", (Object[])new Object[0]));
            return list;
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Boolean> repeatMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            ComponentInfo componentInfo = entry.getValue();
            Map<String, Object> properties = componentInfo.getProperties();
            String name = (String)properties.get("name");
            String number = (String)properties.get("number");
            Map<String, String> mustInputFields = componentInfo.getMustInputFields();
            boolean mustValidate = false;
            sb.setLength(0);
            sb.append(nameMap.get(componentInfo.getComponentType()));
            if (StringUtils.isNotBlank((CharSequence)name)) {
                sb.append('[').append(name).append(']');
            }
            sb.append(": ");
            for (Map.Entry<String, String> mustInputFieldEntry : mustInputFields.entrySet()) {
                String key = mustInputFieldEntry.getKey();
                Object value = properties.get(key);
                if (!Objects.isNull(value) && !StringUtils.isBlank((CharSequence)String.valueOf(value))) continue;
                mustValidate = true;
                sb.append('\"').append(mustInputFieldEntry.getValue()).append("\"\u3001");
            }
            if (mustValidate) {
                String msg = sb.substring(0, sb.lastIndexOf("\u3001")).concat(ResManager.loadKDString((String)" \u4e3a\u7a7a\n", (String)"ComponentUtil_14", (String)"mmc-phm-common", (Object[])new Object[0]));
                list.add(msg);
            }
            if (Objects.isNull(number)) continue;
            String repeatKey = nameMap.get(componentInfo.getComponentType()).concat(number);
            if (Objects.isNull(repeatMap.get(repeatKey))) {
                repeatMap.put(repeatKey, Boolean.FALSE);
                continue;
            }
            if (((Boolean)repeatMap.get(repeatKey)).booleanValue()) continue;
            repeatMap.put(repeatKey, Boolean.TRUE);
            list.add(nameMap.get(componentInfo.getComponentType()).concat(ResManager.loadKDString((String)": \"\u7f16\u7801\"\u4e3a\"", (String)"ComponentUtil_15", (String)"mmc-phm-common", (Object[])new Object[0])).concat(number).concat(ResManager.loadKDString((String)"\"\u7684\u7ec4\u4ef6\u91cd\u590d\n", (String)"ComponentUtil_16", (String)"mmc-phm-common", (Object[])new Object[0])));
        }
        return list;
    }

    public static Set<String> getEigensFromDetail(String pageId) {
        List<ComponentInfo> details = ComponentUtil.getAllComponentInfoByType(pageId, ComponentType.DETAIL);
        return details.stream().map(componentInfo -> (String)componentInfo.getProperties().get("eigencomponent")).collect(Collectors.toSet());
    }

    static {
        nameMap.put(ComponentType.ELEMENT, ResManager.loadKDString((String)"\u5143\u4ef6", (String)"ComponentUtil_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        nameMap.put(ComponentType.ADJUSTMENT, ResManager.loadKDString((String)"\u8c03\u6574\u7ec4\u4ef6", (String)"ComponentUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]));
        nameMap.put(ComponentType.CONNECTION, ResManager.loadKDString((String)"\u8fde\u63a5\u7ec4\u4ef6", (String)"ComponentUtil_2", (String)"mmc-phm-common", (Object[])new Object[0]));
        nameMap.put(ComponentType.EIGENVALUE, ResManager.loadKDString((String)"\u7279\u5f81\u503c\u7ec4\u4ef6", (String)"ComponentUtil_3", (String)"mmc-phm-common", (Object[])new Object[0]));
        nameMap.put(ComponentType.QUERY, ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u4ef6", (String)"ComponentUtil_4", (String)"mmc-phm-common", (Object[])new Object[0]));
        nameMap.put(ComponentType.DETAIL, ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u4ef6", (String)"ComponentUtil_5", (String)"mmc-phm-common", (Object[])new Object[0]));
        nameMap.put(ComponentType.TEXT, ResManager.loadKDString((String)"\u6587\u672c\u7ec4\u4ef6", (String)"ComponentUtil_6", (String)"mmc-phm-common", (Object[])new Object[0]));
    }
}

