/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public final class CronTriggerUtils {
    private CronTriggerUtils() {
        throw new UnsupportedOperationException();
    }

    public static List<Date> computeFireTimes(String cronExpression, Date startTime, int numTimes) {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        try {
            cronTriggerImpl.setCronExpression(cronExpression);
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.parse, new Object[]{e.getMessage()});
        }
        cronTriggerImpl.setStartTime(startTime);
        return TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
    }

    public static Tuple<Date, Date> computePeriod(String cronExpression, Date startTime, Date nowTime, Date previousTime) {
        List<Date> dates = CronTriggerUtils.computeFireTimes(cronExpression, startTime, 10);
        Date nextTime = null;
        int i = 0;
        int dateSize = dates.size();
        while (i < dateSize) {
            Date date = dates.get(i);
            if (nowTime.compareTo(date) <= 0) {
                nextTime = date;
                break;
            }
            previousTime = date;
            if (++i < dateSize) continue;
            return CronTriggerUtils.computePeriod(cronExpression, date, nowTime, previousTime);
        }
        return new Tuple((Object)previousTime, nextTime);
    }
}

