/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.mmc.phm.common.consts.CommonConsts;

public final class DBUtils {
    private static final int DEFAULT_BATCHSIZE = 5000;
    private static final String INSERT_INTO_SQL = "insert into %s select %s from %s";

    private DBUtils() {
        throw new UnsupportedOperationException();
    }

    public static void executeBatch(String sql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = DBUtils.calculateTimes(totalCount, 5000);
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)CommonConsts.ROUTE_PHM, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)CommonConsts.ROUTE_PHM, (String)sql, values);
        }
    }

    public static void executeBatch(String sqlPart, String fieldName, List<Object> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = DBUtils.calculateTimes(totalCount, 5000);
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append(sqlPart, new Object[0]);
                sqlBuilder.appendIn(fieldName, values.subList(startIndex, endIndex));
                DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
            }
        } else {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(sqlPart, new Object[0]);
            sqlBuilder.appendIn(fieldName, values);
            DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
        }
    }

    public static void executeInsertInto(String targetTable, String sourceTable) {
        List columnNames = DB.getColumnNames((DBRoute)CommonConsts.ROUTE_PHM, (String)sourceTable);
        String fields = String.join((CharSequence)",", columnNames);
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)String.format(INSERT_INTO_SQL, targetTable, fields, sourceTable));
    }

    public static int calculateTimes(int count, int batchSize) {
        int times = count / batchSize;
        return count % batchSize != 0 ? times + 1 : times;
    }
}

