/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.basemanager.ScheduleConsts;

public class DataCopyTaskUtil {
    private static final String DEFAULT_HASH;
    private static final String ID = "id";
    private static final String SCH_PREFIX = "phm_";
    private static final String CLASSNAME = "classname";
    private static final String DELETE = "delete";
    private static final String KEY_PARAM = "dataPump";

    private DataCopyTaskUtil() {
    }

    private static boolean isExistsTrigger(String number) {
        QFilter[] filters = new QFilter("number", "=", (Object)number).toArray();
        return QueryServiceHelper.exists((String)"isc_data_copy_trigger", (QFilter[])filters);
    }

    private static DynamicObject getTriggerByNumber(String number) {
        return DataCopyTaskUtil.getDynaByNumber("isc_data_copy_trigger", number);
    }

    private static List<Object> getTriggerIdsByNumbers(List<String> numbers) {
        QFilter[] filters = new QFilter("number", "in", numbers).toArray();
        return QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", (QFilter[])filters, null, (int)-1);
    }

    public static DynamicObject getExistedTrigger(String number) {
        if (DataCopyTaskUtil.isExistsTrigger(number)) {
            return DataCopyTaskUtil.getTriggerByNumber(number);
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy_trigger");
    }

    private static DynamicObject getDynaByNumber(String entity, String number) {
        QFilter[] filters = new QFilter("number", "=", (Object)number).toArray();
        DynamicObject queryResult = QueryServiceHelper.queryOne((String)entity, (String)ID, (QFilter[])filters);
        Object id = 0L;
        if (queryResult != null) {
            id = queryResult.get(ID);
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entity);
    }

    public static DynamicObject[] getTriggersByDataPump(DynamicObject[] dataEntities) {
        List<String> numbers = DataCopyTaskUtil.getNumbersByDataPump(dataEntities);
        return DataCopyTaskUtil.getTriggerByNumbers(numbers);
    }

    public static List<String> getNumbersByDataPump(DynamicObject[] dataEntities) {
        ArrayList<String> numbers = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dataEntity : dataEntities) {
            String number = dataEntity.getString("number");
            DynamicObjectCollection entryCollection = dataEntity.getDynamicObjectCollection("entryentity");
            entryCollection.forEach(entry -> {
                sb.setLength(0);
                sb.append(number).append('_');
                sb.append(entry.getDynamicObject("data_mapping").getString("number"));
                numbers.add(sb.toString());
            });
        }
        return numbers;
    }

    public static void deleteSchDynamicObject(String entityId, String ignoreRefId, String[] ids) {
        boolean exists = QueryServiceHelper.exists((String)entityId, (QFilter[])new QFilter(ID, "in", (Object)ids).toArray());
        if (exists) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignorerefentityids", ignoreRefId);
            DataCopyTaskUtil.check(OperationServiceHelper.executeOperate((String)DELETE, (String)entityId, (Object[])ids, (OperateOption)operateOption));
        }
    }

    private static DynamicObject[] getTriggerByNumbers(List<String> numbers) {
        List<Object> pks = DataCopyTaskUtil.getTriggerIdsByNumbers(numbers);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger");
        return BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)dt);
    }

    public static void updateDataPumpInfo(DynamicObject trigger) {
        trigger.set("runtimes", (Object)(trigger.getInt("runtimes") + 1));
        trigger.set("last_run_time", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)trigger);
    }

    public static void updateDataPumpInfoByNumber(String number) {
        DynamicObject trigger = DataCopyTaskUtil.getDynaByNumber("phm_datapump", number);
        DataCopyTaskUtil.updateDataPumpInfo(trigger);
    }

    public static void deleteTrigger(List<String> numbers) {
        try (TXHandle handle = TX.requiresNew();){
            DynamicObject[] triggers;
            List<Object> triggerIds = DataCopyTaskUtil.getTriggerIdsByNumbers(numbers);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger");
            for (DynamicObject trigger : triggers = BusinessDataServiceHelper.load((Object[])triggerIds.toArray(), (DynamicObjectType)dt)) {
                DataCopyTaskUtil.getAllNextTaskId(trigger, triggerIds);
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger"), (Object[])triggerIds.toArray());
            DataCopyTaskUtil.deleteTriggerRef("isc_bill_log_relation", new QFilter[]{new QFilter("trigger", "in", triggerIds)});
            DataCopyTaskUtil.deleteTriggerRef("isc_data_copy_exec_log", new QFilter[]{new QFilter("data_copy_trigger", "in", triggerIds)});
            DataCopyTaskUtil.deleteTriggerRef("isc_data_copy_execution", new QFilter[]{new QFilter("data_copy_trigger", "in", triggerIds)});
        }
    }

    public static void getAllNextTaskId(DynamicObject trigger, List<Object> nextTaskIds) {
        if (trigger.getPkValue().equals(0L)) {
            return;
        }
        trigger = BusinessDataServiceHelper.loadSingle((Object)trigger.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger"));
        DynamicObjectCollection nextTasks = trigger.getDynamicObjectCollection("next_tasks");
        if (!nextTaskIds.isEmpty()) {
            for (DynamicObject nextTask : nextTasks) {
                DynamicObject nextTrigger = nextTask.getDynamicObject("next_task");
                nextTaskIds.add(nextTrigger.getPkValue());
                DataCopyTaskUtil.getAllNextTaskId(nextTrigger, nextTaskIds);
            }
        }
    }

    private static void deleteTriggerRef(String entity, QFilter[] filters) {
        List pks = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])filters, null, (int)-1);
        if (!pks.isEmpty()) {
            DataCopyTaskUtil.check(OperationServiceHelper.executeOperate((String)DELETE, (String)entity, (Object[])pks.toArray(), (OperateOption)OperateOption.create()));
        }
    }

    public static DynamicObject createJob(DynamicObject dataPump) {
        String id = String.valueOf(DataCopyTaskUtil.md5i64(dataPump.getPkValue().toString().getBytes(StandardCharsets.UTF_8)));
        DynamicObject job = DataCopyTaskUtil.getExistedObject("sch_job", id);
        String number = SCH_PREFIX + dataPump.getString("number");
        job.set("number", (Object)number);
        job.set("jobtype", (Object)JobType.BIZ);
        job.set("name", dataPump.get("name"));
        job.set("taskclassname", DataCopyTaskUtil.createUpdateTaskDefine().item1);
        job.set(CLASSNAME, DataCopyTaskUtil.createUpdateTaskDefine().item2);
        job.set("runbyuser", (Object)RequestContext.get().getUserId());
        job.set("status", (Object)EnableEnum.ENABLE.getValue());
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put(KEY_PARAM, dataPump.getPkValue());
        job.set("params", (Object)SerializationUtils.toJsonString(params));
        DynamicObjectCollection entries = job.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject dataPumpParam = entries.addNew();
        dataPumpParam.set("paramname", (Object)KEY_PARAM);
        dataPumpParam.set("paramvalue", (Object)dataPump.getPkValue().toString());
        return job;
    }

    public static DynamicObject disableJob(DynamicObject dataPump) {
        String id = String.valueOf(DataCopyTaskUtil.md5i64(dataPump.getPkValue().toString().getBytes(StandardCharsets.UTF_8)));
        DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)id, (String)"sch_job");
        job.set("status", (Object)EnableEnum.DISABLE.getValue());
        return job;
    }

    public static DynamicObject disableSchedule(DynamicObject dataPump) {
        String id = String.valueOf(DataCopyTaskUtil.md5i64(dataPump.getPkValue().toString().getBytes(StandardCharsets.UTF_8)));
        DynamicObject schedule = BusinessDataServiceHelper.loadSingle((Object)id, (String)"sch_schedule");
        schedule.set("status", (Object)EnableEnum.DISABLE.getValue());
        return schedule;
    }

    public static DynamicObject createSchedule(DynamicObject dataPump, Object jobId) {
        String id = String.valueOf(DataCopyTaskUtil.md5i64(dataPump.getPkValue().toString().getBytes(StandardCharsets.UTF_8)));
        DynamicObject schedule = DataCopyTaskUtil.getExistedObject("sch_schedule", id);
        String number = SCH_PREFIX + dataPump.getString("number");
        schedule.set("name", dataPump.get("name"));
        schedule.set("number", (Object)number);
        schedule.set("job", jobId);
        schedule.set("starttime", (Object)DataCopyTaskUtil.getStartTime(dataPump));
        schedule.set("endtime", (Object)DataCopyTaskUtil.getEndTime(dataPump));
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", dataPump.get("repeatmode"));
        schedule.set("cyclenum", dataPump.get("cyclenum"));
        schedule.set("plan", dataPump.get("plan"));
        schedule.set("txtdesc", dataPump.get("txtdesc"));
        schedule.set("combdorw", dataPump.get("combdorw"));
        schedule.set("txthost", (Object)DataCopyTaskUtil.getHostIpAddress());
        for (String monthProp : ScheduleConsts.CKMONTH) {
            schedule.set(monthProp, dataPump.get(monthProp));
        }
        for (String dateProp : ScheduleConsts.CKDATE) {
            schedule.set(dateProp, dataPump.get(dateProp));
        }
        for (String weekProp : ScheduleConsts.CKWEEK) {
            schedule.set(weekProp, dataPump.get(weekProp));
        }
        schedule.set("comno", dataPump.get("comno"));
        schedule.set("comweek", dataPump.get("comweek"));
        schedule.set("ckbyweek", dataPump.get("ckbyweek"));
        return schedule;
    }

    private static Tuple<String, String> createUpdateTaskDefine() {
        QFilter filter = new QFilter("number", "=", (Object)"phm_datapump_update_task");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)ID, (QFilter[])new QFilter[]{filter});
        return obj != null ? Tuple.create((Object)((String)obj.getPkValue()), (Object)obj.getString(CLASSNAME)) : DataCopyTaskUtil.innerCreateUpdateTaskDefine("phm_datapump_update_task");
    }

    public static Tuple<String, String> innerCreateUpdateTaskDefine(String number) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
        obj.set("number", (Object)number);
        obj.set("name", (Object)ResManager.loadKDString((String)"\u6570\u636e\u62bd\u53d6\u66f4\u65b0\u4efb\u52a1", (String)"DataCopyTaskUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]));
        obj.set(CLASSNAME, (Object)"kd.mmc.phm.common.task.DataPumpUpdateTask");
        obj.set("appid", (Object)"phm");
        DynamicObjectCollection params = obj.getDynamicObjectCollection("paramentry");
        DynamicObject dataPumpParam = params.addNew();
        dataPumpParam.set("paramname", (Object)KEY_PARAM);
        dataPumpParam.set("paramtype", (Object)"1");
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"sch_taskdefine", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
        DataCopyTaskUtil.check(operationResult);
        String id = "";
        if (!operationResult.getSuccessPkIds().isEmpty()) {
            id = (String)operationResult.getSuccessPkIds().get(0);
        }
        return Tuple.create((Object)id, (Object)obj.getString(CLASSNAME));
    }

    private static DynamicObject getExistedObject(String entityName, String id) {
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)id)})) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        obj.set(ID, (Object)id);
        return obj;
    }

    public static List<Map<String, Object>> executeBatch(List<String> triggerNumbers) {
        ArrayList maps = new ArrayList(triggerNumbers.size());
        for (String triggerNumber : triggerNumbers) {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("trigger_number", triggerNumber);
            map.put("params", null);
            maps.add(map);
        }
        List results = (List)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"executeBatch", (Object[])new Object[]{maps});
        return results;
    }

    public static void check(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo()) {
                sb.append(iOperateInfo.getTitle()).append(' ').append(iOperateInfo.getMessage()).append("\r\n");
            }
            if (sb.length() == 0) {
                throw new KDException(DataCopyTaskUtil.createErrorCode(operationResult.getMessage()), new Object[0]);
            }
            throw new KDException(DataCopyTaskUtil.createErrorCode(sb.toString()), new Object[0]);
        }
    }

    public static ErrorCode createErrorCode(String message) {
        return new ErrorCode("mmc.phm.500", message);
    }

    private static Date getEndTime(DynamicObject trigger) {
        Date end = trigger.getDate("expired_time");
        if (end == null) {
            end = new Timestamp(System.currentTimeMillis() + 315360000000L);
        }
        return end;
    }

    private static Date getStartTime(DynamicObject trigger) {
        Date start = trigger.getDate("validated_time");
        if (start == null) {
            start = new Date(System.currentTimeMillis() - 86400000L);
        }
        return start;
    }

    public static long md5i64(byte[] bytes) {
        byte[] hash = DataCopyTaskUtil.md5(bytes);
        return Math.abs(DataCopyTaskUtil.toLong(hash, 4, 12));
    }

    private static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value = value << 8 | (long)(bytes[i] & 0xFF);
        }
        return value;
    }

    private static byte[] md5(byte[] bytes) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(DEFAULT_HASH);
            md5.update(bytes);
            return md5.digest();
        }
        catch (Exception var2) {
            throw new KDBizException((Throwable)var2, new ErrorCode("", ResManager.loadKDString((String)"MD5\u5931\u8d25\uff1a%s", (String)"DataCopyTaskUtil_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{var2.getMessage()});
        }
    }

    private static RuntimeException e(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw new KDBizException(e, new ErrorCode("", ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"DataCopyTaskUtil_3", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return new RuntimeException(e.getMessage(), e);
    }

    private static String getHostIpAddress() {
        Enumeration<NetworkInterface> allNetInterfaces = null;
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff1a%s", (String)"DataCopyTaskUtil_4", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{"127.0.0.1"});
        }
        InetAddress ip = null;
        boolean hasGet = false;
        String ipStr = null;
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ip = addresses.nextElement();
                if (!(ip instanceof Inet4Address) || "127.0.0.1".equals(ipStr = NetAddressUtils.getLocalIpAddress())) continue;
                hasGet = true;
                break;
            }
            if (!hasGet) continue;
            break;
        }
        return ipStr;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append('M');
        sb.append('D');
        sb.append('5');
        DEFAULT_HASH = sb.toString();
    }
}

