/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DataEntityCacheUtil {
    public static void storeDataEntry(IPageCache pageCache, DynamicObject dynamicObject) {
        if (dynamicObject == null || pageCache == null) {
            return;
        }
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(true);
        String dataTempConfString = DataEntitySerializer.serializerToString((Object)dynamicObject, (DataEntitySerializerOption)option);
        pageCache.putBigObject(dynamicObjectType.getName(), dataTempConfString);
    }

    public static String getDataEntryString(IPageCache pageCache, String entityName, Long dataEntityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return DataEntityCacheUtil.getDataEntryString(pageCache, (DynamicObjectType)entityType, dataEntityId);
    }

    public static String getDataEntryString(IPageCache pageCache, DynamicObjectType dataEntityType, Long dataEntityId) {
        String dataEntryString = pageCache.getBigObject(dataEntityType.getName());
        if (StringUtils.isNotEmpty((CharSequence)dataEntryString)) {
            return dataEntryString;
        }
        if (dataEntityId == null || dataEntityId == 0L) {
            return null;
        }
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntityId, (DynamicObjectType)dataEntityType);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(true);
        dataEntryString = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)option);
        pageCache.putBigObject(dataEntityType.getName(), dataEntryString);
        return dataEntryString;
    }

    public static DynamicObject getDataEntry(IPageCache pageCache, String entityName, Long dataEntityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return DataEntityCacheUtil.getDataEntry(pageCache, (DynamicObjectType)entityType, dataEntityId);
    }

    public static DynamicObject getDataEntry(IPageCache pageCache, DynamicObjectType dataEntityType, Long dataEntityId) {
        String dataEntryString = pageCache.getBigObject(dataEntityType.getName());
        DataEntityDeserializerOption option = new DataEntityDeserializerOption();
        option.setIncludeDataEntityState(true);
        if (StringUtils.isNotEmpty((CharSequence)dataEntryString)) {
            return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)dataEntryString, (IDataEntityType)dataEntityType, (DataEntityDeserializerOption)option);
        }
        if (dataEntityId == null || dataEntityId == 0L) {
            return null;
        }
        DynamicObject dataTempConf = BusinessDataServiceHelper.loadSingle((Object)dataEntityId, (DynamicObjectType)dataEntityType);
        DataEntitySerializerOption option1 = new DataEntitySerializerOption();
        option1.setIncludeDataEntityState(true);
        dataEntryString = DataEntitySerializer.serializerToString((Object)dataTempConf, (DataEntitySerializerOption)option1);
        pageCache.putBigObject(dataEntityType.getName(), dataEntryString);
        return dataTempConf;
    }

    public static void deleteDataEntity(IPageCache pageCache, String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityCacheUtil.deleteDataEntity(pageCache, (DynamicObjectType)entityType);
    }

    public static void deleteDataEntity(IPageCache pageCache, DynamicObjectType dataEntityType) {
        pageCache.removeBigObject(dataEntityType.getName());
    }
}

