/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DataMapUtils {
    private static final String ENTRY_PHM_DATAMAP = "phm_datamap";
    private static final String ENTRY_ISC_DATA_COPY = "isc_data_copy";
    private static final String ENTRY_PHM_METADATAMANAGER = "phm_metadatamanager";

    public static Map<Long, List<Object>> getIscDataCopyMap(List<Object> mappingIds, boolean getMain) {
        DynamicObjectCollection dataMappings = QueryServiceHelper.query((String)ENTRY_PHM_DATAMAP, (String)"id, number, meta.id, entryentity.seq, entryentity.key_srctable", (QFilter[])new QFilter[]{new QFilter("id", "in", mappingIds)});
        HashSet<Long> metaIds = new HashSet<Long>(dataMappings.size());
        HashMap<Long, Tuple> numberMap = new HashMap<Long, Tuple>(16);
        HashMap<Long, LinkedHashMap<String, Integer>> orderMap = new HashMap<Long, LinkedHashMap<String, Integer>>(16);
        for (DynamicObject dataMapping : dataMappings) {
            long metaId = dataMapping.getLong("meta.id");
            long mappingId = dataMapping.getLong("id");
            LinkedHashMap<String, Integer> seqMap = (LinkedHashMap<String, Integer>)orderMap.get(mappingId);
            if (Objects.isNull(seqMap)) {
                seqMap = new LinkedHashMap<String, Integer>(16);
            }
            seqMap.put(dataMapping.getString("entryentity.key_srctable"), dataMapping.getInt("entryentity.seq"));
            orderMap.put(mappingId, seqMap);
            metaIds.add(metaId);
            numberMap.put(metaId, Tuple.create((Object)mappingId, (Object)dataMapping.getString("number")));
        }
        DynamicObject[] metas = BusinessDataServiceHelper.load((Object[])metaIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTRY_PHM_METADATAMANAGER));
        HashMap<Long, List<Object>> resultMap = new HashMap<Long, List<Object>>(16);
        for (DynamicObject meta : metas) {
            List<Object> iscDataCopyIds;
            Tuple tuple = (Tuple)numberMap.get(meta.getLong("id"));
            long mappingId = (Long)tuple.item1;
            String number = (String)tuple.item2;
            Map seqMap = (Map)orderMap.get(mappingId);
            DynamicObjectCollection srcInfos = (DynamicObjectCollection)meta.get("sourcetable");
            ArrayList<String> iscNumbers = new ArrayList<String>();
            TreeMap<Integer, String> mappingSeqMap = new TreeMap<Integer, String>((o1, o2) -> o2 - o1);
            for (DynamicObject srcInfo : srcInfos) {
                if (srcInfo.getBoolean("ismaintable") != getMain) continue;
                String iscNumber = number + "_" + srcInfo.get("link_id") + "_" + srcInfo.getString("srctable");
                iscNumbers.add(iscNumber);
                if (getMain) continue;
                String sourceTable = srcInfo.getDynamicObject("link").getString("number") + "-" + srcInfo.getString("srctable");
                Integer seq = (Integer)seqMap.get(sourceTable);
                mappingSeqMap.put(seq, iscNumber);
            }
            if (mappingSeqMap.isEmpty()) {
                iscDataCopyIds = QueryServiceHelper.queryPrimaryKeys((String)ENTRY_ISC_DATA_COPY, (QFilter[])new QFilter("number", "in", iscNumbers).toArray(), null, (int)-1);
                resultMap.put(mappingId, iscDataCopyIds);
                continue;
            }
            iscDataCopyIds = new ArrayList();
            DynamicObjectCollection dataCopys = QueryServiceHelper.query((String)ENTRY_ISC_DATA_COPY, (String)"id, number", (QFilter[])new QFilter("number", "in", iscNumbers).toArray());
            for (Map.Entry entry : mappingSeqMap.entrySet()) {
                String value = (String)entry.getValue();
                for (DynamicObject dataCopy : dataCopys) {
                    if (!StringUtils.equals((CharSequence)value, (CharSequence)dataCopy.getString("number"))) continue;
                    iscDataCopyIds.add(dataCopy.get("id"));
                }
            }
            resultMap.put(mappingId, iscDataCopyIds);
        }
        return resultMap;
    }
}

