/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kscript.runtime.CaseInSensitiveMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.basemanager.ColumnEntry;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.util.DBUtils;
import kd.mmc.phm.common.util.DataCopyTaskUtil;

public final class DataTableCompareUtils {
    private static final Log LOG = LogFactory.getLog(DataTableCompareUtils.class);
    private static final String NVARCHAR_DEFAULT_SQL = "%s NVARCHAR(%d) DEFAULT('%s') NOT NULL";
    private static final String BIGINT_DEFAULT_SQL = "%s BIGINT DEFAULT %d NOT NULL";
    private static final String DECIMAL_DEFAULT_SQL = "%s DECIMAL(23,10) DEFAULT %f NOT NULL";
    private static final String DATETIME_DEFAULT_SQL = "%s DATETIME";

    public static void saveDifferenceInfo(String tableName, Set<String> modifyFields) {
        LOG.info(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5b58\u5728\u5dee\u5f02, tableName: {}, modifyFields: {}", (String)"DataTableCompareUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]), (Object)tableName, modifyFields);
        if (modifyFields.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("tablename", "=", (Object)tableName)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"phm_table_difference", (String)"entryentity.field, entryentity.modifydate", (QFilter[])filters);
        if (dynamicObject == null) {
            dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_table_difference"));
            dynamicObject.set("tablename", (Object)tableName);
        }
        Date date = new Date();
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryData : entry) {
            String field = entryData.getString("field");
            if (!modifyFields.remove(field)) continue;
            entryData.set("modifydate", (Object)date);
        }
        for (String modifyField : modifyFields) {
            DynamicObject entryData = entry.addNew();
            entryData.set("field", (Object)modifyField);
            entryData.set("modifydate", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static Map<String, CaseInSensitiveMap> getExistedValue(String tableName, String primaryKey, List<Object> primaryValue) {
        CaseInSensitiveMap primaryKey2Value = new CaseInSensitiveMap();
        List columnNames = DB.getColumnNames((DBRoute)CommonConsts.ROUTE_PHM, (String)tableName);
        String selectFields = String.join((CharSequence)",", columnNames);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format("SELECT %s FROM %s WHERE ", selectFields, tableName), new Object[0]);
        sqlBuilder.appendIn(primaryKey, primaryValue);
        try (DataSet dataSet = DB.queryDataSet((String)"DataTableCompareUtils.getExistedValue", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            RowMeta rowMeta = dataSet.getRowMeta();
            for (Row row : dataSet) {
                CaseInSensitiveMap map = new CaseInSensitiveMap();
                rowMeta.toMap(row, (Map)map);
                primaryKey2Value.put((Object)row.getString(primaryKey), (Object)map);
            }
        }
        return primaryKey2Value;
    }

    public static boolean validateRef(String tableName) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"phm_datatable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tableName)}, null, (int)1);
        if (ids.isEmpty()) {
            return false;
        }
        return QueryServiceHelper.exists((String)"phm_filldata_history", (QFilter[])new QFilter("template.datatables.fbasedataid", "=", ids.get(0)).toArray());
    }

    public static List<ThreeTuple<String, String, Boolean>> getOrCreateBackupTable(List<String> triggerNumbers) {
        Set<String> tableNames = DataTableCompareUtils.getTableNames(triggerNumbers);
        if (tableNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)tableNames.size());
        for (String tableName : tableNames) {
            long encryptedTableName = DataCopyTaskUtil.md5i64(tableName.getBytes(StandardCharsets.UTF_8));
            String backupTableName = "T_" + encryptedTableName;
            if (backupTableName.length() > 24) {
                backupTableName = backupTableName.substring(0, 24);
            }
            DataTableCompareUtils.isExitTable(backupTableName, result, tableName);
        }
        return result;
    }

    private static void isExitTable(String backupTableName, List<ThreeTuple<String, String, Boolean>> result, String tableName) {
        if (DB.exitsTable((DBRoute)CommonConsts.ROUTE_PHM, (String)backupTableName)) {
            List sourceTableColumnNames = DB.getColumnNames((DBRoute)CommonConsts.ROUTE_PHM, (String)tableName);
            List backupTableColumnNames = DB.getColumnNames((DBRoute)CommonConsts.ROUTE_PHM, (String)backupTableName);
            int sourceTableSize = sourceTableColumnNames.size();
            sourceTableColumnNames = sourceTableColumnNames.stream().map(String::toUpperCase).collect(Collectors.toList());
            backupTableColumnNames = backupTableColumnNames.stream().map(String::toUpperCase).collect(Collectors.toList());
            boolean isSame = false;
            if (sourceTableSize == backupTableColumnNames.size()) {
                sourceTableColumnNames.retainAll(backupTableColumnNames);
                boolean bl = isSame = sourceTableColumnNames.size() == sourceTableSize;
            }
            if (isSame) {
                result.add((ThreeTuple<String, String, Boolean>)new ThreeTuple((Object)tableName, (Object)backupTableName, (Object)false));
            } else {
                DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)("DROP TABLE " + backupTableName));
                if (DataTableCompareUtils.createBackupTable(tableName, backupTableName)) {
                    result.add((ThreeTuple<String, String, Boolean>)new ThreeTuple((Object)tableName, (Object)backupTableName, (Object)true));
                }
            }
        } else if (DataTableCompareUtils.createBackupTable(tableName, backupTableName)) {
            result.add((ThreeTuple<String, String, Boolean>)new ThreeTuple((Object)tableName, (Object)backupTableName, (Object)true));
        }
    }

    private static boolean createBackupTable(String tableName, String backupTableName) {
        String colType;
        String selectFields = "entryentity.fieldname, entryentity.fielddescription, entryentity.fieldtype, entryentity.fieldlength, entryentity.defvalue, entryentity.primarykey";
        QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)tableName)};
        ArrayList<ColumnEntry> columnEntryList = new ArrayList<ColumnEntry>();
        try (DataSet dataSet = ORM.create().queryDataSet("getDataTableInfo", "phm_datatable", selectFields, numberFilter, null);){
            for (Row row : dataSet) {
                ColumnEntry columnEntry = new ColumnEntry();
                columnEntry.setColName(row.getString(0));
                columnEntry.setColDescribe(row.getString(1));
                colType = row.getString(2);
                columnEntry.setColType(colType);
                columnEntry.setColLength(row.getLong(3));
                String defValue = row.getString(4);
                if (StringUtils.isBlank((CharSequence)defValue)) {
                    if (FieldType.NVARCHAR.getValue().equals(colType)) {
                        columnEntry.setDefValue(" ");
                    } else if (FieldType.DECIMAL.getValue().equals(colType) || FieldType.BIGINT.getValue().equals(colType)) {
                        columnEntry.setDefValue("0");
                    }
                } else {
                    columnEntry.setDefValue(defValue);
                }
                columnEntry.setIsPK(row.getBoolean(5));
                columnEntryList.add(columnEntry);
            }
        }
        StringBuilder sqlSb = new StringBuilder();
        StringBuilder pkSb = new StringBuilder();
        sqlSb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", backupTableName));
        sqlSb.append(String.format("CREATE TABLE %s (", backupTableName));
        for (ColumnEntry columnEntry : columnEntryList) {
            String colName = columnEntry.getColName();
            colType = columnEntry.getColType();
            if (FieldType.NVARCHAR.getValue().equals(colType)) {
                sqlSb.append(String.format(NVARCHAR_DEFAULT_SQL, colName, columnEntry.getColLength(), columnEntry.getDefValue()));
            } else if (FieldType.BIGINT.getValue().equals(colType)) {
                sqlSb.append(String.format(BIGINT_DEFAULT_SQL, colName, Long.parseLong(columnEntry.getDefValue())));
            } else if (FieldType.DECIMAL.getValue().equals(colType)) {
                sqlSb.append(String.format(DECIMAL_DEFAULT_SQL, colName, new BigDecimal(columnEntry.getDefValue())));
            } else {
                sqlSb.append(String.format(DATETIME_DEFAULT_SQL, colName));
            }
            sqlSb.append(", ");
            if (!columnEntry.getIsPK().booleanValue()) continue;
            if (pkSb.length() != 0) {
                pkSb.append(',');
            }
            pkSb.append(colName);
        }
        if (pkSb.length() > 0) {
            sqlSb.append("CONSTRAINT ");
            String pkName = "pk_" + (backupTableName.length() > 2 ? backupTableName.substring(2) : backupTableName);
            sqlSb.append(pkName);
            sqlSb.append(" PRIMARY KEY(");
            sqlSb.append((CharSequence)pkSb);
            sqlSb.append("));");
        }
        return DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)sqlSb.toString());
    }

    public static boolean beforeCompareTable(List<String> triggerNumbers) {
        List<ThreeTuple<String, String, Boolean>> threeTuples = DataTableCompareUtils.getOrCreateBackupTable(triggerNumbers);
        if (threeTuples.isEmpty()) {
            return false;
        }
        LOG.info(ResManager.loadKDString((String)"\u5f00\u59cb\u5907\u4efd\u6570\u636e\u8868, relation: {}", (String)"DataTableCompareUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]), (Object)SerializationUtils.toJsonString(threeTuples));
        String truncateSql = "truncate table %s";
        for (ThreeTuple<String, String, Boolean> threeTuple : threeTuples) {
            boolean isCreate = (Boolean)threeTuple.item3;
            if (!isCreate) {
                DataTableCompareUtils.execcuteData(truncateSql, threeTuple);
            }
            String backupTableName = (String)threeTuple.item2;
            String tableName = (String)threeTuple.item1;
            DBUtils.executeInsertInto(backupTableName, tableName);
        }
        return true;
    }

    private static void execcuteData(String truncateSql, ThreeTuple<String, String, Boolean> threeTuple) {
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)String.format(truncateSql, threeTuple.item2));
    }

    private static Set<String> getTableNames(List<String> triggerNumbers) {
        if (triggerNumbers.isEmpty()) {
            return Collections.emptySet();
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", triggerNumbers)};
        DynamicObjectCollection triggers = QueryServiceHelper.query((String)"isc_data_copy_trigger", (String)"data_copy.target_schema.table_name tableName", (QFilter[])filters);
        HashSet result = Sets.newHashSetWithExpectedSize((int)triggers.size());
        for (DynamicObject trigger : triggers) {
            String tableName = trigger.getString("tableName");
            if (StringUtils.isBlank((CharSequence)tableName)) continue;
            tableName = tableName.substring(0, tableName.indexOf("@"));
            result.add(tableName);
        }
        return DataTableCompareUtils.verifyRef(result);
    }

    /*
     * Exception decompiling
     */
    private static Set<String> verifyRef(Set<String> tableNames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

