/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.bizmodel.DetailStyle;
import kd.mmc.phm.common.bizmodel.DetailTable;
import kd.mmc.phm.common.bizmodel.ElementGroup;
import kd.mmc.phm.common.bizmodel.PictureElement;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.info.DetailGridInfo;

public class DesignerUtils {
    private DesignerUtils() {
        throw new RuntimeException("not supported");
    }

    public static List<ElementGroup> getElementGroup() {
        HashMap<String, Tuple> idMap = DesignerUtils.newHashMapWithExpectedSize(16);
        try (DataSet ds = DesignerUtils.queryComponentDefine();){
            for (Row row : ds) {
                String string = row.getString("name");
                String bizTypeName = row.getString("biztype.name");
                bizTypeName = StringUtils.isBlank((CharSequence)bizTypeName) ? "" : bizTypeName;
                idMap.put(row.getString("id"), Tuple.create((Object)string, (Object)bizTypeName));
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("finterid", "in", idMap.keySet())};
        TreeMap bizTypeNameMap = new TreeMap(Comparator.reverseOrder());
        DataSet attachmentDataSet = QueryServiceHelper.queryDataSet((String)DesignerUtils.class.getSimpleName(), (String)"bos_attachment", (String)"finterid, ffileid", (QFilter[])filters, null);
        Object object = null;
        try {
            for (Row row : attachmentDataSet) {
                Tuple tuple = (Tuple)idMap.get(row.getString("finterid"));
                String bizTypeName = (String)tuple.item2;
                ArrayList<PictureElement> pictureElements = (ArrayList<PictureElement>)bizTypeNameMap.get(bizTypeName);
                if (Objects.isNull(pictureElements)) {
                    pictureElements = new ArrayList<PictureElement>();
                }
                String elementName = (String)tuple.item1;
                String url = UrlService.getAttachmentFullUrl((String)row.getString("ffileid"));
                pictureElements.add(new PictureElement(elementName, url));
                bizTypeNameMap.put(bizTypeName, pictureElements);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (attachmentDataSet != null) {
                if (object != null) {
                    try {
                        attachmentDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    attachmentDataSet.close();
                }
            }
        }
        ArrayList<ElementGroup> list = new ArrayList<ElementGroup>(bizTypeNameMap.size());
        for (Map.Entry entry : bizTypeNameMap.entrySet()) {
            String lang = (String)entry.getKey();
            lang = StringUtils.isBlank((CharSequence)lang) ? ResManager.loadKDString((String)"\u901a\u7528\u5143\u4ef6", (String)"DesignerUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) : lang;
            list.add(new ElementGroup(lang, (List)entry.getValue()));
        }
        return list;
    }

    public static Map<String, ComponentInfo> wrapperComponentInfo(long bizModelId) {
        return DesignerUtils.wrapperComponentInfo(new HashMap<String, ComponentInfo>(16), bizModelId, bizModelId);
    }

    public static boolean exists(Object bizModelId) {
        return QueryServiceHelper.exists((String)"phm_component", (QFilter[])new QFilter("bizmodel", "=", bizModelId).toArray());
    }

    public static DataSet queryComponent(Object bizModelId) {
        return DesignerUtils.queryComponent(bizModelId, null, null);
    }

    public static DataSet queryComponent(Object bizModelId, ComponentType componentType) {
        return DesignerUtils.queryComponent(bizModelId, null, componentType);
    }

    public static DataSet queryComponent(Object bizModelId, String componentId) {
        return DesignerUtils.queryComponent(bizModelId, componentId, null);
    }

    private static DataSet queryComponent(Object bizModelId, String componentId, ComponentType componentType) {
        QFilter filter = new QFilter("bizmodel", "=", bizModelId);
        if (StringUtils.isNotBlank((CharSequence)componentId)) {
            filter.and(new QFilter("component", "=", (Object)componentId));
        }
        if (Objects.nonNull(componentType)) {
            filter.and(new QFilter("type", "=", (Object)componentType.getValue()));
        }
        return QueryServiceHelper.queryDataSet((String)DesignerUtils.class.getSimpleName(), (String)"phm_component", (String)"component, parent, type, data_tag", (QFilter[])filter.toArray(), null);
    }

    public static Map<String, ComponentInfo> wrapperComponentInfo(Map<String, ComponentInfo> componentInfoMap, long bizModelId, long queryBizModelId) {
        try (DataSet dataSet = DesignerUtils.queryComponent(queryBizModelId);){
            if (dataSet.hasNext()) {
                ComponentInfo info = new ComponentInfo();
                info.setBizModelId(bizModelId);
                for (Row row : dataSet) {
                    ComponentInfo clone = (ComponentInfo)info.clone();
                    String id = row.getString("component");
                    ComponentType type = ComponentType.fromValue(row.getString("type"));
                    Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                    clone.setComponentId(id);
                    clone.setElementId(row.getString("parent"));
                    clone.setComponentType(type);
                    clone.setProperties(properties);
                    Map<String, String> mustInputFields = clone.getMustInputFields();
                    switch (type) {
                        case QUERY: {
                            mustInputFields.put("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"DesignerUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]));
                            mustInputFields.put("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"DesignerUtils_2", (String)"mmc-phm-common", (Object[])new Object[0]));
                            break;
                        }
                        case EIGENVALUE: {
                            mustInputFields.put("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"DesignerUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]));
                            mustInputFields.put("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"DesignerUtils_2", (String)"mmc-phm-common", (Object[])new Object[0]));
                            String source = (String)properties.get("source");
                            if (StringUtils.equals((CharSequence)"new", (CharSequence)source)) {
                                mustInputFields.put("valuetype", ResManager.loadKDString((String)"\u503c\u7c7b\u578b", (String)"DesignerUtils_3", (String)"mmc-phm-common", (Object[])new Object[0]));
                                mustInputFields.put("set", ResManager.loadKDString((String)"\u503c\u914d\u7f6e", (String)"DesignerUtils_4", (String)"mmc-phm-common", (Object[])new Object[0]));
                                break;
                            }
                            mustInputFields.put("eigenedit", ResManager.loadKDString((String)"\u7279\u5f81\u503c", (String)"DesignerUtils_5", (String)"mmc-phm-common", (Object[])new Object[0]));
                            break;
                        }
                        case ADJUSTMENT: 
                        case CONNECTION: 
                        case DETAIL: 
                        case ELEMENT: {
                            ComponentInfo.initCommonMustInput(clone);
                            break;
                        }
                    }
                    componentInfoMap.put(id, clone);
                }
            }
        }
        return componentInfoMap;
    }

    public static DetailGridInfo wrapperDetailGridInfo(ComponentInfo componentInfo) {
        if (Objects.isNull(componentInfo)) {
            return null;
        }
        Map<String, Object> properties = componentInfo.getProperties();
        DetailGridInfo detailGridInfo = new DetailGridInfo();
        detailGridInfo.setKey(componentInfo.getComponentId());
        detailGridInfo.setWidth((Integer)properties.get("width"));
        detailGridInfo.setHeight((Integer)properties.getOrDefault("height", 250));
        detailGridInfo.setPageRow(Integer.parseInt((String)properties.get("pagerow")));
        detailGridInfo.setFontColor((String)properties.get("fontcolor"));
        detailGridInfo.setFontSize((Integer)properties.get("fontsize"));
        detailGridInfo.setBackColor((String)properties.get("backcolor"));
        return detailGridInfo;
    }

    public static DetailTable wrapperDetailTable(ComponentInfo detail, boolean running) {
        Map<String, Object> properties = detail.getProperties();
        DetailTable detailTable = new DetailTable();
        detailTable.setId(detail.getComponentId());
        detailTable.setRunning(running);
        boolean hide = (Boolean)properties.get("hide_runtime");
        detailTable.setHide(hide);
        DetailStyle detailStyle = DesignerUtils.wrapperDetailStyle(properties);
        detailTable.setStyle(detailStyle);
        detailTable.setPageSize(detailStyle.getPageSize());
        return detailTable;
    }

    public static DetailStyle wrapperDetailStyle(Map<String, Object> properties) {
        DetailStyle detailStyle = new DetailStyle();
        detailStyle.setWidth((Integer)properties.get("width"));
        detailStyle.setHeadHeight((Integer)properties.getOrDefault("headheight", 40));
        detailStyle.setRowHeight((Integer)properties.getOrDefault("rowheight", 40));
        detailStyle.setMaxRow((Integer)properties.getOrDefault("maxrow", 10));
        detailStyle.setPageSize(Integer.parseInt((String)properties.get("pagerow")));
        detailStyle.setFontColor((String)properties.get("fontcolor"));
        detailStyle.setFontSize((Integer)properties.get("fontsize"));
        detailStyle.setBackColor((String)properties.get("backcolor"));
        detailStyle.setHeadColor((String)properties.get("headcolor"));
        detailStyle.setX(String.valueOf(properties.get("x")));
        detailStyle.setY(String.valueOf(properties.get("y")));
        return detailStyle;
    }

    private static DataSet queryComponentDefine() {
        QFilter[] filters = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()).and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue())).toArray();
        return QueryServiceHelper.queryDataSet((String)DesignerUtils.class.getSimpleName(), (String)"phm_componentdefine", (String)"id, name, biztype.name", (QFilter[])filters, null);
    }

    private static void dealEigenValue(Map<String, Object> dataMap, Object bizModelId) {
        if (DesignerUtils.exists(bizModelId)) {
            try (DataSet dataSet = DesignerUtils.queryComponent(bizModelId, ComponentType.EIGENVALUE);){
                for (Row row : dataSet) {
                    String componentId = row.getString("component");
                    Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                    String name = (String)properties.get("name");
                    String precInfo = (String)properties.get("precinfo_tag");
                    DesignerUtils.deal(dataMap, precInfo, componentId, name);
                }
            }
        } else {
            QFilter[] qfilters = new QFilter[]{new QFilter("bizmodelid", "=", bizModelId), new QFilter("precinfo_tag", "is not null", (Object)"")};
            DynamicObjectCollection objCol = QueryServiceHelper.query((String)"phm_bizmodel_eigen", (String)"id,name,componentid,precinfo_tag", (QFilter[])qfilters);
            for (DynamicObject obj : objCol) {
                String precinfo = obj.getString("precinfo_tag");
                String componentid = obj.getString("componentid");
                String name = obj.getString("name");
                DesignerUtils.deal(dataMap, precinfo, componentid, name);
            }
        }
    }

    public static void deal(Map<String, Object> dataMap, String precinfo, String componentid, String name) {
        Map precinfoMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)precinfo)) {
            precinfoMap = (Map)SerializationUtils.fromJsonString((String)precinfo, Map.class);
        }
        if (precinfoMap == null) {
            return;
        }
        Object data = dataMap.get(componentid);
        if (data instanceof Integer) {
            int result = (Integer)data;
            data = new BigDecimal(result);
            String settings = (String)precinfoMap.get(name);
            if (StringUtils.isEmpty((CharSequence)settings)) {
                return;
            }
            Map settingsMap = (Map)SerializationUtils.fromJsonString((String)settings, Map.class);
            boolean isPercent = (Boolean)settingsMap.get("ispercent");
            int decimal = (Integer)settingsMap.get("decimal");
            NumberFormat format = null;
            format = isPercent ? NumberFormat.getPercentInstance() : NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(decimal);
            format.setMinimumFractionDigits(decimal);
            data = format.format(data);
            dataMap.put(componentid, data);
        } else if (data instanceof BigDecimal) {
            String settings = (String)precinfoMap.get(name);
            if (StringUtils.isEmpty((CharSequence)settings)) {
                return;
            }
            Map settingsMap = (Map)SerializationUtils.fromJsonString((String)settings, Map.class);
            boolean isPercent = (Boolean)settingsMap.get("ispercent");
            int decimal = (Integer)settingsMap.get("decimal");
            NumberFormat format = null;
            format = isPercent ? NumberFormat.getPercentInstance() : NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(decimal);
            format.setMinimumFractionDigits(decimal);
            data = format.format(data);
            dataMap.put(componentid, data);
        } else if (data instanceof JSONObject) {
            Map datasMap;
            JSONObject map = JSONObject.parseObject((String)data.toString());
            Map colTypes = (Map)map.get("colTypes");
            Set colNames = colTypes.keySet();
            ArrayList colNamesList = new ArrayList(colNames);
            HashMap<Integer, Tuple> paramsMap = new HashMap<Integer, Tuple>();
            for (int k = 0; k < colNamesList.size(); ++k) {
                String colName = (String)colNamesList.get(k);
                String settings = (String)precinfoMap.get(colName);
                if (StringUtils.isEmpty((CharSequence)settings)) continue;
                Map settingsMap = (Map)SerializationUtils.fromJsonString((String)settings, Map.class);
                int decimal = (Integer)settingsMap.get("decimal");
                boolean ispercent = (Boolean)settingsMap.get("ispercent");
                Tuple tuple = new Tuple((Object)decimal, (Object)ispercent);
                paramsMap.put(k, tuple);
            }
            List rows = (List)map.get("rows");
            if (rows == null && (datasMap = (Map)map.get("datas")) != null) {
                rows = (List)datasMap.get("rows");
            }
            if (Objects.isNull(rows)) {
                return;
            }
            ArrayList newRows = new ArrayList(10);
            for (int k = 0; k < rows.size(); ++k) {
                List rowDatas = (List)rows.get(k);
                ArrayList newRowDatas = new ArrayList();
                for (int j = 0; j < rowDatas.size(); ++j) {
                    Object rowData = rowDatas.get(j);
                    if (!paramsMap.containsKey(j)) {
                        newRowDatas.add(rowData);
                        continue;
                    }
                    Tuple tuple = (Tuple)paramsMap.get(j);
                    int decimal = (Integer)tuple.item1;
                    boolean ispercent = (Boolean)tuple.item2;
                    NumberFormat format = null;
                    format = ispercent ? NumberFormat.getPercentInstance() : NumberFormat.getNumberInstance();
                    if (rowData instanceof Integer) {
                        int result = (Integer)rowData;
                        format.setMaximumFractionDigits(decimal);
                        format.setMinimumFractionDigits(decimal);
                        rowData = format.format(result);
                    } else if (rowData instanceof BigDecimal) {
                        BigDecimal result = (BigDecimal)rowData;
                        format.setMaximumFractionDigits(decimal);
                        format.setMinimumFractionDigits(decimal);
                        rowData = format.format(result);
                    }
                    newRowDatas.add(rowData);
                }
                newRows.add(newRowDatas);
            }
            if (!newRows.isEmpty()) {
                if (map.containsKey("rows")) {
                    map.put("rows", newRows);
                } else {
                    Map datasMap2 = (Map)map.get("datas");
                    datasMap2.put("rows", newRows);
                    map.put("datas", datasMap2);
                }
            }
            dataMap.put(componentid, map);
        }
    }

    public static Map<String, Object> getFormatEigenvalue(Map<String, Object> eigenvalueMap) {
        return DesignerUtils.formatEigenvalue(eigenvalueMap);
    }

    public static Map<String, Object> getFormatEigenvalue(Map<String, Serializable> datas, Object bizModelId) {
        HashMap<String, Object> singleMap = new HashMap<String, Object>(16);
        if (Objects.isNull(datas) || datas.isEmpty()) {
            return singleMap;
        }
        Map<String, Object> eigenvalueMap = DesignerUtils.getHandledEigenvalue(datas, bizModelId);
        return DesignerUtils.formatEigenvalue(eigenvalueMap);
    }

    private static Map<String, Object> formatEigenvalue(Map<String, Object> eigenvalueMap) {
        HashMap<String, Object> singleMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Object> entry : eigenvalueMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                Map datasMap;
                List rows;
                Object sortedColLabels;
                Map map = (Map)JSONObject.parse((String)value.toString());
                JSONObject colTypes = null;
                JSONArray colNames = null;
                String falseType = "";
                Object colTypesObj = map.get("colTypes");
                if (colTypesObj instanceof JSONObject) {
                    colTypes = (JSONObject)colTypesObj;
                }
                if ((sortedColLabels = map.get("sortedColLabels")) instanceof JSONArray) {
                    colNames = (JSONArray)sortedColLabels;
                }
                if ((rows = (List)map.get("rows")) == null && (datasMap = (Map)map.get("datas")) != null) {
                    rows = (List)datasMap.get("rows");
                }
                if (rows != null && rows.size() > 0) {
                    List row = (List)rows.get(0);
                    row.removeIf(e -> Objects.isNull(e));
                    if (rows.size() == 1 && row.size() == 1) {
                        singleMap.put(entry.getKey(), row.get(0).toString());
                        continue;
                    }
                    singleMap.put(entry.getKey(), ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"DesignerUtils_6", (String)"mmc-phm-common", (Object[])new Object[0]));
                    continue;
                }
                singleMap.put(entry.getKey(), " ");
                continue;
            }
            if (value == null) continue;
            singleMap.put(entry.getKey(), value.toString());
        }
        return singleMap;
    }

    public static Map<String, Object> getHandledEigenvalue(Map<String, Serializable> datas, Object bizModelId) {
        HashMap<String, Object> eigenvalueMap = DesignerUtils.newHashMapWithExpectedSize(datas.size());
        for (Map.Entry<String, Serializable> entry : datas.entrySet()) {
            if (StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)"detail")) continue;
            Serializable value = entry.getValue();
            eigenvalueMap.put(entry.getKey(), value);
        }
        DesignerUtils.dealEigenValue(eigenvalueMap, bizModelId);
        return eigenvalueMap;
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(DesignerUtils.capacity(expectedSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(DesignerUtils.capacity(expectedSize));
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        return expectedSize < 0x40000000 ? (int)((float)expectedSize / 0.75f + 1.0f) : Integer.MAX_VALUE;
    }
}

