/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.mvc.form.ClientViewProxy;

public class EntryUtils {
    private EntryUtils() {
        throw new UnsupportedOperationException();
    }

    public static void batchCreateEntryRow(IFormView view, String entryKey, String[] fields, List<List<Object>> values) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(fields);
        for (List<Object> value : values) {
            tvs.addRow(value.toArray());
        }
        model.batchCreateNewEntryRow(entryKey, tvs);
        model.endInit();
        view.updateView(entryKey);
    }

    public static void setColumnLock(IFormView view, String entryKey, boolean lock, String ... fieldKeys) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
        int lockState = lock ? -1 : 0;
        for (String fieldKey : fieldKeys) {
            entryGrid.setColumnProperty(fieldKey, "l", (Object)lockState);
        }
    }

    public static void setCellStyle(IFormView view, String entryKey, Function<DynamicObject, CellStyle> function) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryKey);
        if (entryEntity.isEmpty()) {
            return;
        }
        int size = entryEntity.size();
        ArrayList cellStyles = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            CellStyle cellStyle = function.apply((DynamicObject)entryEntity.get(i));
            if (cellStyle == null) continue;
            cellStyle.setRow(i);
            cellStyles.add(cellStyle);
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)view.getService(IClientViewProxy.class);
        ClientActions.createCellStyle().addAll((List)cellStyles).invokeControlMethod((IClientViewProxy)clientViewProxy, entryKey);
    }
}

