/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.AutoSubmitParam;
import kd.mmc.phm.common.domian.process.AutoSubmitScheduleParam;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessResourceSourceEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.enums.TaskStatusEnum;
import kd.mmc.phm.common.util.FlowNode;
import kd.mmc.phm.common.util.FlowUtils;
import kd.mmc.phm.common.util.ScheduleUtils;
import kd.mmc.phm.common.util.VersionRuleUtils;
import kd.mmc.phm.common.util.process.AutoSubmitUtil;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import kd.mmc.phm.common.util.process.ProcessUpdateUtil;
import kd.mmc.phm.common.util.process.ScheduleCreateUtil;
import org.apache.commons.lang3.time.DateUtils;

public class FlowActiveUtil {
    private static final String PHM_FLOW_DEFINE = "phm_flow_define";
    private static final String FLOWNODEENTRY = "flownodeentryentity";
    private static final String FLOWCONF = "flowconf_tag";
    private static final BigDecimal ONE_DAY = new BigDecimal(String.valueOf(86400000));
    private static final Log log = LogFactory.getLog(FlowActiveUtil.class);

    public static void activeFlowNode(long flowId, String nodeId, String sign, String historyId) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)PHM_FLOW_DEFINE);
        DynamicObject flowHistory = BusinessDataServiceHelper.loadSingle((Object)historyId, (String)"phm_process_history");
        String flowConfig = flow.getString(FLOWCONF);
        if (StringUtils.isBlank((CharSequence)flowConfig)) {
            return;
        }
        Boolean isNoTaskNode = false;
        FlowNode rootNode = FlowUtils.resolveFlowTree(flowConfig);
        DynamicObjectCollection entryentity = flowHistory.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection flowNodeEntry = flow.getDynamicObjectCollection(FLOWNODEENTRY);
        Map nodesMap = FlowActiveUtil.getNodesMap(flowNodeEntry);
        FlowActiveUtil.removeNotExitNode(nodesMap, rootNode);
        Map<String, Object> entrysMap = nodesMap.get(nodeId);
        DynamicObjectCollection resourceEntrys = (DynamicObjectCollection)entrysMap.get("resourcesubentryentity");
        if (resourceEntrys == null || resourceEntrys.size() == 0) {
            isNoTaskNode = true;
        }
        for (DynamicObject dynamicObject : entryentity) {
            long entryId;
            boolean isFinish;
            if (!nodeId.equals(dynamicObject.getString("nodeid"))) continue;
            if (isNoTaskNode.booleanValue()) {
                dynamicObject.set("node_status", (Object)RunningState.COMPLETED.getValue());
            } else {
                dynamicObject.set("node_status", (Object)RunningState.RUNNING.getValue());
            }
            dynamicObject.set("node_createtime", (Object)new Date());
            Boolean ischeckStatus = true;
            DynamicObjectCollection subentryentity_task = dynamicObject.getDynamicObjectCollection("subentryentity_task");
            subentryentity_task.clear();
            boolean isControl = false;
            for (DynamicObject resourceEntry : resourceEntrys) {
                DynamicObject deliverables = (DynamicObject)resourceEntry.get("deliverables");
                String datasource = deliverables.getString("datasource");
                DynamicObject datasourceid = deliverables.getDynamicObject("datasourceid");
                String status = "C";
                String enable = "1";
                if (deliverables != null) {
                    status = deliverables.getString("status");
                    enable = deliverables.getString("enable");
                }
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)status) || !StringUtils.equals((CharSequence)"1", (CharSequence)enable)) continue;
                DynamicObject subEntry = subentryentity_task.addNew();
                subEntry.set("task_processhistory", flowHistory.getPkValue());
                subEntry.set("task_resourcetype", (Object)datasource);
                subEntry.set("task_resource", resourceEntry.get("resource"));
                subEntry.set("task_createdate", (Object)new Date());
                subEntry.set("task_status", (Object)TaskStatusEnum.UNPROCESS.getValue());
                String deliverablesnumber = resourceEntry.getString("deliverablesnumber");
                subEntry.set("deliverablesnumber", (Object)deliverablesnumber);
                subEntry.set("deliverablesname", resourceEntry.get("deliverablesname"));
                subEntry.set("deliverables", resourceEntry.get("deliverables"));
                FlowActiveUtil.replacePkID(resourceEntry, subEntry, "depersonliable", "depersonliable");
                FlowActiveUtil.replacePkID(resourceEntry, subEntry, "deliableorg", "deliableorg");
                subEntry.set("schedule", resourceEntry.get("schedule"));
                subEntry.set("warningcycle", resourceEntry.get("warningcycle"));
                subEntry.set("overduecycle", resourceEntry.get("overduecycle"));
                subEntry.set("seriousoverduecycle", resourceEntry.get("seriousoverduecycle"));
                FlowActiveUtil.replacePkID(resourceEntry, subEntry, "waringuser", "waringuser");
                FlowActiveUtil.replacePkID(resourceEntry, subEntry, "overduecyuser", "overduecyuser");
                FlowActiveUtil.replacePkID(resourceEntry, subEntry, "seriousoverdueuser", "seriousoverdueuser");
                FlowActiveUtil.setConditionValue(subEntry, resourceEntry, "frontcondition");
                FlowActiveUtil.setConditionValue(subEntry, resourceEntry, "aftercondition");
                subEntry.set("recustomers", resourceEntry.get("recustomers"));
                subEntry.set("remake", resourceEntry.get("remake"));
                FlowActiveUtil.replacePkID(resourceEntry, subEntry, "superior", "superior");
                subEntry.set("datasource", deliverables.get("datasource"));
                subEntry.set("datasourceid", deliverables.get("datasourceid"));
                boolean resourceControl = resourceEntry.getBoolean("control");
                subEntry.set("task_control", (Object)resourceControl);
                if (resourceControl) {
                    isControl = resourceControl;
                    String formula = resourceEntry.getString("formula");
                    if (StringUtils.isNotBlank((CharSequence)formula)) {
                        String[] split = formula.split(";");
                        int value = Integer.parseInt(split[2]);
                        if ("0".equals(split[1])) {
                            ++value;
                        }
                        subEntry.set("taskprogress", (Object)"0/".concat(Integer.toString(value)));
                    }
                }
                BigDecimal nodecycle = dynamicObject.getBigDecimal("node_period");
                subEntry.set("task_period", (Object)nodecycle);
                if (BigDecimal.ZERO.compareTo(nodecycle) != 0) {
                    BigDecimal minutes = nodecycle.multiply(new BigDecimal("24")).multiply(new BigDecimal("60"));
                    subEntry.set("task_completedate", (Object)DateUtils.addMinutes((Date)new Date(), (int)minutes.intValue()));
                }
                DynamicObjectCollection roles = resourceEntry.getDynamicObjectCollection("role");
                DynamicObjectCollection task_roles = subEntry.getDynamicObjectCollection("task_role");
                for (DynamicObject role : roles) {
                    DynamicObject task_role = task_roles.addNew();
                    task_role.set(2, role.get(2));
                }
                subEntry.set("task_role", (Object)task_roles);
                String dealType = resourceEntry.getString("dealtype");
                subEntry.set("task_dealtype", (Object)dealType);
                FlowActiveUtil.writeLog(flowHistory.getString("number"), datasource, deliverablesnumber);
                if ("phm_tasknotice".equals(datasource)) {
                    FlowActiveUtil.creatTaskNotieFlow(resourceEntry, flow, dynamicObject, flowHistory, sign, "tasknotice");
                }
                if ("phm_eigenvalue".equals(datasource)) {
                    if (!FlowActiveUtil.isCompleteEigenvalue(subEntry, deliverables)) {
                        ischeckStatus = false;
                        Object tasknoticeId = FlowActiveUtil.creatTaskNotieFlow(resourceEntry, flow, dynamicObject, flowHistory, sign, "eigenvalues");
                        FlowActiveUtil.creatSuheduByEigenvalue(dynamicObject, flowHistory, deliverablesnumber, tasknoticeId);
                        FlowActiveUtil.creatSuheduPlan(resourceEntry, dynamicObject, flowHistory, deliverablesnumber);
                        continue;
                    }
                    FlowActiveUtil.creatTaskNotieFlow(resourceEntry, flow, dynamicObject, flowHistory, sign, "eigenvalue");
                    continue;
                }
                ischeckStatus = false;
                FlowActiveUtil.creatSuheduPlan(resourceEntry, dynamicObject, flowHistory, deliverablesnumber);
            }
            if (!isControl) {
                dynamicObject.set("node_status", (Object)RunningState.COMPLETED.getValue());
            }
            dynamicObject.set("node_iscontrol", (Object)isControl);
            SaveServiceHelper.saveOperate((String)"phm_process_history", (DynamicObject[])new DynamicObject[]{flowHistory}, (OperateOption)OperateOption.create());
            if (ischeckStatus.booleanValue() && (isFinish = ProcessQueryUtil.queryNodeFinish(entryId = dynamicObject.getLong("id")))) {
                ProcessUpdateUtil.updateNodeStatusByNodeEntryId(entryId, RunningState.COMPLETED.getValue());
                ProcessUpdateUtil.processFinish(Long.parseLong(historyId));
            }
            ArrayList<FlowNode> childNode = new ArrayList<FlowNode>(8);
            FlowUtils.getChildNode(rootNode, nodeId, childNode);
            ArrayList<String> list = new ArrayList<String>(8);
            for (FlowNode flowNode : childNode) {
                list.add(flowNode.getId());
            }
            Map<String, String> nodeName = FlowUtils.getNodeName(list, nodesMap);
            if ("1".equals(sign)) {
                String string = flowHistory.getString("satrnewdate_tag");
                nodesMap = (Map)SerializationUtils.deSerializeFromBase64((String)string);
            }
            ScheduleUtils.createNodeJobAndSchedule(flow, nodeName, nodesMap, flowHistory);
        }
    }

    public static boolean isCompleteEigenvalue(DynamicObject subEntry, DynamicObject deliverables) {
        String table = deliverables.getString("table");
        String filed = deliverables.getString("field");
        boolean isCompelete = true;
        String value = null;
        if (DB.exitsTable((DBRoute)CommonConsts.ROUTE_PHM, (String)table)) {
            StringBuilder stringBuilder = new StringBuilder("select ");
            stringBuilder.append(filed).append(" from ").append(table);
            try (DataSet dataSet = DB.queryDataSet((String)"activeFlowNode", (DBRoute)CommonConsts.ROUTE_PHM, (String)stringBuilder.toString());){
                for (Row row : dataSet) {
                    value = row.getString(filed);
                    if (value == null) continue;
                    break;
                }
            }
            if (value == null || value.isEmpty() || "0".equals(value)) {
                isCompelete = false;
            } else {
                String formula;
                ArrayList statusList = Lists.newArrayList((Object[])new String[]{TaskStatusEnum.WARN.getValue(), TaskStatusEnum.OVERDUE.getValue(), TaskStatusEnum.SEROVERDUE.getValue()});
                String task_status = subEntry.getString("task_status");
                if (task_status == null || !statusList.contains(task_status)) {
                    subEntry.set("task_status", (Object)TaskStatusEnum.CLOSED.getValue());
                }
                if (StringUtils.isNotBlank((CharSequence)(formula = subEntry.getString("taskprogress")))) {
                    String[] split = formula.split("/");
                    int num = Integer.parseInt(split[1]);
                    subEntry.set("taskprogress", (Object)(num + "/" + num));
                }
            }
        } else {
            isCompelete = false;
        }
        return isCompelete;
    }

    private static void creatProcessResources(DynamicObject datasourceid, String datasource, DynamicObject flowHistory_node, DynamicObject flowHistory, String deliverablesnumber, DynamicObjectCollection roles) {
        DynamicObject dynamicObject_taskreationad = BusinessDataServiceHelper.newDynamicObject((String)"phm_process_resources");
        dynamicObject_taskreationad.set("resource_type", (Object)datasource);
        dynamicObject_taskreationad.set("resource_number", (Object)datasourceid);
        Object judge = datasourceid.get("judge");
        if (judge != null && !judge.toString().isEmpty()) {
            dynamicObject_taskreationad.set("resource_status", (Object)"C");
        } else {
            dynamicObject_taskreationad.set("resource_status", (Object)"A");
        }
        dynamicObject_taskreationad.set("resource_modifier", datasourceid.get("taskperson"));
        dynamicObject_taskreationad.set("resource_modifytime", (Object)new Date());
        dynamicObject_taskreationad.set("entry_node", (Object)flowHistory_node);
        dynamicObject_taskreationad.set("resource_processhistory", (Object)flowHistory);
        dynamicObject_taskreationad.set("resource_dealtype", (Object)"manual");
        dynamicObject_taskreationad.set("resource_datatype", (Object)datasource);
        dynamicObject_taskreationad.set("resource_data", (Object)datasourceid);
        dynamicObject_taskreationad.set("number", (Object)deliverablesnumber);
        Object[] ob = new Object[roles.size()];
        int i = 0;
        for (DynamicObject muDynamicObject : roles) {
            ob[i] = muDynamicObject.get(2);
            ++i;
        }
        dynamicObject_taskreationad.set("resource_role", (Object)ob);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject_taskreationad});
        FlowActiveUtil.writeLog(flowHistory.getString("number"), deliverablesnumber + ":ProcessResources");
    }

    /*
     * Loose catch block
     */
    public static void creatSuheduPlan(DynamicObject resourceEntry, DynamicObject dynamicObject_node, DynamicObject flowHistory, String deliverablesnumber) {
        block25: {
            Throwable throwable;
            TXHandle th;
            block22: {
                block23: {
                    block24: {
                        List pkId;
                        OperationResult result;
                        String number;
                        String type;
                        block19: {
                            block20: {
                                block21: {
                                    th = TX.requiresNew();
                                    throwable = null;
                                    type = "warning";
                                    number = flowHistory.getString("number");
                                    result = ScheduleUtils.creatJobPlan(dynamicObject_node, type, flowHistory, deliverablesnumber);
                                    pkId = result.getSuccessPkIds();
                                    if (pkId != null && pkId.size() != 0) break block19;
                                    log.error("\u542f\u52a8\u5931\u8d25\uff0c\u672a\u751f\u6210\u9884\u8b66\u8c03\u5ea6\u4f5c\u4e1a\u3002");
                                    if (th == null) break block20;
                                    if (throwable == null) break block21;
                                    try {
                                        th.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block20;
                                }
                                th.close();
                            }
                            return;
                        }
                        String jobId = pkId.get(0).toString();
                        result = ScheduleUtils.creatSuheduPlan(jobId, resourceEntry, dynamicObject_node, type, number);
                        if (result.getSuccessPkIds() != null && result.getSuccessPkIds().size() != 0) break block22;
                        log.error("\u542f\u52a8\u5931\u8d25\uff0c\u672a\u751f\u6210\u9884\u8b66\u8c03\u5ea6\u8ba1\u5212\u3002");
                        if (th == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            th.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block23;
                    }
                    th.close();
                }
                return;
            }
            try {
                break block25;
                catch (Exception e) {
                    th.markRollback();
                    log.error(e.getMessage());
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (th != null) {
                    if (throwable != null) {
                        try {
                            th.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        th.close();
                    }
                }
            }
        }
    }

    public static void creatSuheduByEigenvalue(DynamicObject flow_node, DynamicObject flowHistory, String deliverablesnumber, Object tasknoticeId) {
        OperationResult result = ScheduleUtils.creatJobByEigenvalue(flow_node, flowHistory, deliverablesnumber, tasknoticeId);
        List pkId = result.getSuccessPkIds();
        if (pkId == null || pkId.size() == 0) {
            log.error("\u542f\u52a8\u5931\u8d25\uff0c\u672a\u751f\u6210\u7279\u5f81\u503c\u8f6e\u8be2\u8c03\u5ea6\u4f5c\u4e1a\u3002");
            return;
        }
        String jobId = pkId.get(0).toString();
        String nodeId = flow_node.getString("nodeId");
        result = ScheduleUtils.creatSuheduByEigenvalue(jobId, flowHistory, deliverablesnumber);
        if (result.getSuccessPkIds() == null || result.getSuccessPkIds().size() == 0) {
            log.error("\u542f\u52a8\u5931\u8d25\uff0c\u672a\u751f\u6210\u7279\u5f81\u503c\u8f6e\u8be2\u8c03\u5ea6\u8ba1\u5212\u3002");
            return;
        }
    }

    public static Object creatTaskNotieFlow(DynamicObject flow_task, DynamicObject flow, DynamicObject flowHistory_node, DynamicObject flowHistory, String sign, String bill) {
        DynamicObjectCollection depersonliable = flow_task.getDynamicObjectCollection("depersonliable");
        DynamicObject deliverables = (DynamicObject)flow_task.get("deliverables");
        String datasource = deliverables.getString("datasource");
        FlowActiveUtil.writeLog(flowHistory.getString("number"), depersonliable.toString());
        for (DynamicObject dynamicObject1 : depersonliable) {
            DynamicObject dynamicObject_notice = BusinessDataServiceHelper.newDynamicObject((String)"phm_tasknotice");
            String codeRule = FlowActiveUtil.getCodeRule("phm_tasknotice");
            dynamicObject_notice.set("number", (Object)codeRule);
            dynamicObject_notice.set("taskperson", dynamicObject1.get("fbasedataid_id"));
            dynamicObject_notice.set("project", flow.getDynamicObject("milepost").get("project"));
            dynamicObject_notice.set("milepoststage", flowHistory_node.get("stage"));
            dynamicObject_notice.set("milepostperson", flow.getDynamicObject("milepost").get("userliable"));
            dynamicObject_notice.set("processname", flow.get("name"));
            FlowActiveUtil.replacePkID(flow, dynamicObject_notice, "processperson", "flowleader");
            dynamicObject_notice.set("nodename", flowHistory_node.get("node_name"));
            dynamicObject_notice.set("nodeperson", flowHistory_node.get("personliables"));
            dynamicObject_notice.set("explain", flow.get("remark"));
            dynamicObject_notice.set("begintime", flowHistory_node.get("planbegintime"));
            dynamicObject_notice.set("endtime", flowHistory_node.get("planendtime"));
            dynamicObject_notice.set("actualtime", flowHistory_node.get("node_createtime"));
            dynamicObject_notice.set("nowtime", (Object)new Date());
            dynamicObject_notice.set("startype", (Object)sign);
            dynamicObject_notice.set("name", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u901a\u77e5\u4e0e\u5b8c\u6210\u786e\u8ba4\u5355", (String)"FlowActiveUtil_0", (String)"mmc-phm-common", (Object[])new Object[0]));
            if ("eigenvalues".equals(bill)) {
                dynamicObject_notice.set("name", (Object)ResManager.loadKDString((String)"\u76d1\u63a7\u7c7b\u4efb\u52a1\u72b6\u6001\u901a\u77e5\u5355", (String)"FlowActiveUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]));
                dynamicObject_notice.set("judge", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u503c\u4e3a\u201c1\u201d\u8868\u793a\u5b8c\u6210\uff0c\u4e3a\u5176\u4ed6\u503c\u8868\u793a\u672a\u5b8c\u6210\u3002", (String)"FlowActiveUtil_2", (String)"mmc-phm-common", (Object[])new Object[0]));
                dynamicObject_notice.set("taskstate", (Object)"2");
            } else if ("eigenvalue".equals(bill)) {
                dynamicObject_notice.set("name", (Object)ResManager.loadKDString((String)"\u76d1\u63a7\u7c7b\u4efb\u52a1\u72b6\u6001\u901a\u77e5\u5355", (String)"FlowActiveUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]));
                dynamicObject_notice.set("judge", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u503c\u4e3a\u201c1\u201d\u8868\u793a\u5b8c\u6210\uff0c\u4e3a\u5176\u4ed6\u503c\u8868\u793a\u672a\u5b8c\u6210\u3002", (String)"FlowActiveUtil_2", (String)"mmc-phm-common", (Object[])new Object[0]));
                dynamicObject_notice.set("taskstate", (Object)"1");
            }
            dynamicObject_notice.set("processhistory", (Object)flowHistory);
            dynamicObject_notice.set("nodeid", (Object)flowHistory_node.getString("nodeid"));
            String number = flow_task.getString("deliverablesnumber");
            dynamicObject_notice.set("taskame", flow_task.get("deliverablesname"));
            dynamicObject_notice.set("entry_task", (Object)number);
            BigDecimal runtime = flowHistory_node.get("planbegintime") != null ? FlowActiveUtil.calcRuntime(flowHistory_node.getDate("planbegintime"), new Date()) : null;
            dynamicObject_notice.set("lenthtime", runtime);
            long currUserId = dynamicObject1.getLong("fbasedataid_id");
            dynamicObject_notice.set("dealperson", (Object)currUserId);
            long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)currUserId);
            ArrayList<Long> userMainOrgIds = new ArrayList<Long>(8);
            ArrayList<Long> userIds = new ArrayList<Long>(8);
            userMainOrgIds.add(userMainOrgId);
            userIds.add(currUserId);
            Map<Long, Long> userDirector = FlowActiveUtil.getUserDirector(userMainOrgIds, userIds);
            dynamicObject_notice.set("superleader", (Object)userDirector.get(currUserId));
            dynamicObject_notice.set("projectmanager", flow.getDynamicObject("milepost").get("userliable"));
            dynamicObject_notice.set("fronttask", flow_task.get("frontcondition"));
            dynamicObject_notice.set("aftertask", flow_task.get("aftercondition"));
            dynamicObject_notice.set("tasktiptime", (Object)new Date());
            if ("phm_eigenvalue".equals(datasource)) {
                datasource = "phm_tasknotice";
            }
            String operationKey = "submit";
            if (!"tasknotice".equals(bill)) {
                dynamicObject_notice.set("status", (Object)"C");
                operationKey = "save";
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"phm_tasknotice", (DynamicObject[])new DynamicObject[]{dynamicObject_notice}, (OperateOption)OperateOption.create());
            String name = dynamicObject1.getDynamicObject("fbasedataid").getString("name");
            List successPkIds = operationResult.getSuccessPkIds();
            FlowActiveUtil.writeLog(flowHistory.getString("number"), number, "phm_tasknotice:" + codeRule, "taskperson:" + name);
            if (successPkIds.size() == 0 || "phm_billtemp".equals(datasource)) continue;
            DynamicObjectCollection roles = flow_task.getDynamicObjectCollection("role");
            FlowActiveUtil.creatProcessResources(dynamicObject_notice, datasource, flowHistory_node, flowHistory, number, roles);
            return successPkIds.get(0);
        }
        return null;
    }

    public static void writeLog(String hisNum, String ... messages) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hisNum).append(":");
        for (String message : messages) {
            stringBuilder.append(message).append("/n");
        }
        log.info(stringBuilder.toString());
    }

    private static BigDecimal calcRuntime(Date startDate, Date endDate) {
        return new BigDecimal(String.valueOf(endDate.getTime())).subtract(new BigDecimal(String.valueOf(startDate.getTime()))).divide(ONE_DAY, 1, 1);
    }

    private static String getCodeRule(String sign) {
        DynamicObject dynamicObject = ORM.create().newDynamicObject(sign);
        String codeRuleNumber = CodeRuleServiceHelper.getNumber((String)sign, (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
        return codeRuleNumber;
    }

    public static void activeEigenvaluePolling(long historyId, String nodeId, String deliverablesnumber, Object tasknoticeId) {
        DynamicObject flowHistory = BusinessDataServiceHelper.loadSingle((Object)historyId, (String)"phm_process_history");
        String startype = flowHistory.getString("startype");
        String number = flowHistory.getString("number");
        DynamicObjectCollection entryentity = flowHistory.getDynamicObjectCollection("entryentity");
        Boolean isDelete = false;
        for (DynamicObject dynamicObject_node : entryentity) {
            if (!nodeId.equals(dynamicObject_node.getString("nodeid"))) continue;
            DynamicObjectCollection subentryentity_task = dynamicObject_node.getDynamicObjectCollection("subentryentity_task");
            for (DynamicObject dynamicObject_task : subentryentity_task) {
                if (!deliverablesnumber.equals(dynamicObject_task.getString("deliverablesnumber"))) continue;
                long entryId = dynamicObject_node.getLong("id");
                DynamicObject deliverables = (DynamicObject)dynamicObject_task.get("deliverables");
                if (!FlowActiveUtil.isCompleteEigenvalue(dynamicObject_task, deliverables)) continue;
                FlowActiveUtil.updateCompeleteState(tasknoticeId);
                isDelete = true;
                boolean isFinish = ProcessQueryUtil.queryNodeFinish(entryId);
                if (!isFinish) continue;
                ProcessUpdateUtil.updateNodeStatusByNodeEntryId(entryId, RunningState.COMPLETED.getValue());
                ProcessUpdateUtil.processFinish(historyId);
            }
        }
        if (isDelete.booleanValue()) {
            ScheduleUtils.deleteEigenvaluePollingSchedule(number, deliverablesnumber);
            ScheduleUtils.deleteSuheduPlan(historyId, deliverablesnumber);
        }
    }

    private static void updateCompeleteState(Object resourceId) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)resourceId, (String)"phm_process_resources");
        if (task == null) {
            return;
        }
        String status = task.getString("taskstate");
        if ("2".equals(status)) {
            task.set("taskstate", (Object)"1");
            SaveServiceHelper.update((DynamicObject)task);
        }
    }

    public static void activeFlow(long flowId, String sign) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)PHM_FLOW_DEFINE);
        String flowConfig = flow.getString(FLOWCONF);
        if (StringUtils.isBlank((CharSequence)flowConfig)) {
            return;
        }
        DynamicObjectCollection flowNodeEntry = flow.getDynamicObjectCollection(FLOWNODEENTRY);
        Map<String, Map<String, Object>> nodesMap = FlowActiveUtil.getNodesMap(flowNodeEntry);
        FlowNode rootNode = FlowUtils.resolveFlowTree(flowConfig);
        if (rootNode == null) {
            return;
        }
        FlowActiveUtil.removeNotExitNode(nodesMap, rootNode);
        ArrayList<String> nodeIdList = new ArrayList<String>(8);
        FlowActiveUtil.getCreatJobNode(nodeIdList, rootNode.getChildren(), rootNode.getChildren().size());
        Map<String, String> runNodeIds = FlowUtils.getNodeName(nodeIdList, nodesMap);
        Date validated_time = flow.getDate("validated_time");
        FlowActiveUtil.changeDateByManual(nodesMap, validated_time, flow);
        Object history = FlowActiveUtil.creatHistory(flow, nodesMap, 0L, sign);
        String historyId = ((DynamicObject)history).getString("id");
        for (Map.Entry<String, Map<String, Object>> mapEntry : nodesMap.entrySet()) {
            Map<String, Object> value;
            DynamicObject flownodeDyn;
            Date beginDate;
            String key = mapEntry.getKey();
            if (!nodeIdList.contains(key) || !(beginDate = (flownodeDyn = (DynamicObject)(value = mapEntry.getValue()).get(FLOWNODEENTRY)).getDate("begindate")).equals(validated_time)) continue;
            FlowActiveUtil.activeFlowNode(flow.getLong("id"), key, "1", historyId);
            runNodeIds.remove(key);
        }
        ScheduleUtils.createNodeJobAndSchedule(flow, runNodeIds, nodesMap, history);
    }

    public static void activeFlow_old(long flowId, String sign) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)PHM_FLOW_DEFINE);
        String flowConfig = flow.getString(FLOWCONF);
        if (StringUtils.isBlank((CharSequence)flowConfig)) {
            return;
        }
        DynamicObjectCollection flowNodeEntry = flow.getDynamicObjectCollection(FLOWNODEENTRY);
        Map<String, Map<String, Object>> nodesMap = FlowActiveUtil.getNodesMap(flowNodeEntry);
        FlowNode rootNode = FlowUtils.resolveFlowTree(flowConfig);
        if (rootNode == null) {
            return;
        }
        ArrayList<String> runNodeIds = new ArrayList<String>(8);
        ArrayList<String> finishNodeIds = new ArrayList<String>(8);
        FlowActiveUtil.addRunNodeId(runNodeIds, finishNodeIds, nodesMap, rootNode.getChildren(), rootNode.getChildren().size());
        FlowActiveUtil.addDatasToHistory(flow, runNodeIds, finishNodeIds, nodesMap, 0L, sign);
    }

    public static Map<String, Map<String, Object>> getNodesMap(DynamicObjectCollection flowNodeEntry) {
        HashMap<String, Map<String, Object>> nodesMap = new HashMap<String, Map<String, Object>>(8);
        if (flowNodeEntry.size() == 0) {
            return nodesMap;
        }
        for (DynamicObject entry : flowNodeEntry) {
            String nodeId = (String)entry.get("nodeid");
            DynamicObjectCollection resourceEntrys = entry.getDynamicObjectCollection("resourcesubentryentity");
            DynamicObjectCollection flowSubEntrys = entry.getDynamicObjectCollection("flowsubentryentity");
            HashMap<String, Object> entrysMap = new HashMap<String, Object>(8);
            entrysMap.put(FLOWNODEENTRY, entry);
            entrysMap.put("resourcesubentryentity", resourceEntrys);
            entrysMap.put("flowsubentryentity", flowSubEntrys);
            nodesMap.put(nodeId, entrysMap);
        }
        return nodesMap;
    }

    public static void getCreatJobNode(List<String> runNodeIds, List<FlowNode> nodes, int runCounts) {
        ArrayList<FlowNode> nextNodes = new ArrayList<FlowNode>(8);
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (FlowNode node : nodes) {
            String nodeId = node.getId();
            runNodeIds.add(nodeId);
        }
        if (runNodeIds.size() == runCounts) {
            return;
        }
        FlowActiveUtil.getCreatJobNode(runNodeIds, nextNodes, runCounts);
    }

    public static void addRunNodeId(List<String> runNodeIds, List<String> finishNodeIds, Map<String, Map<String, Object>> nodesMap, List<FlowNode> nodes, int runCounts) {
        ArrayList<FlowNode> nextNodes = new ArrayList<FlowNode>(8);
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (FlowNode node : nodes) {
            String nodeId = node.getId();
            Map<String, Object> entrysMap = nodesMap.get(nodeId);
            DynamicObjectCollection resourceEntrys = (DynamicObjectCollection)entrysMap.get("resourcesubentryentity");
            if (resourceEntrys != null && resourceEntrys.size() != 0) {
                runNodeIds.add(nodeId);
                continue;
            }
            finishNodeIds.add(nodeId);
            int newRunCounts = node.getChildren().size() - 1;
            if (newRunCounts > 0) {
                runCounts += newRunCounts;
            }
            FlowActiveUtil.addRunNodeId(runNodeIds, finishNodeIds, nodesMap, node.getChildren(), runCounts);
        }
        if (runNodeIds.size() == runCounts) {
            return;
        }
        FlowActiveUtil.addRunNodeId(runNodeIds, finishNodeIds, nodesMap, nextNodes, runCounts);
    }

    public static Object creatHistory(DynamicObject flow, Map<String, Map<String, Object>> nodesMap, long parentProcessId, String sign) {
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((Object)flow.get("versionrule_id"), (String)"phm_versionrule");
        String number = VersionRuleUtils.getNumber(versionRule);
        DynamicObject flowHistory = null;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        flowHistory = dynamicObject != null ? BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"phm_process_history") : new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_history"), (Object)ID.genLongId());
        flowHistory.set("parent", (Object)parentProcessId);
        flowHistory.set("flowdefine", (Object)flow);
        flowHistory.set("number", (Object)number);
        flowHistory.set("satrnewdate_tag", (Object)SerializationUtils.serializeToBase64(nodesMap));
        flowHistory.set("status", (Object)RunningState.RUNNING.getValue());
        flowHistory.set("createtime", (Object)new Date());
        flowHistory.set("milepost", flow.get("milepost"));
        flowHistory.set("startype", (Object)sign);
        flowHistory.set("data_tag", flow.get("sysflowconf_tag"));
        Map<String, List<String>> childRelations = FlowUtils.getChildRelations(flow.getString(FLOWCONF));
        Map<String, List<String>> parentRelations = FlowUtils.getParentRelations(flow.getString(FLOWCONF));
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = nodesMap.entrySet().iterator();
        long[] entryIds = ID.genLongIds((int)nodesMap.size());
        int cyclicCount = -1;
        while (iterator.hasNext()) {
            List<String> preNodeIds;
            ++cyclicCount;
            Map.Entry<String, Map<String, Object>> mapEntry = iterator.next();
            String nodeId = mapEntry.getKey();
            Map<String, Object> nodeMap = mapEntry.getValue();
            if (nodeMap == null) continue;
            DynamicObjectCollection entryentity = flowHistory.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entryentity.addNew();
            entry.set("id", (Object)entryIds[cyclicCount]);
            DynamicObject nodeEntry = (DynamicObject)nodeMap.get(FLOWNODEENTRY);
            entry.set("nodeid", (Object)nodeId);
            entry.set("node_name", nodeEntry.get("nodename"));
            entry.set("node_status", (Object)"prepare");
            entry.set("abnormalstatus", (Object)"3");
            entry.set("node_period", nodeEntry.get("nodecycle"));
            entry.set("stage", nodeEntry.get("stage"));
            entry.set("nodecomplete", nodeEntry.get("nodecomplete"));
            entry.set("planbegintime", nodeEntry.get("begindate"));
            entry.set("node_createtime", nodeEntry.get("begindate"));
            entry.set("planendtime", nodeEntry.get("enddate"));
            entry.set("personliables", nodeEntry.get("personliable"));
            entry.set("liableorgs", nodeEntry.get("liableorg"));
            entry.set("node_iscontrol", (Object)true);
            List<String> nextNodeIds = childRelations.get(nodeId);
            if (nextNodeIds != null) {
                entry.set("nextnodeids", (Object)SerializationUtils.toJsonString(nextNodeIds));
            }
            if ((preNodeIds = parentRelations.get(nodeId)) != null) {
                entry.set("prenodeids", (Object)SerializationUtils.toJsonString(preNodeIds));
            }
            entry.set("dataisolation", nodeEntry.get("nodedataisolation"));
        }
        SaveServiceHelper.saveOperate((String)"phm_process_history", (DynamicObject[])new DynamicObject[]{flowHistory}, (OperateOption)OperateOption.create());
        return flowHistory;
    }

    public static void addDatasToHistory(DynamicObject flow, List<String> runNodeIds, List<String> finishNodeIds, Map<String, Map<String, Object>> nodesMap, long parentProcessId, String sign) {
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((Object)flow.get("versionrule_id"), (String)"phm_versionrule");
        String number = VersionRuleUtils.getNumber(versionRule);
        DynamicObject flowHistory = null;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        flowHistory = dynamicObject != null ? BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"phm_process_history") : new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_history"), (Object)ID.genLongId());
        flowHistory.set("parent", (Object)parentProcessId);
        flowHistory.set("flowdefine", (Object)flow);
        flowHistory.set("number", (Object)number);
        Date date_now = new Date();
        FlowActiveUtil.changeDateByManual(nodesMap, date_now, flow);
        flowHistory.set("status", (Object)RunningState.RUNNING.getValue());
        flowHistory.set("createtime", (Object)date_now);
        flowHistory.set("milepost", flow.get("milepost"));
        flowHistory.set("startype", (Object)sign);
        flowHistory.set("data_tag", flow.get("sysflowconf_tag"));
        Map<String, List<String>> childRelations = FlowUtils.getChildRelations(flow.getString(FLOWCONF));
        Map<String, List<String>> parentRelations = FlowUtils.getParentRelations(flow.getString(FLOWCONF));
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = nodesMap.entrySet().iterator();
        long[] entryIds = ID.genLongIds((int)nodesMap.size());
        ArrayList<AutoSubmitParam> autoSubmitList = new ArrayList<AutoSubmitParam>();
        ArrayList<AutoSubmitScheduleParam> scheduleList = new ArrayList<AutoSubmitScheduleParam>();
        int cyclicCount = -1;
        while (iterator.hasNext()) {
            DynamicObject entry;
            boolean isControl;
            block17: {
                DynamicObjectCollection resourceEntrys;
                block16: {
                    List<String> preNodeIds;
                    ++cyclicCount;
                    Map.Entry<String, Map<String, Object>> mapEntry = iterator.next();
                    String nodeId = mapEntry.getKey();
                    Map<String, Object> nodeMap = mapEntry.getValue();
                    if (nodeMap == null) continue;
                    isControl = false;
                    DynamicObjectCollection entryentity = flowHistory.getDynamicObjectCollection("entryentity");
                    entry = entryentity.addNew();
                    entry.set("id", (Object)entryIds[cyclicCount]);
                    DynamicObject nodeEntry = (DynamicObject)nodeMap.get(FLOWNODEENTRY);
                    entry.set("nodeid", (Object)nodeId);
                    entry.set("node_name", nodeEntry.get("nodename"));
                    entry.set("node_status", (Object)"prepare");
                    entry.set("abnormalstatus", (Object)"3");
                    if (finishNodeIds.contains(nodeId)) {
                        entry.set("node_status", (Object)"completed");
                    }
                    entry.set("node_period", nodeEntry.get("nodecycle"));
                    entry.set("nodecomplete", nodeEntry.get("nodecomplete"));
                    entry.set("planbegintime", nodeEntry.get("begindate"));
                    entry.set("planendtime", nodeEntry.get("enddate"));
                    entry.set("personliables", nodeEntry.get("personliable"));
                    entry.set("liableorgs", nodeEntry.get("liableorg"));
                    entry.set("stage", nodeEntry.get("stage"));
                    List<String> nextNodeIds = childRelations.get(nodeId);
                    if (nextNodeIds != null) {
                        entry.set("nextnodeids", (Object)SerializationUtils.toJsonString(nextNodeIds));
                    }
                    if ((preNodeIds = parentRelations.get(nodeId)) != null) {
                        entry.set("prenodeids", (Object)SerializationUtils.toJsonString(preNodeIds));
                    }
                    entry.set("dataisolation", nodeEntry.get("nodedataisolation"));
                    resourceEntrys = (DynamicObjectCollection)nodeMap.get("resourcesubentryentity");
                    if (resourceEntrys == null || resourceEntrys.size() == 0) continue;
                    if (!runNodeIds.contains(nodeId)) break block16;
                    entry.set("node_status", (Object)RunningState.RUNNING.getValue());
                    entry.set("node_createtime", (Object)new Date());
                    DynamicObjectCollection subentryentity_task = entry.getDynamicObjectCollection("subentryentity_task");
                    for (DynamicObject resourceEntry : resourceEntrys) {
                        DynamicObject deliverables = (DynamicObject)resourceEntry.get("deliverables");
                        String datasource = deliverables.getString("datasource");
                        DynamicObject datasourceid = deliverables.getDynamicObject("datasourceid");
                        String status = "C";
                        String enable = "1";
                        if (deliverables != null) {
                            status = deliverables.getString("status");
                            enable = deliverables.getString("enable");
                        }
                        if (!StringUtils.equals((CharSequence)"C", (CharSequence)status) || !StringUtils.equals((CharSequence)"1", (CharSequence)enable)) continue;
                        DynamicObject subEntry = subentryentity_task.addNew();
                        subEntry.set("task_processhistory", flowHistory.getPkValue());
                        subEntry.set("task_resourcetype", resourceEntry.get("resourcetype"));
                        subEntry.set("task_resource", resourceEntry.get("resource"));
                        subEntry.set("task_createdate", (Object)date_now);
                        subEntry.set("task_status", (Object)TaskStatusEnum.UNPROCESS.getValue());
                        String deliverablesnumber = resourceEntry.getString("deliverablesnumber");
                        subEntry.set("deliverablesnumber", resourceEntry.get("deliverablesnumber"));
                        subEntry.set("deliverablesname", resourceEntry.get("deliverablesname"));
                        subEntry.set("deliverables", resourceEntry.get("deliverables"));
                        FlowActiveUtil.replacePkID(resourceEntry, subEntry, "depersonliable", "depersonliable");
                        FlowActiveUtil.replacePkID(resourceEntry, subEntry, "deliableorg", "deliableorg");
                        subEntry.set("schedule", resourceEntry.get("schedule"));
                        subEntry.set("warningcycle", resourceEntry.get("warningcycle"));
                        subEntry.set("overduecycle", resourceEntry.get("overduecycle"));
                        subEntry.set("seriousoverduecycle", resourceEntry.get("seriousoverduecycle"));
                        FlowActiveUtil.replacePkID(resourceEntry, subEntry, "waringuser", "waringuser");
                        FlowActiveUtil.replacePkID(resourceEntry, subEntry, "overduecyuser", "overduecyuser");
                        FlowActiveUtil.replacePkID(resourceEntry, subEntry, "seriousoverdueuser", "seriousoverdueuser");
                        FlowActiveUtil.setConditionValue(subEntry, resourceEntry, "frontcondition");
                        FlowActiveUtil.setConditionValue(subEntry, resourceEntry, "aftercondition");
                        subEntry.set("recustomers", resourceEntry.get("recustomers"));
                        subEntry.set("remake", resourceEntry.get("remake"));
                        FlowActiveUtil.replacePkID(resourceEntry, subEntry, "superior", "superior");
                        subEntry.set("datasource", deliverables.get("datasource"));
                        subEntry.set("datasourceid", deliverables.get("datasourceid"));
                        boolean resourceControl = resourceEntry.getBoolean("control");
                        subEntry.set("task_control", (Object)resourceControl);
                        if (resourceControl) {
                            isControl = resourceControl;
                            String formula = resourceEntry.getString("formula");
                            if (StringUtils.isNotBlank((CharSequence)formula)) {
                                String[] split = formula.split(";");
                                int value = Integer.parseInt(split[2]);
                                if ("0".equals(split[1])) {
                                    ++value;
                                }
                                subEntry.set("taskprogress", (Object)"0/".concat(Integer.toString(value)));
                            }
                        }
                        BigDecimal nodecycle = nodeEntry.getBigDecimal("nodecycle");
                        subEntry.set("task_period", (Object)nodecycle);
                        if (BigDecimal.ZERO.compareTo(nodecycle) != 0) {
                            BigDecimal minutes = nodecycle.multiply(new BigDecimal("24")).multiply(new BigDecimal("60"));
                            subEntry.set("task_completedate", (Object)DateUtils.addMinutes((Date)new Date(), (int)minutes.intValue()));
                        }
                        DynamicObjectCollection roles = resourceEntry.getDynamicObjectCollection("role");
                        DynamicObjectCollection task_roles = subEntry.getDynamicObjectCollection("task_role");
                        for (DynamicObject role : roles) {
                            DynamicObject task_role = task_roles.addNew();
                            task_role.set(2, role.get(2));
                        }
                        subEntry.set("task_role", (Object)task_roles);
                        String dealType = resourceEntry.getString("dealtype");
                        subEntry.set("task_dealtype", (Object)dealType);
                        if (!DealTypeEnum.MANUAL.getName().equals(dealType)) {
                            FlowActiveUtil.getAutoSubmitParam(flow, flowHistory, autoSubmitList, scheduleList, entry, resourceEntry, subEntry, dealType);
                        }
                        if ("phm_tasknotice".equals(datasource)) {
                            FlowActiveUtil.creatTaskNotieFlow(resourceEntry, flow, entry, flowHistory, sign, "tasknotice");
                        }
                        if ("phm_eigenvalue".equals(datasource)) {
                            if (!FlowActiveUtil.isCompleteEigenvalue(subEntry, deliverables)) {
                                Object tasknoticeId = FlowActiveUtil.creatTaskNotieFlow(resourceEntry, flow, entry, flowHistory, sign, "eigenvalues");
                                FlowActiveUtil.creatSuheduByEigenvalue(entry, flowHistory, deliverablesnumber, tasknoticeId);
                                FlowActiveUtil.creatSuheduPlan(resourceEntry, entry, flowHistory, deliverablesnumber);
                                continue;
                            }
                            FlowActiveUtil.creatTaskNotieFlow(resourceEntry, flow, entry, flowHistory, sign, "eigenvalue");
                            continue;
                        }
                        FlowActiveUtil.creatSuheduPlan(resourceEntry, entry, flowHistory, deliverablesnumber);
                    }
                    if (isControl) break block17;
                    entry.set("node_finishtime", (Object)new Date());
                    entry.set("node_status", (Object)RunningState.COMPLETED.getValue());
                    break block17;
                }
                for (DynamicObject resourceEntry : resourceEntrys) {
                    boolean resourceControl = resourceEntry.getBoolean("control");
                    if (!resourceControl) continue;
                    isControl = true;
                    break;
                }
            }
            entry.set("node_iscontrol", (Object)isControl);
        }
        SaveServiceHelper.saveOperate((String)"phm_process_history", (DynamicObject[])new DynamicObject[]{flowHistory}, (OperateOption)OperateOption.create());
        long flowHistoryId = flowHistory.getLong("id");
        Boolean isCreat = FlowActiveUtil.setNodeCompleteStatus(flowHistoryId, runNodeIds);
        FlowActiveUtil.dealAutoSubmitResource(autoSubmitList, scheduleList);
    }

    public static void changeDateByManual(Map<String, Map<String, Object>> nodesMap, Date date, DynamicObject flow) {
        Date beginDate = null;
        Object mid = flow.getDynamicObject("milepost").getPkValue();
        DynamicObject milepost = BusinessDataServiceHelper.loadSingle((Object)mid, (String)"phm_milepost");
        DynamicObjectCollection milepostEntry = milepost.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : milepostEntry) {
            if (dynamicObject.getInt("seq") != 1) continue;
            beginDate = dynamicObject.getDate("begintime");
        }
        if (beginDate == null) {
            return;
        }
        Long differ = beginDate.getTime() - date.getTime();
        for (Map.Entry<String, Map<String, Object>> mapEntry : nodesMap.entrySet()) {
            String key = mapEntry.getKey();
            Map<String, Object> value = mapEntry.getValue();
            DynamicObject flownodeDyn = (DynamicObject)value.get(FLOWNODEENTRY);
            Date beginDate_old = flownodeDyn.getDate("begindate");
            Date endDate_old = flownodeDyn.getDate("enddate");
            Long nowBegin_long = beginDate_old.getTime() - differ;
            Long nowEnd_long = endDate_old.getTime() - differ;
            Date nowBegin_date = FlowActiveUtil.longTimeToDate(nowBegin_long);
            Date nowEnd_date = FlowActiveUtil.longTimeToDate(nowEnd_long);
            flownodeDyn.set("begindate", (Object)nowBegin_date);
            flownodeDyn.set("enddate", (Object)nowEnd_date);
        }
    }

    private static Date longTimeToDate(long l) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            String format = df.format(l);
            Date parse = df.parse(format);
            return parse;
        }
        catch (Exception e) {
            throw new KDBizException("longTimeToDate :" + e.getMessage());
        }
    }

    private static Boolean setNodeCompleteStatus(Long processHistoryId, List<String> runNodeIds) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)processHistoryId, (String)"phm_process_history");
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject_node : entryentity) {
            long entryId;
            boolean isFinish;
            if (!runNodeIds.contains(dynamicObject_node.getString("nodeid")) || !(isFinish = ProcessQueryUtil.queryNodeFinish(entryId = dynamicObject_node.getLong("id")))) continue;
            ProcessUpdateUtil.updateNodeStatusByNodeEntryId(entryId, RunningState.COMPLETED.getValue());
            ProcessUpdateUtil.processFinish(processHistoryId);
            return true;
        }
        return false;
    }

    public static void dealAutoSubmitResource(List<AutoSubmitParam> autoSubmitList, List<AutoSubmitScheduleParam> scheduleList) {
        if (!CollectionUtils.isEmpty(autoSubmitList)) {
            AutoSubmitUtil.createResourceSync(autoSubmitList);
        }
        if (!CollectionUtils.isEmpty(scheduleList)) {
            ScheduleCreateUtil.createScheduleTask(scheduleList);
        }
    }

    private static void getAutoSubmitParam(DynamicObject flow, DynamicObject flowHistory, List<AutoSubmitParam> autoSubmitList, List<AutoSubmitScheduleParam> scheduleList, DynamicObject entry, DynamicObject resourceEntry, DynamicObject subEntry, String dealType) {
        if (DealTypeEnum.AUTO.getName().equals(dealType)) {
            AutoSubmitParam autoSubmitParam = new AutoSubmitParam();
            autoSubmitParam.setProcessHistoryId(Long.parseLong(flowHistory.getPkValue().toString()));
            autoSubmitParam.setEntryNodeId(entry.getLong("id"));
            autoSubmitParam.setProcessId(flow.getLong("id"));
            autoSubmitParam.setResourceType(ProcessResourceSourceEnum.DataTemp.getValue());
            autoSubmitParam.setResourceId(resourceEntry.getDynamicObject("resource").getLong("id"));
            autoSubmitParam.setDealType(dealType);
            autoSubmitList.add(autoSubmitParam);
        } else if (DealTypeEnum.CYCLE.getName().equals(dealType)) {
            AutoSubmitScheduleParam scheduleParam = new AutoSubmitScheduleParam();
            scheduleParam.setProcessHistoryId(Long.parseLong(flowHistory.getPkValue().toString()));
            scheduleParam.setEntryNodeId(entry.getLong("id"));
            scheduleParam.setProcessId(flow.getLong("id"));
            scheduleParam.setResourceType(ProcessResourceSourceEnum.DataTemp.getValue());
            scheduleParam.setResourceId(resourceEntry.getDynamicObject("resource").getLong("id"));
            scheduleParam.setStartDate(subEntry.getDate("task_completedate"));
            scheduleParam.setName(flow.getString("name") + "-" + flowHistory.getString("number") + "-" + entry.getString("node_name") + "-" + resourceEntry.getString("id"));
            scheduleParam.setNumber(flow.getString("number") + "-" + flowHistory.getString("number") + "-" + entry.getString("node_name") + "-" + resourceEntry.getString("id"));
            scheduleParam.setDealType(dealType);
            scheduleList.add(scheduleParam);
        }
    }

    public static void setConditionValue(DynamicObject subEntry, DynamicObject resourceEntry, String condition) {
        String listSer = "";
        if ("frontcondition".equals(condition)) {
            listSer = resourceEntry.getString("frontcondition_tag");
            subEntry.set("frontcondition_tag", (Object)listSer);
        } else {
            listSer = resourceEntry.getString("aftercondition_tag");
            subEntry.set("aftercondition_tag", (Object)listSer);
        }
        if (listSer.isEmpty()) {
            return;
        }
        List list = (List)SerializationUtils.deSerializeFromBase64((String)listSer);
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append(",");
        }
        String substring = "";
        if (sb.length() > 1) {
            substring = sb.substring(0, sb.length() - 1);
        }
        if ("frontcondition".equals(condition)) {
            subEntry.set("frontcondition", (Object)substring);
        } else {
            subEntry.set("aftercondition", (Object)substring);
        }
    }

    public static void replacePkID(DynamicObject resourceEntry, DynamicObject subEntry, String sign, String valueKey) {
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)resourceEntry.get(valueKey);
        DynamicObjectCollection dynamicObjects = subEntry.getDynamicObjectCollection(sign);
        int i = 0;
        Object[] ob = new Object[mulBasedataDynamicObjectCollection.size()];
        if (dynamicObjects == null) {
            for (DynamicObject muDynamicObject : mulBasedataDynamicObjectCollection) {
                ob[i] = muDynamicObject.get(2);
                ++i;
            }
            subEntry.set(sign, (Object)ob);
        } else {
            for (DynamicObject muDynamicObject : mulBasedataDynamicObjectCollection) {
                DynamicObject dynamicObject = dynamicObjects.addNew();
                dynamicObject.set(2, muDynamicObject.get(2));
            }
            subEntry.set(sign, (Object)dynamicObjects);
        }
    }

    public static void activeWarnFlow(long flowId, String nodeId, String deliverablesnumber, String type) {
        FlowActiveUtil.creatTaskWarnBill(flowId, nodeId, type, deliverablesnumber);
    }

    private static void creatTaskWarnBill(long flowHistoryId, String nodeId, String type, String deliverablesnumber) {
        String number;
        type = FlowActiveUtil.changeTypeValue(type);
        DynamicObject flowHistory = BusinessDataServiceHelper.loadSingle((Object)flowHistoryId, (String)"phm_process_history");
        Object flowdefine = flowHistory.getDynamicObject("flowdefine").getPkValue();
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowdefine, (String)PHM_FLOW_DEFINE);
        DynamicObjectCollection flowNodeEntry = flowHistory.getDynamicObjectCollection("entryentity");
        Object dynamicObject_node = null;
        DynamicObject dynamicObject_task = null;
        for (Object dynamicObject_flownode : flowNodeEntry) {
            if (!dynamicObject_flownode.getString("nodeid").equals(nodeId)) continue;
            dynamicObject_node = dynamicObject_flownode;
            break;
        }
        if (dynamicObject_node == null) {
            return;
        }
        DynamicObjectCollection dynamicObject_tasks = dynamicObject_node.getDynamicObjectCollection("subentryentity_task");
        for (DynamicObject dynamicObject_t : dynamicObject_tasks) {
            if (!dynamicObject_t.getString("deliverablesnumber").equals(deliverablesnumber)) continue;
            dynamicObject_task = dynamicObject_t;
            break;
        }
        if (dynamicObject_task == null) {
            return;
        }
        DynamicObject dynamicObject_warn = BusinessDataServiceHelper.newDynamicObject((String)"phm_taskunusualnotice");
        dynamicObject_warn.set("number", (Object)FlowActiveUtil.getCodeRule("phm_taskunusualnotice"));
        dynamicObject_warn.set("status", (Object)"A");
        dynamicObject_warn.set("enable", (Object)"1");
        dynamicObject_warn.set("project", flow.getDynamicObject("milepost").get("project"));
        dynamicObject_warn.set("milepoststage", dynamicObject_node.get("stage"));
        dynamicObject_warn.set("milepostperson", flow.getDynamicObject("milepost").get("userliable"));
        dynamicObject_warn.set("processname", flow.get("name"));
        FlowActiveUtil.replacePkID(flow, dynamicObject_warn, "processperson", "flowleader");
        dynamicObject_warn.set("nodename", dynamicObject_node.get("node_name"));
        dynamicObject_warn.set("nodeperson", dynamicObject_node.get("personliables"));
        dynamicObject_warn.set("taskame", dynamicObject_task.get("deliverablesname"));
        FlowActiveUtil.replacePkID(dynamicObject_task, dynamicObject_warn, "taskperson", "depersonliable");
        FlowActiveUtil.replacePkID(dynamicObject_task, dynamicObject_warn, "warninguser", "waringuser");
        FlowActiveUtil.replacePkID(dynamicObject_task, dynamicObject_warn, "overdueusers", "overduecyuser");
        FlowActiveUtil.replacePkID(dynamicObject_task, dynamicObject_warn, "soverdueuser", "seriousoverdueuser");
        FlowActiveUtil.replacePkID(dynamicObject_task, dynamicObject_warn, "superleader", "superior");
        List<String> taskCompletePerson = FlowActiveUtil.getTaskCompletePerson(deliverablesnumber, dynamicObject_node.getPkValue(), flowHistoryId);
        FlowActiveUtil.setNoticeobjectValue(taskCompletePerson, dynamicObject_task, dynamicObject_warn);
        dynamicObject_warn.set("projectmanager", flow.getDynamicObject("milepost").get("userliable"));
        dynamicObject_warn.set("fronttask", dynamicObject_task.get("frontcondition"));
        dynamicObject_warn.set("aftertask", dynamicObject_task.get("aftercondition"));
        dynamicObject_warn.set("endtime", dynamicObject_node.get("planendtime"));
        dynamicObject_warn.set("nowtime", (Object)new Date());
        dynamicObject_warn.set("types", (Object)type);
        dynamicObject_warn.set("time", (Object)new Date());
        dynamicObject_warn.set("processhistory", (Object)flowHistory);
        dynamicObject_warn.set("entry_node", dynamicObject_node);
        dynamicObject_warn.set("entry_tasks", (Object)deliverablesnumber);
        dynamicObject_warn.set("entry_task", (Object)dynamicObject_task);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"phm_taskunusualnotice", (DynamicObject[])new DynamicObject[]{dynamicObject_warn}, (OperateOption)OperateOption.create());
        List successPkIds = operationResult.getSuccessPkIds();
        if (successPkIds.size() == 0) {
            log.error("\u9884\u8b66\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25");
            return;
        }
        FlowActiveUtil.creatEvent(dynamicObject_warn, flowHistory, flow, (DynamicObject)dynamicObject_node, dynamicObject_task, type);
        if ("1".equals(type)) {
            type = "overdue";
        } else if ("2".equals(type)) {
            type = "seriousoverdue";
        } else if ("3".equals(type)) {
            return;
        }
        OperationResult operationResult1 = ScheduleUtils.creatJobPlan((DynamicObject)dynamicObject_node, type, flowHistory, deliverablesnumber);
        List successPkIds1 = operationResult1.getSuccessPkIds();
        if (successPkIds1.size() == 0) {
            log.error("\u903e\u671f\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25");
            return;
        }
        String jobId = successPkIds1.get(0).toString();
        OperationResult operationResult2 = ScheduleUtils.creatSuheduPlan(jobId, dynamicObject_task, (DynamicObject)dynamicObject_node, type, number = flowHistory.getString("number"));
        List successPkIds2 = operationResult2.getSuccessPkIds();
        if (successPkIds2.size() == 0) {
            log.error("\u903e\u671f\u8c03\u5ea6\u8ba1\u5212\u5931\u8d25");
            return;
        }
    }

    private static void creatEvent(DynamicObject dynamicObject_warn, DynamicObject flowHistory, DynamicObject flow, DynamicObject dynamicObject_node, DynamicObject dynamicObject_task, String type) {
        String flowHistoryNumber = flowHistory.getString("number");
        String deliverablesnumber = dynamicObject_task.getString("deliverablesnumber");
        String number = flowHistoryNumber + "_" + deliverablesnumber + "_event";
        String eventName = "";
        DynamicObject dynamicObject_event = BusinessDataServiceHelper.newDynamicObject((String)"phm_process_event");
        if ("1".equals(type)) {
            eventName = ResManager.loadKDString((String)"\u9884\u8b66", (String)"FlowActiveUtil_3", (String)"mmc-phm-common", (Object[])new Object[0]);
        } else if ("2".equals(type)) {
            eventName = ResManager.loadKDString((String)"\u903e\u671f", (String)"FlowActiveUtil_4", (String)"mmc-phm-common", (Object[])new Object[0]);
        } else if ("3".equals(type)) {
            eventName = ResManager.loadKDString((String)"\u4e25\u91cd\u903e\u671f", (String)"FlowActiveUtil_5", (String)"mmc-phm-common", (Object[])new Object[0]);
        }
        dynamicObject_event.set("abnormalstatus", (Object)type);
        dynamicObject_event.set("nodestatus", dynamicObject_node.get("node_status"));
        dynamicObject_event.set("event_processid", flowHistory.get("id"));
        dynamicObject_event.set("status", (Object)"processing");
        dynamicObject_event.set("number", (Object)number);
        dynamicObject_event.set("eventname", (Object)(flowHistoryNumber + ResManager.loadKDString((String)"\u8282\u70b9", (String)"FlowActiveUtil_6", (String)"mmc-phm-common", (Object[])new Object[0]) + deliverablesnumber + eventName + ResManager.loadKDString((String)"\u4e8b\u4ef6", (String)"FlowActiveUtil_7", (String)"mmc-phm-common", (Object[])new Object[0])));
        dynamicObject_event.set("tasknotic", (Object)dynamicObject_warn);
        dynamicObject_event.set("nodetask", (Object)dynamicObject_task);
        dynamicObject_event.set("enable", (Object)"1");
        dynamicObject_event.set("event_startnodeid", (Object)dynamicObject_node);
        dynamicObject_event.set("entry_node", (Object)dynamicObject_node);
        dynamicObject_event.set("modifier", (Object)new Date());
        dynamicObject_event.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
        dynamicObject_event.set("createtime", (Object)new Date());
        dynamicObject_event.set("modifytime", (Object)RequestContext.getOrCreate().getCurrUserId());
        FlowActiveUtil.replacePkID(dynamicObject_task, dynamicObject_event, "event_repositoryrole", "task_role");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject_event});
    }

    private static String changeTypeValue(String type) {
        if ("seriousoverdue".equals(type)) {
            return "3";
        }
        if ("overdue".equals(type)) {
            return "2";
        }
        return "1";
    }

    private static void setNoticeobjectValue(List<String> taskCompletePerson, DynamicObject dynamicObject_task, DynamicObject dynamicObject_warn) {
        DynamicObjectCollection dynamicObjects = dynamicObject_warn.getDynamicObjectCollection("noticeobject");
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)dynamicObject_task.get("depersonliable");
        for (DynamicObject muDynamicObject : mulBasedataDynamicObjectCollection) {
            String id = muDynamicObject.getString(2);
            if (taskCompletePerson.contains(id)) continue;
            DynamicObject dynamicObject = dynamicObjects.addNew();
            dynamicObject.set(2, muDynamicObject.get(2));
        }
        dynamicObject_warn.set("noticeobject", (Object)dynamicObjects);
    }

    private static List<String> getTaskCompletePerson(String deliverablesnumber, Object nodeId, long flowHistoryId) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter qFilter_number = new QFilter("number", "=", (Object)deliverablesnumber);
        QFilter qFilter_noid = new QFilter("entry_node", "=", nodeId);
        QFilter qFilter_flowHistoryId = new QFilter("resource_processhistory", "=", (Object)flowHistoryId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"phm_process_resources", (String)"resource_status,resource_modifier", (QFilter[])new QFilter[]{qFilter_number, qFilter_noid, qFilter_flowHistoryId});
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!"C".equals(dynamicObject.getString("resource_status"))) continue;
            list.add(dynamicObject.getString("resource_modifier"));
        }
        return list;
    }

    public static Map<Long, Long> getUserDirector(List<Long> orgList, List<Long> userList) {
        String selectFields = "id,entryentity.superior";
        QFilter orgFilter = new QFilter("entryentity.dpt", "in", orgList);
        QFilter ispartjobFilter = new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE);
        QFilter idFilter = new QFilter("id", "in", userList);
        QFilter[] filters = new QFilter[]{orgFilter, ispartjobFilter, idFilter};
        DynamicObjectCollection userPosCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters);
        HashMap<Long, Long> userAndDirector = new HashMap<Long, Long>(8);
        for (DynamicObject dynamicObject : userPosCol) {
            if (0L == dynamicObject.getLong("entryentity.superior")) continue;
            userAndDirector.put(dynamicObject.getLong("id"), dynamicObject.getLong("entryentity.superior"));
        }
        return userAndDirector;
    }

    public static void removeNotExitNode(Map<String, Map<String, Object>> nodesMap, FlowNode rootNode) {
        ArrayList<String> nodeIds = new ArrayList<String>(8);
        FlowUtils.getAllNode(rootNode, nodeIds);
        Set<String> keySet = nodesMap.keySet();
        for (String nodeId : keySet) {
            if (nodeIds.contains(nodeId)) continue;
            nodesMap.remove(nodeId);
        }
    }
}

