/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.util.FLowEdge;
import kd.mmc.phm.common.util.FlowNode;

public class FlowUtils {
    public static FlowNode resolveFlowTree(String flowConfig) {
        Map flowConfigMap = (Map)SerializationUtils.fromJsonString((String)flowConfig, Map.class);
        Map graphData = (Map)flowConfigMap.get("graphData");
        if (graphData == null) {
            return null;
        }
        List cells = (List)graphData.get("cells");
        if (cells == null) {
            return null;
        }
        ArrayList<FLowEdge> fLowEdges = new ArrayList<FLowEdge>(8);
        ArrayList<String> sourceList = new ArrayList<String>(8);
        ArrayList<String> targetList = new ArrayList<String>(8);
        ArrayList<String> idList = new ArrayList<String>(8);
        for (Map cellMap : cells) {
            String id;
            String shape = (String)cellMap.get("shape");
            if (StringUtils.isNotBlank((CharSequence)shape) && shape.contains("edge")) {
                Map sourceMap = (Map)cellMap.get("source");
                String source = (String)sourceMap.get("cell");
                Map targetMap = (Map)cellMap.get("target");
                String target = (String)targetMap.get("cell");
                FLowEdge flowEdge = new FLowEdge(source, target);
                fLowEdges.add(flowEdge);
                sourceList.add(source);
                targetList.add(target);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)shape) || !"x-rect".equals(shape) && !"x-circle".equals(shape) && !"x-diamond".equals(shape) || !StringUtils.isNotBlank((CharSequence)(id = (String)cellMap.get("id")))) continue;
            idList.add(id);
        }
        FlowNode rootNode = new FlowNode();
        rootNode.setId("0");
        rootNode.setRoot(true);
        if (idList.size() == 1) {
            String rootId = (String)idList.get(0);
            FlowNode root = new FlowNode();
            root.setId(rootId);
            root.setRoot(false);
            rootNode.getChildren().add(root);
        } else {
            List<String> rootIdList = FlowUtils.findTrueRootNode(sourceList, targetList);
            idList.removeAll(targetList);
            idList.removeAll(rootIdList);
            rootIdList.addAll(idList);
            for (String rootId : rootIdList) {
                FlowNode root = new FlowNode();
                root.setId(rootId);
                root.setRoot(false);
                FlowUtils.findChildNode(root, fLowEdges, 0);
                rootNode.getChildren().add(root);
            }
        }
        return rootNode;
    }

    public static Map<String, List<String>> getChildRelations(String flowConfig) {
        HashMap<String, List<String>> relationsMap = new HashMap<String, List<String>>(8);
        Map flowConfigMap = (Map)SerializationUtils.fromJsonString((String)flowConfig, Map.class);
        Map graphData = (Map)flowConfigMap.get("graphData");
        if (graphData == null) {
            return null;
        }
        List cells = (List)graphData.get("cells");
        if (cells == null) {
            return null;
        }
        for (Map cellMap : cells) {
            String shape = (String)cellMap.get("shape");
            if (!StringUtils.isNotBlank((CharSequence)shape) || !shape.contains("edge")) continue;
            Map sourceMap = (Map)cellMap.get("source");
            String source = (String)sourceMap.get("cell");
            Map targetMap = (Map)cellMap.get("target");
            String target = (String)targetMap.get("cell");
            if (StringUtils.isBlank((CharSequence)source) || StringUtils.isBlank((CharSequence)target)) continue;
            ArrayList<String> targets = (ArrayList<String>)relationsMap.get(source);
            if (targets == null) {
                targets = new ArrayList<String>();
            }
            targets.add(target);
            relationsMap.put(source, targets);
        }
        return relationsMap;
    }

    public static Map<String, List<String>> getParentRelations(String flowConfig) {
        HashMap<String, List<String>> relationsMap = new HashMap<String, List<String>>(8);
        Map flowConfigMap = (Map)SerializationUtils.fromJsonString((String)flowConfig, Map.class);
        Map graphData = (Map)flowConfigMap.get("graphData");
        if (graphData == null) {
            return null;
        }
        List cells = (List)graphData.get("cells");
        if (cells == null) {
            return null;
        }
        for (Map cellMap : cells) {
            String shape = (String)cellMap.get("shape");
            if (!StringUtils.isNotBlank((CharSequence)shape) || !shape.contains("edge")) continue;
            Map sourceMap = (Map)cellMap.get("source");
            String source = (String)sourceMap.get("cell");
            Map targetMap = (Map)cellMap.get("target");
            String target = (String)targetMap.get("cell");
            if (StringUtils.isBlank((CharSequence)source) || StringUtils.isBlank((CharSequence)target)) continue;
            ArrayList<String> sources = (ArrayList<String>)relationsMap.get(target);
            if (sources == null) {
                sources = new ArrayList<String>();
            }
            sources.add(source);
            relationsMap.put(target, sources);
        }
        return relationsMap;
    }

    public static List<Object> getAloneNodes(Map<String, String> nodesMap, String flowConfig) {
        ArrayList<Object> aloneNodeNames = new ArrayList<Object>(8);
        ArrayList<String> notAloneNodeIds = new ArrayList<String>(8);
        ArrayList<String> nodeIds = new ArrayList<String>();
        Map flowConfigMap = (Map)SerializationUtils.fromJsonString((String)flowConfig, Map.class);
        Map graphData = (Map)flowConfigMap.get("graphData");
        if (graphData == null) {
            return null;
        }
        List cells = (List)graphData.get("cells");
        if (cells == null) {
            return null;
        }
        for (Map cellMap : cells) {
            String shape = (String)cellMap.get("shape");
            if (StringUtils.isNotBlank((CharSequence)shape) && shape.contains("edge")) {
                Map sourceMap = (Map)cellMap.get("source");
                String source = (String)sourceMap.get("cell");
                Map targetMap = (Map)cellMap.get("target");
                String target = (String)targetMap.get("cell");
                notAloneNodeIds.add(source);
                notAloneNodeIds.add(target);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)shape) || !"x-rect".equals(shape) && !"x-circle".equals(shape) && !"x-diamond".equals(shape)) continue;
            nodeIds.add((String)cellMap.get("id"));
        }
        nodeIds.removeAll(notAloneNodeIds);
        for (String nodeId : nodeIds) {
            aloneNodeNames.add(nodesMap.get(nodeId));
        }
        return aloneNodeNames;
    }

    private static List<String> findTrueRootNode(List<String> sourceList, List<String> targetList) {
        ArrayList<String> sameList = new ArrayList<String>(8);
        for (String id : sourceList) {
            if (!targetList.contains(id)) continue;
            sameList.add(id);
        }
        sourceList.removeAll(sameList);
        return sourceList;
    }

    private static void findChildNode(FlowNode node, List<FLowEdge> fLowEdges, int count) {
        if (++count > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u6d41\u7a0b\u51fa\u73b0\u6b7b\u5faa\u73af\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u3002", (String)"FlowUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        for (FLowEdge fLowEdge : fLowEdges) {
            String source = fLowEdge.getSource();
            String target = fLowEdge.getTarget();
            if (!StringUtils.equals((CharSequence)source, (CharSequence)node.getId())) continue;
            FlowNode child = new FlowNode();
            child.setId(target);
            child.setRoot(false);
            FlowUtils.findChildNode(child, fLowEdges, count);
            node.getChildren().add(child);
        }
    }

    public static List<Queue<String>> getRoutes(String flowConfig, String preNodeID, String nextNodeId) {
        FlowNode flowNode = FlowUtils.resolveFlowTree(flowConfig);
        return null;
    }

    private static void getPreNode(FlowNode node, String preNodeID, FlowNode retrunNode) {
        if (preNodeID.equals(node.getId())) {
            return;
        }
        List<FlowNode> children = node.getChildren();
        Iterator<FlowNode> iterator = children.iterator();
        while (iterator.hasNext()) {
            FlowNode child;
            retrunNode = child = iterator.next();
            FlowUtils.getPreNode(child, preNodeID, retrunNode);
        }
    }

    private static List<List<String>> getRoutes(FlowNode node, List<List<String>> routeLsit, String nextNodeId) {
        return null;
    }

    public static void getChildNode(FlowNode root, String nodeId, List<FlowNode> childNode) {
        List<FlowNode> children = root.getChildren();
        for (FlowNode flowNode : children) {
            if (flowNode.getId().equals(nodeId)) {
                childNode.addAll(flowNode.getChildren());
                continue;
            }
            FlowUtils.getChildNode(flowNode, nodeId, childNode);
        }
    }

    public static Map<String, String> getNodeName(List<String> nodeIdList, Map<String, Map<String, Object>> nodesMap) {
        HashMap<String, String> runNodeIds = new HashMap<String, String>(8);
        for (String nodeId : nodeIdList) {
            if (!nodesMap.containsKey(nodeId)) continue;
            Map<String, Object> map = nodesMap.get(nodeId);
            DynamicObject flowNode = (DynamicObject)map.get("flownodeentryentity");
            String nodename = flowNode.getString("nodename");
            runNodeIds.put(nodeId, nodename);
        }
        return runNodeIds;
    }

    public static List<String> getAloneNodeIds(Map<String, List<String>> childRelations, FlowNode flowNodes, Map<String, List<String>> parentRelations) {
        List<FlowNode> children = flowNodes.getChildren();
        ArrayList<String> aloneList = new ArrayList<String>();
        for (FlowNode flowNode : children) {
            String id = flowNode.getId();
            if (childRelations.containsKey(id) || parentRelations.containsKey(id)) continue;
            aloneList.add(id);
        }
        return aloneList;
    }

    public static void getAllNode(FlowNode flowNodes, List<String> nodeIds) {
        List<FlowNode> children = flowNodes.getChildren();
        for (FlowNode flowNode : children) {
            String id = flowNode.getId();
            nodeIds.add(id);
            FlowUtils.getAllNode(flowNode, nodeIds);
        }
    }

    public static int maxDepth(FlowNode root) {
        if (root == null) {
            return 0;
        }
        LinkedList<FlowNode> queue = new LinkedList<FlowNode>();
        queue.offer(root);
        int depth = 0;
        while (!queue.isEmpty()) {
            int size = queue.size();
            ++depth;
            for (int i = 0; i < size; ++i) {
                FlowNode cur = (FlowNode)queue.peek();
                queue.poll();
                for (int j = 0; j < cur.getChildren().size(); ++j) {
                    if (cur.getChildren().get(j) == null) continue;
                    queue.offer(cur.getChildren().get(j));
                }
            }
        }
        return depth;
    }

    public static Set<String> getLastOrBeginNodeIds(Map<String, List<String>> childRelations, Map<String, List<String>> parentRelations, String sign) {
        Set<String> childSet = childRelations.keySet();
        Set<String> parentSet = parentRelations.keySet();
        HashSet<String> nodes = null;
        if ("begin".equals(sign)) {
            nodes = new HashSet<String>(childSet);
            nodes.removeAll(parentSet);
        } else {
            nodes = new HashSet<String>(parentSet);
            nodes.removeAll(childSet);
        }
        return nodes;
    }
}

