/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.info.ComponentInfo;

public class JsonUtil {
    private static ObjectMapper objectMapper;

    private JsonUtil() {
    }

    private static ObjectMapper getObjectMapper() {
        if (objectMapper != null) {
            return objectMapper;
        }
        objectMapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
            private static final long serialVersionUID = 1L;
            private SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");

            @Override
            public Date parse(String source) throws ParseException {
                if (source == null) {
                    return null;
                }
                return source.length() <= 10 ? this.shortSdf.parse(source) : super.parse(source);
            }
        };
        objectMapper.setDateFormat((DateFormat)sdf);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        return objectMapper;
    }

    public static String toJsonString(Object object) {
        try {
            return JsonUtil.getObjectMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static <T> T fromJsonString(String content, Class<?> valueType) {
        try {
            return (T)JsonUtil.getObjectMapper().readValue(content, valueType);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static <T> T fromJsonStringByComponentInfo(String content) {
        try {
            TypeReference<HashMap<String, ComponentInfo>> typeReference = new TypeReference<HashMap<String, ComponentInfo>>(){};
            return (T)JsonUtil.getObjectMapper().readValue(content, (TypeReference)typeReference);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

