/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;

public class PHMUtils {
    public static final String ENTITY_NODETYPE = "phm_nodetype";
    public static final String ENTITY_PROCDEF = "phm_procdef";
    public static final String FORM_PROCDEFPROP = "phm_procdef_prop";
    public static final String OPER_AUDIT = "audit";
    public static final String OPER_DISABLE = "disable";
    public static final String OPER_ENABLE = "enable";
    public static final String OPER_SAVE = "save";
    public static final String OPER_SUBMIT = "submit";
    public static final String OPER_UNAUDIT = "unaudit";
    public static final String OPER_UNSUBMIT = "unsubmit";
    public static final String PROP_CREATEORG = "createorg";
    public static final String PROP_ENABLE = "enable";
    public static final String PROP_ID = "id";
    public static final String PROP_NAME = "name";
    public static final String PROP_NUMBER = "number";
    public static final String PROP_STATUS = "status";
    public static final String PROP_USEORG = "useorg";
    public static final long dayTime = 86400000L;
    public static final long hourTime = 3600000L;
    public static final long minuteTime = 60000L;
    public static final DBRoute phmDBRoute = new DBRoute("phm");
    public static final long secondTime = 1000L;
    public static final int treeNodeMaxLevel = 50;

    public static BillShowParameter createBillShowParameter(String formID, ShowType showType, OperationStatus os, long id, Map cp, CloseCallBack ccb) {
        if (StringUtils.isEmpty((String)formID) || showType == null) {
            return null;
        }
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(formID);
        bsp.getOpenStyle().setShowType(showType);
        if (id > 0L) {
            bsp.setPkId((Object)id);
        }
        if (os != null) {
            bsp.setStatus(os);
        }
        if (!PHMUtils.isEmptyMap(cp)) {
            bsp.setCustomParams(cp);
        }
        if (ccb != null) {
            bsp.setCloseCallBack(ccb);
        }
        return bsp;
    }

    public static FormShowParameter createFormShowParameter(String formID, ShowType showType, Map cp, CloseCallBack ccb) {
        if (StringUtils.isEmpty((String)formID) || showType == null) {
            return null;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formID);
        fsp.getOpenStyle().setShowType(showType);
        if (!PHMUtils.isEmptyMap(cp)) {
            fsp.setCustomParams(cp);
        }
        if (ccb != null) {
            fsp.setCloseCallBack(ccb);
        }
        return fsp;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = PHMUtils.getDataModelData(dataModel, param);
        return value == null ? null : (value instanceof BigDecimal ? (BigDecimal)value : null);
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, BigDecimal defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        BigDecimal value = PHMUtils.getDataModelBigDecimalData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getDataModelBooleanData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = PHMUtils.getDataModelData(dataModel, param);
        return value != null && (value instanceof Boolean ? (Boolean)value != false : Boolean.parseBoolean(value.toString()));
    }

    public static Object getDataModelData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        IDataEntityProperty dep = dataModel.getProperty(param);
        return dep == null ? null : dataModel.getValue(param);
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = PHMUtils.getDataModelData(dataModel, param);
        return value == null ? null : Integer.valueOf(value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param, Integer defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        Integer value = PHMUtils.getDataModelIntegerData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static String getDataModelStringData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = PHMUtils.getDataModelData(dataModel, param);
        return value == null ? null : value.toString();
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, String defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        String value = PHMUtils.getDataModelStringData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static Timestamp getDataModelTimestampData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = PHMUtils.getDataModelData(dataModel, param);
        return value == null ? null : (value instanceof Timestamp ? (Timestamp)value : null);
    }

    public static Object getListData(List list, int index) {
        if (PHMUtils.isEmptyList(list) || index < 0) {
            return null;
        }
        int size = list.size();
        if (index + 1 > size) {
            return null;
        }
        return list.get(index);
    }

    public static Map getListMapData(List list, int index) {
        if (PHMUtils.isEmptyList(list) || index < 0) {
            return null;
        }
        Object value = PHMUtils.getListData(list, index);
        return value == null ? null : (value instanceof Map ? (Map)value : null);
    }

    public static Map getListMapData(List list, int index, Map defaultValue) {
        if (PHMUtils.isEmptyList(list) || index < 0) {
            return defaultValue;
        }
        Map value = PHMUtils.getListMapData(list, index);
        return value == null ? defaultValue : value;
    }

    public static String getLocaleID() {
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            return null;
        }
        Lang lang = requestContext.getLang();
        if (lang == null) {
            return null;
        }
        Locale locale = lang.getLocale();
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (StringUtils.isEmpty((String)language) || StringUtils.isEmpty((String)country)) {
            return null;
        }
        return language + "_" + country;
    }

    public static BigDecimal getMapBigDecimalData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof BigDecimal ? (BigDecimal)value : null);
    }

    public static BigDecimal getMapBigDecimalData(Map map, Object param, BigDecimal defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        BigDecimal value = PHMUtils.getMapBigDecimalData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getMapBooleanData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Boolean ? (Boolean)value : null);
    }

    public static Boolean getMapBooleanData(Map map, Object param, Boolean defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Boolean value = PHMUtils.getMapBooleanData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Object getMapData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        return map.get(param);
    }

    public static Date getMapDateData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Date ? (Date)value : null);
    }

    public static Integer getMapIntegerData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : Integer.valueOf(value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
    }

    public static Integer getMapIntegerData(Map map, Object param, Integer defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Integer value = PHMUtils.getMapIntegerData(map, param);
        return value == null ? defaultValue : value;
    }

    public static List getMapListData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof List ? (List)value : null);
    }

    public static List getMapListData(Map map, Object param, List defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        List value = PHMUtils.getMapListData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Long getMapLongData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Long ? (Long)value : null);
    }

    public static Map getMapMapData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Map ? (Map)value : null);
    }

    public static Map getMapMapData(Map map, Object param, Map defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Map value = PHMUtils.getMapMapData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Set getMapSetData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Set ? (Set)value : null);
    }

    public static Set getMapSetData(Map map, Object param, Set defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Set value = PHMUtils.getMapSetData(map, param);
        return value == null ? defaultValue : value;
    }

    public static String getMapStringData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : value.toString();
    }

    public static String getMapStringData(Map map, Object param, String defaultValue) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? defaultValue : value.toString();
    }

    public static Time getMapTimeData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Time ? (Time)value : null);
    }

    public static Timestamp getMapTimestampData(Map map, Object param) {
        if (PHMUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = PHMUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Timestamp ? (Timestamp)value : null);
    }

    public static boolean isEmptyList(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static boolean isEmptyMap(Map map) {
        if (map == null) {
            return true;
        }
        return map.size() == 0;
    }

    public static boolean isEmptySet(Set set) {
        if (set == null) {
            return true;
        }
        return set.size() == 0;
    }

    public static boolean isEmptyStringBuilder(StringBuilder sb) {
        if (sb == null) {
            return true;
        }
        if (sb.length() == 0) {
            return true;
        }
        return sb.toString().trim().length() == 0;
    }

    public static boolean isZeroBigDecimal(BigDecimal num) {
        if (num == null) {
            return true;
        }
        return num.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isZeroInteger(Integer num) {
        if (num == null) {
            return true;
        }
        return num.compareTo(0) == 0;
    }

    public static void setBizChanged(DynamicObject doDE, String propName, boolean isChanged) {
        int refIDPropOrdinal;
        IDataEntityProperty refIDProp;
        BasedataProp bpTmp;
        if (doDE == null || StringUtils.isEmpty((String)propName)) {
            return;
        }
        DataEntityState desTmp = doDE.getDataEntityState();
        if (desTmp == null) {
            return;
        }
        DynamicObjectType dotTmp = doDE.getDynamicObjectType();
        if (dotTmp == null) {
            return;
        }
        DynamicProperty dpTmp = dotTmp.getProperty(propName);
        if (dpTmp == null) {
            return;
        }
        int propOrdinal = dpTmp.getOrdinal();
        if (propOrdinal < 0) {
            return;
        }
        desTmp.setBizChanged(propOrdinal, isChanged);
        BasedataProp basedataProp = bpTmp = dpTmp instanceof BasedataProp ? (BasedataProp)dpTmp : null;
        if (bpTmp != null && (refIDProp = bpTmp.getRefIdProp()) != null && (refIDPropOrdinal = refIDProp.getOrdinal()) > 0) {
            desTmp.setBizChanged(refIDPropOrdinal, isChanged);
        }
    }

    public static void test() {
        Long formatTime = 90061000L;
        PHMUtils.timeFormat(formatTime, "HH");
        PHMUtils.timeFormat(formatTime, "HH:MM");
        PHMUtils.timeFormat(formatTime, "HH:MM:SS");
        formatTime = 61000L;
        PHMUtils.timeFormat(formatTime, "HH");
        formatTime = 1000L;
        PHMUtils.timeFormat(formatTime, "HH:MM");
        formatTime = 500L;
        PHMUtils.timeFormat(formatTime, "HH:MM:SS");
        PHMUtils.getLocaleID();
        ArrayList tmpList = new ArrayList();
        HashMap<String, Object> tmpMap = new HashMap<String, Object>();
        tmpMap.put(PROP_ID, 1000);
        PHMUtils.createBillShowParameter(FORM_PROCDEFPROP, ShowType.InContainer, OperationStatus.EDIT, 1000L, tmpMap, new CloseCallBack());
        PHMUtils.getMapIntegerData(tmpMap, PROP_ID);
        tmpList.add(tmpMap);
        PHMUtils.getListMapData(tmpList, 0);
        tmpMap.put("data", BigDecimal.ONE);
        PHMUtils.getMapBigDecimalData(tmpMap, "data");
        tmpMap.put("data", Boolean.FALSE);
        PHMUtils.getMapBooleanData(tmpMap, "data");
        tmpMap.put("data", new Date());
        PHMUtils.getMapDateData(tmpMap, "data");
        tmpMap.put("data", new ArrayList());
        PHMUtils.getMapListData(tmpMap, "data");
        tmpMap.put("data", Long.valueOf("1000"));
        PHMUtils.getMapLongData(tmpMap, "data");
        tmpMap.put("data", new HashMap());
        PHMUtils.getMapMapData(tmpMap, "data");
        tmpMap.put("data", new HashSet());
        PHMUtils.getMapSetData(tmpMap, "data");
        tmpMap.put("data", Time.valueOf(LocalTime.now()));
        PHMUtils.getMapTimeData(tmpMap, "data");
        tmpMap.put("data", Timestamp.valueOf(LocalDateTime.now()));
        PHMUtils.getMapTimestampData(tmpMap, "data");
        PHMUtils.getListData(tmpList, 0);
        tmpMap.put("data", "data");
        PHMUtils.getMapStringData(tmpMap, "data");
        PHMUtils.getMapStringData(tmpMap, "type", "None");
        PHMUtils.getListMapData(tmpList, 1, new HashMap());
        PHMUtils.getMapBigDecimalData(tmpMap, "type", BigDecimal.ONE);
        PHMUtils.getMapBooleanData(tmpMap, "type", Boolean.TRUE);
        PHMUtils.getMapIntegerData(tmpMap, "type", 1000);
        PHMUtils.getMapListData(tmpMap, "type", new ArrayList());
        PHMUtils.getMapMapData(tmpMap, "type", new HashMap());
        PHMUtils.getMapSetData(tmpMap, "type", new HashSet());
        StringBuilder sb = new StringBuilder();
        sb.append("type");
        PHMUtils.isEmptyStringBuilder(sb);
        PHMUtils.isZeroInteger(1);
        PHMUtils.isZeroBigDecimal(BigDecimal.ONE);
        PHMUtils.getMapData(tmpMap, "data");
        PHMUtils.isEmptySet(new HashSet());
    }

    public static String timeFormat(long time, String format) {
        long mod;
        boolean formatS;
        if (StringUtils.isEmpty((String)format)) {
            return null;
        }
        String upperFormat = format.toUpperCase();
        StringBuilder sb = new StringBuilder();
        long newTime = time;
        boolean formatH = upperFormat.indexOf(72) >= 0;
        boolean formatM = upperFormat.indexOf(77) >= 0;
        boolean bl = formatS = upperFormat.indexOf(83) >= 0;
        if (formatH) {
            if (newTime >= 3600000L) {
                mod = newTime % 3600000L;
                long h = (newTime -= mod) / 3600000L;
                sb.append(h);
                newTime = mod;
            } else {
                sb.append('0');
            }
            sb.append('\u65f6');
        }
        if (formatM) {
            if (newTime >= 60000L) {
                mod = newTime % 60000L;
                long m = (newTime -= mod) / 60000L;
                if (formatH && m < 10L) {
                    sb.append('0');
                }
                sb.append(m);
                newTime = mod;
            } else {
                sb.append("00");
            }
            sb.append('\u5206');
        }
        if (formatS) {
            if (newTime >= 1000L) {
                mod = newTime % 1000L;
                long s = (newTime -= mod) / 1000L;
                if (formatM && s < 10L) {
                    sb.append('0');
                }
                sb.append(s);
                newTime = mod;
            } else {
                sb.append("00");
            }
            sb.append('\u79d2');
        }
        return sb.toString();
    }
}

