/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.CronStruct;
import kd.mmc.phm.common.basemanager.ScheduleConsts;
import kd.mmc.phm.common.bizmodel.TaskUtils;
import kd.mmc.phm.common.util.FlowActiveUtil;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class ScheduleUtils {
    private static final Log logger = LogFactory.getLog(ScheduleUtils.class);
    private static final String TASKCLASS_NUMBER = "phm_flow_active_task";
    private static final String TASKCLASSWARN_NUMBER = "phm_flow_active_task_warn";
    private static final String PHM_FLOW_EIGENVALUE = "phm_flow_eigenvalue";
    private static final String SCH_JOB = "sch_job";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String SCH_TASKDEFINE = "sch_taskdefine";
    private static final String PHM_TARGET_RATE = "phm_target_rate";
    private static final BigDecimal ONE_DAY = new BigDecimal(String.valueOf(86400000));
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static void deleteSuheduPlanByprocesshistoryNumber(String processhistoryNumber) {
        try {
            String scheduleNum;
            String scheduleId;
            String jobNumber_warning = "PHM_FLOW_WARNING_" + processhistoryNumber + "_";
            String jobNumber_overdue = "PHM_FLOW_OVERDUE_" + processhistoryNumber + "_";
            String jobNumber_seriousoverdue = "PHM_FLOW_SERIOUSOVERDUE_" + processhistoryNumber + "_";
            ArrayList list = Lists.newArrayList((Object[])new String[]{jobNumber_warning, jobNumber_overdue, jobNumber_seriousoverdue});
            List<String> existByNum = TaskUtils.getExistLikeByNum(SCH_JOB, list);
            if (existByNum.size() > 0) {
                DeleteServiceHelper.delete((String)SCH_JOB, (QFilter[])new QFilter[]{new QFilter("number", "in", existByNum)});
                logger.info(existByNum.toString());
            }
            if (!(scheduleId = TaskUtils.getIdByLikeNum(SCH_SCHEDULE, scheduleNum = "PLAN_PHM_FLOW_WARNING_" + processhistoryNumber + "_")).isEmpty()) {
                DeleteServiceHelper.delete((String)SCH_SCHEDULE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scheduleId)});
                logger.info(scheduleId);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static void deleteSuheduPlan(Object processhistory, Object taskNumber) {
        try {
            String scheduleNum;
            String scheduleId;
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", processhistory)});
            String processhistoryNumber = dynamicObject.getString("number");
            String jobNumber_warning = "PHM_FLOW_WARNING_" + processhistoryNumber + "_" + taskNumber;
            String jobNumber_overdue = "PHM_FLOW_OVERDUE_" + processhistoryNumber + "_" + taskNumber;
            String jobNumber_seriousoverdue = "PHM_FLOW_SERIOUSOVERDUE_" + processhistoryNumber + "_" + taskNumber;
            ArrayList list = Lists.newArrayList((Object[])new String[]{jobNumber_warning, jobNumber_overdue, jobNumber_seriousoverdue});
            List<String> existByNum = TaskUtils.getExistByNum(SCH_JOB, list);
            if (existByNum.size() > 0) {
                DeleteServiceHelper.delete((String)SCH_JOB, (QFilter[])new QFilter[]{new QFilter("number", "in", existByNum)});
                logger.info("\u5220\u9664\u9884\u8b66\u8c03\u5ea6\u8ba1\u5212:" + existByNum.toString());
            }
            if (!(scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum = "PLAN_PHM_FLOW_WARNING_" + processhistoryNumber + "_" + taskNumber)).isEmpty()) {
                DeleteServiceHelper.delete((String)SCH_SCHEDULE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scheduleId)});
                logger.info("\u5220\u9664\u9884\u8b66\u8c03\u5ea6\u4efb\u52a1:" + scheduleId);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static void deleteEigenvaluePollingSchedule(String flowHistoryNumber, String deliverablesnumber) {
        try {
            String jobNumber = "PHM_FLOW_EIGENVALUE_" + flowHistoryNumber + "_" + deliverablesnumber;
            String scheduleNum = "PLAN_PHM_FLOW_NODE_EIGENVALUE" + flowHistoryNumber + "_" + deliverablesnumber;
            DeleteServiceHelper.delete((String)SCH_JOB, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)jobNumber)});
            DeleteServiceHelper.delete((String)SCH_SCHEDULE, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)scheduleNum)});
            logger.info("deleteEigenvaluePollingSchedule:" + jobNumber + "_" + scheduleNum);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static void deleteEigenvaluePollingScheduleByFlowHistoryNumber(String flowHistoryNumber) {
        try {
            String jobNumber = "PHM_FLOW_EIGENVALUE_" + flowHistoryNumber + "_";
            String scheduleNum = "PLAN_PHM_FLOW_NODE_EIGENVALUE" + flowHistoryNumber + "_";
            DeleteServiceHelper.delete((String)SCH_JOB, (QFilter[])new QFilter[]{new QFilter("number", "ftlike", (Object)jobNumber)});
            DeleteServiceHelper.delete((String)SCH_SCHEDULE, (QFilter[])new QFilter[]{new QFilter("number", "ftlike", (Object)scheduleNum)});
            logger.info("deleteEigenvaluePollingSchedule:" + jobNumber + "_" + scheduleNum);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static OperationResult creatJobByEigenvalue(DynamicObject dynamicObject, DynamicObject flowHistory, String deliverablesnumber, Object tasknoticeId) {
        String flowHistoryNumber = flowHistory.getString("number");
        String jobNumber = "PHM_FLOW_EIGENVALUE_" + flowHistoryNumber + "_" + deliverablesnumber;
        String jobId = TaskUtils.getIdByNum(SCH_JOB, jobNumber);
        DynamicObject job = TaskUtils.getExistedObject(SCH_JOB, jobId);
        job.set("number", (Object)jobNumber);
        job.set("name", (Object)(ResManager.loadKDString((String)"\u7279\u5f81\u503c\u8f6e\u8be2", (String)"ScheduleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + flowHistoryNumber + "_" + deliverablesnumber));
        job.set("jobtype", (Object)"BIZ");
        String taskClassId = TaskUtils.getIdByNum(SCH_TASKDEFINE, PHM_FLOW_EIGENVALUE);
        job.set("taskclassname", (Object)taskClassId);
        job.set("runbyuser", (Object)RequestContext.get().getCurrUserId());
        job.set("status", (Object)"1");
        job.set("runmode", (Object)"0");
        job.set("runconcurrent", (Object)true);
        job.set("runorder", (Object)"1");
        job.set("strategy", (Object)"1");
        DynamicObjectCollection collection = job.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject addNew = collection.addNew();
        addNew.set("paramname", (Object)"flowHistoryId");
        addNew.set("paramvalue", flowHistory.get("id"));
        DynamicObject addNew1 = collection.addNew();
        addNew1.set("paramname", (Object)"nodeId");
        addNew1.set("paramvalue", dynamicObject.get("nodeid"));
        DynamicObject addNew2 = collection.addNew();
        addNew2.set("paramname", (Object)"deliverablesnumber");
        addNew2.set("paramvalue", (Object)deliverablesnumber);
        DynamicObject addNew3 = collection.addNew();
        addNew3.set("paramname", (Object)"tasknoticeId");
        addNew3.set("paramvalue", tasknoticeId);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("flowHistoryId", flowHistory.get("id"));
        paramsMap.put("nodeId", dynamicObject.get("nodeid"));
        paramsMap.put("deliverablesnumber", deliverablesnumber);
        paramsMap.put("tasknoticeId", tasknoticeId);
        job.set("params", (Object)SerializationUtils.toJsonString(paramsMap));
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
        FlowActiveUtil.writeLog(flowHistoryNumber, deliverablesnumber, ResManager.loadKDString((String)"\u7279\u5f81\u503c\u8f6e\u8be2", (String)"ScheduleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + jobNumber);
        return operationResult;
    }

    public static OperationResult creatSuheduByEigenvalue(String jobId, DynamicObject flowHistory, String deliverablesnumber) {
        String flowHistoryNumber = flowHistory.getString("number");
        String scheduleNum = "PLAN_PHM_FLOW_NODE_EIGENVALUE" + flowHistoryNumber + "_" + deliverablesnumber;
        String scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scheduleId)) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject schedule = TaskUtils.getExistedObject(SCH_SCHEDULE, scheduleId);
        schedule.set("number", (Object)scheduleNum);
        schedule.set("name", (Object)(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u7279\u5f81\u503c\u4efb\u52a1\u8f6e\u8be2", (String)"ScheduleUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]) + flowHistoryNumber + "_" + deliverablesnumber));
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        Date startTime = new Date();
        schedule.set("starttime", (Object)startTime);
        try {
            schedule.set("endtime", (Object)sdf.parse("2099-12-31"));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u9519\u8bef%s", (String)"ScheduleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", (Object)"n");
        schedule.set("txtdesc", (Object)ScheduleUtils.genDesc(10, startTime, "mi", schedule));
        schedule.set("repeatmode", (Object)"mi");
        schedule.set("cyclenum", (Object)10);
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
        List pkId = operationResult.getSuccessPkIds();
        if (pkId == null || pkId.size() == 0) {
            logger.error(scheduleNum + ":\u521b\u5efa\u8282\u70b9\u8c03\u5ea6\u8ba1\u5212\u5931\u8d25");
        }
        FlowActiveUtil.writeLog(flowHistoryNumber, deliverablesnumber, ResManager.loadKDString((String)"\u7279\u5f81\u503c\u8f6e\u8be2", (String)"ScheduleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + scheduleNum);
        return operationResult;
    }

    private static String genDesc(int cycleNum, Date time, String repeatMode, DynamicObject schedule) {
        if (cycleNum <= 0) {
            return "";
        }
        Calendar startTime = ScheduleUtils.getStartTime(time);
        CronStruct cron = ScheduleUtils.getCronStruct(startTime);
        StringBuilder descBuf = cron.getDescBuf();
        descBuf.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"ScheduleUtils_3", (String)"mmc-phm-common", (Object[])new Object[0]));
        String startTimeStr = new SimpleDateFormat(DATETIME_FORMAT).format(startTime.getTime());
        descBuf.append(startTimeStr).append(ResManager.loadKDString((String)"\u8d77\uff0c", (String)"ScheduleUtils_4", (String)"mmc-phm-common", (Object[])new Object[0]));
        switch (repeatMode) {
            case "n": {
                descBuf.setLength(0);
                descBuf.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"ScheduleUtils_5", (String)"mmc-phm-common", (Object[])new Object[0]));
                break;
            }
            case "mi": {
                ScheduleUtils.repeatByHour(cron, repeatMode);
                descBuf.append('\u6bcf').append(cycleNum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002 ", (String)"ScheduleUtils_6", (String)"mmc-phm-common", (Object[])new Object[0]));
                if (cycleNum > 1) {
                    cron.setMinutes("0/" + cycleNum);
                } else {
                    cron.setMinutes("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "d": {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5929');
                if (cycleNum > 1) {
                    String day = String.valueOf(startTime.get(5));
                    cron.setDayOfMonth(day + "/" + cycleNum);
                } else {
                    cron.setDayOfMonth("*");
                }
                ScheduleUtils.repeatByHour(cron, repeatMode);
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"DataPumpEdit_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        schedule.set("plan", (Object)cron.toString());
        if (!StringUtils.equals((CharSequence)"n", (CharSequence)repeatMode)) {
            descBuf.append(ResManager.loadKDString((String)"\u9884\u8ba1\u4e0b\u4e00\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"ScheduleUtils_7", (String)"mmc-phm-common", (Object[])new Object[0]));
            descBuf.append(ScheduleUtils.computeFireTimes(cron.toString(), startTime.getTime(), 1));
        }
        return descBuf.toString();
    }

    private static String computeFireTimes(String cronExp, Date startDate, Integer numTimes) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FORMAT);
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExp);
            cronTriggerImpl.setStartTime(startDate);
            List dateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
            return dateFormat.format((Date)dateList.get(0));
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\uff1a%s", (String)"ScheduleUtils_8", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private static CronStruct getCronStruct(Calendar startTime) {
        return CronStruct.init(startTime);
    }

    private static Calendar getStartTime(Date startTime) {
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        }
        return crStartTime;
    }

    private static void repeatByHour(CronStruct cron, String repeatMode) {
        String cronExpStr;
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        Stream.iterate(0, x -> {
            x = x + 1;
            return x;
        }).limit(24L).forEachOrdered(h -> {
            String hour = h < 10 ? "ckhour_0" + h : "ckhour_" + h;
            cronExp.append(h).append(',');
            cronDesc.append(h).append(ResManager.loadKDString((String)"\u65f6\uff0c", (String)"ScheduleUtils_9", (String)"mmc-phm-common", (Object[])new Object[0]));
        });
        if (cronExp.length() > 0) {
            cronExpStr = cronExp.substring(0, cronExp.length() - 1);
        } else {
            String string = cronExpStr = "mi".equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDesc.length() > 0) {
            cron.getDescBuf().append(cronDesc.substring(0, cronDesc.length() - 1));
        }
        cron.setHours(cronExpStr);
    }

    public static OperationResult creatJobPlan(DynamicObject dynamicObject, String sign, DynamicObject flowHistory, String deliverablesnumber) {
        String flowHistoryNumber = flowHistory.getString("number");
        String jobNumber = "PHM_FLOW_WARNING_" + flowHistoryNumber + "_" + deliverablesnumber;
        if ("seriousoverdue".equals(sign)) {
            jobNumber = "PHM_FLOW_OVERDUE_" + flowHistoryNumber + "_" + deliverablesnumber;
        }
        String jobId = TaskUtils.getIdByNum(SCH_JOB, jobNumber);
        DynamicObject job = TaskUtils.getExistedObject(SCH_JOB, jobId);
        if ("overdue".equals(sign)) {
            jobNumber = "PHM_FLOW_OVERDUE_" + flowHistoryNumber + "_" + deliverablesnumber;
        } else if ("seriousoverdue".equals(sign)) {
            jobNumber = "PHM_FLOW_SERIOUSOVERDUE_" + flowHistoryNumber + "_" + deliverablesnumber;
        }
        job.set("number", (Object)jobNumber);
        job.set("name", (Object)(flowHistoryNumber + "_" + deliverablesnumber));
        job.set("jobtype", (Object)"BIZ");
        String taskClassId = TaskUtils.getIdByNum(SCH_TASKDEFINE, TASKCLASSWARN_NUMBER);
        job.set("taskclassname", (Object)taskClassId);
        job.set("runbyuser", (Object)RequestContext.get().getUserId());
        job.set("status", (Object)"1");
        job.set("runmode", (Object)"0");
        job.set("runconcurrent", (Object)true);
        job.set("runorder", (Object)"1");
        job.set("strategy", (Object)"1");
        DynamicObjectCollection collection = job.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject addNew = collection.addNew();
        addNew.set("paramname", (Object)"flowHistoryId");
        addNew.set("paramvalue", flowHistory.get("id"));
        DynamicObject addNew1 = collection.addNew();
        addNew1.set("paramname", (Object)"nodeId");
        addNew1.set("paramvalue", dynamicObject.get("nodeid"));
        DynamicObject addNew2 = collection.addNew();
        addNew2.set("paramname", (Object)"deliverablesnumber");
        addNew2.set("paramvalue", (Object)deliverablesnumber);
        DynamicObject addNew3 = collection.addNew();
        addNew3.set("paramname", (Object)"type");
        addNew3.set("paramvalue", (Object)sign);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("flowHistoryId", flowHistory.get("id"));
        paramsMap.put("nodeId", dynamicObject.get("nodeid"));
        paramsMap.put("deliverablesnumber", deliverablesnumber);
        paramsMap.put("type", sign);
        job.set("params", (Object)SerializationUtils.toJsonString(paramsMap));
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
        FlowActiveUtil.writeLog(flowHistoryNumber, deliverablesnumber, ResManager.loadKDString((String)"\u9884\u8b66\u8c03\u5ea6\u4f5c\u4e1a:", (String)"ScheduleUtils_10", (String)"mmc-phm-common", (Object[])new Object[0]) + jobNumber);
        return operationResult;
    }

    public static OperationResult creatSuheduPlan(String jobId, DynamicObject resourceEntry, DynamicObject dynamicObject, String type, String number) {
        Date date = dynamicObject.getDate("planendtime");
        BigDecimal bigDecimal = null;
        String name = "";
        if ("warning".equals(type)) {
            name = ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u4e49\u4efb\u52a1\u9884\u8b66", (String)"ScheduleUtils_11", (String)"mmc-phm-common", (Object[])new Object[0]) + resourceEntry.getString("deliverablesname");
            bigDecimal = resourceEntry.getBigDecimal("warningcycle");
        } else if ("overdue".equals(type)) {
            name = ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u4e49\u4efb\u52a1\u903e\u671f", (String)"ScheduleUtils_12", (String)"mmc-phm-common", (Object[])new Object[0]) + resourceEntry.getString("deliverablesname");
            bigDecimal = resourceEntry.getBigDecimal("overduecycle");
        } else {
            name = ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u4e49\u4efb\u52a1\u4e25\u91cd\u903e\u671f", (String)"ScheduleUtils_13", (String)"mmc-phm-common", (Object[])new Object[0]) + resourceEntry.getString("deliverablesname");
            bigDecimal = resourceEntry.getBigDecimal("seriousoverduecycle");
        }
        String deliverablesnumber = resourceEntry.getString("deliverablesnumber");
        Date date_star = ScheduleUtils.calcBeginDate(date, bigDecimal, type);
        String scheduleNum = "PLAN_PHM_FLOW_WARNING_" + number + "_" + deliverablesnumber;
        String scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scheduleId)) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject schedule = TaskUtils.getExistedObject(SCH_SCHEDULE, scheduleId);
        schedule.set("number", (Object)scheduleNum);
        schedule.set("name", (Object)name);
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        schedule.set("starttime", (Object)date_star);
        try {
            schedule.set("endtime", (Object)sdf.parse("2099-12-31"));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u9519\u8bef%s", (String)"ScheduleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", (Object)"n");
        schedule.set("txtdesc", (Object)ScheduleUtils.genDesc(1, date_star, "n", schedule));
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
        FlowActiveUtil.writeLog(number, deliverablesnumber, ResManager.loadKDString((String)"\u9884\u8b66\u8c03\u5ea6\u8ba1\u5212:", (String)"ScheduleUtils_14", (String)"mmc-phm-common", (Object[])new Object[0]) + scheduleNum);
        return operationResult;
    }

    private static Date calcBeginDate(Date date, BigDecimal bigDecimal, String type) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
            long endTime = date.getTime();
            BigDecimal multiply = bigDecimal.multiply(ONE_DAY);
            Long starTime = "warning".equals(type) ? Long.valueOf(endTime - multiply.longValue()) : Long.valueOf(endTime + multiply.longValue());
            Date parse = new SimpleDateFormat(DATETIME_FORMAT).parse(sdf.format(new Date(starTime)));
            return parse;
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void createNodeJobAndSchedule(DynamicObject dynamicObject, Map<String, String> runNodeIds, Map<String, Map<String, Object>> nodesMap, Object history) {
        if (runNodeIds.size() == 0) {
            return;
        }
        Object historyId = ((DynamicObject)history).get("id");
        String number = ((DynamicObject)history).getString("number");
        for (Map.Entry<String, String> runNode : runNodeIds.entrySet()) {
            String runNodeId = runNode.getKey();
            String runNodeName = runNode.getValue();
            String jobNumber = "PHM_FLOW_NODE_" + number + "_" + runNodeId;
            String jobId = TaskUtils.getIdByNum(SCH_JOB, jobNumber);
            DynamicObject job = TaskUtils.getExistedObject(SCH_JOB, jobId);
            job.set("number", (Object)jobNumber);
            job.set("name", (Object)(dynamicObject.getString("name") + "_" + runNodeName));
            job.set("jobtype", (Object)"BIZ");
            String taskClassId = TaskUtils.getIdByNum(SCH_TASKDEFINE, TASKCLASS_NUMBER);
            job.set("taskclassname", (Object)taskClassId);
            job.set("runbyuser", (Object)RequestContext.get().getUserId());
            job.set("status", (Object)"1");
            job.set("runmode", (Object)"0");
            job.set("runconcurrent", (Object)true);
            job.set("runorder", (Object)"1");
            job.set("strategy", (Object)"1");
            Object id = dynamicObject.get("id");
            DynamicObjectCollection collection = job.getDynamicObjectCollection("entryentity");
            collection.clear();
            DynamicObject addNew = collection.addNew();
            addNew.set("paramname", (Object)"test");
            addNew.set("paramvalue", id);
            DynamicObject addNew1 = collection.addNew();
            addNew1.set("paramname", (Object)"nodeId");
            addNew1.set("paramvalue", (Object)runNodeId);
            DynamicObject addNew2 = collection.addNew();
            addNew2.set("paramname", (Object)"historyId");
            addNew2.set("paramvalue", historyId);
            DynamicObject addNew3 = collection.addNew();
            addNew3.set("paramname", (Object)"id");
            addNew3.set("paramvalue", id);
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
            paramsMap.put("id3333", id);
            paramsMap.put("nodeId", runNodeId);
            paramsMap.put("historyId", historyId);
            paramsMap.put("id", id);
            job.set("params", (Object)SerializationUtils.toJsonString(paramsMap));
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
            List pkId = operationResult.getSuccessPkIds();
            if (pkId != null && pkId.size() != 0) {
                FlowActiveUtil.writeLog(number, ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a:", (String)"ScheduleUtils_15", (String)"mmc-phm-common", (Object[])new Object[0]) + jobNumber, ResManager.loadKDString((String)"\u4e0b\u4e00\u8282\u70b9:", (String)"ScheduleUtils_16", (String)"mmc-phm-common", (Object[])new Object[0]) + runNodeId);
                jobId = pkId.get(0).toString();
                ScheduleUtils.createNodeSchedule(jobId, dynamicObject, runNodeId, nodesMap, number);
                continue;
            }
            logger.error(jobNumber + ":\u521b\u5efa\u8282\u70b9\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25");
        }
    }

    public static OperationResult createRateJob(DynamicObject targetdefine, String rateSign) {
        String number = targetdefine.getString("number");
        String name = targetdefine.getString("name");
        String jobNumber = "PHM_TARGET_" + number + rateSign;
        String jobId = TaskUtils.getIdByNum(SCH_JOB, jobNumber);
        DynamicObject job = TaskUtils.getExistedObject(SCH_JOB, jobId);
        job.set("number", (Object)jobNumber);
        job.set("name", (Object)name);
        job.set("jobtype", (Object)"BIZ");
        String taskClassId = TaskUtils.getIdByNum(SCH_TASKDEFINE, PHM_TARGET_RATE);
        job.set("taskclassname", (Object)taskClassId);
        job.set("runbyuser", (Object)RequestContext.get().getUserId());
        job.set("status", (Object)"1");
        job.set("runmode", (Object)"0");
        job.set("runconcurrent", (Object)true);
        job.set("runorder", (Object)"1");
        job.set("strategy", (Object)"1");
        DynamicObjectCollection collection = job.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject addNew = collection.addNew();
        addNew.set("paramname", (Object)"id");
        addNew.set("paramvalue", targetdefine.get("id"));
        DynamicObject addNew1 = collection.addNew();
        addNew1.set("paramname", (Object)"rateSign");
        addNew1.set("paramvalue", (Object)rateSign);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("id", targetdefine.get("id"));
        paramsMap.put("rateSign", rateSign);
        job.set("params", (Object)SerializationUtils.toJsonString(paramsMap));
        return SaveServiceHelper.saveOperate((String)SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
    }

    public static OperationResult createJob(DynamicObject dynamicObject, String sign) {
        String jobNumber = "PHM_FLOW_" + dynamicObject.getString("number");
        String jobId = TaskUtils.getIdByNum(SCH_JOB, jobNumber);
        DynamicObject job = TaskUtils.getExistedObject(SCH_JOB, jobId);
        job.set("number", (Object)jobNumber);
        job.set("name", (Object)dynamicObject.getString("name"));
        job.set("jobtype", (Object)"BIZ");
        String taskClassId = TaskUtils.getIdByNum(SCH_TASKDEFINE, TASKCLASS_NUMBER);
        job.set("taskclassname", (Object)taskClassId);
        job.set("runbyuser", (Object)RequestContext.get().getUserId());
        job.set("status", (Object)"1");
        job.set("runmode", (Object)"0");
        job.set("runconcurrent", (Object)true);
        job.set("runorder", (Object)"1");
        job.set("strategy", (Object)"1");
        DynamicObjectCollection collection = job.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject addNew = collection.addNew();
        addNew.set("paramname", (Object)"id");
        addNew.set("paramvalue", dynamicObject.get("id"));
        DynamicObject addNew1 = collection.addNew();
        addNew1.set("paramname", (Object)"startype");
        addNew1.set("paramvalue", (Object)sign);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("id", dynamicObject.get("id"));
        paramsMap.put("startype", sign);
        job.set("params", (Object)SerializationUtils.toJsonString(paramsMap));
        return SaveServiceHelper.saveOperate((String)SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
    }

    public static void createRateSchedule(String jobId, DynamicObject dynamicObject, String rateSign, Date rateStartTime) {
        String number = dynamicObject.getString("number");
        String scheduleNum = "PLAN_PHM_RATE_" + number + "_" + rateSign;
        String scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scheduleId)) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject schedule = TaskUtils.getExistedObject(SCH_SCHEDULE, scheduleId);
        schedule.set("number", (Object)scheduleNum);
        schedule.set("name", (Object)(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8003\u6838\u9891\u7387", (String)"ScheduleUtils_20", (String)"mmc-phm-common", (Object[])new Object[0]) + number + "-" + rateSign));
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        schedule.set("starttime", (Object)rateStartTime);
        try {
            schedule.set("endtime", (Object)sdf.parse("2099-12-31"));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u9519\u8bef%s", (String)"ScheduleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", (Object)"n");
        schedule.set("txtdesc", (Object)ScheduleUtils.genDesc(1, rateStartTime, "n", schedule));
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
        List pkId = operationResult.getSuccessPkIds();
        if (pkId == null || pkId.size() == 0) {
            logger.error(scheduleNum + "\u521b\u5efa\u8003\u6838\u9891\u7387\u8ba1\u5212\u5931\u8d25");
        }
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        ScheduleUtils.setTime(cal);
        return cal.getTime();
    }

    public static Date getRateStartTime(String rateSign, Date time) {
        Date date = null;
        if ("YEAR".equals(rateSign)) {
            date = ScheduleUtils.getCurrYearLast(time);
        } else if ("HALFYEAR".equals(rateSign)) {
            date = ScheduleUtils.getHelfYearLast(time);
        } else if ("QUARTER".equals(rateSign)) {
            date = ScheduleUtils.getQuarterEnd(time);
        } else if ("MONTH".equals(rateSign)) {
            date = ScheduleUtils.getCurrMonthLast(time);
        } else if ("TENDAYS".equals(rateSign)) {
            date = ScheduleUtils.getTendaysDate(time);
        } else if ("WEEK".equals(rateSign)) {
            date = ScheduleUtils.getWeekEnd(time);
        } else if ("DAY".equals(rateSign)) {
            date = ScheduleUtils.getDayEnd(time);
        }
        return date;
    }

    private static Date getDayEnd(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        ScheduleUtils.setTime(calendar);
        return calendar.getTime();
    }

    public static Date getWeekStart(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            calendar.add(5, -6);
        } else {
            calendar.set(7, 2);
        }
        return calendar.getTime();
    }

    public static Date getWeekEnd(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ScheduleUtils.getWeekStart(time));
        calendar.add(5, 6);
        ScheduleUtils.setTime(calendar);
        return calendar.getTime();
    }

    public static Date getTendaysDate(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(5, 10);
        ScheduleUtils.setTime(calendar);
        Date tendaysDate = calendar.getTime();
        return tendaysDate;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        ScheduleUtils.setTime(calendar);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    private static void setTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
    }

    public static Date getQuarterEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        ScheduleUtils.setTime(calendar);
        Date time = calendar.getTime();
        return time;
    }

    public static Date getHelfYearLast(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int currentMonth = calendar.get(2);
        if (currentMonth <= 5) {
            calendar.set(2, 5);
            int maximum = calendar.getActualMaximum(5);
            calendar.set(5, maximum);
        } else {
            calendar.set(2, 11);
            int maximum = calendar.getActualMaximum(5);
            calendar.set(5, maximum);
        }
        ScheduleUtils.setTime(calendar);
        return calendar.getTime();
    }

    public static Date getCurrYearLast(Date time) {
        Calendar currCal = Calendar.getInstance();
        currCal.setTime(time);
        int currentYear = currCal.get(1);
        return ScheduleUtils.getYearLast(currentYear);
    }

    public static Date getCurrMonthLast(Date time) {
        Calendar currCal = Calendar.getInstance();
        currCal.setTime(time);
        int currentYear = currCal.get(1);
        int currentMonth = currCal.get(2);
        return ScheduleUtils.getLastDayOfMonth(currentYear, currentMonth);
    }

    public static void createNodeSchedule(String jobId, DynamicObject dynamicObject, String nodeId, Map<String, Map<String, Object>> nodesMap, String number) {
        String scheduleNum = "PLAN_PHM_FLOW_NODE_" + number + "_" + nodeId;
        String scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scheduleId)) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject schedule = TaskUtils.getExistedObject(SCH_SCHEDULE, scheduleId);
        schedule.set("number", (Object)scheduleNum);
        schedule.set("name", (Object)(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9", (String)"ScheduleUtils_17", (String)"mmc-phm-common", (Object[])new Object[0]) + dynamicObject.getString("name")));
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        Date startTime = new Date();
        for (Map.Entry<String, Map<String, Object>> mapEntry : nodesMap.entrySet()) {
            Map<String, Object> nodeMap;
            if (!nodeId.equals(mapEntry.getKey()) || (nodeMap = mapEntry.getValue()) == null) continue;
            DynamicObject flowNode = (DynamicObject)nodeMap.get("flownodeentryentity");
            startTime = flowNode.getDate("begindate");
        }
        schedule.set("starttime", (Object)startTime);
        try {
            schedule.set("endtime", (Object)sdf.parse("2099-12-31"));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u9519\u8bef%s", (String)"ScheduleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", (Object)"n");
        schedule.set("txtdesc", (Object)ScheduleUtils.genDesc(1, startTime, "n", schedule));
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
        List pkId = operationResult.getSuccessPkIds();
        FlowActiveUtil.writeLog(number, ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212:", (String)"ScheduleUtils_18", (String)"mmc-phm-common", (Object[])new Object[0]) + scheduleNum, ResManager.loadKDString((String)"\u4e0b\u4e00\u8282\u70b9:", (String)"ScheduleUtils_16", (String)"mmc-phm-common", (Object[])new Object[0]) + nodeId);
        if (pkId == null || pkId.size() == 0) {
            logger.error(scheduleNum + ":\u521b\u5efa\u8282\u70b9\u8c03\u5ea6\u8ba1\u5212\u5931\u8d25");
        }
    }

    public static OperationResult createSchedule(String jobId, DynamicObject dynamicObject) {
        String scheduleNum = "PLAN_PHM_FLOW_" + dynamicObject.getString("number");
        String scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scheduleId)) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject schedule = TaskUtils.getExistedObject(SCH_SCHEDULE, scheduleId);
        schedule.set("number", (Object)scheduleNum);
        schedule.set("name", (Object)(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u4e49", (String)"ScheduleUtils_19", (String)"mmc-phm-common", (Object[])new Object[0]) + dynamicObject.getString("name")));
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        Date startTime = dynamicObject.getDate("validated_time");
        if (startTime == null) {
            startTime = new Date();
        }
        schedule.set("starttime", (Object)startTime);
        try {
            schedule.set("endtime", (Object)sdf.parse("2099-12-31"));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u9519\u8bef%s", (String)"ScheduleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", dynamicObject.get("repeatmode"));
        schedule.set("cyclenum", dynamicObject.get("cyclenum"));
        schedule.set("plan", dynamicObject.get("plan"));
        schedule.set("txtdesc", dynamicObject.get("txtdesc"));
        schedule.set("combdorw", dynamicObject.get("combdorw"));
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        for (String monthProp : ScheduleConsts.CKMONTH) {
            schedule.set(monthProp, dynamicObject.get(monthProp));
        }
        for (String dateProp : ScheduleConsts.CKDATE) {
            schedule.set(dateProp, dynamicObject.get(dateProp));
        }
        for (String weekProp : ScheduleConsts.CKWEEK) {
            schedule.set(weekProp, dynamicObject.get(weekProp));
        }
        schedule.set("comno", dynamicObject.get("comno"));
        schedule.set("comweek", dynamicObject.get("comweek"));
        schedule.set("ckbyweek", dynamicObject.get("ckbyweek"));
        return SaveServiceHelper.saveOperate((String)SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
    }
}

