/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.command.Seat;
import kd.mmc.phm.common.command.SeatEnum;
import kd.mmc.phm.common.command.Veidoo;
import kd.mmc.phm.common.command.VeidooEnum;
import kd.mmc.phm.common.command.VeidooScene;
import kd.mmc.phm.common.util.DesignerUtils;

public class SeatUtils {
    private static final Log logger = LogFactory.getLog(SeatUtils.class);
    private static final Map<String, String> comparisonOperatorMap = DesignerUtils.newHashMapWithExpectedSize(8);

    private SeatUtils() {
        throw new RuntimeException("not supported");
    }

    public static String getText(DynamicObjectCollection entryEntity, boolean running) {
        StringBuilder example = new StringBuilder();
        for (DynamicObject dynamicObject : entryEntity) {
            String type = dynamicObject.getString("type");
            String value = dynamicObject.getString("value");
            if (StringUtils.equals((CharSequence)value, (CharSequence)ResManager.loadKDString((String)"\u53cc\u51fb\u7ef4\u62a4", (String)"SeatUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]))) continue;
            String text = StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)type) && StringUtils.isBlank((CharSequence)value) ? ResManager.loadKDString((String)"\u7279\u5f81\u503c", (String)"SeatUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]) : (running && StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)type) ? "%s" : value);
            example.append(text);
        }
        return example.toString();
    }

    public static List<Seat> wrapperSeat(Object commandId) {
        HashMap seatMap = new HashMap(16);
        QFilter[] filters = new QFilter("command", "=", commandId).toArray();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"phm_veidooscene", (String)"id, name, seat, veidoo, bizmodel.xml_tag", (QFilter[])filters);
        for (DynamicObject dynamicObject : collection) {
            String veidooValue;
            ArrayList<DynamicObject> rows;
            String seatValue = dynamicObject.getString("seat");
            HashMap<String, ArrayList<DynamicObject>> veidooSceneMap2 = (HashMap<String, ArrayList<DynamicObject>>)seatMap.get(seatValue);
            if (Objects.isNull(veidooSceneMap2)) {
                veidooSceneMap2 = new HashMap<String, ArrayList<DynamicObject>>(16);
            }
            if (Objects.isNull(rows = (ArrayList<DynamicObject>)veidooSceneMap2.get(veidooValue = dynamicObject.getString("veidoo")))) {
                rows = new ArrayList<DynamicObject>();
            }
            rows.add(dynamicObject);
            veidooSceneMap2.put(veidooValue, rows);
            seatMap.put(seatValue, veidooSceneMap2);
        }
        BiFunction<VeidooEnum, Map, Veidoo> veidooFunction = (veidooEnum, veidooSceneMap) -> {
            List rows;
            Veidoo veidoo = new Veidoo();
            veidoo.setId(veidooEnum.getKey());
            veidoo.setName(veidooEnum.getName());
            ArrayList<VeidooScene> veidooScenes = new ArrayList<VeidooScene>();
            if (Objects.nonNull(veidooSceneMap) && Objects.nonNull(rows = (List)veidooSceneMap.get(veidooEnum.getValue()))) {
                for (DynamicObject row : rows) {
                    VeidooScene veidooScene = new VeidooScene();
                    veidooScene.setId(row.getString("id"));
                    veidooScene.setName(row.getString("name"));
                    veidooScene.setXml(row.getString("bizmodel.xml_tag"));
                    veidooScene.setDetail(null);
                    veidooScenes.add(veidooScene);
                }
            }
            veidoo.setChildren(veidooScenes);
            return veidoo;
        };
        Function<SeatEnum, Seat> seatFunction = seatEnum -> {
            Seat seat = new Seat();
            seat.setId(seatEnum.getKey());
            seat.setName(seatEnum.getName());
            List<Veidoo> veidoos = Arrays.stream(VeidooEnum.values()).filter(veidooEnum -> veidooEnum != VeidooEnum.OTHER).map(veidooEnum -> (Veidoo)veidooFunction.apply((VeidooEnum)((Object)veidooEnum), (Map)seatMap.get(seatEnum.getValue()))).collect(Collectors.toList());
            seat.setChildren(veidoos);
            return seat;
        };
        return Arrays.stream(SeatEnum.values()).filter(seatEnum -> seatEnum != SeatEnum.OTHER).map(seatFunction).collect(Collectors.toList());
    }

    public static List<VeidooScene> wrapperRightData(String groupDisplayId) {
        DynamicObject groupDisplayObject = QueryServiceHelper.queryOne((String)"phm_groupdisplay", (String)"setdata,setdata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupDisplayId)});
        String setData = groupDisplayObject.getString("setdata_tag");
        ArrayList<VeidooScene> ls = new ArrayList<VeidooScene>(4);
        if (StringUtils.isNotEmpty((CharSequence)setData)) {
            JSONArray objects = JSONObject.parseArray((String)setData);
            QFilter[] filters = new QFilter("id", "in", (Object)objects.toJavaList(String.class)).toArray();
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"phm_veidooscene", (String)"id, name, seat, veidoo, bizmodel.xml_tag", (QFilter[])filters);
            HashMap<String, DynamicObject> id_dyObj = new HashMap<String, DynamicObject>(4);
            for (DynamicObject veiDooScene : collection) {
                String id = veiDooScene.getString("id");
                id_dyObj.put(id, veiDooScene);
            }
            for (Object id : objects) {
                DynamicObject veiDooScene = (DynamicObject)id_dyObj.get(id);
                VeidooScene veidooScene = new VeidooScene();
                if (veiDooScene != null) {
                    veidooScene.setId(veiDooScene.getString("id"));
                    veidooScene.setName(veiDooScene.getString("name"));
                    veidooScene.setXml(veiDooScene.getString("bizmodel.xml_tag"));
                    veidooScene.setDetail(null);
                } else {
                    veidooScene.setId("");
                    veidooScene.setName("");
                    veidooScene.setXml("");
                    veidooScene.setDetail(null);
                }
                ls.add(veidooScene);
            }
        }
        return ls;
    }

    public static String executeCondition(DynamicObjectCollection entryEntity, Map<String, Serializable> result) {
        String returnData;
        Tuple<String, Map<String, Integer>> tuple = SeatUtils.wrapperFormula(entryEntity);
        String formula = (String)tuple.item1;
        logger.info("expr----->" + formula);
        Map colLabelIndex = (Map)tuple.item2;
        try {
            Serializable[] values = (Serializable[])colLabelIndex.keySet().stream().map(key -> (Serializable)result.get(key.toLowerCase())).toArray(Serializable[]::new);
            returnData = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"IExprService", (String)"execute", (Object[])new Object[]{formula, colLabelIndex, values});
        }
        catch (Exception e) {
            String returnData2 = "-1";
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8bed\u6cd5\u6811\u6267\u884c\u5931\u8d25: %s", (String)"SeatUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return returnData;
    }

    public static boolean executeCondition(DynamicObjectCollection entryEntity) {
        Tuple<String, Map<String, Integer>> tuple = SeatUtils.wrapperFormula(entryEntity);
        String formula = (String)tuple.item1;
        try {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"IExprService", (String)"isWellFormatted", (Object[])new Object[]{formula});
        }
        catch (Exception e) {
            logger.error("\u516c\u5f0f\u914d\u7f6e\u6709\u8bef: " + e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u6709\u8bef\uff1a%s", (String)"SeatUtils_3", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private static Tuple<String, Map<String, Integer>> wrapperFormula(DynamicObjectCollection entryEntity) {
        HashMap<String, Integer> colLabelIndex = new HashMap<String, Integer>(16);
        StringBuilder formula = new StringBuilder("if");
        for (DynamicObject dynamicObject : entryEntity) {
            String logicalSymbol;
            String key = dynamicObject.getString("condition_field").toUpperCase();
            colLabelIndex.putIfAbsent(key, colLabelIndex.size());
            String leftBracket = dynamicObject.getString("left_bracket");
            formula.append(' ');
            if (StringUtils.isNotBlank((CharSequence)leftBracket)) {
                formula.append(leftBracket);
            }
            formula.append('@').append(key).append(' ');
            String comparisonOperator = comparisonOperatorMap.get(dynamicObject.getString("compare_type"));
            formula.append(comparisonOperator).append(' ');
            String value = dynamicObject.getString("fixed_value");
            if (StringUtils.contains((CharSequence)comparisonOperator, (CharSequence)"in")) {
                if (StringUtils.contains((CharSequence)value, (CharSequence)",")) {
                    String[] split;
                    for (String str : split = value.split(",")) {
                        formula.append('\'').append(str).append('\'').append(',');
                    }
                    formula.replace(formula.lastIndexOf(","), formula.length(), "");
                } else {
                    formula.append('[').append('\'').append(value).append('\'').append(']');
                }
            } else {
                formula.append('\'').append(value).append('\'');
            }
            String rightBracket = dynamicObject.getString("right_bracket");
            if (StringUtils.isNotBlank((CharSequence)rightBracket)) {
                formula.append(rightBracket);
            }
            if (StringUtils.isBlank((CharSequence)(logicalSymbol = dynamicObject.getString("logical_symbol"))) || StringUtils.equals((CharSequence)"EMPTY", (CharSequence)logicalSymbol)) continue;
            formula.append(' ').append(logicalSymbol);
        }
        if (formula.indexOf("(") == -1 && formula.indexOf(")") == -1) {
            formula.insert(3, '(').append(')');
        }
        formula.append(" return '1'; ").append("else return '0';");
        return Tuple.create((Object)formula.toString(), colLabelIndex);
    }

    static {
        comparisonOperatorMap.put("equals", "=");
        comparisonOperatorMap.put("not_equals", "<>");
        comparisonOperatorMap.put("large_than", ">");
        comparisonOperatorMap.put("less_than", "<");
        comparisonOperatorMap.put("large_equals", ">=");
        comparisonOperatorMap.put("less_equals", "<=");
        comparisonOperatorMap.put("in", "in");
        comparisonOperatorMap.put("not_in", "not in");
    }
}

