/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.phm.common.bizmodel.Column;
import kd.mmc.phm.common.bizmodel.DetailTable;
import kd.mmc.phm.common.util.DesignerUtils;

public class TableUtils {
    private static final Log log = LogFactory.getLog(TableUtils.class);
    private static final String DATE_TYPE = "TIMESTAMP";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private TableUtils() {
        throw new RuntimeException("not supported");
    }

    public static DetailTable initDetailTable(int pageSize, JSONObject result, Tuple<Map<String, String>, Set<String>> detailConfiguration) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        Map fieldNames = (Map)detailConfiguration.item1;
        Set relationFields = (Set)detailConfiguration.item2;
        List<Column> cols = fieldNames.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            Column column = new Column((String)entry.getValue(), key);
            column.setLink(relationFields.contains(key));
            return column;
        }).collect(Collectors.toList());
        if (Objects.nonNull(result)) {
            log.info("TableUtils-> fieldNames: {}", (Object)fieldNames);
            JSONObject alias2Name = result.getJSONObject("alias2Name");
            JSONObject colTypeObj = result.getJSONObject("colTypes");
            HashMap colTypes = new HashMap(16);
            for (Map.Entry entry2 : colTypeObj.entrySet()) {
                String key = ((String)entry2.getKey()).toUpperCase();
                String fieldName = alias2Name.getString(key);
                if (fieldName == null) {
                    fieldName = key;
                }
                colTypes.put(fieldName, entry2.getValue());
            }
            log.info("TableUtils-> colTypes: {}", colTypes);
            Object[] colLabels = (String[])result.getJSONArray("sortedColLabels").stream().map(s -> s.toString().toUpperCase()).toArray(String[]::new);
            log.info("TableUtils-> colLabels: {}", (Object)Arrays.toString(colLabels));
            HashMap<String, Integer> seqMap = DesignerUtils.newHashMapWithExpectedSize(colLabels.length);
            int length = colLabels.length;
            for (int i = 0; i < length; ++i) {
                String colLabel = ((String)colLabels[i]).toUpperCase();
                String fieldName = alias2Name.getString(colLabel);
                if (fieldName == null) {
                    fieldName = colLabel;
                }
                seqMap.put(fieldName, i);
            }
            log.info("TableUtils-> seqMap: {}", seqMap);
            JSONObject rowResult = result.getJSONObject("datas");
            JSONArray rowDatas = rowResult.getJSONArray("rows");
            int size = rowDatas.size();
            for (int i = 0; i < size; ++i) {
                JSONArray rowData = rowDatas.getJSONArray(i);
                LinkedHashMap<String, Object> row = DesignerUtils.newLinkedHashMapWithExpectedSize(fieldNames.size());
                for (Map.Entry entry3 : fieldNames.entrySet()) {
                    Timestamp timestamp;
                    String name = (String)entry3.getKey();
                    name = name.toUpperCase();
                    String colType = (String)colTypes.get(name);
                    int index = (Integer)seqMap.get(name);
                    Object value = StringUtils.equals((CharSequence)DATE_TYPE, (CharSequence)colType) ? (Objects.nonNull(timestamp = (Timestamp)rowData.getTimestamp(index)) ? THREAD_LOCAL.get().format(new Date(timestamp.getTime())) : " ") : rowData.get(index);
                    if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                    }
                    row.put(name, value);
                }
                rows.add(row);
            }
        }
        DetailTable detailTable = new DetailTable(1, pageSize, rows);
        detailTable.setCols(cols);
        return detailTable;
    }

    public static DetailTable orderPageBean(DetailTable detailTable, String orderBy, int sortType) {
        String sortStyle = TableUtils.getSortStyle(sortType);
        List<Map<String, Object>> rows = detailTable.getRows();
        rows.sort((o1, o2) -> {
            Object value = o1.get(orderBy);
            Object value2 = o1.get(orderBy);
            if (value instanceof Number) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"asc", (CharSequence)sortStyle)) {
                    return new BigDecimal(String.valueOf(o1.get(orderBy))).compareTo(new BigDecimal(String.valueOf(o2.get(orderBy))));
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"desc", (CharSequence)sortStyle)) {
                    return new BigDecimal(String.valueOf(o2.get(orderBy))).compareTo(new BigDecimal(String.valueOf(o1.get(orderBy))));
                }
                return 0;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"asc", (CharSequence)sortStyle)) {
                return String.valueOf(o1.get(orderBy)).compareTo(String.valueOf(o2.get(orderBy)));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"desc", (CharSequence)sortStyle)) {
                return String.valueOf(o2.get(orderBy)).compareTo(String.valueOf(o1.get(orderBy)));
            }
            return 0;
        });
        return detailTable;
    }

    private static String getSortStyle(int sortType) {
        if (sortType == 1) {
            return "asc";
        }
        return sortType == 2 ? "desc" : null;
    }
}

