/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.util.CodeRuleInfoBuilder;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.basemanager.ScheduleConsts;
import kd.mmc.phm.common.basemanager.WeekEnum;
import kd.mmc.phm.common.enums.RepeatMode;
import kd.mmc.phm.common.util.CronTriggerUtils;

public final class VersionRuleUtils {
    private static final Log log = LogFactory.getLog((String)"VersionRuleUtils");
    private static final String ENTITY_VERSION = "phm_versionrule";
    private static final String ENTITY_CODERULE = "bos_coderule";
    private static final String EMPTY = "EMPTY";
    private static final String BIZOBJECTID = "bizobjectid";
    private static final String NOT_FIND = "notFind";

    private static Map<String, Object> getConstsValues(DynamicObjectCollection versionRuleEntryColl) {
        Map<String, String> constsValues = null;
        for (DynamicObject dynamicObject : versionRuleEntryColl) {
            if (!dynamicObject.getBoolean("isperiodconsts")) continue;
            constsValues = (Map)SerializationUtils.fromJsonString((String)dynamicObject.getString("constsjson"), Map.class);
            break;
        }
        if (CollectionUtils.isEmpty(constsValues)) {
            constsValues = new HashMap<String, String>(2);
            constsValues.put("", "");
        }
        return constsValues;
    }

    private static DynamicObject[] createCodeRule(DynamicObject versionRule, String prefix) {
        DynamicObjectCollection versionRuleEntryColl = versionRule.getDynamicObjectCollection("entryentity");
        Map<String, Object> constsValues = VersionRuleUtils.getConstsValues(versionRuleEntryColl);
        return VersionRuleUtils.createCodeRuleByPeriodConsts(versionRule, prefix, versionRuleEntryColl, constsValues, Collections.emptyMap());
    }

    private static DynamicObject[] createCodeRuleByPeriodConsts(DynamicObject versionRule, String prefix, DynamicObjectCollection versionRuleEntryColl, Map<String, Object> constsValues, Map<String, DynamicObject> existCodeRules) {
        int size = constsValues.size();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_CODERULE);
        String[] ids = ID.genStringIds((int)size);
        int count = 0;
        String defaultSeparator = versionRule.getString("default_separators");
        long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        Date createTime = versionRule.getDate("modifytime");
        DynamicObject[] codeRuleArray = new DynamicObject[size];
        for (Map.Entry<String, Object> entry : constsValues.entrySet()) {
            String id = ids[count];
            DynamicObject codeRule = new DynamicObject((DynamicObjectType)dt);
            codeRule.set("id", (Object)id);
            String key = prefix + entry.getKey();
            DynamicObject existCodeRule = existCodeRules.get(key);
            int oldStep = -1;
            if (existCodeRule != null) {
                DynamicObjectCollection ruleEntry = existCodeRule.getDynamicObjectCollection("ruleentry");
                for (DynamicObject dynamicObject : ruleEntry) {
                    if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(dynamicObject.getString("attributetype"))) continue;
                    oldStep = dynamicObject.getInt("step");
                    break;
                }
            }
            codeRule.set("number", (Object)key);
            if (key.length() > 50) {
                key = key.substring(0, 50);
            }
            codeRule.set("name", (Object)key);
            codeRule.set("status", (Object)StatusEnum.AUDIT.getValue());
            codeRule.set("enable", (Object)EnableEnum.ENABLE.getValue());
            codeRule.set("creator", (Object)currentUserId);
            codeRule.set("createtime", (Object)createTime);
            codeRule.set(BIZOBJECTID, (Object)ENTITY_VERSION);
            codeRule.set("splitsign", (Object)defaultSeparator);
            codeRule.set("isaddview", (Object)Character.valueOf('0'));
            codeRule.set("ismodifiable", (Object)Character.valueOf('0'));
            codeRule.set("isunique", (Object)Character.valueOf('0'));
            codeRule.set("masterid", (Object)id);
            codeRule.set("isnonbreak", (Object)Character.valueOf('0'));
            DynamicObjectCollection ruleEntryColl = codeRule.getDynamicObjectCollection("ruleentry");
            int versionRuleEntryCollSize = versionRuleEntryColl.size();
            for (int i = 0; i < versionRuleEntryCollSize; ++i) {
                DynamicObject versionEntry = (DynamicObject)versionRuleEntryColl.get(i);
                DynamicObject codeRuleEntry = ruleEntryColl.addNew();
                String codeType = versionEntry.getString("codetype");
                codeRuleEntry.set("attributetype", (Object)codeType);
                if (i != 0) {
                    String separators = versionEntry.getString("separators");
                    if (EMPTY.equals(separators)) {
                        codeRuleEntry.set("issplitsign", (Object)Character.valueOf('0'));
                        codeRuleEntry.set("splitsignentry", null);
                    } else {
                        codeRuleEntry.set("issplitsign", (Object)Character.valueOf('1'));
                        codeRuleEntry.set("splitsignentry", (Object)separators);
                    }
                }
                if (CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr().equals(codeType)) {
                    if (versionEntry.getBoolean("isperiodconsts")) {
                        Map currConstsValues = (Map)SerializationUtils.fromJsonString((String)versionEntry.getString("constsjson"), Map.class);
                        int index = 0;
                        for (Map.Entry currConstsValueEntry : currConstsValues.entrySet()) {
                            if (count != index++) continue;
                            codeRuleEntry.set("format", (Object)String.valueOf(currConstsValueEntry.getValue()));
                            break;
                        }
                    } else {
                        codeRuleEntry.set("format", (Object)versionEntry.getString("constantvalue"));
                    }
                } else if (CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(codeType)) {
                    codeRuleEntry.set("length", versionEntry.get("length"));
                    codeRuleEntry.set("step", versionEntry.get("step"));
                    codeRuleEntry.set("initial", versionEntry.get("initialvalue"));
                    int step = versionEntry.getInt("step");
                    if (existCodeRule != null) {
                        DynamicObject[] objs;
                        QFilter filter = new QFilter("coderuleid", "=", existCodeRule.getPkValue());
                        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)"coderuleid, sortitemvalue", (QFilter[])new QFilter[]{filter})) {
                            obj.set("coderuleid", (Object)id);
                        }
                        SaveServiceHelper.update((DynamicObject[])objs);
                        if (oldStep != -1 && oldStep != step) {
                            VersionRuleUtils.updateStepForSortItems(objs, step, id);
                        }
                    }
                } else if (CodeRuleEntryTypeEnum.TYPE_SYSTEM_TIME_FIELD.getTypeStr().equals(codeType)) {
                    codeRuleEntry.set("format", (Object)versionEntry.getString("dateformat"));
                }
                codeRuleEntry.set("attusingmode", (Object)"1");
                codeRuleEntry.set("addstyle", (Object)"1");
                codeRuleEntry.set("cutstyle", (Object)"1");
                codeRuleEntry.set("issortitem", (Object)Character.valueOf('0'));
                codeRuleEntry.set("isvisable", (Object)Character.valueOf('1'));
            }
            codeRuleArray[count++] = codeRule;
        }
        SaveServiceHelper.save((DynamicObject[])codeRuleArray);
        return codeRuleArray;
    }

    private static void updateStepForSortItems(DynamicObject[] objs, int step, String id) {
        for (DynamicObject obj : objs) {
            String sortitemvalue = obj.getString("sortitemvalue");
            CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance((String)id);
            codeRuleSigner.updateStep(id, sortitemvalue, step);
        }
    }

    public static Tuple<Date, Date> computePeriod(DynamicObject versionRule) {
        String cronExpression = versionRule.getString("plan");
        Date startTime = versionRule.getDate("validated_time");
        int cycleNum = versionRule.getInt("cyclenum");
        String repeatModeStr = versionRule.getString("repeatmode");
        RepeatMode repeatMode = RepeatMode.forValue(repeatModeStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        switch (repeatMode) {
            case DAY: {
                calendar.add(5, cycleNum * -1);
                break;
            }
            case WEEK: {
                calendar.add(5, -7);
                break;
            }
            case MONTH: {
                calendar.add(2, cycleNum * -1);
                break;
            }
            case YEAR: {
                calendar.add(1, -1);
                break;
            }
        }
        Tuple<Date, Date> tuple = CronTriggerUtils.computePeriod(cronExpression, calendar.getTime(), new Date(), null);
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u5468\u671f\u8ba1\u7b97-->repeatModeStr: {},  startTime:{}, cycleNum: {}, realStartTime: {}, previousTime: {}, nextTime: {}", new Object[]{repeatModeStr, startTime, cycleNum, calendar.getTime(), tuple.item1, tuple.item2});
        }
        return tuple;
    }

    public static String getNumber(DynamicObject versionRule) {
        Tuple<Date, Date> tuple = VersionRuleUtils.computePeriod(versionRule);
        Date previousTime = (Date)tuple.item1;
        Date nextTime = (Date)tuple.item2;
        return VersionRuleUtils.getNumber(versionRule, previousTime, nextTime);
    }

    public static String getNumber(DynamicObject versionRule, Date previousTime, Date nextTime) {
        CodeRuleInfo codeRuleInfo;
        QFilter[] filters;
        Map codeRuleMap;
        DynamicObject[] codeRules;
        String prefix = "phm_" + versionRule.getPkValue() + "_";
        String versionRuleNumber = versionRule.getString("number");
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u83b7\u53d6\u7248\u672c\u89c4\u5219\u7f16\u7801--> previousTime\uff1a{}\uff0c nextTime\uff1a{}\uff0c prefixNumber\uff1a{}", new Object[]{previousTime, nextTime, prefix});
        }
        if ((codeRules = CollectionUtils.isEmpty((Map)(codeRuleMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_CODERULE, (QFilter[])(filters = new QFilter[]{new QFilter(BIZOBJECTID, "=", (Object)ENTITY_VERSION), new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()), new QFilter("number", "like", (Object)(prefix + "%"))})))) ? VersionRuleUtils.createCodeRule(versionRule, prefix) : VersionRuleUtils.updateCodeRule(versionRule, prefix, codeRuleMap)).length == 0) {
            if (log.isInfoEnabled()) {
                log.info("[VersionRuleUtils] \u83b7\u53d6\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a, versionRuleNumber\uff1a{}", (Object)versionRuleNumber);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VersionRuleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        if (codeRules.length == 1) {
            if (log.isInfoEnabled()) {
                log.info("[VersionRuleUtils] \u957f\u5ea6\u4e3a1, \u76f4\u63a5\u83b7\u53d6\u7f16\u7801\u89c4\u5219, versionRuleNumber\uff1a{}", (Object)versionRuleNumber);
            }
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)CodeRuleInfoBuilder.buildCodeRuleInfo((DynamicObject)codeRules[0]), (DynamicObject)versionRule);
        }
        String currentPeriod = VersionRuleUtils.getCurrentPeriod(versionRule, previousTime, nextTime);
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u5f53\u524d\u5468\u671f\u5e38\u91cf--> currentPeriod\uff1a{}, versionRuleNumber\uff1a{}", (Object)currentPeriod, (Object)versionRuleNumber);
        }
        if (StringUtils.isBlank((CharSequence)currentPeriod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VersionRuleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        String currentCodeNumber = null;
        if (NOT_FIND.equals(currentPeriod)) {
            DynamicObjectCollection versionRuleEntryColl = versionRule.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : versionRuleEntryColl) {
                if (!dynamicObject.getBoolean("isperiodconsts")) continue;
                Map constsValues = (Map)SerializationUtils.fromJsonString((String)dynamicObject.getString("constsjson"), Map.class);
                int count = 0;
                int size = constsValues.size();
                for (String key : constsValues.keySet()) {
                    if (++count != size) continue;
                    currentCodeNumber = prefix + key;
                }
            }
            if (StringUtils.isBlank((CharSequence)currentCodeNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VersionRuleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
            }
        } else {
            currentCodeNumber = prefix + currentPeriod;
        }
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u5f53\u524d\u5468\u671f\u5e38\u91cf--> currentCodeNumber\uff1a{}, versionRuleNumber\uff1a{}", (Object)currentCodeNumber, (Object)versionRuleNumber);
        }
        if ((codeRuleInfo = VersionRuleUtils.getCodeRuleByNumber(currentCodeNumber)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VersionRuleUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)versionRule);
    }

    private static DynamicObject[] updateCodeRule(DynamicObject versionRule, String prefix, Map<Object, DynamicObject> codeRuleMap) {
        boolean modified = false;
        Date modifyTime = versionRule.getDate("modifytime");
        int count = 0;
        for (Map.Entry<Object, DynamicObject> entry : codeRuleMap.entrySet()) {
            if (count++ != 0) continue;
            Date createTime = entry.getValue().getDate("createtime");
            modified = modifyTime.compareTo(createTime) != 0;
        }
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u662f\u5426\u9700\u8981\u4fee\u6539\u7f16\u7801\u89c4\u5219--> modified\uff1a{}", (Object)modified);
        }
        if (modified) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_CODERULE), (Object[])codeRuleMap.keySet().toArray());
            DynamicObjectCollection versionRuleEntryColl = versionRule.getDynamicObjectCollection("entryentity");
            Map<String, Object> constsValues = VersionRuleUtils.getConstsValues(versionRuleEntryColl);
            HashMap number2DynamicObject = Maps.newHashMapWithExpectedSize((int)codeRuleMap.size());
            for (Map.Entry<Object, DynamicObject> entry : codeRuleMap.entrySet()) {
                DynamicObject value = entry.getValue();
                number2DynamicObject.put(value.getString("number"), value);
            }
            return VersionRuleUtils.createCodeRuleByPeriodConsts(versionRule, prefix, versionRuleEntryColl, constsValues, number2DynamicObject);
        }
        return codeRuleMap.values().toArray(new DynamicObject[0]);
    }

    private static CodeRuleInfo getCodeRuleByNumber(String number) {
        String selectFields = "id, splitsign, appmode, isupdaterecover,orgentry.id, orgentry.orgid, isaddview, ismodifiable, isnonbreak, isunique, isfast, orgentry.isincludesuborg, conditionentry.id, conditionentry.property, conditionentry.propertyvalue, ruleentry.id, ruleentry.seq,ruleentry.attributeType,ruleentry.valueAtribute,ruleentry.attusingmode,ruleentry.length,ruleentry.cutstyle,ruleentry.format,ruleentry.addchar,ruleentry.addstyle,ruleentry.initial,ruleentry.step,ruleentry.isSortItem,ruleentry.issplit,sign,ruleentry.issplitsign,ruleentry.splitsignentry,ruleentry.isvisable,name,filtercondition";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter(BIZOBJECTID, "=", (Object)ENTITY_VERSION), new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue())};
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((String)ENTITY_CODERULE, (String)selectFields, (QFilter[])filters);
        if (codeRule == null) {
            return null;
        }
        return CodeRuleInfoBuilder.buildCodeRuleInfo((DynamicObject)codeRule);
    }

    private static String getCurrentPeriod(DynamicObject versionRule, Date previouseTime, Date nextTime) {
        String period;
        String versionRuleNumber = versionRule.getString("number");
        if (previouseTime == null) {
            return NOT_FIND;
        }
        String cronExpression = versionRule.getString("plan");
        String[] crons = cronExpression.split(" ");
        String weekCron = crons[5];
        boolean isMonth = StringUtils.equals((CharSequence)"?", (CharSequence)weekCron);
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u83b7\u53d6\u5f53\u524d\u65e5\u671f\u6240\u5728\u5468\u671f\u5e38\u91cf--> cronExpression: {}, isMonth\uff1a{}, versionRuleNumber\uff1a{}", new Object[]{cronExpression, isMonth, versionRuleNumber});
        }
        if (isMonth) {
            String dayCron = crons[3];
            boolean isLastDay = StringUtils.equals((CharSequence)"L", (CharSequence)dayCron);
            period = VersionRuleUtils.computeMonthPeriod(versionRule, previouseTime, nextTime, isLastDay);
        } else {
            period = VersionRuleUtils.computeWeekPeriod(previouseTime, nextTime);
        }
        return period;
    }

    private static String computeMonthPeriod(DynamicObject versionRule, Date previouseTime, Date nextTime, boolean isLastDay) {
        boolean needDayStr;
        String versionRuleNumber = versionRule.getString("number");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(previouseTime);
        int previousDay = isLastDay ? -1 : calendar.get(5);
        int previousHour = calendar.get(11);
        calendar.setTime(nextTime);
        int nextDay = isLastDay ? -1 : calendar.get(5);
        int nextHour = calendar.get(11);
        boolean checkedDay = VersionRuleUtils.isCheckedDay(versionRule);
        boolean bl = needDayStr = isLastDay || checkedDay;
        if (log.isInfoEnabled()) {
            log.info("[VersionRuleUtils] \u8ba1\u7b97\u6708\u7684\u5468\u671f\u5e38\u91cf--> checkedDay: {}, isLastDay\uff1a{}, versionRuleNumber\uff1a{}", new Object[]{checkedDay, isLastDay, versionRuleNumber});
        }
        if (needDayStr) {
            return VersionRuleUtils.convertDayStr(previousDay) + VersionRuleUtils.convertHourStr(previousHour) + "-" + VersionRuleUtils.convertDayStr(nextDay) + VersionRuleUtils.convertHourStr(nextHour);
        }
        return VersionRuleUtils.convertHourStr(previousHour) + "-" + VersionRuleUtils.convertHourStr(nextHour);
    }

    private static String computeWeekPeriod(Date previouseTime, Date nextTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(previouseTime);
        int previousWeek = calendar.get(7);
        int previousHour = calendar.get(11);
        calendar.setTime(nextTime);
        int nextWeek = calendar.get(7);
        int nextHour = calendar.get(11);
        return VersionRuleUtils.convertDayOfWeekStr(previousWeek) + VersionRuleUtils.convertHourStr(previousHour) + "-" + VersionRuleUtils.convertDayOfWeekStr(nextWeek) + VersionRuleUtils.convertHourStr(nextHour);
    }

    private static boolean isCheckedDay(DynamicObject versionRule) {
        boolean addDay = false;
        for (int i = 0; i < ScheduleConsts.CKDATE.size(); ++i) {
            if (!versionRule.getBoolean(ScheduleConsts.CKDATE.get(i))) continue;
            addDay = true;
            break;
        }
        return addDay;
    }

    private static String convertDayOfWeekStr(int num) {
        return WeekEnum.forValue(num).getName();
    }

    private static String convertDayStr(int num) {
        if (num <= 0) {
            return ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"VersionRuleUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]);
        }
        return num < 10 ? "0" + num + ResManager.loadKDString((String)"\u65e5", (String)"VersionRuleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0]) : num + ResManager.loadKDString((String)"\u65e5", (String)"VersionRuleUtils_2", (String)"mmc-phm-common", (Object[])new Object[0]);
    }

    private static String convertHourStr(int num) {
        if (num < 0) {
            num = 23;
        }
        return num < 10 ? "0" + num + ResManager.loadKDString((String)"\u65f6", (String)"VersionRuleUtils_3", (String)"mmc-phm-common", (Object[])new Object[0]) : num + ResManager.loadKDString((String)"\u65f6", (String)"VersionRuleUtils_3", (String)"mmc-phm-common", (Object[])new Object[0]);
    }
}

