/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.basedata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.consts.CommonConsts;

public class RoleUtils {
    private static final String ALGO_KEY = "RoleUtils.";
    private static final String PHM_ROLE_USER = "phm_role_user";
    private static final String USER = "user";
    private static final String ROLEID = "roleid";

    public static List<Long> listRoleByUser(long userId) {
        QFilter[] filters = new QFilter[]{new QFilter(USER, "=", (Object)userId)};
        try (DataSet dataSet = ORM.create().queryDataSet("RoleUtils.listRoleByCurrentUser", PHM_ROLE_USER, USER, filters);){
            if (dataSet.hasNext()) {
                ArrayList<Long> userIds = new ArrayList<Long>();
                for (Row row : dataSet) {
                    userIds.add(row.getLong(0));
                }
                ArrayList<Long> arrayList = userIds;
                return arrayList;
            }
            List<Long> list = Collections.emptyList();
            return list;
        }
    }

    public static List<Long> getAllUserByRole(long roleId) {
        QFilter[] filters = new QFilter[]{new QFilter(ROLEID, "=", (Object)roleId)};
        try (DataSet dataSet = ORM.create().queryDataSet("RoleUtils.listRoleByCurrentUser", PHM_ROLE_USER, USER, filters);){
            if (dataSet.hasNext()) {
                ArrayList<Long> roleIds = new ArrayList<Long>();
                for (Row row : dataSet) {
                    roleIds.add(row.getLong(0));
                }
                ArrayList<Long> arrayList = roleIds;
                return arrayList;
            }
            List<Long> list = Collections.emptyList();
            return list;
        }
    }

    public static Long queryFirstRoleByUser(long userId, Long process, String nodeId, Long resourceId) {
        String sql = "select fid from t_phm_role where fid in (select fid from t_phm_roleuserentry where fuser = ? ) and fid in (select fbasedataid from t_phm_resourecrole where fdetailid in (select fdetailid from t_phm_flowresource where fresourceid = ? and fentryid in (select fentryid from t_phm_flownode where fid = ? and fnodeid =?)))order by fmodifytime desc ";
        try (DataSet dataSet = DB.queryDataSet((String)"phm_queryFirstRoleByUser", (DBRoute)CommonConsts.ROUTE_PHM, (String)sql, (Object[])new Object[]{userId, resourceId, process, nodeId});){
            if (dataSet.hasNext()) {
                Long l = dataSet.next().getLong(0);
                return l;
            }
            Long l = 0L;
            return l;
        }
    }

    public static List<Long> listRoleByResource(long resourceId) {
        QFilter[] filters = new QFilter[]{new QFilter("entryentity2.resources", "=", (Object)resourceId)};
        try (DataSet dataSet = ORM.create().queryDataSet("RoleUtils.listRoleByResource", "phm_role", "id", filters);){
            if (dataSet.hasNext()) {
                ArrayList<Long> roleIds = new ArrayList<Long>();
                for (Row row : dataSet) {
                    roleIds.add(row.getLong(0));
                }
                ArrayList<Long> arrayList = roleIds;
                return arrayList;
            }
            List<Long> list = Collections.emptyList();
            return list;
        }
    }

    public static boolean checkRole(long userId, long roleId) {
        List<Long> roleIds = RoleUtils.listRoleByUser(userId);
        return roleIds.contains(roleId);
    }
}

