/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.datatemp;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.spread.model.CellArea;
import kd.mmc.phm.common.util.datatemp.FormulaParseUtils;
import kd.mmc.phm.common.util.datatemp.FormulaValiditionUtils;
import kd.mmc.phm.common.util.datatemp.TempDataHandleUtils;
import org.apache.commons.lang3.StringUtils;

public class FixTempConfigParse {
    private static final Log logger = LogFactory.getLog(FixTempConfigParse.class);
    private static final Set<String> OPERATION_LIST = Sets.newHashSet((Object[])new String[]{"(", ")", "min", "max", "avg", "sum", ",", "+", "-", "*", "/"});
    private static final String PARAM_PRE = "param_";
    private static ThreadPool fixTempConfigParsePool = ThreadPools.newFixedThreadPool((String)"FixTempConfigParsePool", (int)4);
    private static final String ENTITY_HISTORY = "phm_filldata_history";

    public static List<Cell> getDataByCellConfId(Long cellConfId, Long procesHistoryId, Long nodeEntryId, Long orgId) {
        QFilter qFilter;
        logger.info("\u56fa\u5b9a\u6a21\u677f\u67e5\u8be2\u6570\u636e\u914d\u7f6eid:".concat(Long.toString(cellConfId)));
        long startTime = System.currentTimeMillis();
        DynamicObject cellset = BusinessDataServiceHelper.loadSingle((Object)cellConfId, (String)"phm_fixtpl_cellset");
        DynamicObjectCollection cellsetEntryEntity = cellset.getDynamicObjectCollection("cellentryentity");
        if (CollectionUtils.isEmpty((Collection)cellsetEntryEntity)) {
            logger.info("\u56fa\u5b9a\u6a21\u677f\u67e5\u8be2\u6570\u636e:\u65e0\u5355\u5143\u683c\u914d\u7f6e");
            return null;
        }
        ArrayList<Cell> returnData = new ArrayList<Cell>(cellsetEntryEntity.size());
        HashSet<Long> tplIds = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : cellsetEntryEntity) {
            DynamicObjectCollection datatemps = dynamicObject.getDynamicObjectCollection("datatemps");
            for (DynamicObject datatemp : datatemps) {
                tplIds.add(datatemp.getLong("fbasedataid_id"));
            }
        }
        QFilter[] idFilters = new QFilter[]{new QFilter("id", "in", tplIds)};
        DynamicObject[] sourceBillTemps = BusinessDataServiceHelper.load((String)"phm_billtemp", (String)"id,versionrule,number", (QFilter[])idFilters);
        if (sourceBillTemps == null || sourceBillTemps.length == 0 || sourceBillTemps.length != tplIds.size()) {
            logger.info("\u56fa\u5b9a\u6a21\u677f\u67e5\u8be2\u6570\u636e\uff1a\u6709\u6765\u6e90\u6a21\u677f\u4e0d\u5b58\u5728");
            return returnData;
        }
        if (procesHistoryId != null && procesHistoryId != 0L) {
            List<Object> collect = tplIds.stream().map(x -> x).collect(Collectors.toList());
            qFilter = TempDataHandleUtils.getQFilterByTempsAndProcess(collect, procesHistoryId, nodeEntryId, orgId);
        } else {
            qFilter = TempDataHandleUtils.getQFilterByTemps(sourceBillTemps);
        }
        final DynamicObjectCollection dataTemps = QueryServiceHelper.query((String)ENTITY_HISTORY, (String)"template,spreadjson_tag", (QFilter[])qFilter.toArray());
        ArrayList<Future> futureList = new ArrayList<Future>(cellsetEntryEntity.size());
        for (final DynamicObject cellsetDynamicObject : cellsetEntryEntity) {
            Future submit = fixTempConfigParsePool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String formula = cellsetDynamicObject.getString("formula");
                    logger.info("\u56fa\u5b9a\u6a21\u677f\u67e5\u8be2\u5355\u5143\u683c\u914d\u7f6e:".concat(formula));
                    if (StringUtils.isBlank((CharSequence)formula)) {
                        return null;
                    }
                    List<Long> sourceTplIds = cellsetDynamicObject.getDynamicObjectCollection("datatemps").stream().map(x -> x.getLong("fbasedataid_id")).distinct().collect(Collectors.toList());
                    List spreadjsonTags = dataTemps.stream().filter(x -> sourceTplIds.contains(x.getLong("template"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(spreadjsonTags)) {
                        return null;
                    }
                    HashMap<Long, List<Map<String, Object>>> tempToTempRowDataMap = new HashMap<Long, List<Map<String, Object>>>(sourceTplIds.size());
                    for (DynamicObject dataTemp : spreadjsonTags) {
                        long templateId = dataTemp.getLong("template");
                        if (!sourceTplIds.contains(templateId)) continue;
                        List tempDatas = tempToTempRowDataMap.getOrDefault(templateId, new ArrayList(8));
                        Map<String, Object> dataMap = TempDataHandleUtils.getRowMap(dataTemp.getString("spreadjson_tag"));
                        tempDatas.add(dataMap);
                        tempToTempRowDataMap.put(templateId, tempDatas);
                    }
                    Object resultObject = FixTempConfigParse.paraseAndCalculate(formula, tempToTempRowDataMap, cellsetDynamicObject, sourceTplIds);
                    Cell cell = new Cell(cellsetDynamicObject.getInt("cellrow"), cellsetDynamicObject.getInt("cellcol"), resultObject);
                    return cell;
                }
            });
            futureList.add(submit);
        }
        for (Future objectFuture : futureList) {
            try {
                if (objectFuture.get() == null) continue;
                returnData.add((Cell)objectFuture.get());
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("FIX_RESOLVE_DATAS_EXC", ResManager.loadKDString((String)"\u52a0\u8f7d\u56fa\u5b9a\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FixTempConfigParse_0", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            catch (ExecutionException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("FIX_RESOLVE_DATAS_EXC", ResManager.loadKDString((String)"\u52a0\u8f7d\u56fa\u5b9a\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FixTempConfigParse_0", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u56fa\u5b9a\u6a21\u677f\u67e5\u8be2\u6570\u636e\u5b8c\u6bd5\uff1a\u8017\u65f6" + (endTime - startTime) + "\u6beb\u79d2");
        return returnData;
    }

    public static Object paraseAndCalculate(String formula, Map<Long, List<Map<String, Object>>> tempToTempRowDataMap, DynamicObject cellsetDynamicObject, List<Long> sourceTplIds) {
        int[] formulaIndexs = FormulaParseUtils.formulaParase(formula, 0, formula.length());
        logger.info("\u56fa\u5b9a\u6a21\u677f\u516c\u5f0f:".concat(formula).concat("\u5207\u5272\u7d22\u5f15\uff1a").concat(JSON.toJSONString((Object)formulaIndexs)));
        String formulaContent = formula.substring(formulaIndexs[0], formulaIndexs[1]);
        String[] cellStrings = FormulaEngine.extractVariables((String)formulaContent);
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        List<Map<String, Object>> rowMapList = new ArrayList<Map<String, Object>>(8);
        String tempId = Long.toString(sourceTplIds.get(0));
        if (sourceTplIds.size() == 1) {
            for (List list : tempToTempRowDataMap.values()) {
                rowMapList.addAll(list);
            }
        } else {
            for (Map.Entry entry : tempToTempRowDataMap.entrySet()) {
                tempId = Long.toString((Long)entry.getKey());
                if (!cellStrings[0].contains(tempId)) continue;
                rowMapList = (List)entry.getValue();
                break;
            }
        }
        for (int i = 0; i < cellStrings.length; ++i) {
            String string = cellStrings[i];
            cellStrings[i] = string.replace(tempId, "");
        }
        String formulaNoTempId = formulaContent.replaceAll(tempId, "");
        String string = FixTempConfigParse.getFormulaParam(rowMapList, formulaNoTempId, cellStrings, valueMap, cellsetDynamicObject.getString("cellposition"));
        logger.info("\u56fa\u5b9a\u6a21\u677f\u516c\u5f0f\u6267\u884c\uff0c\u8868\u8fbe\u5f0f:".concat(string).concat("\u53c2\u6570\uff1a").concat(JSON.toJSONString(valueMap)));
        Object resultObject = FormulaParseUtils.execFormula(string, valueMap);
        String replaceFormula = formula.replace(formulaContent, resultObject.toString());
        if (FormulaEngine.extractVariables((String)replaceFormula).length > 0) {
            return FixTempConfigParse.paraseAndCalculate(replaceFormula, tempToTempRowDataMap, cellsetDynamicObject, sourceTplIds);
        }
        if (valueMap.isEmpty()) {
            return BigDecimal.ZERO.setScale(0, 4);
        }
        try {
            return new BigDecimal(replaceFormula).setScale(cellsetDynamicObject.getInt("format"), 4).stripTrailingZeros();
        }
        catch (Exception e) {
            Object lastResultObject = FormulaParseUtils.execLastFormula(replaceFormula);
            return new BigDecimal(lastResultObject.toString()).setScale(cellsetDynamicObject.getInt("format"), 4).stripTrailingZeros();
        }
    }

    private static String getFormulaParam(List<Map<String, Object>> rowMapList, String formula, String[] cellStrings, Map<String, Object> valueMap, String cellposition) {
        if (CollectionUtils.isEmpty(rowMapList)) {
            for (String cellString : cellStrings) {
                formula = formula.replace(cellString, "0");
            }
        } else {
            int index = 0;
            Map<String, int[]> cellIndexMap = FormulaParseUtils.getCellIndexMap(cellStrings);
            String formulaContext = formula.substring(4, formula.length() - 1);
            ArrayList<String> formulaReplaceList = new ArrayList<String>(rowMapList.size());
            StringBuilder sb = new StringBuilder();
            for (Map<String, Object> stringObjectMap : rowMapList) {
                String formulaReplace = formulaContext;
                for (String cellStr : cellStrings) {
                    int[] cellIndex = cellIndexMap.get(cellStr);
                    Map colMap = (Map)stringObjectMap.get(Integer.toString(cellIndex[1]));
                    Map conditionMap = (Map)colMap.get(Integer.toString(cellIndex[0]));
                    if (conditionMap == null || conditionMap.get("value") == null || StringUtils.isBlank((CharSequence)conditionMap.get("value").toString())) {
                        valueMap.put(PARAM_PRE.concat(Integer.toString(index)), BigDecimal.ZERO);
                    } else {
                        try {
                            Object value = conditionMap.get("value");
                            valueMap.put(PARAM_PRE.concat(Integer.toString(index)), new BigDecimal(value.toString()));
                        }
                        catch (Exception e) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u5143\u683c\"", (String)"FixTempConfigParse_1", (String)"mmc-phm-common", (Object[])new Object[0]) + cellposition + ResManager.loadKDString((String)"\"\u7684\u6240\u6709\u7edf\u8ba1\u6570\u636e\u4e2d\u6709\u4e0d\u662f\u6570\u5b57\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"FixTempConfigParse_2", (String)"mmc-phm-common", (Object[])new Object[0]));
                        }
                    }
                    formulaReplace = formulaReplace.replace(cellStr, PARAM_PRE.concat(Integer.toString(index++)));
                }
                formulaReplaceList.add(formulaReplace);
            }
            String replaceString = "0";
            if (!CollectionUtils.isEmpty(formulaReplaceList)) {
                replaceString = StringUtils.join((Object[])formulaReplaceList.toArray(), (char)',');
            }
            formula = formula.replace(formulaContext, replaceString);
        }
        return formula;
    }

    public static String validitionFormat(String formula, Map<String, String> tempIdToNumberMap) {
        logger.info("\u516c\u5f0f\u6267\u884c\uff0c\u8868\u8fbe\u5f0f:".concat(formula).concat("\u6a21\u677fid\u4e0e\u7f16\u7801\u6620\u5c04\u5173\u7cfb\uff1a").concat(JSON.toJSONString(tempIdToNumberMap)));
        if (tempIdToNumberMap == null || tempIdToNumberMap.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u6a21\u677f\u4e3a\u7a7a", (String)"FixTempConfigParse_3", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        Map<String, CellArea> tempCellAreaMap = FixTempConfigParse.querySourceTempInfo(tempIdToNumberMap);
        ArrayList<String> formulaList = new ArrayList<String>();
        String tempIdFormula = formula;
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            for (Map.Entry<String, String> entry : tempIdToNumberMap.entrySet()) {
                tempIdFormula = tempIdFormula.replace(entry.getValue(), entry.getKey());
            }
            FormulaParseUtils.getFormulaList(tempIdFormula, formulaList, OPERATION_LIST, true);
        }
        String hiddenFormula = "";
        for (String value : formulaList) {
            String key = OPERATION_LIST.contains(value) ? value : (tempIdToNumberMap.containsKey(value) ? value : (FormulaValiditionUtils.isNumber(value) ? value : FixTempConfigParse.validitionFuncContent(tempIdToNumberMap, value, tempCellAreaMap)));
            hiddenFormula = hiddenFormula.concat(key);
        }
        try {
            FormulaEngine.extractVariables((String)hiddenFormula);
        }
        catch (FormulaException formulaException) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"FixTempConfigParse_4", (String)"mmc-phm-common", (Object[])new Object[0]) + (formulaException.getCause() == null ? formulaException.getMessage() : formulaException.getCause().getMessage()));
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"FixTempConfigParse_4", (String)"mmc-phm-common", (Object[])new Object[0]) + exception.getMessage());
        }
        FormulaValiditionUtils.validitionFixFormula(hiddenFormula, tempIdToNumberMap);
        return hiddenFormula;
    }

    private static String validitionFuncContent(Map<String, String> tempIdToNumberMap, String value, Map<String, CellArea> tempCellAreaMap) {
        boolean contentIsError;
        String keys = null;
        String[] split = value.split("\\.");
        boolean bl = contentIsError = tempIdToNumberMap.size() > 1 && split.length != 2 || tempIdToNumberMap.size() == 1 && split.length > 2;
        if (contentIsError) {
            value = FixTempConfigParse.getOrignStr(tempIdToNumberMap, value);
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a \u53d8\u91cf\"", (String)"FixTempConfigParse_5", (String)"mmc-phm-common", (Object[])new Object[0]) + value + ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\u3002", (String)"FixTempConfigParse_6", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        if (split.length == 1) {
            try {
                SpreadUtils.pos2XY(split[0]);
            }
            catch (Exception e) {
                value = FixTempConfigParse.getOrignStr(tempIdToNumberMap, value);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u91cf\uff1a\"", (String)"FixTempConfigParse_7", (String)"mmc-phm-common", (Object[])new Object[0]).concat(value).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"FixTempConfigParse_8", (String)"mmc-phm-common", (Object[])new Object[0])));
            }
            keys = split[0];
        } else if (split.length == 2) {
            boolean isArea;
            int[] xy;
            if (!tempIdToNumberMap.containsKey(split[0])) {
                value = FixTempConfigParse.getOrignStr(tempIdToNumberMap, value);
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a \u53d8\u91cf\"", (String)"FixTempConfigParse_5", (String)"mmc-phm-common", (Object[])new Object[0]) + value + ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\u3002", (String)"FixTempConfigParse_6", (String)"mmc-phm-common", (Object[])new Object[0]));
            }
            try {
                xy = SpreadUtils.pos2XY(split[1]);
            }
            catch (Exception e) {
                value = FixTempConfigParse.getOrignStr(tempIdToNumberMap, value);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u91cf\uff1a\"", (String)"FixTempConfigParse_7", (String)"mmc-phm-common", (Object[])new Object[0]).concat(value).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"FixTempConfigParse_8", (String)"mmc-phm-common", (Object[])new Object[0])));
            }
            CellArea cellArea = tempCellAreaMap.get(split[0]);
            boolean bl2 = isArea = xy[1] < cellArea.getR() || xy[1] > cellArea.getR() + cellArea.getRc() || xy[0] < cellArea.getC() || xy[0] > cellArea.getC() + cellArea.getCc();
            if (isArea) {
                value = FixTempConfigParse.getOrignStr(tempIdToNumberMap, value);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u91cf\uff1a\"", (String)"FixTempConfigParse_7", (String)"mmc-phm-common", (Object[])new Object[0]).concat(value).concat(ResManager.loadKDString((String)"\"\u4e2d\u5355\u5143\u683c\u4e0d\u662f\u53ef\u9009\u62e9\u8303\u56f4\uff0c\u8bf7\u66f4\u6539\u3002", (String)"FixTempConfigParse_9", (String)"mmc-phm-common", (Object[])new Object[0])));
            }
            keys = split[1].concat(split[0]);
        }
        return keys == null ? "" : keys;
    }

    private static Map<String, CellArea> querySourceTempInfo(Map<String, String> tempIdToNumberMap) {
        List sourceTempIdList = tempIdToNumberMap.keySet().stream().map(x -> Long.parseLong(x)).collect(Collectors.toList());
        HashMap<String, CellArea> returnData = new HashMap<String, CellArea>(sourceTempIdList.size());
        QFilter[] idFilters = new QFilter[]{new QFilter("id", "in", sourceTempIdList)};
        try (DataSet dataSet = ORM.create().queryDataSet("querySourceTempInfo", "phm_billtemp", "tempclassify,realrow,realcol,tempconf,id", idFilters);){
            for (Row row : dataSet) {
                CellArea cellArea = new CellArea();
                if ("3".equals(row.getString("tempclassify"))) {
                    long tempconfId = row.getLong("tempconf");
                    DynamicObject tempCof = BusinessDataServiceHelper.loadSingle((Object)tempconfId, (String)"phm_billtemp_set", (String)"areastart,areaend");
                    if (tempCof == null || StringUtils.isBlank((CharSequence)tempCof.getString("areastart")) || StringUtils.isBlank((CharSequence)tempCof.getString("areaend"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\" ", (String)"FixTempConfigParse_10", (String)"mmc-phm-common", (Object[])new Object[0]) + tempIdToNumberMap.get(row.getString(4)) + ResManager.loadKDString((String)"\"\u672a\u8bbe\u7f6e\u6570\u636e\u533a\u57df", (String)"FixTempConfigParse_11", (String)"mmc-phm-common", (Object[])new Object[0]));
                    }
                    int[] areastart = SpreadUtils.pos2XY(tempCof.getString("areastart"));
                    int[] areaend = SpreadUtils.pos2XY(tempCof.getString("areaend"));
                    cellArea.setR(areastart[1]);
                    cellArea.setC(areastart[0]);
                    cellArea.setRc(areaend[1] - areastart[1]);
                    cellArea.setCc(areaend[0] - areastart[0]);
                } else {
                    cellArea.setR(0);
                    cellArea.setC(0);
                    cellArea.setRc(row.getInteger("realrow") - 1);
                    cellArea.setCc(row.getInteger("realcol") - 1);
                }
                returnData.put(row.getString("id"), cellArea);
            }
        }
        return returnData;
    }

    private static String getOrignStr(Map<String, String> tempIdToNumberMap, String value) {
        for (Map.Entry<String, String> stringStringEntry : tempIdToNumberMap.entrySet()) {
            value = value.replace(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        return value;
    }
}

