/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.datatemp;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.mmc.phm.common.spread.SpreadUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaParseUtils {
    private static final List<String> FUNCTION_LIST = Arrays.asList("min", "max", "avg", "sum");
    private static final Set<String> OPERATION_LIST = Sets.newHashSet((Object[])new String[]{"+", "-", "*", "/"});

    public static int[] formulaParase(String formula, int pre, int last) {
        String substring = formula.substring(pre, last);
        int minIndexOfFunction = FormulaParseUtils.getFuncLeftIndex(substring);
        if (minIndexOfFunction < substring.length()) {
            int rightBracketIndex = FormulaParseUtils.getFuncRightIndex(formula, pre + minIndexOfFunction + 4);
            return FormulaParseUtils.formulaParase(formula, pre + minIndexOfFunction + 4, rightBracketIndex);
        }
        return new int[]{pre - 4, last};
    }

    private static int getFuncRightIndex(String formula, int pre) {
        String substring = formula.substring(pre);
        int leftBracketSize = 1;
        int rightBracketIndex = 0;
        for (int i = 0; i < substring.length(); ++i) {
            if ('(' == substring.charAt(i)) {
                ++leftBracketSize;
            }
            if (')' == substring.charAt(i)) {
                --leftBracketSize;
            }
            if (leftBracketSize != 0) continue;
            rightBracketIndex = pre + i + 1;
            break;
        }
        return rightBracketIndex;
    }

    private static int getFuncLeftIndex(String formula) {
        int minIndex = formula.length();
        for (String functionName : FUNCTION_LIST) {
            if (!formula.contains(functionName)) continue;
            minIndex = formula.indexOf(functionName) < minIndex ? formula.indexOf(functionName) : minIndex;
        }
        return minIndex;
    }

    public static Object execFormula(String formula) {
        try {
            return FormulaEngine.execExcelFormula((String)formula);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u5931\u8d25\uff1a", (String)"FormulaParseUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]).concat(e.getMessage()));
        }
    }

    public static Object execFormula(String formula, Map<String, Object> variableMap) {
        try {
            return FormulaEngine.execExcelFormula((String)formula, variableMap);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u5931\u8d25\uff1a", (String)"FormulaParseUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]).concat(e.getMessage()));
        }
    }

    public static Object execLastFormula(String formula) {
        ArrayList<String> formulaList = new ArrayList<String>(16);
        FormulaParseUtils.getFormulaList(formula, formulaList, OPERATION_LIST, true);
        String replaceFormula = "";
        int paramIndex = 0;
        HashMap<String, Object> variableMap = new HashMap<String, Object>(8);
        for (String value : formulaList) {
            if (OPERATION_LIST.contains(value)) {
                replaceFormula = replaceFormula.concat(value);
                continue;
            }
            if (FormulaParseUtils.isFunction(value)) {
                replaceFormula = replaceFormula.concat(value);
                continue;
            }
            replaceFormula = replaceFormula.concat("param_" + paramIndex);
            variableMap.put("param_" + paramIndex++, new BigDecimal(value));
        }
        return FormulaParseUtils.execFormula(replaceFormula, variableMap);
    }

    private static boolean isFunction(String funcStr) {
        for (String func : FUNCTION_LIST) {
            if (!funcStr.contains(func)) continue;
            return true;
        }
        return false;
    }

    public static void getFormulaList(String formula, List<String> formulaList, Set<String> operationList, boolean includeOperation) {
        int[] minandmax = new int[]{formula.length(), formula.length()};
        int i = formula.length();
        String splitString = "";
        for (String oper : operationList) {
            if (!formula.contains(oper) || formula.indexOf(oper) >= i) continue;
            i = formula.indexOf(oper);
            splitString = oper;
        }
        if (StringUtils.isNotBlank((CharSequence)splitString)) {
            minandmax = FormulaParseUtils.setMinAndMax(minandmax, i, splitString.length(), formula.length());
        }
        String substringPre = formula.substring(0, minandmax[0]);
        String substring = formula.substring(minandmax[0], minandmax[1]);
        if (StringUtils.isNotBlank((CharSequence)substringPre)) {
            formulaList.add(substringPre.trim());
        }
        if (includeOperation && StringUtils.isNotBlank((CharSequence)substring)) {
            formulaList.add(substring.trim());
        }
        String formulanext = formula.substring(minandmax[1]);
        formulanext = FormulaParseUtils.getFormulaString(formulaList, formulanext);
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            FormulaParseUtils.getFormulaList(formulanext, formulaList, operationList, includeOperation);
        }
    }

    private static String getFormulaString(List<String> formulaList, String formulanext) {
        int i1;
        if ((formulanext = formulanext.trim()).startsWith("\"") && (i1 = formulanext.indexOf(34, 1)) != -1) {
            formulaList.add(formulanext.substring(0, i1 + 1));
            formulanext = formulanext.substring(i1 + 1);
        }
        if (formulanext.startsWith("'") && (i1 = formulanext.indexOf(39, 1)) != -1) {
            formulaList.add(formulanext.substring(0, i1 + 1));
            formulanext = formulanext.substring(i1 + 1);
        }
        return formulanext;
    }

    private static int[] setMinAndMax(int[] minandmax, int i, int length, int strLength) {
        if (i == 0) {
            minandmax[0] = 0;
            minandmax[1] = length;
        } else if (i == strLength - 1) {
            minandmax[0] = 0;
            minandmax[1] = i;
        } else {
            minandmax[0] = i;
            minandmax[1] = i + length;
        }
        return minandmax;
    }

    public static Map<String, int[]> getCellIndexMap(String[] cellStrings) {
        HashMap<String, int[]> cellIndexMap = new HashMap<String, int[]>(cellStrings.length);
        for (String cellString : cellStrings) {
            if (cellIndexMap.containsKey(cellString)) continue;
            cellIndexMap.put(cellString, SpreadUtils.pos2XY(cellString));
        }
        return cellIndexMap;
    }
}

