/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.datatemp;

import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.mmc.phm.common.util.datatemp.FormulaParseUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaValiditionUtils {
    private static final Pattern PATTERN = Pattern.compile("-?[0-9]+\\.?[0-9]*");

    public static boolean isNumber(String str) {
        return PATTERN.matcher(str.trim()).matches();
    }

    public static void validitionFixFormula(String hiddenFormula, Map<String, String> tempIdToNumberMap) {
        int[] strings = FormulaParseUtils.formulaParase(hiddenFormula, 0, hiddenFormula.length());
        if (strings[0] < 0) {
            String[] cellStrings = FormulaEngine.extractVariables((String)hiddenFormula);
            if (cellStrings.length > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a \u5355\u5143\u683c\u53ea\u80fd\u7528\u4e8e\u51fd\u6570\u4e2d\u3002", (String)"FormulaValiditionUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]));
            }
        } else {
            String funcContent;
            String substring = hiddenFormula.substring(strings[0], strings[1]);
            String[] cellStrings = FormulaEngine.extractVariables((String)substring);
            if (cellStrings.length == 0) {
                String replace = hiddenFormula.replace(substring, "1");
                FormulaValiditionUtils.validitionFixFormula(replace, tempIdToNumberMap);
            }
            if (StringUtils.isBlank((CharSequence)(funcContent = substring.trim().substring(0, substring.length() - 1).substring(4).trim()))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u51fd\u6570\u91cc\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaValiditionUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]));
            }
            int containTemp = 0;
            for (String tempId : tempIdToNumberMap.keySet()) {
                if (!funcContent.contains(tempId)) continue;
                ++containTemp;
            }
            if (containTemp > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a \u51fd\u6570\u53ea\u80fd\u7edf\u8ba1\u540c\u4e00\u6a21\u677f\u5355\u5143\u683c\u6570\u636e\u3002", (String)"FormulaValiditionUtils_2", (String)"mmc-phm-common", (Object[])new Object[0]));
            }
            String replace = hiddenFormula.replace(substring, "1");
            FormulaValiditionUtils.validitionFixFormula(replace, tempIdToNumberMap);
        }
    }

    public static boolean validitionFormulaCell(String formula) {
        int[] strings = FormulaParseUtils.formulaParase(formula, 0, formula.length());
        if (strings[0] < 0) {
            String[] cellStrings = FormulaEngine.extractVariables((String)formula);
            return cellStrings.length > 0;
        }
        String substring = formula.substring(strings[0], strings[1]);
        String funcContent = substring.trim().substring(0, substring.length() - 1).substring(4).trim();
        if (StringUtils.isBlank((CharSequence)funcContent)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u51fd\u6570\u91cc\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaValiditionUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]));
        }
        String replace = formula.replace(substring, "1");
        return FormulaValiditionUtils.validitionFormulaCell(replace);
    }
}

