/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.datatemp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.enums.datatemp.DataResourceEnum;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.util.datatemp.TableLineConfigUnits;
import kd.mmc.phm.common.util.datatemp.TempDataHandleUtils;

public class MultiTempConfigParse {
    private static final Log logger = LogFactory.getLog(MultiTempConfigParse.class);
    private static ThreadPool lineThreadPool = ThreadPools.newFixedThreadPool((String)"lineThreadPool", (int)4);
    private static final String BASETABLE_ID = "basetable_id";
    private static final String DATATABLE_ID = "datatable_id";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String DATATPL_ID = "datatpl_id";

    public static Map<String, Object> getDataBytempId(Long tempId, Long procesHistoryId, Long nodeEntryId, Long orgId) {
        logger.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u591a\u884c\u6a21\u677f\u67e5\u8be2\u6570\u636e\u5165\u53c2:" + tempId);
        long tempConfigId = 0L;
        String tempNumber = "";
        int realRow = 0;
        ORM orm = ORM.create();
        QFilter[] tempFilters = new QFilter[]{new QFilter(ID, "=", (Object)tempId)};
        try (DataSet dataSet = orm.queryDataSet("phm_queryBilltemp", "phm_billtemp", "tempconf,number,realrow", tempFilters);){
            for (Row row : dataSet) {
                tempConfigId = row.getLong(0);
                tempNumber = row.getString(1);
                realRow = row.getInteger(2);
            }
        }
        logger.warn("---\u6a21\u677f\u914d\u7f6eid:" + tempConfigId);
        DynamicObject billtempSet = null;
        if (tempConfigId != 0L) {
            billtempSet = BusinessDataServiceHelper.loadSingle((Object)tempConfigId, (String)"phm_billtemp_set");
        }
        return MultiTempConfigParse.getDataMapByConfig(billtempSet, procesHistoryId, nodeEntryId, tempConfigId, tempNumber, realRow, orgId);
    }

    public static Map<String, Object> getDataMapByConfig(DynamicObject billtempSet, Long procesHistoryId, Long nodeEntryId, Long tempConfigId, String tempNumber, Integer realRow, Long orgId) {
        QFilter qFilter;
        ArrayList<Map<String, Object>> mapDataList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Cell> returnData = new ArrayList<Cell>(16);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(3);
        MultiTempConfigParse.setReturnMap(returnMap, realRow, realRow, returnData);
        if (tempConfigId == 0L) {
            logger.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u591a\u884c\u6a21\u677f\u67e5\u8be2\u8fd4\u56de\u6570\u636e:\u6a21\u677f\u672a\u67e5\u8be2\u5230\u6a21\u677f\u914d\u7f6eid");
            return returnMap;
        }
        Long basetableId = billtempSet.getLong(BASETABLE_ID);
        String baseset = billtempSet.getString("baseset");
        int selectline = billtempSet.getInt("selectline");
        if (basetableId == 0L || StringUtils.isBlank((CharSequence)baseset)) {
            logger.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u591a\u884c\u6a21\u677f\u67e5\u8be2\u8fd4\u56de\u6570\u636e:\u65e0\u4e3b\u6570\u636e\u8bbe\u7f6e");
            return returnMap;
        }
        DynamicObjectCollection fieldentryentity = billtempSet.getDynamicObjectCollection("fieldentryentity");
        int startRow = MultiTempConfigParse.getStartRow(realRow, selectline, fieldentryentity);
        ArrayList<Object> baseDataList = new ArrayList<Object>();
        MultiTempConfigParse.queryBaseData(baseset, selectline, baseDataList, mapDataList, returnData, startRow);
        if (CollectionUtils.isEmpty(baseDataList)) {
            logger.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u591a\u884c\u6a21\u677f\u67e5\u8be2\u8fd4\u56de\u6570\u636e:\u4e3b\u6570\u636e\u4e3a\u7a7a");
            return returnMap;
        }
        String filterStr = MultiTempConfigParse.getBaseDataFilterStr(baseset);
        MultiTempConfigParse.queryTable(billtempSet, basetableId, selectline, baseDataList, fieldentryentity, mapDataList, returnData, startRow, filterStr);
        if (procesHistoryId == null || procesHistoryId == 0L) {
            logger.info("\u9884\u89c8\u6a21\u677f\u53f7\uff1a".concat(tempNumber));
            MultiTempConfigParse.setReturnMap(returnMap, startRow, startRow + baseDataList.size(), returnData);
            return returnMap;
        }
        List<DynamicObject> templeSource = fieldentryentity.stream().filter(x -> DataResourceEnum.TEMP.getValue().equals(x.getString("dataresource"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(templeSource)) {
            logger.info("\u6a21\u677f\u53f7\uff1a".concat(tempNumber).concat("\u65e0\u5173\u8054\u6a21\u677f\u7684\u8868\u5217\u914d\u7f6e"));
            MultiTempConfigParse.setReturnMap(returnMap, startRow, startRow + baseDataList.size(), returnData);
            return returnMap;
        }
        List<Long> tplIds = templeSource.stream().map(x -> x.getLong(DATATPL_ID)).distinct().collect(Collectors.toList());
        QFilter[] idFilters = new QFilter[]{new QFilter(ID, "in", tplIds)};
        DynamicObject[] sourceBillTemps = BusinessDataServiceHelper.load((String)"phm_billtemp", (String)"id,realrow,versionrule,tempconf", (QFilter[])idFilters);
        if (sourceBillTemps == null || sourceBillTemps.length == 0 || sourceBillTemps.length != tplIds.size()) {
            logger.info("\u591a\u884c\u6a21\u677f\u67e5\u8be2\u6570\u636e\uff1a\u6709\u6765\u6e90\u6a21\u677f\u4e0d\u5b58\u5728");
            MultiTempConfigParse.setReturnMap(returnMap, startRow, startRow + baseDataList.size(), returnData);
            return returnMap;
        }
        HashMap<Long, Integer> tempToRealRowMap = new HashMap<Long, Integer>(sourceBillTemps.length);
        MultiTempConfigParse.getTempRealRowMap(tempToRealRowMap, sourceBillTemps);
        if (procesHistoryId != null && procesHistoryId != 0L) {
            List<Object> collect = tplIds.stream().map(x -> x).collect(Collectors.toList());
            qFilter = TempDataHandleUtils.getQFilterByTempsAndProcess(collect, procesHistoryId, nodeEntryId, orgId);
        } else {
            qFilter = TempDataHandleUtils.getQFilterByTemps(sourceBillTemps);
        }
        DynamicObjectCollection dataTemps = QueryServiceHelper.query((String)"phm_filldata_history", (String)"template,spreadjson_tag", (QFilter[])qFilter.toArray());
        MultiTempConfigParse.querTempData(tplIds, tempToRealRowMap, dataTemps, mapDataList, returnData, realRow, templeSource, tempConfigId);
        MultiTempConfigParse.setReturnMap(returnMap, startRow, startRow + baseDataList.size(), returnData);
        return returnMap;
    }

    private static String getBaseDataFilterStr(String baseset) {
        String[] split = baseset.split("where");
        String filterStr = null;
        if (split.length == 2) {
            filterStr = split[1];
        }
        return filterStr;
    }

    public static int getStartRow(int realRow, int selectline, DynamicObjectCollection fieldentryentity) {
        List collect = fieldentryentity.stream().filter(x -> x.getInt("cellcol") == selectline).collect(Collectors.toList());
        int startRow = ((DynamicObject)collect.get(0)).getInt("startrow") - 1;
        if (startRow == -1) {
            startRow = realRow;
        }
        return startRow;
    }

    private static void setReturnMap(Map<String, Object> returnMap, int startRow, int endRow, List<Cell> cellList) {
        returnMap.put("startRow", startRow);
        returnMap.put("endRow", endRow);
        returnMap.put("cellList", cellList);
    }

    private static void querTempData(List<Long> tplIds, Map<Long, Integer> tempToRealRowMap, DynamicObjectCollection dataTemps, List<Map<String, Object>> mapDataList, List<Cell> returnData, final int startRow, List<DynamicObject> templeSource, long tempConfigId) {
        for (Long tplId : tplIds) {
            List<String> spreadjsonTags = dataTemps.stream().filter(x -> tplId.equals(x.getLong("template"))).map(x -> x.getString("spreadjson_tag")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(spreadjsonTags)) continue;
            final List<Map<String, Object>> rowMapList = TempDataHandleUtils.getRowDatas(spreadjsonTags);
            List fieldformulaList = templeSource.stream().filter(x -> tplId.equals(x.getLong(DATATPL_ID))).collect(Collectors.toList());
            final int rowCount = tempToRealRowMap.get(tplId);
            for (final DynamicObject dynamicObject : fieldformulaList) {
                final String expressionAll = dynamicObject.getString("fieldformula");
                final int format = dynamicObject.getInt("format");
                final int sourceIndex = TableLineConfigUnits.getSourceIndex(expressionAll);
                String[] formulaSplit = expressionAll.split("&");
                final String formula = formulaSplit[1];
                ArrayList<Future> futureList = new ArrayList<Future>(mapDataList.size());
                int i = 0;
                while (i < mapDataList.size()) {
                    final Map<String, Object> returnDatum = mapDataList.get(i);
                    final long targetTempConfigId = tempConfigId;
                    final int rowIndex = i++;
                    Future submit = lineThreadPool.submit((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            String[] strings = TableLineConfigUnits.getColIndexAndFieldType(expressionAll, targetTempConfigId);
                            Object filterData = returnDatum.get(strings[0]);
                            Object resultObject = TableLineConfigUnits.paraseAndCalculate(sourceIndex, formula, rowMapList, filterData, rowCount, format);
                            int lineIndex = dynamicObject.getInt("cellcol");
                            Cell cell = new Cell(startRow + rowIndex, lineIndex, resultObject);
                            return cell;
                        }
                    });
                    futureList.add(submit);
                }
                for (Future objectFuture : futureList) {
                    try {
                        returnData.add((Cell)objectFuture.get());
                    }
                    catch (InterruptedException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("MULTI_RESOLVE_DATAS_EXC", ResManager.loadKDString((String)"\u52a0\u8f7d\u591a\u884c\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"MultiTempConfigParse_0", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
                    }
                    catch (ExecutionException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("MULTI_RESOLVE_DATAS_EXC", ResManager.loadKDString((String)"\u52a0\u8f7d\u591a\u884c\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"MultiTempConfigParse_0", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
                    }
                }
            }
        }
    }

    private static void getTempRealRowMap(Map<Long, Integer> tempToRealRowMap, DynamicObject[] sourceBillTemps) {
        for (DynamicObject sourceBillTemp : sourceBillTemps) {
            tempToRealRowMap.put(sourceBillTemp.getLong(ID), sourceBillTemp.getInt("realrow"));
        }
    }

    private static void queryTable(DynamicObject billtempSet, Long basetableId, int selectline, ArrayList<Object> baseDataList, DynamicObjectCollection fieldentryentity, List<Map<String, Object>> mapDataList, List<Cell> returnData, int startRow, String filterStr) {
        List tableSource = fieldentryentity.stream().filter(x -> DataResourceEnum.TABLE.getValue().equals(x.getString("dataresource")) && basetableId.equals(x.getLong(DATATABLE_ID))).collect(Collectors.toList());
        DynamicObject basetable = billtempSet.getDynamicObject("basetable");
        String basetableNumber = basetable.getString(NUMBER);
        List fieldKeyList = tableSource.stream().filter(x -> "1".equals(x.getString("fieldlogic"))).collect(Collectors.toList());
        if (tableSource.size() > 1 && !CollectionUtils.isEmpty(fieldKeyList) && fieldKeyList.size() == 1 && selectline == ((DynamicObject)fieldKeyList.get(0)).getInt("cellcol")) {
            List valueList = tableSource.stream().filter(x -> "2".equals(x.getString("fieldlogic"))).collect(Collectors.toList());
            StringBuilder selectTableSql = new StringBuilder();
            selectTableSql.append("select ");
            for (DynamicObject dynamicObject : valueList) {
                selectTableSql.append(dynamicObject.getString("fieldnumber")).append(", ");
            }
            selectTableSql.append(((DynamicObject)fieldKeyList.get(0)).getString("fieldnumber"));
            selectTableSql.append(" FROM ");
            selectTableSql.append(basetableNumber);
            selectTableSql.append(" WHERE ");
            selectTableSql.append(((DynamicObject)fieldKeyList.get(0)).getString("fieldnumber"));
            selectTableSql.append(" in ");
            String fieldtype = ((DynamicObject)fieldKeyList.get(0)).getString("fieldtype");
            selectTableSql.append('(');
            for (int i = 0; i < baseDataList.size(); ++i) {
                if (StringUtils.equals((CharSequence)FieldType.NVARCHAR.getValue(), (CharSequence)fieldtype)) {
                    selectTableSql.append('\'').append(baseDataList.get(i)).append('\'');
                } else {
                    selectTableSql.append(baseDataList.get(i));
                }
                if (i == baseDataList.size() - 1) continue;
                selectTableSql.append(',');
            }
            selectTableSql.append(')');
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                selectTableSql.append(" and ").append(filterStr);
            } else {
                selectTableSql.append(" order by ").append(((DynamicObject)fieldKeyList.get(0)).getString("fieldnumber"));
            }
            logger.warn("---\u67e5\u8be2\u6570\u636e\u8868\u7d22\u5f15\u503csql:" + selectTableSql);
            try (DataSet dataSet = DB.queryDataSet((String)"phm_selectdataline", (DBRoute)CommonConsts.ROUTE_PHM, (String)selectTableSql.toString());){
                if (dataSet.hasNext()) {
                    int returnDataIndex = 0;
                    for (Row row : dataSet) {
                        Map<String, Object> stringObjectMap = mapDataList.get(returnDataIndex);
                        for (int i1 = 0; i1 < valueList.size(); ++i1) {
                            int cellIndex = ((DynamicObject)valueList.get(i1)).getInt("cellcol");
                            stringObjectMap.put(Integer.toString(cellIndex), row.get(i1));
                            returnData.add(new Cell(startRow + returnDataIndex, cellIndex, row.get(i1)));
                        }
                        ++returnDataIndex;
                    }
                }
            }
        }
    }

    private static void queryBaseData(String baseset, int selectline, ArrayList<Object> baseDataList, List<Map<String, Object>> mapDataList, List<Cell> returnData, int startRow) {
        try (DataSet dataSet = DB.queryDataSet((String)"phm_selectSum", (DBRoute)CommonConsts.ROUTE_PHM, (String)baseset);){
            if (dataSet.hasNext()) {
                int rowIndex = 0;
                for (Row row : dataSet) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    baseDataList.add(row.get(0));
                    map.put(Integer.toString(selectline), row.get(0));
                    mapDataList.add(map);
                    returnData.add(new Cell(startRow + rowIndex++, selectline, row.get(0)));
                }
            }
        }
    }
}

