/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.datatemp;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.util.VersionRuleUtils;
import kd.mmc.phm.common.util.datatemp.FormulaParseUtils;
import kd.mmc.phm.common.util.datatemp.TempDataHandleUtils;
import org.apache.commons.lang3.StringUtils;

public class TableLineConfigUnits {
    private static final Log logger = LogFactory.getLog(TableLineConfigUnits.class);
    private static final String PHM_BILLTEMP = "phm_billtemp";
    private static final String ID = "id";
    private static final String PARAM_PRE = "param_";

    public static BigDecimal execute(Object filterData, String inputType, Long sourceTempId, String expressionAll, Long procesHistoryId, Long nodeEntryId, int format) {
        QFilter qFilter;
        logger.info("\u516c\u5f0f\u8ba1\u7b97\u5165\u53c2:".concat(filterData.toString()).concat(",\u7c7b\u578b:").concat(inputType).concat(",\u6765\u6e90id:").concat(Long.toString(sourceTempId)).concat(",\u8868\u8fbe\u5f0f:").concat(expressionAll));
        QFilter[] idFilters = new QFilter[]{new QFilter(ID, "=", (Object)sourceTempId)};
        DynamicObject billtemp = BusinessDataServiceHelper.loadSingle((String)PHM_BILLTEMP, (String)"realrow,versionrule", (QFilter[])idFilters);
        int realrow = billtemp.getInt("realrow");
        DynamicObject versionRule = billtemp.getDynamicObject("versionrule");
        if (procesHistoryId != null && procesHistoryId != 0L) {
            QFilter qFilterByTempsAndProcess;
            qFilter = qFilterByTempsAndProcess = TempDataHandleUtils.getQFilterByTempsAndProcess(Lists.newArrayList((Object[])new Object[]{sourceTempId}), procesHistoryId, nodeEntryId, RequestContext.get().getOrgId());
        } else {
            QFilter qFilterOrign = new QFilter("template", "=", (Object)sourceTempId);
            qFilterOrign.and(new QFilter("status", "=", (Object)"C"));
            if (versionRule != null) {
                Tuple<Date, Date> tuple = VersionRuleUtils.computePeriod(versionRule);
                qFilterOrign.and(new QFilter("starttime", "=", tuple.item1));
                qFilterOrign.and(new QFilter("endtime", "=", tuple.item2));
            }
            qFilter = qFilterOrign;
        }
        DynamicObjectCollection dataTemps = QueryServiceHelper.query((String)"phm_filldata_history", (String)"template,spreadjson_tag", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dataTemps)) {
            return null;
        }
        List<String> spreadjsonTags = dataTemps.stream().map(x -> x.getString("spreadjson_tag")).collect(Collectors.toList());
        List<Map<String, Object>> rowMapList = TempDataHandleUtils.getRowDatas(spreadjsonTags);
        String[] formulaSplit = expressionAll.split("&");
        String formula = formulaSplit[1];
        int sourceIndex = TableLineConfigUnits.getSourceIndex(expressionAll);
        Object resultObject = TableLineConfigUnits.paraseAndCalculate(sourceIndex, formula, rowMapList, filterData, realrow, format);
        return new BigDecimal(resultObject.toString());
    }

    public static Object paraseAndCalculate(int sourceIndex, String formula, List<Map<String, Object>> rowMapList, Object filterData, int realrow, int format) {
        BigDecimal lastResult;
        if (filterData == null) {
            logger.info("\u89e3\u6790\u516c\u5f0f\u5e76\u8ba1\u7b97\u51fa\u7ed3\u679c\uff0c\u8fc7\u6ee4\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        int[] formulaIndexs = FormulaParseUtils.formulaParase(formula, 0, formula.length());
        String formulaContent = formula.substring(formulaIndexs[0], formulaIndexs[1]);
        String[] cellStrings = FormulaEngine.extractVariables((String)formulaContent);
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        String replaceFormulaContent = TableLineConfigUnits.getFormulaParam(rowMapList, formulaContent, cellStrings, valueMap, sourceIndex, realrow, filterData);
        logger.info("\u516c\u5f0f\u6267\u884c\uff0c\u8868\u8fbe\u5f0f:".concat(replaceFormulaContent).concat("\u53c2\u6570\uff1a").concat(JSON.toJSONString(valueMap)));
        Object resultObject = FormulaParseUtils.execFormula(replaceFormulaContent, valueMap);
        String replaceFormula = formula.replace(formulaContent, resultObject.toString());
        if (FormulaEngine.extractVariables((String)replaceFormula).length > 0) {
            return TableLineConfigUnits.paraseAndCalculate(sourceIndex, replaceFormula, rowMapList, filterData, realrow, format);
        }
        if (valueMap.isEmpty()) {
            return BigDecimal.ZERO.setScale(0, 4);
        }
        try {
            lastResult = new BigDecimal(replaceFormula).setScale(format, 4);
        }
        catch (Exception e) {
            Object lastResultObject = FormulaParseUtils.execLastFormula(replaceFormula);
            lastResult = new BigDecimal(lastResultObject.toString()).setScale(format, 4);
        }
        return lastResult.stripTrailingZeros();
    }

    private static String getFormulaParam(List<Map<String, Object>> rowMapList, String formula, String[] cellStrings, Map<String, Object> valueMap, int sourceIndex, int realrow, Object filterData) {
        if (CollectionUtils.isEmpty(rowMapList)) {
            for (String cellString : cellStrings) {
                formula = formula.replace(cellString, "0");
            }
        } else {
            int index = 0;
            String formulaContext = formula.substring(4, formula.length() - 1);
            ArrayList<String> formulaReplaceList = new ArrayList<String>(rowMapList.size());
            for (Map<String, Object> rowMap : rowMapList) {
                for (Map.Entry<String, Object> stringObjectMap : rowMap.entrySet()) {
                    Map colMap;
                    Map conditionLineMap;
                    int row = Integer.parseInt(stringObjectMap.getKey());
                    if (row < realrow || (conditionLineMap = (Map)(colMap = (Map)stringObjectMap.getValue()).get(Integer.toString(sourceIndex))) == null || conditionLineMap.get("value") == null || StringUtils.isBlank((CharSequence)conditionLineMap.get("value").toString()) || !filterData.toString().equals(conditionLineMap.get("value").toString())) continue;
                    String formulaReplace = formulaContext;
                    for (String cellStr : cellStrings) {
                        int lineIndex = SpreadUtils.pos2X(cellStr);
                        Map lineMap = (Map)colMap.get(Integer.toString(lineIndex));
                        if (lineMap == null || lineMap.get("value") == null || StringUtils.isBlank((CharSequence)lineMap.get("value").toString())) {
                            valueMap.put(PARAM_PRE.concat(Integer.toString(index)), BigDecimal.ZERO);
                        } else {
                            try {
                                valueMap.put(PARAM_PRE.concat(Integer.toString(index)), new BigDecimal(lineMap.get("value").toString()));
                            }
                            catch (Exception e) {
                                throw new KDBizException((Throwable)e, new ErrorCode("SOURCE_DATA_NOT_NUMBER", ResManager.loadKDString((String)"\u7edf\u8ba1\u6570\u636e\u4e2d\u5305\u542b\u5b57\u7b26\u4e32\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TableLineConfigUnits_0", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[0]);
                            }
                        }
                        formulaReplace = formulaReplace.replace(cellStr, PARAM_PRE.concat(Integer.toString(index++)));
                    }
                    formulaReplaceList.add(formulaReplace);
                }
            }
            String replaceString = "0";
            if (!CollectionUtils.isEmpty(formulaReplaceList)) {
                replaceString = StringUtils.join((Object[])formulaReplaceList.toArray(), (char)',');
            }
            formula = formula.replace(formulaContext, replaceString);
        }
        return formula;
    }

    public static int getSourceIndex(String expressionAll) {
        String[] formulaSplit = expressionAll.split("&");
        String[] split = formulaSplit[3].split("\\(");
        String[] conditionFormulaSplit = split[1].split(",");
        String sourceConditionCell = conditionFormulaSplit[0].trim();
        int sourceConditionCellIndex = SpreadUtils.pos2X(sourceConditionCell);
        return sourceConditionCellIndex;
    }

    public static String[] parseFormula(String expressionAll, Long tempId) {
        long tempConfId;
        logger.info("\u516c\u5f0f\u89e3\u6790\u5165\u53c2:".concat(expressionAll).concat("\u5173\u8054\u6a21\u677fid").concat(Long.toString(tempId)));
        QFilter[] idFilters = new QFilter[]{new QFilter(ID, "=", (Object)tempId)};
        try (DataSet dataSet = ORM.create().queryDataSet("phm_queryBilltemp", PHM_BILLTEMP, "tempconf", idFilters);){
            if (!dataSet.hasNext()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u6a21\u7248\u4e0d\u5b58\u5728:", (String)"TableLineConfigUnits_1", (String)"mmc-phm-common", (Object[])new Object[0]).concat(Long.toString(tempId)));
            }
            tempConfId = dataSet.next().getLong(0);
        }
        return TableLineConfigUnits.getColIndexAndFieldType(expressionAll, tempConfId);
    }

    public static String[] getColIndexAndFieldType(String expressionAll, long tempConfId) {
        String[] formulaSplit = expressionAll.split("&");
        String[] conditionSplit = formulaSplit[3].split("\\)");
        String targetCell = conditionSplit[0].split(",")[1].trim();
        String[] returnData = new String[2];
        QFilter[] configFilters = new QFilter[]{new QFilter(ID, "=", (Object)tempConfId), new QFilter("fieldentryentity.fieldcellpo", "=", (Object)targetCell)};
        try (DataSet dataSet = ORM.create().queryDataSet("phm_queryBilltempSet", "phm_billtemp_set", "fieldentryentity.fieldtype type, fieldentryentity.cellcol cellcol", configFilters);){
            if (!dataSet.hasNext()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u5143\u683c\u5b9a\u4f4d\"", (String)"TableLineConfigUnits_2", (String)"mmc-phm-common", (Object[])new Object[0]).concat(targetCell).concat(ResManager.loadKDString((String)"\"\u7684\u8868\u5217\u914d\u7f6e\u4fe1\u606f\u3002", (String)"TableLineConfigUnits_3", (String)"mmc-phm-common", (Object[])new Object[0])));
            }
            Row next = dataSet.next();
            returnData[0] = next.getString(1);
            returnData[1] = next.getString(0);
        }
        return returnData;
    }
}

