/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.datatemp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.util.VersionRuleUtils;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;

public class TempDataHandleUtils {
    public static Map<String, Object> getRowMap(String spreadjsonTag) {
        String convertSpreadJson = SpreadUtils.convertSpreadJson(spreadjsonTag);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, Map.class);
        Map sheets = (Map)spreadMap.get("sheets");
        Map sheetMap = (Map)sheets.get("Sheet1");
        Map data = (Map)sheetMap.get("data");
        return data.getOrDefault("dataTable", Collections.emptyMap());
    }

    public static List<Map<String, Object>> getRowDatas(List<String> spreadjsonTags) {
        ArrayList<Map<String, Object>> rowMapList = new ArrayList<Map<String, Object>>(spreadjsonTags.size());
        for (String spreadjsonTag : spreadjsonTags) {
            Map<String, Object> rowMap = TempDataHandleUtils.getRowMap(spreadjsonTag);
            rowMapList.add(rowMap);
        }
        return rowMapList;
    }

    public static QFilter getQFilterByTemps(DynamicObject[] sourceBillTemps) {
        QFilter qFilter = null;
        for (int i = 0; i < sourceBillTemps.length; ++i) {
            DynamicObject sourceBillTemp = sourceBillTemps[i];
            QFilter tempQFilter = new QFilter("template", "in", (Object)sourceBillTemp.getLong("id"));
            tempQFilter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObject versionRule = sourceBillTemp.getDynamicObject("versionrule");
            if (versionRule != null) {
                Tuple<Date, Date> tuple = VersionRuleUtils.computePeriod(versionRule);
                tempQFilter.and(new QFilter("starttime", "=", tuple.item1));
                tempQFilter.and(new QFilter("endtime", "=", tuple.item2));
            }
            if (i == 0) {
                qFilter = tempQFilter;
                continue;
            }
            if (qFilter == null) continue;
            qFilter.or(tempQFilter);
        }
        return qFilter;
    }

    public static QFilter getQFilterByTempsAndProcess(List<Object> sourceBillTempIds, Long procesHistoryId, Long currentNodeEntryId, Long orgId) {
        Set<Long> preNodeEntryId = ProcessQueryUtil.queryPreNodeEntryId(procesHistoryId, currentNodeEntryId);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fdataid from t_phm_node_resource resource,t_phm_process_node node where resource.ftype = ? and", new Object[]{"phm_billtemp"});
        sqlBuilder.appendIn("resource.fresourceid", sourceBillTempIds);
        sqlBuilder.append("and resource.fentryid = node.fentryid  and node.fid = ? ", new Object[]{procesHistoryId});
        if (!CollectionUtils.isEmpty(preNodeEntryId)) {
            sqlBuilder.append("and ", new Object[0]);
            sqlBuilder.appendIn("node.fentryid", preNodeEntryId.stream().map(x -> x).collect(Collectors.toList()));
        }
        if (orgId != null && orgId != 0L) {
            sqlBuilder.append("and (resource.forgid = ?  or resource.forgid = 0 )", new Object[]{orgId});
        }
        ArrayList<Long> historyId = new ArrayList<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"phm_queryDataId", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                historyId.add(row.getLong(0));
            }
        }
        QFilter qFilter = new QFilter("id", "in", historyId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        return qFilter;
    }
}

