/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.formula.FormulaEngine;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.domian.process.AutoSubmitParam;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessErrorTypeEnum;
import kd.mmc.phm.common.enums.ProcessResourceSourceEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.enums.datatemp.DataResourceEnum;
import kd.mmc.phm.common.info.FormulaColumnInfo;
import kd.mmc.phm.common.info.IndexCol;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.util.VersionRuleUtils;
import kd.mmc.phm.common.util.datatemp.FixTempConfigParse;
import kd.mmc.phm.common.util.datatemp.MultiTempConfigParse;
import kd.mmc.phm.common.util.process.AutoUpdateUtil;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import kd.mmc.phm.common.util.process.ProcessUpdateUtil;

public class AutoSubmitUtil {
    private static final String ENTITY_HISTORY = "phm_filldata_history";
    private static final String algoKey = "AutoSubmitUtil.";
    private static final Log logger = LogFactory.getLog(AutoSubmitUtil.class);

    public static void createResourceSync(List<AutoSubmitParam> autoSubmitList) {
        ThreadPools.executeOnceIncludeRequestContext((String)"PHMProcessAutoSubmit", () -> {
            for (AutoSubmitParam autoSubmitParam : autoSubmitList) {
                AutoSubmitUtil.createProcessResource(autoSubmitParam);
            }
        }, (String)"phm");
    }

    public static void createResource(AutoSubmitParam autoSubmitParam) {
        if (ProcessResourceSourceEnum.DataTemp.getValue().equals(autoSubmitParam.getResourceType())) {
            boolean isFinish;
            Long tempHistoryId = AutoSubmitUtil.createTempHistory(autoSubmitParam.getResourceId(), autoSubmitParam.getProcessId(), autoSubmitParam.getProcessHistoryId(), autoSubmitParam.getEntryNodeId());
            AutoSubmitUtil.createProcesResourceHistory(autoSubmitParam, tempHistoryId);
            int isCheckNodeTaskFinish = ProcessUpdateUtil.updateTaskProgress(autoSubmitParam.getEntryNodeId(), autoSubmitParam.getResourceId(), 1, "1");
            boolean fromEvent = autoSubmitParam.getFromEvent();
            if (!fromEvent && isCheckNodeTaskFinish == 1 && (isFinish = ProcessQueryUtil.queryNodeFinish(autoSubmitParam.getEntryNodeId()))) {
                ProcessUpdateUtil.updateNodeStatusByNodeEntryId(autoSubmitParam.getEntryNodeId(), RunningState.COMPLETED.getValue());
                DynamicObjectCollection nodeEntryList = ProcessQueryUtil.queryNodeEntry(autoSubmitParam.getProcessHistoryId());
                ProcessUpdateUtil.createNextNodeTask(autoSubmitParam.getEntryNodeId(), autoSubmitParam.getProcessHistoryId(), autoSubmitParam.getProcessId(), nodeEntryList);
            }
        }
    }

    private static void createProcesResourceHistory(AutoSubmitParam autoSubmitParam, Long tempHistoryId) {
        Long tempId = autoSubmitParam.getResourceId();
        Long processHistoryId = autoSubmitParam.getProcessHistoryId();
        Long entryNodeId = autoSubmitParam.getEntryNodeId();
        String dealType = autoSubmitParam.getDealType();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"phm_process_resources");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt);
        dynamicObject.set("entry_node", (Object)entryNodeId);
        dynamicObject.set("resource_datatype", (Object)ENTITY_HISTORY);
        dynamicObject.set("resource_data", (Object)tempHistoryId);
        dynamicObject.set("resource_type", (Object)"phm_billtemp");
        dynamicObject.set("resource_number", (Object)tempId);
        dynamicObject.set("resource_modifytime", (Object)new Date());
        dynamicObject.set("resource_processhistory", (Object)processHistoryId);
        dynamicObject.set("resource_status", (Object)StatusEnum.AUDIT.getValue());
        dynamicObject.set("resource_dealtype", (Object)dealType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static Long createTempHistory(Long tempId, Long processId, Long processHistoryId, Long nodeEntryId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_HISTORY);
        long tempHistoryId = ID.genLongId();
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt, (Object)tempHistoryId);
        dynamicObject.set("template", (Object)tempId);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)tempId)};
        long templateVersionRuleId = 0L;
        try (DataSet dataSet = ORM.create().queryDataSet("AutoSubmitUtil.queryTemplate", "phm_billtemp", "createorg, ctrlstrategy, versionrule", filters, null, 1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                dynamicObject.set("createorg", row.get(0));
                dynamicObject.set("ctrlstrategy", row.get(1));
                templateVersionRuleId = row.getLong(2);
            }
        }
        dynamicObject.set("number", (Object)String.valueOf(tempId));
        dynamicObject.set("name", (Object)String.valueOf(tempId));
        dynamicObject.set("enable", (Object)EnableEnum.ENABLE.getValue());
        dynamicObject.set("status", (Object)StatusEnum.AUDIT.getValue());
        dynamicObject.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set("createtime", (Object)new Date());
        DynamicObject processDynamicObject = BusinessDataServiceHelper.loadSingle((Object)processId, (String)"phm_flow_define", (String)"versionrule,globalrule");
        boolean useGlobal = processDynamicObject.getBoolean("globalrule");
        long processVersionRuleId = processDynamicObject.getLong("versionrule_id");
        long versionRuleId = !useGlobal && templateVersionRuleId != 0L ? templateVersionRuleId : processVersionRuleId;
        dynamicObject.set("versionrule", (Object)versionRuleId);
        AutoSubmitUtil.fillNumberByRule(dynamicObject, versionRuleId);
        dynamicObject.set("name", (Object)dynamicObject.getString("number"));
        String spreadJson = AutoSubmitUtil.getTempSpreadJson(tempId, processHistoryId, nodeEntryId);
        dynamicObject.set("spreadjson_tag", (Object)spreadJson);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return tempHistoryId;
    }

    private static String getTempSpreadJson(Long tempId, Long processHistoryId, Long nodeEntryId) {
        long cellConfId;
        String tempclassify;
        DynamicObject templete = QueryServiceHelper.queryOne((String)"phm_billtemp", (String)"id,tempclassify,number,tempconf,cellconf,realrow,realcol,spreadjson_tag", (QFilter[])new QFilter("id", "=", (Object)tempId).toArray());
        String spreadJson = templete.getString("spreadjson_tag");
        long tempConfId = templete.getLong("tempconf");
        DynamicObject tempConfObj = null;
        if (tempConfId != 0L) {
            tempConfObj = BusinessDataServiceHelper.loadSingle((Object)tempConfId, (String)"phm_billtemp_set");
        }
        String convertSpreadJson = SpreadUtils.convertSpreadJson(spreadJson);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, Map.class);
        Map sheets = (Map)spreadMap.get("sheets");
        Map sheetMap = (Map)sheets.get("Sheet1");
        Map data = (Map)sheetMap.get("data");
        Map<String, Object> rowMap = data.getOrDefault("dataTable", Collections.emptyMap());
        if (tempConfObj != null) {
            DynamicObjectCollection collection = tempConfObj.getDynamicObjectCollection("headentryentity");
            ArrayList<Cell> cellList = new ArrayList<Cell>(collection.size());
            for (DynamicObject obj : collection) {
                String formula = obj.getString("headformula");
                if (!StringUtils.isNotBlank((CharSequence)formula)) continue;
                Object newValue = FormulaEngine.execExcelFormula((String)formula);
                int headCol = obj.getInt("headcol");
                int headRow = obj.getInt("headrow");
                Cell cell = new Cell(headRow, headCol, newValue);
                cellList.add(cell);
            }
            AutoSubmitUtil.updateHeadCellValue(rowMap, cellList);
        }
        if ("2".equals(tempclassify = templete.getString("tempclassify")) && tempConfId != 0L) {
            DynamicObjectCollection fieldEntryEntity;
            List<DynamicObject> excelFormulaSet;
            String tempNumber = templete.getString("number");
            int realRow = templete.getInt("realrow");
            int realCol = templete.getInt("realcol");
            Map<String, Object> datas = MultiTempConfigParse.getDataMapByConfig(tempConfObj, processHistoryId, nodeEntryId, tempConfId, tempNumber, realRow, null);
            List cells = (List)datas.get("cellList");
            int endRow = (Integer)datas.get("endRow");
            int startRow = (Integer)datas.get("startRow");
            int appendRows = endRow - realRow;
            for (int row = 0; row < appendRows; ++row) {
                HashMap colMap = new HashMap(realCol);
                for (int col = 0; col < realCol; ++col) {
                    HashMap<String, Object> colMapValue = new HashMap<String, Object>(1);
                    colMapValue.put("value", null);
                    colMap.put(Integer.toString(col), colMapValue);
                }
                rowMap.put(Integer.toString(realRow + row), colMap);
            }
            AutoSubmitUtil.updateCellValue(rowMap, cells);
            if (Objects.nonNull(tempConfObj) && !CollectionUtils.isEmpty(excelFormulaSet = (fieldEntryEntity = tempConfObj.getDynamicObjectCollection("fieldentryentity")).stream().filter(x -> DataResourceEnum.EXCEL.getValue().equals(x.getString("dataresource"))).collect(Collectors.toList()))) {
                AutoSubmitUtil.addFormulaAndCalculate(rowMap, excelFormulaSet, startRow);
            }
            sheetMap.put("rowCount", endRow);
        } else if ("3".equals(tempclassify) && (cellConfId = templete.getLong("cellconf")) != 0L) {
            List<Cell> dataByCellConfId = FixTempConfigParse.getDataByCellConfId(cellConfId, processHistoryId, nodeEntryId, null);
            AutoSubmitUtil.updateCellValue(rowMap, dataByCellConfId);
        }
        AutoUpdateUtil.formulaEvaluator(spreadMap, null);
        return AutoSubmitUtil.getRetrunSpreadjsonTag(spreadMap);
    }

    private static void addFormulaAndCalculate(Map<String, Object> rowMap, List<DynamicObject> excelFormulaSet, int startRow) {
        ArrayList<FormulaColumnInfo> formulaColumnInfoList = new ArrayList<FormulaColumnInfo>(8);
        for (DynamicObject obj : excelFormulaSet) {
            if (!DataResourceEnum.EXCEL.getValue().equals(obj.getString("dataresource"))) continue;
            int colStartRow = obj.getInt("startrow") > startRow ? obj.getInt("startrow") : startRow;
            String fieldFormula = obj.getString("calculateconf");
            int cellCol = obj.getInt("cellcol");
            FormulaColumnInfo formulaColumnInfo = new FormulaColumnInfo();
            formulaColumnInfo.setStartRow(colStartRow);
            formulaColumnInfo.setFormulaCol(new IndexCol(cellCol, "", ""));
            formulaColumnInfo.setFormula(fieldFormula);
            formulaColumnInfoList.add(formulaColumnInfo);
        }
        Set colList = formulaColumnInfoList.stream().map(x -> x.getFormulaCol().getCol()).collect(Collectors.toSet());
        for (Map.Entry<String, Object> rowData : rowMap.entrySet()) {
            int rowIndex = Integer.parseInt(rowData.getKey());
            Map colMap = (Map)rowData.getValue();
            for (Map.Entry colData : colMap.entrySet()) {
                FormulaColumnInfo formulaColumnInfo;
                int colIndex = Integer.parseInt((String)colData.getKey());
                Map colDataValue = (Map)colData.getValue();
                if (!colList.contains(colIndex) || rowIndex < (formulaColumnInfo = formulaColumnInfoList.stream().filter(x -> x.getFormulaCol().getCol() == colIndex).findFirst().get()).getStartRow()) continue;
                String formula = formulaColumnInfo.getFormula();
                colDataValue.put("formula", formula);
            }
        }
    }

    private static void updateHeadCellValue(Map<String, Object> rowMap, List<Cell> cellList) {
        if (CollectionUtils.isEmpty(cellList)) {
            return;
        }
        for (Cell cell : cellList) {
            Map colMap = (Map)rowMap.get(Integer.toString(cell.getRow()));
            Map conditionLineMap = colMap.computeIfAbsent(Integer.toString(cell.getCol()), x -> new HashMap(1));
            conditionLineMap.put("value", cell.getValue());
            colMap.put(Integer.toString(cell.getCol()), conditionLineMap);
        }
    }

    private static void updateCellValue(Map<String, Object> rowMap, List<Cell> cellList) {
        if (CollectionUtils.isEmpty(cellList)) {
            return;
        }
        for (Cell cell : cellList) {
            Map colMap = (Map)rowMap.computeIfAbsent(Integer.toString(cell.getRow()), k -> new HashMap());
            Map conditionLineMap = colMap.computeIfAbsent(Integer.toString(cell.getCol()), x -> new HashMap(1));
            conditionLineMap.put("value", cell.getValue());
            AutoSubmitUtil.setLockStyle(conditionLineMap);
            colMap.put(Integer.toString(cell.getCol()), conditionLineMap);
        }
    }

    private static void setLockStyle(Map<String, Object> conditionLineMap) {
        conditionLineMap.put("locked", true);
        String styleString = "{\"backColor\":\"#E2E7EF\",\"font\":\"normal normal normal 12px Calibri\",\"borderLeft\":{\"color\":\"#D4D4D4\",\"style\":1},\"borderTop\":{\"color\":\"#D4D4D4\",\"style\":1},\"borderRight\":{\"color\":\"#D4D4D4\",\"style\":1},\"borderBottom\":{\"color\":\"#D4D4D4\",\"style\":1}}";
        Map styleMap = (Map)SerializationUtils.fromJsonString((String)styleString, Map.class);
        conditionLineMap.put("style", styleMap);
    }

    private static String getRetrunSpreadjsonTag(Map<String, Object> spreadMap) {
        String convertSpreadJson = SerializationUtils.toJsonString(spreadMap);
        String spreadjsonTag = SpreadUtils.convertCompressJson(convertSpreadJson);
        return spreadjsonTag;
    }

    private static void fillNumberByRule(DynamicObject history, long versionRuleId) {
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((Object)versionRuleId, (String)"phm_versionrule");
        Tuple<Date, Date> tuple = VersionRuleUtils.computePeriod(versionRule);
        Date previousTime = (Date)tuple.item1;
        Date nextTime = (Date)tuple.item2;
        history.set("starttime", (Object)previousTime);
        history.set("endtime", (Object)nextTime);
        history.set("number", (Object)VersionRuleUtils.getNumber(versionRule, previousTime, nextTime));
    }

    public static void manualUpdateAutoCreateResource(AutoSubmitParam autoSubmitParam, RequestContext requestContext) {
        RequestContext.copyAndSet((RequestContext)requestContext);
        AutoSubmitUtil.createProcessResource(autoSubmitParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createProcessResource(AutoSubmitParam autoSubmitParam) {
        DLock dLock = DLock.create((String)("auto.submit." + autoSubmitParam.getProcessHistoryId() + autoSubmitParam.getEntryNodeId() + autoSubmitParam.getResourceType() + autoSubmitParam.getResourceId()));
        if (!dLock.tryLock(5000L)) {
            return;
        }
        try (TXHandle h2 = TX.requiresNew();){
            try {
                if (!AutoSubmitUtil.existProcessResource(autoSubmitParam)) {
                    ProcessCalcLogService.clearErrorLog(ProcessErrorTypeEnum.AUTO_AUDIT_ERR.getValue(), autoSubmitParam.getProcessHistoryId(), autoSubmitParam.getEntryNodeId(), null, autoSubmitParam.getResourceId(), null);
                    AutoSubmitUtil.createResource(autoSubmitParam);
                }
            }
            catch (Exception e) {
                h2.markRollback();
                logger.error(e.getMessage());
                throw e;
            }
        }
        catch (Exception e) {
            new ProcessCalcLogService().insertErrorLog(ProcessErrorTypeEnum.AUTO_AUDIT_ERR, Objects.requireNonNull(DealTypeEnum.getDealTypeEnum(autoSubmitParam.getDealType())), autoSubmitParam, e);
        }
        finally {
            dLock.unlock();
        }
    }

    public static boolean existProcessResource(AutoSubmitParam autoSubmitParam) {
        QFilter qFilter = new QFilter("resource_processhistory", "=", (Object)autoSubmitParam.getProcessHistoryId());
        qFilter.and(new QFilter("entry_node", "=", (Object)autoSubmitParam.getEntryNodeId()));
        qFilter.and(new QFilter("resource_type", "=", (Object)autoSubmitParam.getResourceType()));
        qFilter.and(new QFilter("resource_number", "=", (Object)autoSubmitParam.getResourceId()));
        return QueryServiceHelper.exists((String)"phm_process_resources", (QFilter[])qFilter.toArray());
    }
}

