/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.enums.datatemp.DataResourceEnum;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.util.QueryUtils;
import kd.mmc.phm.common.util.datatemp.FixTempConfigParse;
import kd.mmc.phm.common.util.datatemp.TableLineConfigUnits;
import kd.mmc.phm.common.util.datatemp.TempDataHandleUtils;
import kd.mmc.phm.common.util.process.ExcelFormulaUtil;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;

public class AutoUpdateUtil {
    private static final Log LOG = LogFactory.getLog(AutoUpdateUtil.class);

    public static void updateConfigCell(Long tempId, Long processHistoryId, Long tempHistoryId, Long entryNodeId) {
        ArrayList list = Lists.newArrayList((Object[])new Long[]{tempHistoryId});
        DynamicObjectCollection tempHistoryData = AutoUpdateUtil.queryTempHistoryData(list);
        Long orgId = AutoUpdateUtil.queryDataOrgId(tempId, processHistoryId, tempHistoryId, entryNodeId);
        QFilter qFilter = new QFilter("id", "in", (Object)tempId);
        try (DataSet rows = ORM.create().queryDataSet("phm_queryTemp", "phm_billtemp", "id,tempclassify,tempconf,cellconf,realrow, number", qFilter.toArray());){
            for (Row row : rows) {
                LOG.info("[ProcessResourceAutoUpdate] number: {}, tempclassify: {}", (Object)row.getString("number"), (Object)row.getString("tempclassify"));
                if ("3".equals(row.getString("tempclassify"))) {
                    if (row.getLong("cellconf") == 0L) {
                        return;
                    }
                    List<DynamicObject> cellSet = AutoUpdateUtil.queryFixTempConfig(row.getLong("cellconf"));
                    if (CollectionUtils.isEmpty(cellSet)) {
                        return;
                    }
                    AutoUpdateUtil.updateFixTempData((List<DynamicObject>)tempHistoryData, cellSet, processHistoryId, entryNodeId, row.getString("number"), orgId);
                }
            }
        }
    }

    private static Long queryDataOrgId(Long tempId, Long processHistoryId, Long tempHistoryId, Long entryNodeId) {
        QFilter qFilter = new QFilter("entry_node", "=", (Object)entryNodeId);
        qFilter.and(new QFilter("resource_processhistory", "=", (Object)processHistoryId));
        qFilter.and(new QFilter("resource_data", "=", (Object)tempHistoryId));
        qFilter.and(new QFilter("resource_number", "=", (Object)tempId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"phm_queryDataOrgId", (String)"phm_process_resources", (String)"resource_org", (QFilter[])qFilter.toArray(), null);){
            if (dataSet.hasNext()) {
                Long l = dataSet.next().getLong("resource_org");
                return l;
            }
        }
        return null;
    }

    protected static List<Long> querySourceTempHistoryId(Set<Long> tempIds, Long processHistoryId, Long entryNodeId, Long orgId) {
        QFilter qFilter = new QFilter("resource_type", "=", (Object)"phm_billtemp");
        qFilter.and(new QFilter("resource_number", "in", tempIds));
        Set<Long> preNodeEntryIds = ProcessQueryUtil.queryPreNodeEntryId(processHistoryId, entryNodeId);
        if (!CollectionUtils.isEmpty(preNodeEntryIds)) {
            qFilter.and(new QFilter("entry_node", "in", preNodeEntryIds));
        }
        qFilter.and(new QFilter("resource_processhistory", "=", (Object)processHistoryId));
        qFilter.and(new QFilter("resource_status", "=", (Object)StatusEnum.AUDIT.getValue()));
        if (orgId != null && orgId != 0L) {
            qFilter.and(new QFilter("resource_org", "in", Arrays.asList(orgId, 0L)));
        }
        DynamicObjectCollection tempHistoryData = QueryServiceHelper.query((String)"phm_process_resources", (String)"resource_data", (QFilter[])qFilter.toArray());
        List<Long> tempHistoryId = tempHistoryData.stream().map(x -> x.getLong("resource_data")).collect(Collectors.toList());
        return tempHistoryId;
    }

    protected static DynamicObjectCollection queryTempHistoryData(List<Long> tempHistoryIdList) {
        QFilter qFilter = new QFilter("id", "in", tempHistoryIdList);
        DynamicObjectCollection tempHistoryData = ORM.create().query("phm_filldata_history", "id,spreadjson_tag,template", qFilter.toArray());
        return tempHistoryData;
    }

    public static List<DynamicObject> queryFixTempConfig(Long cellConfId) {
        DynamicObject billtempSet = BusinessDataServiceHelper.loadSingle((Object)cellConfId, (String)"phm_fixtpl_cellset");
        DynamicObjectCollection cellSetCollection = billtempSet.getDynamicObjectCollection("cellentryentity");
        return cellSetCollection.stream().filter(x -> "2".equals(x.getString("dataresource"))).collect(Collectors.toList());
    }

    private static void updateFixTempData(List<DynamicObject> tempDataList, List<DynamicObject> cellsetEntryEntity, Long processHistoryId, Long entryNodeId, String number, Long orgId) {
        HashSet<Long> tplIds = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : cellsetEntryEntity) {
            DynamicObjectCollection datatemps = dynamicObject.getDynamicObjectCollection("datatemps");
            for (DynamicObject datatemp : datatemps) {
                tplIds.add(datatemp.getLong("fbasedataid_id"));
            }
        }
        List<Long> sourceTempHistoryId = AutoUpdateUtil.querySourceTempHistoryId(tplIds, processHistoryId, entryNodeId, orgId);
        LOG.info("[ProcessResourceAutoUpdate] number: {}, sourceTempHistoryId: {}", (Object)number, sourceTempHistoryId);
        if (CollectionUtils.isEmpty(sourceTempHistoryId)) {
            return;
        }
        DynamicObjectCollection sourceTempHistoryData = AutoUpdateUtil.queryTempHistoryData(sourceTempHistoryId);
        Map<Long, Map<String, Object>> tempIdToDataMap = AutoUpdateUtil.getTempIdToDataMap(tempDataList);
        for (DynamicObject cellsetDynamicObject : cellsetEntryEntity) {
            String formula = cellsetDynamicObject.getString("formula");
            if (StringUtils.isBlank((CharSequence)formula)) continue;
            List<Long> sourceTplIds = cellsetDynamicObject.getDynamicObjectCollection("datatemps").stream().map(x -> x.getLong("fbasedataid_id")).distinct().collect(Collectors.toList());
            List spreadjsonTags = sourceTempHistoryData.stream().filter(x -> sourceTplIds.contains(x.getLong("template"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(spreadjsonTags)) {
                AutoUpdateUtil.updateCellValue(tempIdToDataMap, cellsetDynamicObject.getInt("cellrow"), cellsetDynamicObject.getInt("cellcol"), BigDecimal.ZERO);
                continue;
            }
            HashMap<Long, List<Map<String, Object>>> tempToTempRowDataMap = new HashMap<Long, List<Map<String, Object>>>(sourceTplIds.size());
            for (DynamicObject dataTemp : spreadjsonTags) {
                long templateId = dataTemp.getLong("template");
                if (!sourceTplIds.contains(templateId)) continue;
                List tempDatas = tempToTempRowDataMap.getOrDefault(templateId, new ArrayList(8));
                Map<String, Object> dataMap = TempDataHandleUtils.getRowMap(dataTemp.getString("spreadjson_tag"));
                tempDatas.add(dataMap);
                tempToTempRowDataMap.put(templateId, tempDatas);
            }
            Object resultObject = FixTempConfigParse.paraseAndCalculate(formula, tempToTempRowDataMap, cellsetDynamicObject, sourceTplIds);
            AutoUpdateUtil.updateCellValue(tempIdToDataMap, cellsetDynamicObject.getInt("cellrow"), cellsetDynamicObject.getInt("cellcol"), resultObject);
        }
        AutoUpdateUtil.updateHistoryData(tempIdToDataMap, tempDataList, null);
    }

    private static void updateNotFixTempData(List<DynamicObject> tempDataList, DynamicObjectCollection fieldentryentity, Long processHistoryId, Long entryNodeId, long targetTempConfigId, int realRow, String number, Long orgId) {
        List fieldformulaList = fieldentryentity.stream().filter(x -> DataResourceEnum.TEMP.getValue().equals(x.getString("dataresource"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fieldformulaList)) {
            return;
        }
        Set<Long> tplIds = fieldformulaList.stream().map(x -> x.getLong("datatpl_id")).collect(Collectors.toSet());
        List<Long> sourceTempHistoryId = AutoUpdateUtil.querySourceTempHistoryId(tplIds, processHistoryId, entryNodeId, orgId);
        LOG.info("[ProcessResourceAutoUpdate] number: {}, sourceTempHistoryId: {}", (Object)number, sourceTempHistoryId);
        if (CollectionUtils.isEmpty(sourceTempHistoryId)) {
            return;
        }
        Integer minLineStartRow = fieldentryentity.stream().filter(dynamicObject -> DataResourceEnum.TABLE.getValue().equals(dynamicObject.getString("dataresource")) && dynamicObject.getInt("startrow") > 0).map(dynamicObject -> dynamicObject.getInt("startrow") - 1).min(Integer::compareTo).orElse(realRow);
        int calcuateStartRow = Math.min(minLineStartRow, realRow);
        LOG.info("[ProcessResourceAutoUpdate] number: {}, calcuateStartRow: {}, minLineStartRow: {}, realRow: {}", new Object[]{number, calcuateStartRow, minLineStartRow, realRow});
        DynamicObjectCollection sourceTempHistoryData = AutoUpdateUtil.queryTempHistoryData(sourceTempHistoryId);
        Map<Long, Object> templateId2RealRow = QueryUtils.getId2PropertyValueForSingle("phm_billtemp", tplIds, "realrow");
        Map<Long, Map<String, Object>> tempIdToDataMap = AutoUpdateUtil.getTempIdToDataMap(tempDataList);
        for (DynamicObject dynamicObject2 : fieldformulaList) {
            Long templatId = dynamicObject2.getLong("datatpl_id");
            List<String> spreadjsonTags = sourceTempHistoryData.stream().filter(x -> templatId.equals(x.getLong("template"))).map(x -> x.getString("spreadjson_tag")).collect(Collectors.toList());
            int templateRow = (Integer)templateId2RealRow.getOrDefault(templatId, 0);
            List<Map<String, Object>> sourceRowMapList = TempDataHandleUtils.getRowDatas(spreadjsonTags);
            int lineStartRow = dynamicObject2.getInt("startrow") - 1;
            int format = dynamicObject2.getInt("format");
            String expressionAll = dynamicObject2.getString("fieldformula");
            String[] strings = TableLineConfigUnits.getColIndexAndFieldType(expressionAll, targetTempConfigId);
            int sourceIndex = TableLineConfigUnits.getSourceIndex(expressionAll);
            String[] formulaSplit = expressionAll.split("&");
            String formula = formulaSplit[1];
            int startRow = AutoUpdateUtil.getStartRow(dynamicObject2, realRow);
            for (Map.Entry<Long, Map<String, Object>> longMapEntry : tempIdToDataMap.entrySet()) {
                Map sheets = (Map)longMapEntry.getValue().get("sheets");
                Map sheetMap = (Map)sheets.get("Sheet1");
                Map data = (Map)sheetMap.get("data");
                Map rowMapList = data.getOrDefault("dataTable", Collections.emptyMap());
                for (Map.Entry entry : rowMapList.entrySet()) {
                    Map conditionLineMap;
                    int row = Integer.parseInt((String)entry.getKey());
                    if (row < calcuateStartRow) continue;
                    Object resultObject = null;
                    Map colMap = (Map)entry.getValue();
                    if (!CollectionUtils.isEmpty(sourceRowMapList) && (conditionLineMap = (Map)colMap.get(strings[0])) != null) {
                        Object filterData = conditionLineMap.get("value");
                        resultObject = TableLineConfigUnits.paraseAndCalculate(sourceIndex, formula, sourceRowMapList, filterData, templateRow, format);
                    }
                    int lineIndex = dynamicObject2.getInt("cellcol");
                    Map updateMap = (Map)colMap.get(Integer.toString(lineIndex));
                    updateMap.put("value", resultObject);
                }
            }
        }
        HashMap<Integer, String> colIndexToFieldTypeMap = new HashMap<Integer, String>(16);
        AutoUpdateUtil.updateHistoryData(tempIdToDataMap, tempDataList, colIndexToFieldTypeMap);
    }

    private static int getStartRow(DynamicObject fieldformula, int realRow) {
        int startRow = fieldformula.getInt("startrow") - 1;
        if (startRow == -1) {
            startRow = realRow;
        }
        return startRow;
    }

    private static Map<Long, Map<String, Object>> getTempIdToDataMap(List<DynamicObject> tempDataList) {
        HashMap<Long, Map<String, Object>> tempIdToDataMap = new HashMap<Long, Map<String, Object>>(tempDataList.size());
        for (DynamicObject dynamicObject : tempDataList) {
            String spreadjsonTag = dynamicObject.getString("spreadjson_tag");
            String convertSpreadJson = SpreadUtils.convertSpreadJson(spreadjsonTag);
            Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, Map.class);
            tempIdToDataMap.put(dynamicObject.getLong("id"), spreadMap);
        }
        return tempIdToDataMap;
    }

    private static void updateCellValue(Map<Long, Map<String, Object>> tempIdToDataMap, int row, int col, Object resultObject) {
        for (Map.Entry<Long, Map<String, Object>> longMapEntry : tempIdToDataMap.entrySet()) {
            Map sheets = (Map)longMapEntry.getValue().get("sheets");
            Map sheetMap = (Map)sheets.get("Sheet1");
            Map data = (Map)sheetMap.get("data");
            Map rowMapList = data.getOrDefault("dataTable", Collections.emptyMap());
            Map colMap = (Map)rowMapList.get(Integer.toString(row));
            Map conditionMap = (Map)colMap.get(Integer.toString(col));
            conditionMap.put("value", resultObject);
        }
    }

    private static void updateHistoryData(Map<Long, Map<String, Object>> tempIdToDataMap, List<DynamicObject> tempDataList, Map<Integer, String> colIndexToFieldTypeMap) {
        DynamicObject[] updata = new DynamicObject[tempDataList.size()];
        for (int i = 0; i < tempDataList.size(); ++i) {
            DynamicObject dynamicObject = tempDataList.get(0);
            Map<String, Object> stringObjectMap = tempIdToDataMap.get(dynamicObject.getLong("id"));
            AutoUpdateUtil.formulaEvaluator(stringObjectMap, colIndexToFieldTypeMap);
            String convertSpreadJson = SerializationUtils.toJsonString(stringObjectMap);
            String spreadjsonTag = SpreadUtils.convertCompressJson(convertSpreadJson);
            dynamicObject.set("spreadjson_tag", (Object)spreadjsonTag);
            dynamicObject.set("modifytime", (Object)new Date());
            updata[i] = dynamicObject;
        }
        SaveServiceHelper.update((DynamicObject[])updata);
    }

    public static void formulaEvaluator(Map<String, Object> spreadData, Map<Integer, String> colIndexToFieldTypeMap) {
        Map sheets = (Map)spreadData.get("sheets");
        Map sheetMap = (Map)sheets.get("Sheet1");
        Map data = (Map)sheetMap.get("data");
        Map<String, Object> rowMap = data.getOrDefault("dataTable", Collections.emptyMap());
        ExcelFormulaUtil.executeFormula(rowMap);
    }
}

