/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.spread.SpreadUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelFormulaUtil {
    private static final Log LOG = LogFactory.getLog(ExcelFormulaUtil.class);
    private static final Pattern PATTERN = Pattern.compile("^\\d+\\.?\\d*%$");

    public static void executeFormula(Map<String, Object> rowDataMap) {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            XSSFSheet sheet = workbook.createSheet();
            List<Cell> formualCells = ExcelFormulaUtil.setOrGetFormulaCell(rowDataMap, sheet, true);
            if (formualCells.isEmpty()) {
                return;
            }
            XSSFFormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
            for (Cell formualCell : formualCells) {
                CellValue cellValue = formulaEvaluator.evaluate(formualCell);
                int row = formualCell.getRowIndex();
                int col = formualCell.getColumnIndex();
                if (cellValue.getCellType() == CellType.ERROR) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884cExcel\u516c\u5f0f\u5931\u8d25: %s, formula: %s, row: %d, col: %d", (String)"ExcelFormulaUtil_0", (String)"mmc-phm-common", (Object[])new Object[0]), cellValue.toString(), formualCell.toString(), row, col));
                }
                Map rowData = (Map)rowDataMap.get(Integer.toString(row));
                Map colData = (Map)rowData.get(Integer.toString(col));
                colData.put("value", ExcelFormulaUtil.getValue(cellValue));
            }
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, PHMErrorCode.bizException, new Object[]{ResManager.loadKDString((String)"\u540e\u53f0\u66f4\u65b0Spread\u6570\u636e\u5931\u8d25: ", (String)"ExcelFormulaUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]) + exception.getMessage()});
        }
    }

    private static List<Cell> setOrGetFormulaCell(Map<String, Object> rowDataMap, XSSFSheet sheet, boolean returnFormulaCell) throws ParseException, NoSuchFieldException, IllegalAccessException {
        ArrayList<Cell> formualCells = returnFormulaCell ? new ArrayList<Cell>() : Collections.emptyList();
        ArrayList<CellRangeAddress> cellRangeAddressList = new ArrayList<CellRangeAddress>();
        for (Map.Entry<String, Object> rowData : rowDataMap.entrySet()) {
            int rowIndex = Integer.parseInt(rowData.getKey());
            XSSFRow row = sheet.createRow(rowIndex);
            Map colMap = (Map)rowData.getValue();
            for (Map.Entry colData : colMap.entrySet()) {
                Map colDataValue = (Map)colData.getValue();
                Object value = colDataValue.get("value");
                String formula = (String)colDataValue.get("formula");
                int colIndex = Integer.parseInt((String)colData.getKey());
                XSSFCell cell = row.createCell(colIndex);
                if (formula != null) {
                    String formatRef;
                    cell.setCellFormula(formula);
                    if (StringUtils.startsWithIgnoreCase((CharSequence)formula, (CharSequence)"SUMPRODUCT") && StringUtils.isNotBlank((CharSequence)(formatRef = ExcelFormulaUtil.getFormatRef(formula)))) {
                        cell.getCTCell().getF().setRef(formatRef);
                        cellRangeAddressList.add(new CellRangeAddress(rowIndex, rowIndex, colIndex, colIndex));
                    }
                    if (!returnFormulaCell) continue;
                    formualCells.add((Cell)cell);
                    continue;
                }
                if (value == null) continue;
                String valueStr = String.valueOf(value);
                if (value instanceof Number) {
                    cell.setCellValue(new BigDecimal(valueStr).doubleValue());
                    continue;
                }
                if (valueStr.endsWith("%") && ExcelFormulaUtil.isPercentage(valueStr)) {
                    cell.setCellValue(((Double)NumberFormat.getPercentInstance().parse(valueStr)).doubleValue());
                    continue;
                }
                cell.setCellValue(valueStr);
            }
        }
        if (!cellRangeAddressList.isEmpty()) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass("kd.bos.filter.SchemeFilterColumn");
                Field arrayFormulas = clazz.getDeclaredField("arrayFormulas");
                AccessibleObject[] colorAcce = new AccessibleObject[]{arrayFormulas};
                AccessibleObject.setAccessible(colorAcce, true);
                arrayFormulas.set(sheet, cellRangeAddressList);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return formualCells;
    }

    public static Map<String, Object> getCellData(Map<String, Object> rowDataMap, List<String> posList) {
        if (rowDataMap == null) {
            LOG.error(ResManager.loadKDString((String)"excel\u83b7\u53d6\u516c\u5f0f\u8ba1\u7b97\u503c\u4f20\u5165excel\u6570\u636e\u53c2\u6570\u4e3a\u7a7a", (String)"ExcelFormulaUtil_2", (String)"mmc-phm-common", (Object[])new Object[0]));
            return null;
        }
        if (CollectionUtils.isEmpty(posList)) {
            LOG.error(ResManager.loadKDString((String)"excel\u83b7\u53d6\u516c\u5f0f\u8ba1\u7b97\u503c\u4f20\u5165\u5750\u6807\u53c2\u6570\u4e3a\u7a7a", (String)"ExcelFormulaUtil_3", (String)"mmc-phm-common", (Object[])new Object[0]));
            return null;
        }
        ArrayList newPosList = Lists.newArrayList(posList);
        LOG.info(ResManager.loadKDString((String)"excel\u83b7\u53d6\u516c\u5f0f\u8ba1\u7b97\u503c\u4f20\u5165\u5750\u6807\u53c2\u6570: ", (String)"ExcelFormulaUtil_4", (String)"mmc-phm-common", (Object[])new Object[0]) + newPosList);
        HashMap retrunData = Maps.newHashMapWithExpectedSize((int)newPosList.size());
        Iterator iterator = newPosList.iterator();
        while (iterator.hasNext()) {
            String pos = (String)iterator.next();
            int row = SpreadUtils.pos2Y(pos);
            Map rowData = (Map)rowDataMap.get(Integer.toString(row));
            if (rowData == null) {
                retrunData.put(pos, pos + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u884c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5750\u6807\u503c\u3002", (String)"ExcelFormulaUtil_5", (String)"mmc-phm-common", (Object[])new Object[0]));
                continue;
            }
            int col = SpreadUtils.pos2X(pos);
            Map colData = (Map)rowData.get(Integer.toString(col));
            if (colData == null) {
                retrunData.put(pos, pos + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5217\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5750\u6807\u503c\u3002", (String)"ExcelFormulaUtil_6", (String)"mmc-phm-common", (Object[])new Object[0]));
                continue;
            }
            Object value = colData.get("value");
            if (value == null) continue;
            iterator.remove();
            retrunData.put(pos, value);
        }
        if (!newPosList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                XSSFSheet sheet = workbook.createSheet();
                ExcelFormulaUtil.setOrGetFormulaCell(rowDataMap, sheet, false);
                XSSFFormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
                for (String pos : newPosList) {
                    int row = SpreadUtils.pos2Y(pos);
                    XSSFRow xssfRow = sheet.getRow(row);
                    if (xssfRow == null) {
                        retrunData.put(pos, pos + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u884c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5750\u6807\u503c\u3002", (String)"ExcelFormulaUtil_5", (String)"mmc-phm-common", (Object[])new Object[0]));
                        continue;
                    }
                    int col = SpreadUtils.pos2X(pos);
                    XSSFCell cell = xssfRow.getCell(col);
                    if (cell == null) {
                        retrunData.put(pos, pos + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5217\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5750\u6807\u503c\u3002", (String)"ExcelFormulaUtil_6", (String)"mmc-phm-common", (Object[])new Object[0]));
                        continue;
                    }
                    CellValue cellValue = formulaEvaluator.evaluate((Cell)cell);
                    if (cellValue.getCellType() == CellType.ERROR) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884cExcel\u516c\u5f0f\u5931\u8d25: %s, formula: %s, row: %d, col: %d", (String)"ExcelFormulaUtil_0", (String)"mmc-phm-common", (Object[])new Object[0]), cellValue.toString(), cell.toString(), row, col));
                    }
                    retrunData.put(pos, ExcelFormulaUtil.getValue(cellValue));
                }
            }
            catch (Exception exception) {
                throw new KDBizException((Throwable)exception, PHMErrorCode.bizException, new Object[]{ResManager.loadKDString((String)"\u540e\u53f0\u66f4\u65b0Spread\u6570\u636e\u5931\u8d25: ", (String)"ExcelFormulaUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]) + exception.getMessage()});
            }
        }
        LOG.info(ResManager.loadKDString((String)"excel\u83b7\u53d6\u516c\u5f0f\u8ba1\u7b97\u503c\u8fd4\u56de\u7ed3\u679c: ", (String)"ExcelFormulaUtil_7", (String)"mmc-phm-common", (Object[])new Object[0]) + retrunData);
        return retrunData;
    }

    public static String getFormatRef(String formula) {
        int multily = formula.indexOf(42);
        if (multily == -1) {
            return null;
        }
        int equ = formula.indexOf(61);
        equ = equ == -1 ? multily : equ;
        String substring = formula.substring(0, equ);
        int left = substring.lastIndexOf(40);
        int right = substring.indexOf(41);
        right = right == -1 ? substring.length() : right;
        return substring.substring(left + 1, right);
    }

    public static Object getValue(CellValue cellValue) {
        if (cellValue.getCellType() == CellType.NUMERIC) {
            return new BigDecimal(String.valueOf(cellValue.getNumberValue()));
        }
        if (cellValue.getCellType() == CellType.BOOLEAN) {
            return cellValue.getBooleanValue();
        }
        return cellValue.getStringValue();
    }

    public static boolean isPercentage(String text) {
        return PATTERN.matcher(text).matches();
    }
}

