/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.ResourceTypeEnum;
import kd.mmc.phm.common.enums.RunningState;

public class ProcessHistoryUtil {
    public static void updateDiffField(DynamicObject processHistory) {
        long processId = processHistory.getLong("flowdefine_id");
        long processParentId = processHistory.getLong("parentid");
        if (processId == 0L) {
            return;
        }
        Date date = processHistory.getDate("createtime");
        if (processParentId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)processParentId);
            DynamicObject processParent = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"createtime", (QFilter[])new QFilter[]{qFilter});
            date = processParent == null ? date : processParent.getDate("createtime");
        }
        long processHistoryId = processHistory.getLong("id");
        Map<String, DynamicObject> existsDiffs = ProcessHistoryUtil.getProcessUpdateDiffs(processHistoryId);
        List<DynamicObject> processDataUpdateDiff = ProcessHistoryUtil.resourceDataUpdataDiff(processHistoryId, date);
        if (processDataUpdateDiff == null || processDataUpdateDiff.isEmpty()) {
            return;
        }
        for (int i = 0; i < processDataUpdateDiff.size(); ++i) {
            DynamicObject oldDiff;
            DynamicObject diff = processDataUpdateDiff.get(i);
            String number = diff.getString("billno");
            DynamicObject dynamicObject = oldDiff = existsDiffs == null ? null : existsDiffs.get(number);
            if (oldDiff == null) continue;
            processDataUpdateDiff.set(i, oldDiff);
            existsDiffs.remove(number);
        }
        if (existsDiffs != null && !existsDiffs.isEmpty()) {
            Object[] pks = existsDiffs.values().stream().map(x -> x.get("id")).toArray();
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"phm_process_updatediff"), (Object[])pks);
        }
        Map<String, List<DynamicObject>> processDataDiffTableMap = processDataUpdateDiff.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject("datatable").getString("number")));
        Map<String, List<DynamicObject>> tableDiffMap = ProcessHistoryUtil.getTableDiffs(processDataDiffTableMap.keySet());
        ArrayList saveList = new ArrayList();
        ArrayList updateList = new ArrayList();
        for (Map.Entry<String, List<DynamicObject>> entry : processDataDiffTableMap.entrySet()) {
            String tableName = StringUtils.upperCase((String)entry.getKey());
            List<DynamicObject> fieldsDiff = entry.getValue();
            List<DynamicObject> fieldsChanges = tableDiffMap == null ? null : tableDiffMap.get(tableName);
            HashMap fieldsChangeMap = new HashMap(4);
            if (fieldsChanges != null && !fieldsChanges.isEmpty()) {
                fieldsChanges.forEach(x -> fieldsChangeMap.put(StringUtils.upperCase((String)x.getString("field")), x));
            }
            fieldsDiff.forEach(x -> {
                long id = x.getLong("id");
                if (id == 0L) {
                    saveList.add(x);
                } else {
                    updateList.add(x);
                }
                String fieldNumber = StringUtils.upperCase((String)x.getString("tablefield"));
                DynamicObject tableFieldDiff = (DynamicObject)fieldsChangeMap.get(fieldNumber);
                if (tableFieldDiff == null) {
                    return;
                }
                Date processFieldModifyDate = x.getDate("modifydate");
                Date tableFieldModifyDate = tableFieldDiff.getDate("modifydate");
                if (tableFieldModifyDate.getTime() > processFieldModifyDate.getTime()) {
                    x.set("latest", (Object)"0");
                }
            });
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, List<DynamicObject>> getTableDiffs(Set<String> tableNames) {
        QFilter qFilter = new QFilter("tablename", "in", tableNames);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"phm_table_difference", (String)"tablename,entryentity.field field,entryentity.modifydate modifydate", (QFilter[])qFilter.toArray());
        if (dynamicObjects == null) {
            return null;
        }
        return dynamicObjects.stream().collect(Collectors.groupingBy(item -> StringUtils.upperCase((String)item.getString(0))));
    }

    private static Map<String, DynamicObject> getProcessUpdateDiffs(Long processHistoryId) {
        QFilter filter = new QFilter("processhistory", "=", (Object)processHistoryId);
        StringJoiner selectFields = new StringJoiner(",");
        selectFields.add("id").add("billno").add("latest");
        selectFields.add("processhistory").add("datatable").add("tablefield").add("modifydate");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"phm_process_updatediff", (String)selectFields.toString(), (QFilter[])filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.put(dynamicObject.getString("billno"), dynamicObject);
        }
        return map;
    }

    private static Map<Long, DynamicObject> getDataTempConfIds(List<Long> dataTempIds) {
        QFilter qFilter = new QFilter("id", "in", dataTempIds);
        HashMap tempConfMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"phm_billtemp", (String)"id,number,tempconf", (QFilter[])qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return null;
        }
        dynamicObjects.forEach(x -> {
            long tempConfId = x.getLong(2);
            if (tempConfId != 0L) {
                tempConfMap.put(tempConfId, x);
            }
        });
        return tempConfMap;
    }

    private static List<DynamicObject> resourceDataUpdataDiff(Long processHistoryId, Date date) {
        List<Long> dataTempIds = ProcessHistoryUtil.getProcessDataTempResources(processHistoryId);
        Map<Long, DynamicObject> tempConfIds = ProcessHistoryUtil.getDataTempConfIds(dataTempIds);
        if (tempConfIds == null) {
            return null;
        }
        DynamicObject[] tempConfs = ProcessHistoryUtil.getDataTempConf(tempConfIds.keySet());
        if (tempConfs == null || tempConfs.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> processDataDiffs = new ArrayList<DynamicObject>(16);
        HashSet<String> billNos = new HashSet<String>();
        for (DynamicObject tempConf : tempConfs) {
            if (tempConf == null) continue;
            Long tempConfId = tempConf.getLong("id");
            DynamicObject resourceObj = tempConfIds.get(tempConfId);
            Long resourceId = resourceObj == null ? 0L : resourceObj.getLong("id");
            String resourceNumber = resourceObj == null ? "" : resourceObj.getString("number");
            DynamicObjectCollection columnConfs = tempConf.getDynamicObjectCollection("fieldentryentity");
            if (columnConfs == null || columnConfs.isEmpty()) continue;
            for (DynamicObject columnConf : columnConfs) {
                DynamicObject dataTable = columnConf.getDynamicObject("datatable");
                String tableName = dataTable == null ? "" : dataTable.getString("number");
                String tableField = columnConf.getString("fieldnumber");
                String billNo = resourceNumber + "_" + tableName + "_" + tableField;
                if (billNos.contains(billNo)) continue;
                billNos.add(billNo);
                boolean isIndexValue = "2".equals(columnConf.getString("fieldlogic"));
                if (!isIndexValue) continue;
                DynamicObject processDataDiff = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_updatediff"));
                processDataDiff.set("billno", (Object)billNo);
                processDataDiff.set("processhistory", (Object)processHistoryId);
                processDataDiff.set("resourcetype", (Object)ResourceTypeEnum.DATETEMP.getValue());
                processDataDiff.set("resource_id", (Object)resourceId);
                processDataDiff.set("datatable", columnConf.get("datatable"));
                processDataDiff.set("tablefield", (Object)tableField);
                processDataDiff.set("tablefieldname", columnConf.get("fieldname"));
                processDataDiff.set("fieldtype", columnConf.get("fieldlogic"));
                processDataDiff.set("modifydate", (Object)date);
                processDataDiff.set("latest", (Object)"1");
                processDataDiffs.add(processDataDiff);
            }
        }
        return processDataDiffs;
    }

    private static List<Long> getProcessDataTempResources(Long processId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select c.fresourceid  from t_phm_process_history a left join  t_phm_process_node b on a.fid =b.fid  left  join  t_phm_node_resource c  on b.fentryid = c.fentryid ", new Object[0]);
        sqlBuilder.append("where a.fid = ? and c.ftype = ?", new Object[]{processId, ResourceTypeEnum.DATETEMP.getValue()});
        ArrayList dataTempIds = Lists.newArrayListWithCapacity((int)10);
        try (DataSet ds = DB.queryDataSet((String)"ProcessDataUpdateOp", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                dataTempIds.add(row.getLong(0));
            }
        }
        return dataTempIds;
    }

    private static DynamicObject[] getDataTempConf(Collection<Long> tempConfIds) {
        QFilter qFilter = new QFilter("id", "in", tempConfIds);
        QFilter qFilter1 = new QFilter("fieldentryentity.dataresource", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("fieldentryentity.fieldlogic", "=", (Object)"2");
        return BusinessDataServiceHelper.load((String)"phm_billtemp_set", (String)"id,fieldentryentity.cellcol,fieldentryentity.dataresource,fieldentryentity.datatable,fieldentryentity.fieldnumber,fieldentryentity.fieldname,fieldentryentity.fieldtype,fieldentryentity.fieldlogic,fieldentryentity.startrow", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
    }

    public static void defaultCopyProcessHistory(long processHistoryId) {
        DynamicObject processHistory = BusinessDataServiceHelper.loadSingle((Object)processHistoryId, (String)"phm_process_history");
        String number = processHistory.getString("number") + "-0";
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        qFilter.and("parent", "=", (Object)processHistoryId);
        DynamicObject defaultCopy = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"id", (QFilter[])qFilter.toArray());
        if (defaultCopy != null) {
            return;
        }
        ProcessHistoryUtil.copyProcessHistory(processHistory, processHistoryId, number);
    }

    public static void copyProcessHistory(long processHistoryId, long parentId) {
        DynamicObject processHistory = BusinessDataServiceHelper.loadSingle((Object)processHistoryId, (String)"phm_process_history");
        processHistory.set("copystatus", processHistory.get("status"));
        long copyId = ID.genLongId();
        DynamicObject processHistoryCopy = (DynamicObject)OrmUtils.clone((Object)processHistory, (IDataEntityType)processHistory.getDataEntityType(), (boolean)false, (boolean)true);
        processHistoryCopy.set("id", (Object)copyId);
        processHistoryCopy.set("exceptiondesc", null);
        String number = processHistory.getString("number");
        if (processHistoryId != parentId) {
            DynamicObject parentProcessHistory = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
            number = parentProcessHistory.getString("number");
        }
        QFilter qFilter = new QFilter("parentid", "=", (Object)parentId);
        qFilter.and("number", "!=", (Object)(number + "-0"));
        DynamicObjectCollection id = QueryServiceHelper.query((String)"phm_process_history", (String)"id", (QFilter[])qFilter.toArray());
        int copyNo = id.size() + 1;
        ProcessHistoryUtil.copyProcessHistory(processHistory, parentId, number + "-" + copyNo);
    }

    public static void copyProcessHistory(DynamicObject processHistory, long parentId, String number) {
        processHistory.set("copystatus", processHistory.get("status"));
        long copyId = ID.genLongId();
        DynamicObject processHistoryCopy = (DynamicObject)OrmUtils.clone((Object)processHistory, (IDataEntityType)processHistory.getDataEntityType(), (boolean)false, (boolean)true);
        processHistoryCopy.set("id", (Object)copyId);
        processHistoryCopy.set("exceptiondesc", null);
        processHistoryCopy.set("number", (Object)number);
        processHistoryCopy.set("parentid", (Object)parentId);
        DynamicObjectCollection nodeCollection = processHistoryCopy.getDynamicObjectCollection("entryentity");
        ArrayList<Long> resourceIdList = new ArrayList<Long>();
        for (DynamicObject nodeEntry : nodeCollection) {
            DynamicObjectCollection resourceEntity = nodeEntry.getDynamicObjectCollection("subentryentity_resources");
            for (DynamicObject resource : resourceEntity) {
                resourceIdList.add(resource.getLong("resource_data_id"));
            }
        }
        HashMap resourceIdMap = new HashMap(resourceIdList.size());
        if (!CollectionUtils.isEmpty(resourceIdList)) {
            long[] newIds = ID.genLongIds((int)resourceIdList.size());
            for (int i = 0; i < resourceIdList.size(); ++i) {
                resourceIdMap.put(resourceIdList.get(i), newIds[i]);
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        for (DynamicObject nodeEntry : nodeCollection) {
            nodeEntry.set("subentryentity_task", null);
            nodeEntry.set("subentryentity_event", null);
            DynamicObjectCollection resourceEntity = nodeEntry.getDynamicObjectCollection("subentryentity_resources");
            for (DynamicObject resource : resourceEntity) {
                resource.set("resource_modifier", (Object)userId);
                resource.set("resource_modifytime", (Object)new Date());
                Long oldResourceId = resource.getLong("resource_data_id");
                resource.set("resource_data_id", resourceIdMap.get(oldResourceId));
                resource.set("resource_processhistory_id", (Object)copyId);
                resource.set("resource_data", resource.get("resource_number"));
            }
        }
        processHistoryCopy.set("createtime", (Object)new Date());
        if (!CollectionUtils.isEmpty(resourceIdList)) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"phm_filldata_history");
            DynamicObject[] resourceHistoryList = BusinessDataServiceHelper.load((Object[])resourceIdList.toArray(), (DynamicObjectType)dt);
            DynamicObject[] resourceCopyList = new DynamicObject[resourceHistoryList.length];
            for (int i = 0; i < resourceHistoryList.length; ++i) {
                DynamicObject dynamicObject = resourceHistoryList[i];
                Long resourceId = dynamicObject.getLong("id");
                DynamicObject resourceCopy = (DynamicObject)OrmUtils.clone((Object)dynamicObject, (IDataEntityType)dynamicObject.getDataEntityType(), (boolean)false, (boolean)true);
                resourceCopy.set("id", resourceIdMap.get(resourceId));
                resourceCopy.set("createtime", (Object)new Date());
                resourceCopy.set("modifytime", (Object)new Date());
                resourceCopy.set("creator", (Object)userId);
                resourceCopy.set("modifier", (Object)userId);
                resourceCopyList[i] = resourceCopy;
            }
            SaveServiceHelper.save((DynamicObject[])resourceCopyList);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{processHistoryCopy});
    }

    public static int countUpatingNodes(long processHistoryId) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("historyid", "=", (Object)processHistoryId);
        qFilter.and(new QFilter("node_status", "=", (Object)RunningState.AUTO.getValue()));
        return orm.count("ProcessDataUpdateValidator", "phm_process_node", qFilter.toArray());
    }
}

