/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.WorkbenchSubType;
import kd.mmc.phm.common.util.process.TaskProgressUtil;

public class ProcessQueryUtil {
    public static Set<Long> queryNodeResourceByRole(List<Object> roleIdObjectList, String processNodeId, Long process) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t1.fresourceid from t_phm_flowresource t1 , t_phm_flownode t2 , t_phm_resourecrole t3 ", new Object[0]);
        sqlBuilder.append("where t1.fresourcetype = ? ", new Object[]{"phm_billtemp"});
        sqlBuilder.append("and t1.fentryid = t2.fentryid and t2.fnodeid = ? and t2.fid = ? ", new Object[]{processNodeId, process});
        sqlBuilder.append("and t1.fdetailid = t3.fdetailid and", new Object[0]);
        sqlBuilder.appendIn("t3.fbasedataid", roleIdObjectList);
        sqlBuilder.append("and t1.fdealtype = ?", new Object[]{DealTypeEnum.MANUAL.getName()});
        HashSet<Long> resourceIds = new HashSet<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"queryNodeRoesource", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                resourceIds.add(row.getLong(0));
            }
        }
        return resourceIds;
    }

    public static boolean queryNodeFinish(Long nodeEntryID) {
        QFilter filter = new QFilter("entry_node", "=", (Object)nodeEntryID);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"phm_process_task", (String)"task_control,taskprogress", (QFilter[])filter.toArray());
        boolean isFinish = true;
        for (DynamicObject task : tasks) {
            String taskprogress;
            if (!task.getBoolean("task_control") || TaskProgressUtil.validationProgress(taskprogress = task.getString("taskprogress"))) continue;
            isFinish = false;
            break;
        }
        return isFinish;
    }

    public static DynamicObject queryNodeFirstEvent(Long nodeId) {
        QFilter qFilter = new QFilter("entry_node", "=", (Object)nodeId);
        qFilter.and(new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{WorkbenchSubType.EVENT_PROCESSING.getValue(), WorkbenchSubType.EVENT_UNPROCESSED.getValue()})));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"phm_process_event", (String)"nodestatus,statuschange", (QFilter[])qFilter.toArray(), (String)"createtime");
        if (query == null || query.size() == 0) {
            return null;
        }
        return (DynamicObject)query.get(0);
    }

    public static String getNodeOrginStatus(Long nodeId) {
        QFilter qFilter = new QFilter("event_startnodeid", "=", (Object)nodeId);
        qFilter.or(new QFilter("entry_node", "=", (Object)nodeId));
        qFilter.and(new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{WorkbenchSubType.EVENT_PROCESSING.getValue(), WorkbenchSubType.EVENT_UNPROCESSED.getValue()})));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"phm_process_event", (String)"nodestatus,targetnodestatus,entry_node,event_startnodeid", (QFilter[])qFilter.toArray(), (String)"createtime");
        if (query == null || query.size() == 0) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)query.get(0);
        if (nodeId.equals(dynamicObject.getLong("event_startnodeid"))) {
            return dynamicObject.getString("nodestatus");
        }
        return dynamicObject.getString("targetnodestatus");
    }

    public static DynamicObjectCollection queryNodeEntry(Long processHistoryId) {
        QFilter qFilter = new QFilter("historyid", "=", (Object)processHistoryId);
        DynamicObjectCollection nodeEntryList = QueryServiceHelper.query((String)"phm_process_node", (String)"id,nodeid,prenodeids,nextnodeids", (QFilter[])qFilter.toArray());
        return nodeEntryList;
    }

    public static Long queryDefindFlow(Long processHistoryId) {
        QFilter qFilter = new QFilter("id", "=", (Object)processHistoryId);
        DynamicObject nodeEntry = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"flowdefine", (QFilter[])qFilter.toArray());
        if (nodeEntry != null) {
            return nodeEntry.getLong("flowdefine");
        }
        return 0L;
    }

    public static Set<Long> queryPreNodeEntryId(Long processHistoryId, Long currentNodeEntryId) {
        DynamicObjectCollection nodeEntryCollection = ProcessQueryUtil.queryNodeEntry(processHistoryId);
        HashSet<Long> preNodeEntryIdSet = new HashSet<Long>();
        preNodeEntryIdSet.add(currentNodeEntryId);
        DynamicObject currentNodeEntry = nodeEntryCollection.stream().filter(x -> currentNodeEntryId.equals(x.getLong("id"))).findFirst().get();
        ProcessQueryUtil.recursionPreNode(currentNodeEntry, nodeEntryCollection, preNodeEntryIdSet);
        return preNodeEntryIdSet;
    }

    private static void recursionPreNode(DynamicObject currentNodeEntry, DynamicObjectCollection NodeEntryCollection, Set<Long> preNodeEntryIdSet) {
        String preNodeIds = currentNodeEntry.getString("prenodeids");
        if (StringUtils.isNotBlank((CharSequence)preNodeIds)) {
            List preNodeIdList = SerializationUtils.fromJsonStringToList((String)preNodeIds, String.class);
            for (String preNodeId : preNodeIdList) {
                DynamicObject preNodeEntry = NodeEntryCollection.stream().filter(x -> preNodeId.equals(x.getString("nodeid"))).findFirst().get();
                if (preNodeEntry == null) continue;
                preNodeEntryIdSet.add(preNodeEntry.getLong("id"));
                ProcessQueryUtil.recursionPreNode(preNodeEntry, NodeEntryCollection, preNodeEntryIdSet);
            }
        }
    }
}

