/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.AutoSubmitParam;
import kd.mmc.phm.common.domian.process.AutoSubmitScheduleParam;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessResourceSourceEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.enums.TaskStatusEnum;
import kd.mmc.phm.common.util.FlowActiveUtil;
import kd.mmc.phm.common.util.process.AutoSubmitUtil;
import kd.mmc.phm.common.util.process.ProcessHistoryUtil;
import kd.mmc.phm.common.util.process.TaskProgressUtil;
import org.apache.commons.lang3.time.DateUtils;

public class ProcessUpdateUtil {
    private static final Log log = LogFactory.getLog((String)"ProcessUpdateUtil");

    public static void createNextNodeTask(Long nodeEntryId, Long processHistroyId, Long processId, DynamicObjectCollection nodeEntryList) {
        log.info("\u4e0b\u4e00\u8282\u70b9\u751f\u6210\u8282\u70b9\u4efb\u52a1,nodeEntryId:" + nodeEntryId + ",processHistroyId:" + processHistroyId + ",processId:" + processId);
        DynamicObject nodeEntry = nodeEntryList.stream().filter(x -> nodeEntryId.equals(x.getLong("id"))).findFirst().get();
        String nextNodeIds = nodeEntry.getString("nextnodeids");
        if (StringUtils.isNotBlank((CharSequence)nextNodeIds)) {
            List nextNodeIdList = SerializationUtils.fromJsonStringToList((String)nextNodeIds, String.class);
            for (String nextNodeId : nextNodeIdList) {
                boolean canCreate = ProcessUpdateUtil.queryNodeCanCreateTask(nextNodeId, processHistroyId);
                if (!canCreate) continue;
                Map<String, Object> nodeTask = ProcessUpdateUtil.createNodeTask(nextNodeId, processHistroyId, processId);
                boolean isControl = (Boolean)nodeTask.get("isControl");
                if (isControl) {
                    ProcessUpdateUtil.updateNodeStatusByNodeId(nextNodeId, processHistroyId, RunningState.RUNNING.getValue());
                    List autoSubmitList = (List)nodeTask.get("autoSubmitList");
                    List scheduleList = (List)nodeTask.get("scheduleList");
                    FlowActiveUtil.dealAutoSubmitResource(autoSubmitList, scheduleList);
                    continue;
                }
                ProcessUpdateUtil.updateNodeStatusByNodeId(nextNodeId, processHistroyId, RunningState.COMPLETED.getValue());
                Long nextNodeEntryId = ProcessUpdateUtil.queryNodeEntryId(nextNodeId, processHistroyId);
                ProcessUpdateUtil.createNextNodeTask(nextNodeEntryId, processHistroyId, processId, nodeEntryList);
            }
        } else {
            ProcessUpdateUtil.updateNodeStatusByNodeEntryId(nodeEntryId, RunningState.COMPLETED.getValue());
            ProcessUpdateUtil.processFinish(processHistroyId);
        }
    }

    public static void processFinish(Long processHistroyId) {
        String queryNodeStatus = "select count(distinct fstatus) from t_phm_process_node where fid = ? ";
        try (DataSet statusSet = DB.queryDataSet((String)"phm_queryNodeStatus", (DBRoute)CommonConsts.ROUTE_PHM, (String)queryNodeStatus, (Object[])new Object[]{processHistroyId});){
            Row next;
            if (statusSet.hasNext() && (next = statusSet.next()).getInteger(0) == 1) {
                String updateProcessStatus = "update t_phm_process_history set fstatus = ? where fid = ? ";
                DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)updateProcessStatus, (Object[])new Object[]{RunningState.COMPLETED.getValue(), processHistroyId});
                ProcessHistoryUtil.defaultCopyProcessHistory(processHistroyId);
            }
        }
    }

    private static boolean queryNodeCanCreateTask(String nodeId, Long processHistroyId) {
        QFilter qFilter = new QFilter("nodeid", "=", (Object)nodeId);
        qFilter.and(new QFilter("historyid", "=", (Object)processHistroyId));
        DynamicObject nodeDynamicObject = QueryServiceHelper.queryOne((String)"phm_process_node", (String)"nodecomplete,prenodeids", (QFilter[])qFilter.toArray());
        if (nodeDynamicObject.getBoolean("nodecomplete")) {
            String prenodeids = nodeDynamicObject.getString("prenodeids");
            if (StringUtils.isBlank((CharSequence)prenodeids)) {
                return true;
            }
            List preNodeIdList = SerializationUtils.fromJsonStringToList((String)prenodeids, String.class);
            if (preNodeIdList.size() == 1) {
                return true;
            }
            QFilter preQFilter = new QFilter("nodeid", "in", (Object)preNodeIdList);
            preQFilter.and(new QFilter("historyid", "=", (Object)processHistroyId));
            preQFilter.and(new QFilter("node_status", "in", (Object)Lists.newArrayList((Object[])new String[]{RunningState.PREPARE.getValue(), RunningState.AUTO.getValue(), RunningState.SUSPEND.getValue(), RunningState.RUNNING.getValue()})));
            boolean exists = QueryServiceHelper.exists((String)"phm_process_node", (QFilter[])preQFilter.toArray());
            return !exists;
        }
        Integer count = ProcessUpdateUtil.queryNodeTaskIsExist(nodeId, processHistroyId);
        if (count > 0) {
            ProcessUpdateUtil.processFinish(processHistroyId);
            return false;
        }
        return true;
    }

    private static Long queryNodeEntryId(String nextNodeId, Long processHistroyId) {
        QFilter qFilter = new QFilter("historyid", "=", (Object)processHistroyId);
        qFilter.and(new QFilter("nodeid", "=", (Object)nextNodeId));
        Throwable throwable = null;
        try (DataSet statusSet = ORM.create().queryDataSet("phm_queryNodeStatus", "phm_process_node", "id", qFilter.toArray());){
            if (statusSet.hasNext()) {
                Row next = statusSet.next();
                Long l = next.getLong("id");
                return l;
            }
            try {
                throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9:", (String)"ProcessUpdateUtil_0", (String)"mmc-phm-common", (Object[])new Object[0]) + nextNodeId + ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u3002", (String)"ProcessUpdateUtil_1", (String)"mmc-phm-common", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static Integer queryNodeTaskIsExist(String nodeId, Long processHistroyId) {
        String selectNodeEntryId = "select count(t1.fdetailid) from t_phm_node_task t1 , t_phm_process_node  t2 where t1.fentryid = t2.fentryid and t2.fnodeid = ? and t2.fid = ?";
        try (DataSet nodeDataSet = DB.queryDataSet((String)"phm_queryNodeTaskCount", (DBRoute)CommonConsts.ROUTE_PHM, (String)selectNodeEntryId, (Object[])new Object[]{nodeId, processHistroyId});){
            if (nodeDataSet.hasNext()) {
                Row next = nodeDataSet.next();
                Integer n = next.getInteger(0);
                return n;
            }
        }
        return 0;
    }

    public static Map<String, Object> createNodeTask(String nodeId, Long processHistroyId, Long processId) {
        DynamicObject processHistory = BusinessDataServiceHelper.loadSingle((Object)processHistroyId, (String)"phm_process_history");
        DynamicObject processs = processHistory.getDynamicObject("flowdefine");
        DynamicObject flow_define = BusinessDataServiceHelper.loadSingle((Object)processs.getPkValue(), (String)"phm_flow_define");
        Long entryId = ProcessUpdateUtil.queryNodeEntryId(nodeId, processHistroyId);
        SqlBuilder queryResourceRole = new SqlBuilder();
        QFilter qFilter_id = new QFilter("id", "=", (Object)processId);
        QFilter qFilter_nodeId = new QFilter("flownodeentryentity.nodeid", "=", (Object)nodeId);
        QFilter qFilter_status = new QFilter("resourcesubentryentity.deliverables.status", "=", (Object)"C");
        QFilter qFilter_enable = new QFilter("resourcesubentryentity.deliverables.enable", "=", (Object)"1");
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"phm_flow_define", (QFilter[])new QFilter[]{qFilter_id, qFilter_nodeId, qFilter_status, qFilter_enable});
        boolean isControl = false;
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
        ArrayList<AutoSubmitParam> autoSubmitList = new ArrayList<AutoSubmitParam>();
        ArrayList<AutoSubmitScheduleParam> scheduleList = new ArrayList<AutoSubmitScheduleParam>();
        for (DynamicObject dynamicObject : objectDynamicObjectMap.values()) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("flownodeentryentity");
            for (DynamicObject dynamicObject_node : dynamicObjectCollection) {
                if (!nodeId.equals(dynamicObject_node.getString("nodeid"))) continue;
                DynamicObjectCollection dynamicObjectCollection_res = dynamicObject_node.getDynamicObjectCollection("resourcesubentryentity");
                for (DynamicObject dynamicObject_task : dynamicObjectCollection_res) {
                    DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"phm_process_task");
                    DynamicObject deliverables = (DynamicObject)dynamicObject_task.get("deliverables");
                    String datasource = deliverables.getString("datasource");
                    DynamicObject datasourceid = deliverables.getDynamicObject("datasourceid");
                    task.set("task_processhistory", (Object)processHistroyId);
                    task.set("entry_node", (Object)entryId);
                    task.set("task_createdate", (Object)new Date());
                    task.set("task_status", (Object)TaskStatusEnum.UNPROCESS.getValue());
                    task.set("task_resourcetype", dynamicObject_task.get("resourcetype"));
                    task.set("task_resource", dynamicObject_task.get("resource"));
                    String deliverablesnumber = dynamicObject_task.getString("deliverablesnumber");
                    task.set("deliverablesnumber", (Object)deliverablesnumber);
                    task.set("deliverablesname", dynamicObject_task.get("deliverablesname"));
                    task.set("deliverables", dynamicObject_task.get("deliverables"));
                    FlowActiveUtil.replacePkID(dynamicObject_task, task, "depersonliable", "depersonliable");
                    FlowActiveUtil.replacePkID(dynamicObject_task, task, "deliableorg", "deliableorg");
                    task.set("schedule", dynamicObject_task.get("schedule"));
                    task.set("warningcycle", dynamicObject_task.get("warningcycle"));
                    task.set("overduecycle", dynamicObject_task.get("overduecycle"));
                    task.set("seriousoverduecycle", dynamicObject_task.get("seriousoverduecycle"));
                    FlowActiveUtil.replacePkID(dynamicObject_task, task, "waringuser", "waringuser");
                    FlowActiveUtil.replacePkID(dynamicObject_task, task, "overduecyuser", "overduecyuser");
                    FlowActiveUtil.replacePkID(dynamicObject_task, task, "seriousoverdueuser", "seriousoverdueuser");
                    FlowActiveUtil.setConditionValue(task, dynamicObject_task, "frontcondition");
                    FlowActiveUtil.setConditionValue(task, dynamicObject_task, "aftercondition");
                    task.set("recustomers", dynamicObject_task.get("recustomers"));
                    task.set("remake", dynamicObject_task.get("remake"));
                    FlowActiveUtil.replacePkID(dynamicObject_task, task, "superior", "superior");
                    task.set("datasource", deliverables.get("datasource"));
                    task.set("datasourceid", deliverables.get("datasourceid"));
                    boolean resourceControl = dynamicObject_task.getBoolean("control");
                    task.set("task_control", (Object)resourceControl);
                    if (resourceControl) {
                        isControl = resourceControl;
                        String formula = dynamicObject_task.getString("formula");
                        if (StringUtils.isNotBlank((CharSequence)formula)) {
                            String[] split = formula.split(";");
                            int value = Integer.parseInt(split[2]);
                            if ("0".equals(split[1])) {
                                ++value;
                            }
                            task.set("taskprogress", (Object)"0/".concat(Integer.toString(value)));
                        }
                    }
                    BigDecimal nodecycle = dynamicObject_node.getBigDecimal("nodecycle");
                    task.set("task_period", (Object)nodecycle);
                    if (BigDecimal.ZERO.compareTo(nodecycle) != 0) {
                        BigDecimal minutes = nodecycle.multiply(new BigDecimal("24")).multiply(new BigDecimal("60"));
                        task.set("task_completedate", (Object)DateUtils.addMinutes((Date)new Date(), (int)minutes.intValue()));
                    }
                    DynamicObjectCollection roles = dynamicObject_task.getDynamicObjectCollection("role");
                    DynamicObjectCollection task_roles = task.getDynamicObjectCollection("task_role");
                    for (DynamicObject role : roles) {
                        DynamicObject task_role = task_roles.addNew();
                        task_role.set(2, role.get(2));
                    }
                    task.set("task_role", (Object)task_roles);
                    String dealType = dynamicObject_task.getString("dealtype");
                    task.set("task_dealtype", (Object)dealType);
                    DynamicObject processHistory_node = null;
                    DynamicObjectCollection entryentity_node = processHistory.getDynamicObjectCollection("entryentity");
                    for (DynamicObject his_en : entryentity_node) {
                        if (!nodeId.equals(his_en.getString("nodeid"))) continue;
                        processHistory_node = his_en;
                        break;
                    }
                    if (processHistory_node != null) {
                        String startype = processHistory.getString("startype");
                        if ("phm_tasknotice".equals(datasource)) {
                            FlowActiveUtil.creatTaskNotieFlow(dynamicObject_task, flow_define, processHistory_node, processHistory, startype, "tasknotice");
                        }
                        if ("phm_eigenvalue".equals(datasource)) {
                            if (!FlowActiveUtil.isCompleteEigenvalue(task, deliverables)) {
                                Object tasknoticeId = FlowActiveUtil.creatTaskNotieFlow(dynamicObject_task, flow_define, processHistory_node, processHistory, startype, "eigenvalues");
                                FlowActiveUtil.creatSuheduByEigenvalue(dynamicObject, processHistory, deliverablesnumber, tasknoticeId);
                                FlowActiveUtil.creatSuheduPlan(dynamicObject_task, processHistory_node, processHistory, deliverablesnumber);
                            } else {
                                FlowActiveUtil.creatTaskNotieFlow(dynamicObject_task, flow_define, processHistory_node, processHistory, startype, "eigenvalue");
                            }
                        } else {
                            FlowActiveUtil.creatSuheduPlan(dynamicObject_task, processHistory_node, processHistory, deliverablesnumber);
                        }
                    }
                    if (DealTypeEnum.AUTO.getName().equals(dealType)) {
                        AutoSubmitParam autoSubmitParam = new AutoSubmitParam();
                        autoSubmitParam.setProcessHistoryId(processHistroyId);
                        autoSubmitParam.setEntryNodeId(entryId);
                        autoSubmitParam.setProcessId(processId);
                        autoSubmitParam.setResourceType(ProcessResourceSourceEnum.DataTemp.getValue());
                        autoSubmitParam.setResourceId(dynamicObject_task.getLong("resourceid"));
                        autoSubmitParam.setDealType(dealType);
                        autoSubmitList.add(autoSubmitParam);
                    } else if (DealTypeEnum.CYCLE.getName().equals(dealType)) {
                        AutoSubmitScheduleParam scheduleParam = new AutoSubmitScheduleParam();
                        scheduleParam.setProcessHistoryId(processHistroyId);
                        scheduleParam.setEntryNodeId(entryId);
                        scheduleParam.setProcessId(processId);
                        scheduleParam.setResourceType(ProcessResourceSourceEnum.DataTemp.getValue());
                        scheduleParam.setResourceId(dynamicObject_task.getLong("resourceid"));
                        scheduleParam.setStartDate(task.getDate("task_completedate"));
                        scheduleParam.setName(flow_define.getString("name") + "-" + processHistory.getString("number") + "-" + dynamicObject_task.getString("nodename") + "-" + dynamicObject_task.getString("resourceid"));
                        scheduleParam.setNumber(flow_define.getString("number") + "-" + processHistory.getString("number") + "-" + dynamicObject_task.getString("nodename") + "-" + dynamicObject_task.getString("resourceid"));
                        scheduleParam.setDealType(dealType);
                        scheduleList.add(scheduleParam);
                    }
                    taskList.add(task);
                }
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("isControl", isControl);
        resultMap.put("autoSubmitList", autoSubmitList);
        resultMap.put("scheduleList", scheduleList);
        if (taskList.size() == 0) {
            return resultMap;
        }
        SaveServiceHelper.saveOperate((String)"phm_process_task", (DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]), (OperateOption)OperateOption.create());
        return resultMap;
    }

    public static int updateTaskProgressByEigenvalue(Long entryid, String deliverablesnumber) {
        log.info("\u66f4\u65b0\u8282\u70b9\u4efb\u52a1\u8fdb\u5ea6,entryid:" + entryid + ",resource:" + deliverablesnumber);
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{TaskStatusEnum.WARN.getValue(), TaskStatusEnum.OVERDUE.getValue(), TaskStatusEnum.SEROVERDUE.getValue()});
        QFilter qFilter = new QFilter("deliverablesnumber", "=", (Object)deliverablesnumber);
        qFilter.and(new QFilter("entry_node", "=", (Object)entryid));
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"phm_process_task", (String)"task_control,taskprogress,task_status,task_dealtype", (QFilter[])qFilter.toArray());
        if (!task.getBoolean("task_control")) {
            task.set("task_status", (Object)TaskStatusEnum.PROCESSING.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
            return 0;
        }
        String updateProgress = TaskProgressUtil.updateMliepostProgress(task.getString("taskprogress"));
        task.set("taskprogress", (Object)updateProgress);
        BigDecimal taskProgressValue = TaskProgressUtil.getTaskProgressValue(updateProgress);
        if (!statusList.contains(task.getString("task_status"))) {
            task.set("task_status", (Object)TaskStatusEnum.CLOSED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        if (DealTypeEnum.MANUAL.getName().equals(task.getString("task_dealtype")) && TaskStatusEnum.CLOSED.getValue().equals(task.getString("task_status"))) {
            return 2;
        }
        return BigDecimal.ONE.compareTo(taskProgressValue) <= 0 ? 1 : 0;
    }

    public static int updateTaskProgress(Long entryid, Long resource, int value, String sign) {
        log.info("\u66f4\u65b0\u8282\u70b9\u4efb\u52a1\u8fdb\u5ea6,entryid:" + entryid + ",resource:" + resource + ",value:" + value);
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{TaskStatusEnum.WARN.getValue(), TaskStatusEnum.OVERDUE.getValue(), TaskStatusEnum.SEROVERDUE.getValue()});
        QFilter qFilter = null;
        qFilter = "1".equals(sign) ? new QFilter("datasourceid", "=", (Object)resource) : new QFilter("id", "=", (Object)resource);
        qFilter.and(new QFilter("entry_node", "=", (Object)entryid));
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"phm_process_task", (String)"task_control,taskprogress,task_status,task_dealtype", (QFilter[])qFilter.toArray());
        if (!task.getBoolean("task_control")) {
            task.set("task_status", (Object)TaskStatusEnum.PROCESSING.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
            return 0;
        }
        String updateProgress = TaskProgressUtil.updateProgress(task.getString("taskprogress"), value);
        task.set("taskprogress", (Object)updateProgress);
        BigDecimal taskProgressValue = TaskProgressUtil.getTaskProgressValue(updateProgress);
        if (!statusList.contains(task.getString("task_status"))) {
            if (value > 0) {
                if (BigDecimal.ONE.compareTo(taskProgressValue) == 0) {
                    task.set("task_status", (Object)TaskStatusEnum.CLOSED.getValue());
                } else {
                    task.set("task_status", (Object)TaskStatusEnum.PROCESSING.getValue());
                }
            } else {
                task.set("task_status", (Object)TaskStatusEnum.PROCESSING.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        if (DealTypeEnum.MANUAL.getName().equals(task.getString("task_dealtype")) && TaskStatusEnum.CLOSED.getValue().equals(task.getString("task_status"))) {
            return 2;
        }
        return BigDecimal.ONE.compareTo(taskProgressValue) <= 0 ? 1 : 0;
    }

    public static void startWaitTask(Long entryid, boolean fromEvent) {
        QFilter qFilter = new QFilter("entry_node", "=", (Object)entryid);
        qFilter.and(new QFilter("task_status", "in", Arrays.asList(TaskStatusEnum.UNPROCESS.getValue(), TaskStatusEnum.PROCESSING.getValue())));
        qFilter.and(new QFilter("task_dealtype", "=", (Object)DealTypeEnum.MANUAL.getName()));
        boolean exists = QueryServiceHelper.exists((String)"phm_process_task", (QFilter[])qFilter.toArray());
        if (!exists) {
            QFilter queryWaitTask = new QFilter("entry_node", "=", (Object)entryid);
            queryWaitTask.and(new QFilter("task_dealtype", "=", (Object)DealTypeEnum.WAIT.getName()));
            queryWaitTask.and(new QFilter("task_status", "in", Arrays.asList(TaskStatusEnum.UNPROCESS.getValue(), TaskStatusEnum.PROCESSING.getValue())));
            DynamicObject[] waitTasks = BusinessDataServiceHelper.load((String)"phm_process_task", (String)"task_processhistory,task_resource,task_dealtype", (QFilter[])queryWaitTask.toArray());
            if (waitTasks == null || waitTasks.length == 0) {
                return;
            }
            ArrayList<AutoSubmitParam> autoSubmitList = new ArrayList<AutoSubmitParam>(waitTasks.length);
            for (DynamicObject waitTask : waitTasks) {
                AutoSubmitParam autoSubmitParam = new AutoSubmitParam();
                DynamicObject processHistory = waitTask.getDynamicObject("task_processhistory");
                autoSubmitParam.setProcessId(processHistory.getLong("process_id"));
                autoSubmitParam.setProcessHistoryId(processHistory.getLong("id"));
                autoSubmitParam.setEntryNodeId(entryid);
                autoSubmitParam.setResourceType(ProcessResourceSourceEnum.DataTemp.getValue());
                autoSubmitParam.setResourceId(waitTask.getLong("task_resource_id"));
                autoSubmitParam.setDealType(waitTask.getString("task_dealtype"));
                autoSubmitParam.setFromEvent(fromEvent);
                autoSubmitList.add(autoSubmitParam);
            }
            AutoSubmitUtil.createResourceSync(autoSubmitList);
        }
    }

    public static void updateNodeStatusByNodeId(String nodeId, Long processHistroyId, String nodeStatus) {
        log.info("\u901a\u8fc7\u8282\u70b9id\u66f4\u65b0\u8282\u70b9\u72b6\u6001,nodeId:" + nodeId + ",processHistroyId:" + processHistroyId + ",nodeStatus:" + nodeStatus);
        if (RunningState.COMPLETED.getValue().equals(nodeStatus)) {
            String updateSql = "update t_phm_process_node set fstatus = ?, ffinishtime = ? where  fid = ? and fnodeid =?";
            DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{nodeStatus, new Date(), processHistroyId, nodeId});
        } else {
            String updateSql = "update t_phm_process_node set fstatus = ?, fcreatetime = ? where  fid = ? and fnodeid =?";
            DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{nodeStatus, new Date(), processHistroyId, nodeId});
        }
    }

    public static void updateNodeStatusByNodeEntryId(Long nodeEntryId, String nodeStatus) {
        log.info("\u901a\u8fc7\u8282\u70b9\u5206\u5f55id\u66f4\u65b0\u8282\u70b9\u72b6\u6001,nodeEntryId:" + nodeEntryId + ",nodeStatus:" + nodeStatus);
        if (RunningState.COMPLETED.getValue().equals(nodeStatus)) {
            String updateSql = "update t_phm_process_node set fstatus = ?, ffinishtime = ? where  fentryid = ? ";
            DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{nodeStatus, new Date(), nodeEntryId});
        } else {
            String updateSql = "update t_phm_process_node set fstatus = ?, fcreatetime = ? where  fentryid = ?";
            DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{nodeStatus, new Date(), nodeEntryId});
        }
    }
}

