/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.util.process;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.mmc.phm.common.CronStruct;
import kd.mmc.phm.common.bizmodel.TaskUtils;
import kd.mmc.phm.common.domian.process.AutoSubmitScheduleParam;
import kd.mmc.phm.common.util.process.ProcessErrorDealUtil;
import org.apache.commons.lang3.time.DateUtils;

public class ScheduleCreateUtil {
    private static final String TASKCLASS_NUMBER = "phm_flow_auto_submit_task";
    private static final String SCH_JOB = "sch_job";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String SCH_TASKDEFINE = "sch_taskdefine";
    private static final Log logger = LogFactory.getLog(ScheduleCreateUtil.class);

    public static void createScheduleTask(List<AutoSubmitScheduleParam> scheduleList) {
        ThreadPools.executeOnceIncludeRequestContext((String)"PHMProcessAutoSubmitSchedule", () -> {
            for (AutoSubmitScheduleParam scheduleParam : scheduleList) {
                try {
                    OperationResult result = ScheduleCreateUtil.createJob(scheduleParam);
                    List pkId = result.getSuccessPkIds();
                    if (pkId == null || pkId.size() == 0) {
                        return;
                    }
                    String jobId = pkId.get(0).toString();
                    result = ScheduleCreateUtil.createSchedule(jobId, scheduleParam);
                    if (result.getSuccessPkIds() != null && result.getSuccessPkIds().size() != 0) continue;
                    return;
                }
                catch (Exception e) {
                    ProcessErrorDealUtil.addErrorInfo(scheduleParam, e);
                    logger.error(e.getMessage());
                    break;
                }
            }
        }, (String)"phm");
    }

    private static OperationResult createJob(AutoSubmitScheduleParam scheduleParam) {
        String jobNumber = "PHM_AUTO_SUBMIT_" + scheduleParam.getNumber();
        String jobId = TaskUtils.getIdByNum(SCH_JOB, jobNumber);
        DynamicObject job = TaskUtils.getExistedObject(SCH_JOB, jobId);
        job.set("number", (Object)jobNumber);
        job.set("name", (Object)scheduleParam.getName());
        job.set("jobtype", (Object)"BIZ");
        String taskClassId = TaskUtils.getIdByNum(SCH_TASKDEFINE, TASKCLASS_NUMBER);
        job.set("taskclassname", (Object)taskClassId);
        job.set("runbyuser", (Object)RequestContext.get().getUserId());
        job.set("status", (Object)"1");
        job.set("runmode", (Object)"0");
        job.set("runconcurrent", (Object)true);
        job.set("runorder", (Object)"1");
        job.set("strategy", (Object)"1");
        DynamicObjectCollection collection = job.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject addNew1 = collection.addNew();
        addNew1.set("paramname", (Object)"processHistoryId");
        addNew1.set("paramvalue", (Object)scheduleParam.getProcessHistoryId());
        DynamicObject addNew2 = collection.addNew();
        addNew2.set("paramname", (Object)"resouceId");
        addNew2.set("paramvalue", (Object)scheduleParam.getResourceId());
        DynamicObject addNew3 = collection.addNew();
        addNew3.set("paramname", (Object)"resouceType");
        addNew3.set("paramvalue", (Object)scheduleParam.getResourceType());
        DynamicObject addNew4 = collection.addNew();
        addNew4.set("paramname", (Object)"entryNodeId");
        addNew4.set("paramvalue", (Object)scheduleParam.getEntryNodeId());
        DynamicObject addNew5 = collection.addNew();
        addNew5.set("paramname", (Object)"processId");
        addNew5.set("paramvalue", (Object)scheduleParam.getProcessId());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("processHistoryId", scheduleParam.getProcessHistoryId());
        paramsMap.put("resouceId", scheduleParam.getResourceId());
        paramsMap.put("resouceType", scheduleParam.getResourceType());
        paramsMap.put("entryNodeId", scheduleParam.getEntryNodeId());
        paramsMap.put("processId", scheduleParam.getProcessId());
        job.set("params", (Object)SerializationUtils.toJsonString(paramsMap));
        return SaveServiceHelper.saveOperate((String)SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
    }

    private static OperationResult createSchedule(String jobId, AutoSubmitScheduleParam submitScheduleParam) {
        String scheduleNum = "PHM_AUTO_SUBMIT_" + submitScheduleParam.getNumber();
        String scheduleId = TaskUtils.getIdByNum(SCH_SCHEDULE, scheduleNum);
        if (StringUtils.isNotEmpty((String)scheduleId)) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject schedule = TaskUtils.getExistedObject(SCH_SCHEDULE, scheduleId);
        schedule.set("number", (Object)scheduleNum);
        schedule.set("name", (Object)(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-\u6d41\u7a0b\u5b9a\u65f6\u63d0\u4ea4", (String)"ScheduleCreateUtil_0", (String)"mmc-phm-common", (Object[])new Object[0]) + submitScheduleParam.getName()));
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        schedule.set("starttime", (Object)submitScheduleParam.getStartDate());
        try {
            schedule.set("endtime", (Object)sdf.parse("2099-12-31"));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u9519\u8bef%s", (String)"ScheduleCreateUtil_1", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", (Object)Character.valueOf('n'));
        schedule.set("cyclenum", (Object)1);
        Calendar calendar = DateUtils.toCalendar((Date)submitScheduleParam.getStartDate());
        CronStruct init = CronStruct.init(calendar);
        schedule.set("plan", (Object)init.toString());
        schedule.set("txtdesc", (Object)"");
        schedule.set("combdorw", (Object)"d");
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        schedule.set("comno", (Object)"");
        schedule.set("comweek", (Object)"");
        schedule.set("ckbyweek", (Object)false);
        return SaveServiceHelper.saveOperate((String)SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
    }
}

