/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.opplugin.validator.DataConnectionSaveValidator;

public class DataConnectionSaveOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(DataConnectionSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("linktype");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("ip");
        e.getFieldKeys().add("host");
        e.getFieldKeys().add("appno");
        e.getFieldKeys().add("apppassword");
        e.getFieldKeys().add("accountid");
        e.getFieldKeys().add("tenantid");
        e.getFieldKeys().add("loginuser");
        e.getFieldKeys().add("loginword");
        e.getFieldKeys().add("dbname");
        e.getFieldKeys().add("oracleservice");
        e.getFieldKeys().add("unicode");
        e.getFieldKeys().add("datacenter");
        e.getFieldKeys().add("easservice");
        e.getFieldKeys().add("webappname");
        e.getFieldKeys().add("proxyuser");
        e.getFieldKeys().add("http");
        e.getFieldKeys().add("language");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifytime");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            String number = obj.getString("number");
            DynamicObject linkObj = this.isExistsLink(number) ? this.updateDataLink(obj) : this.generateDataLink(obj);
            long linkid = (Long)linkObj.getPkValue();
            obj.set("linkid", (Object)linkid);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    private boolean isExistsLink(String number) {
        QFilter qfilter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"isc_database_link", (QFilter[])new QFilter[]{qfilter});
    }

    private DynamicObject generateDataLink(DynamicObject obj) {
        ORM orm = ORM.create();
        DynamicObject linkObj = orm.newDynamicObject("isc_database_link");
        linkObj.set("number", obj.get("number"));
        linkObj.set("name", obj.get("name"));
        linkObj.set("database_type", obj.get("linktype"));
        linkObj.set("source_system", null);
        linkObj.set("creator", obj.get("creator"));
        linkObj.set("enable", (Object)"1");
        linkObj.set("status", (Object)"C");
        linkObj.set("state", null);
        linkObj.set("server_ip", obj.get("ip"));
        linkObj.set("server_port", obj.get("host"));
        linkObj.set("appid", obj.get("appno"));
        linkObj.set("appsecret", obj.get("apppassword"));
        linkObj.set("account", obj.get("accountid"));
        linkObj.set("tenant", obj.get("tenantid"));
        linkObj.set("user", obj.get("loginuser"));
        linkObj.set("password", obj.get("loginword"));
        linkObj.set("sql_database", obj.get("dbname"));
        linkObj.set("oracle_service", obj.get("oracleservice"));
        linkObj.set("charset", obj.get("unicode"));
        linkObj.set("data_center", obj.get("datacenter"));
        linkObj.set("eas_service", obj.get("easservice"));
        linkObj.set("web_app", obj.get("webappname"));
        linkObj.set("ierp_proxy_user", obj.get("proxyuser"));
        linkObj.set("http_protocal", obj.get("http"));
        linkObj.set("icid", obj.get("language"));
        linkObj.set("creator", obj.get("creator"));
        linkObj.set("modifier", obj.get("modifier"));
        linkObj.set("createtime", obj.get("createtime"));
        linkObj.set("modifytime", obj.get("modifytime"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{linkObj});
        DynamicObject dataSource = orm.newDynamicObject("isc_data_source");
        dataSource.set("dblink", linkObj.getPkValue());
        dataSource.set("number", obj.get("number"));
        dataSource.set("name", obj.get("name"));
        dataSource.set("status", (Object)"C");
        dataSource.set("enable", (Object)"1");
        dataSource.set("creator", obj.get("creator"));
        dataSource.set("modifier", obj.get("modifier"));
        dataSource.set("createtime", obj.get("createtime"));
        dataSource.set("modifytime", obj.get("modifytime"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSource});
        return linkObj;
    }

    private DynamicObject updateDataLink(DynamicObject obj) {
        String number = obj.getString("number");
        QFilter qfilter = new QFilter("number", "=", (Object)number);
        DynamicObject linkObj = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (String)"id", (QFilter[])new QFilter[]{qfilter});
        linkObj = BusinessDataServiceHelper.loadSingle((Object)linkObj.getPkValue(), (String)"isc_database_link");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (String)"id", (QFilter[])new QFilter[]{qfilter});
        dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSource.getPkValue(), (String)"isc_data_source");
        linkObj.set("name", obj.get("name"));
        linkObj.set("source_system", null);
        linkObj.set("creator", obj.get("creator"));
        linkObj.set("enable", obj.get("enable"));
        linkObj.set("status", (Object)"C");
        linkObj.set("state", null);
        linkObj.set("server_ip", obj.get("ip"));
        linkObj.set("server_port", obj.get("host"));
        linkObj.set("appid", obj.get("appno"));
        linkObj.set("appsecret", obj.get("apppassword"));
        linkObj.set("account", obj.get("accountid"));
        linkObj.set("tenant", obj.get("tenantid"));
        linkObj.set("user", obj.get("loginuser"));
        linkObj.set("password", obj.get("loginword"));
        linkObj.set("sql_database", obj.get("dbname"));
        linkObj.set("oracle_service", obj.get("oracleservice"));
        linkObj.set("charset", obj.get("unicode"));
        linkObj.set("data_center", obj.get("datacenter"));
        linkObj.set("eas_service", obj.get("easservice"));
        linkObj.set("web_app", obj.get("webappname"));
        linkObj.set("ierp_proxy_user", obj.get("proxyuser"));
        linkObj.set("http_protocal", obj.get("http"));
        linkObj.set("icid", obj.get("language"));
        linkObj.set("modifier", obj.get("modifier"));
        linkObj.set("modifytime", obj.get("modifytime"));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{linkObj});
        dataSource.set("name", obj.get("name"));
        dataSource.set("status", (Object)"C");
        dataSource.set("enable", (Object)"1");
        dataSource.set("modifier", obj.get("modifier"));
        dataSource.set("modifytime", obj.get("modifytime"));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataSource});
        return linkObj;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DataConnectionSaveValidator());
    }
}

