/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.basemanager.ColumnEntry;

public class DataMapSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRY_PHM_DATAMAP = "phm_datamap";
    private static final String ENTRY_PHM_METADATAMANAGER = "phm_metadatamanager";
    private static final String ENTRY_DATACONNECTION = "phm_dataconnection";
    private static final String ENTRY_ISC_DATA_COPY = "isc_data_copy";
    private static final String ENTRY_ISC_DATA_SOURCE = "isc_data_source";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_ID = "id";
    private static final String PROP_RETALEMETAID = "retalemetaid";
    private static final String PROP_DESTFIELD = "destfield";
    private static final String PROP_SRCTABLE = "srctable";
    private static final String PROP_MAPPING_TAR_COLUMN = "mapping_tar_column";
    private static final String PROP_MAPPING_SRC_COLUMN = "mapping_src_column";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject dataMap = dataEntity.getDataEntity();
            DynamicObject dataMapObj = BusinessDataServiceHelper.loadSingle((Object)dataMap.getLong(PROP_ID), (String)ENTRY_PHM_DATAMAP);
            if (dataMapObj == null) {
                e.setCancel(true);
                this.addErrMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff01", (String)"DataMapSubmitOp_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject meta = (DynamicObject)dataMapObj.get("meta");
            DynamicObject metaObj = BusinessDataServiceHelper.loadSingle((Object)meta.getLong(PROP_ID), (String)ENTRY_PHM_METADATAMANAGER);
            DynamicObjectCollection srcInfos = (DynamicObjectCollection)metaObj.get("sourcetable");
            Long iscSchemaId = metaObj.getLong("iscschemaid");
            if (iscSchemaId == 0L) {
                e.cancel = true;
                this.addErrMessage(dataEntity, ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4fe1\u606f\u6709\u8bef\uff01", (String)"DataMapSubmitOp_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject src : srcInfos) {
                List<ColumnEntry> colInfo = this.getSrcTableColInfo(metaObj, src);
                DynamicObject linkObj = this.getLinkObj(src);
                String iscNumber = dataMap.getString(PROP_NUMBER) + "_" + linkObj.getString(PROP_ID) + "_" + src.getString(PROP_SRCTABLE);
                OperationResult result = this.create(dataMapObj, src, colInfo, linkObj.getLong("linkid"), iscSchemaId, iscNumber);
                if (result == null) {
                    e.setCancel(true);
                    this.addErrMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u96c6\u6210\u65b9\u6848\u5931\u8d25,\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff01", (String)"DataMapSubmitOp_2", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (result.isSuccess()) continue;
                e.setCancel(true);
                this.addErrMessage(dataEntity, this.getErrorInfo(result));
            }
        }
    }

    private List<ColumnEntry> getSrcTableColInfo(DynamicObject metaObj, DynamicObject src) {
        ArrayList<ColumnEntry> cols = new ArrayList<ColumnEntry>();
        if (!src.getBoolean("ismaintable")) {
            String table = src.getString(PROP_SRCTABLE);
            DynamicObject link = src.getDynamicObject("link");
            table = link.getString(PROP_NUMBER) + "-" + table;
            DynamicObjectCollection properties = metaObj.getDynamicObjectCollection("fieldlink");
            for (DynamicObject p : properties) {
                if (!table.equalsIgnoreCase(p.getString("src_table"))) continue;
                ColumnEntry col = new ColumnEntry();
                col.setColName(p.getString("srcfield"));
                col.setColDescribe(p.getString("srcfieldname"));
                col.setColType(p.getString("srcfieldtype"));
                col.setIsPK(Boolean.valueOf(p.getBoolean("srcpkfield")));
                cols.add(col);
            }
        }
        return cols;
    }

    private String getErrorInfo(OperationResult result) {
        List vErr;
        List err = result.getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        if (err.size() > 0) {
            for (OperateErrorInfo errInfo : err) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        if ((vErr = result.getAllErrorOrValidateInfo()).size() > 0) {
            for (IOperateInfo errInfo : vErr) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        return sb.toString();
    }

    private OperationResult create(DynamicObject dataMap, DynamicObject srcInfo, List<ColumnEntry> cols, Long iscLinkId, Long iscSchemaId, String number) {
        ORM orm = ORM.create();
        boolean isExists = this.isExistsDataMap(number);
        DynamicObject iscDataMapObj = isExists ? this.getISCDataMapObj(number) : orm.newDynamicObject(ENTRY_ISC_DATA_COPY);
        iscDataMapObj.set("source_schema", (Object)srcInfo.getString(PROP_RETALEMETAID));
        iscDataMapObj.set("source_schema_id", (Object)srcInfo.getString(PROP_RETALEMETAID));
        DynamicObject dataSrcObj = this.getDataSrcObj(iscLinkId);
        iscDataMapObj.set("data_source", dataSrcObj.get(PROP_ID));
        iscDataMapObj.set("data_source_id", dataSrcObj.get(PROP_ID));
        iscDataMapObj.set("target_schema", (Object)iscSchemaId);
        iscDataMapObj.set("target_schema_id", (Object)iscSchemaId);
        DynamicObject selfLink = this.getISCSelfLink();
        if (selfLink == null) {
            return null;
        }
        DynamicObject dataDestObj = this.getDataSrcObj(selfLink.getLong(PROP_ID));
        iscDataMapObj.set("data_target", (Object)dataDestObj.getString(PROP_ID));
        iscDataMapObj.set("data_target_id", (Object)dataDestObj.getString(PROP_ID));
        iscDataMapObj.set("mode", (Object)dataMap.getString("mode"));
        iscDataMapObj.set(PROP_NUMBER, (Object)number);
        iscDataMapObj.set("name", (Object)dataMap.getString("name"));
        iscDataMapObj.set("record_oid_mappings", (Object)Boolean.FALSE);
        iscDataMapObj.set("record_oid_log", (Object)Boolean.FALSE);
        iscDataMapObj.set("remark", (Object)dataMap.getString("remarks"));
        DynamicObject temp = (DynamicObject)dataMap.get("creator");
        iscDataMapObj.set("creator", (Object)temp.getLong(PROP_ID));
        iscDataMapObj.set("createtime", (Object)dataMap.getDate("createtime"));
        temp = (DynamicObject)dataMap.get("modifier");
        iscDataMapObj.set("modifier", (Object)temp.getLong(PROP_ID));
        iscDataMapObj.set("modifytime", (Object)dataMap.getDate("modifytime"));
        iscDataMapObj.set("status", (Object)"C");
        iscDataMapObj.set("enable", (Object)"1");
        String table = srcInfo.getString(PROP_SRCTABLE);
        DynamicObject link = srcInfo.getDynamicObject("link");
        table = link.getString(PROP_NUMBER) + "-" + table;
        this.fieldLinkSet(iscDataMapObj, dataMap, srcInfo, cols, table);
        this.filterValueSet(iscDataMapObj, dataMap, table);
        return SaveServiceHelper.saveOperate((String)ENTRY_ISC_DATA_COPY, (DynamicObject[])new DynamicObject[]{iscDataMapObj}, (OperateOption)OperateOption.create());
    }

    private void fieldLinkSet(DynamicObject iscDataMapObj, DynamicObject dataMap, DynamicObject srcInfo, List<ColumnEntry> cols, String table) {
        DynamicObjectCollection fieldMap = iscDataMapObj.getDynamicObjectCollection("mapping_entries");
        DynamicObjectCollection fields = (DynamicObjectCollection)dataMap.get("entryentity1");
        Map<String, String> linkField = this.getTableLink(dataMap, table);
        boolean isMainTable = srcInfo.getBoolean("ismaintable");
        for (DynamicObject field : fields) {
            if (!table.equalsIgnoreCase(field.getString("src_table"))) continue;
            DynamicObject iscFieldLink = this.getRowObj(field.getString(PROP_DESTFIELD), field.getString("src_field"), fieldMap);
            iscFieldLink.set(PROP_MAPPING_TAR_COLUMN, (Object)field.getString(PROP_DESTFIELD));
            iscFieldLink.set("tar_desc", (Object)field.getString("destfielddesc"));
            iscFieldLink.set("candidate_key", (Object)this.isPk(field, linkField, isMainTable));
            iscFieldLink.set(PROP_MAPPING_SRC_COLUMN, (Object)field.getString("src_field"));
            iscFieldLink.set("src_desc", (Object)field.getString("src_fielddesc"));
        }
        if (!isMainTable && linkField.size() > 0) {
            for (Map.Entry<String, String> entry : linkField.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                DynamicObject iscFieldLink = this.getRowObj(key, value, fieldMap);
                iscFieldLink.set(PROP_MAPPING_TAR_COLUMN, (Object)key);
                iscFieldLink.set("tar_desc", (Object)this.getDestFieldDescription(this.getTarTable(dataMap), key));
                iscFieldLink.set("candidate_key", (Object)Boolean.TRUE);
                iscFieldLink.set(PROP_MAPPING_SRC_COLUMN, (Object)value);
                iscFieldLink.set("src_desc", (Object)this.getSrcFieldDescription(cols, value));
            }
        }
    }

    private void filterValueSet(DynamicObject iscDataMapObj, DynamicObject dataMap, String table) {
        DynamicObjectCollection filterEntries = iscDataMapObj.getDynamicObjectCollection("filter_entries");
        DynamicObjectCollection filters = (DynamicObjectCollection)dataMap.get("entryentity2");
        for (DynamicObject filter : filters) {
            if (!filter.getString("rule_srctable").equalsIgnoreCase(table)) continue;
            DynamicObject iscFilter = filterEntries.addNew();
            iscFilter.set("filter_left_bracket", (Object)filter.getString("rule_left_bracket"));
            iscFilter.set("filter_column", (Object)filter.getString("rule_conditionfield"));
            iscFilter.set("filter_label", (Object)filter.getBoolean("rule_fielddesc"));
            iscFilter.set("filter_compare", (Object)filter.getString("rule_compare"));
            iscFilter.set("filter_value_var", (Object)filter.getString("rule_value_var"));
            iscFilter.set("filter_value_fixed", (Object)filter.getString("rule_value_fixed"));
            iscFilter.set("filter_right_bracket", (Object)filter.getString("rule_right_bracket"));
            iscFilter.set("filter_link", (Object)filter.getString("rule_link"));
        }
    }

    private String getTarTable(DynamicObject dataMap) {
        DynamicObjectCollection tableLinks = (DynamicObjectCollection)dataMap.get("entryentity");
        if (tableLinks != null && tableLinks.size() > 0) {
            DynamicObject table = (DynamicObject)tableLinks.get(0);
            return table.getString("key_desttable");
        }
        return "";
    }

    private String getDestFieldDescription(String table, String field) {
        QFilter f1 = new QFilter(PROP_NUMBER, "=", (Object)table);
        QFilter f2 = new QFilter("entryentity.fieldname", "=", (Object)field);
        DynamicObject fieldObj = QueryServiceHelper.queryOne((String)"phm_datatable", (String)"id,number,entryentity.fielddescription", (QFilter[])new QFilter[]{f1, f2});
        if (fieldObj != null) {
            return fieldObj.getString("entryentity.fielddescription");
        }
        return field;
    }

    private String getSrcFieldDescription(List<ColumnEntry> cols, String field) {
        for (ColumnEntry col : cols) {
            if (!col.getColName().equalsIgnoreCase(field)) continue;
            return col.getColDescribe();
        }
        return field;
    }

    private boolean isPk(DynamicObject field, Map<String, String> pkFields, boolean isMainTable) {
        if (isMainTable) {
            return field.getBoolean("ispk");
        }
        String destField = field.getString(PROP_DESTFIELD);
        boolean eq = pkFields.containsKey(destField);
        if (eq) {
            pkFields.remove(destField);
            return eq;
        }
        return false;
    }

    private Map<String, String> getTableLink(DynamicObject dataMap, String table) {
        HashMap<String, String> linkField = new HashMap<String, String>();
        DynamicObjectCollection tableLinks = (DynamicObjectCollection)dataMap.get("entryentity");
        if (tableLinks != null && tableLinks.size() > 0) {
            for (DynamicObject tableLink : tableLinks) {
                if (!table.equalsIgnoreCase(tableLink.getString("key_srctable"))) continue;
                linkField.put(tableLink.getString("key_desttablefield"), tableLink.getString("key_srctablefield"));
            }
        }
        return linkField;
    }

    private DynamicObject getRowObj(String destField, String srcField, DynamicObjectCollection fields) {
        for (DynamicObject temp : fields) {
            String fieldName = temp.getString(PROP_MAPPING_TAR_COLUMN);
            String fieldName3 = temp.getString(PROP_MAPPING_SRC_COLUMN);
            if (!fieldName.equalsIgnoreCase(destField) || !fieldName3.equalsIgnoreCase(srcField)) continue;
            return temp;
        }
        return fields.addNew();
    }

    private DynamicObject getISCSelfLink() {
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("database_type", "=", (Object)"self");
        return orm.queryOne("isc_database_link", new QFilter[]{f1});
    }

    private DynamicObject getDataSrcObj(Long linkId) {
        ORM orm = ORM.create();
        QFilter f2 = new QFilter("dblink", "=", (Object)linkId);
        return orm.queryOne(ENTRY_ISC_DATA_SOURCE, new QFilter[]{f2});
    }

    private DynamicObject getISCDataMapObj(String number) {
        ORM orm = ORM.create();
        QFilter f1 = new QFilter(PROP_NUMBER, "=", (Object)number);
        DynamicObject map = orm.queryOne(ENTRY_ISC_DATA_COPY, new QFilter[]{f1});
        Long id = map.getLong(PROP_ID);
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTRY_ISC_DATA_COPY);
    }

    private DynamicObject getLinkObj(DynamicObject srcTableInfo) {
        DynamicObject link = (DynamicObject)srcTableInfo.get("link");
        Long linkId = link.getLong("masterid");
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("masterid", "=", (Object)linkId);
        return orm.queryOne(ENTRY_DATACONNECTION, new QFilter[]{f1});
    }

    private boolean isExistsDataMap(String number) {
        QFilter f1 = new QFilter(PROP_NUMBER, "=", (Object)number);
        return QueryServiceHelper.exists((String)ENTRY_ISC_DATA_COPY, (QFilter[])new QFilter[]{f1});
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u521b\u5efa", (String)"DataMapSubmitOp_3", (String)"mmc-phm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

