/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.basemanager.ScheduleConsts;
import kd.mmc.phm.common.util.DataCopyTaskUtil;

public class DataPumpEnableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("data_mapping");
        fieldKeys.add("validated_time");
        fieldKeys.add("expired_time");
        fieldKeys.add("repeatmode");
        fieldKeys.add("txtdesc");
        fieldKeys.add("cyclenum");
        fieldKeys.add("combdorw");
        fieldKeys.add("comno");
        fieldKeys.add("comweek");
        fieldKeys.add("ckbyweek");
        fieldKeys.add("plan");
        fieldKeys.addAll(ScheduleConsts.CKDATE);
        fieldKeys.addAll(ScheduleConsts.CKWEEK);
        fieldKeys.addAll(ScheduleConsts.CKMONTH);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] triggers = DataCopyTaskUtil.getTriggersByDataPump((DynamicObject[])dataEntities);
        if (StringUtils.equals((CharSequence)"enable", (CharSequence)e.getOperationKey())) {
            for (DynamicObject trigger : triggers) {
                trigger.set("enable", (Object)EnableEnum.ENABLE.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])triggers);
            Object[] objectArray = this.createJobs(dataEntities);
            Object[] scheduleIds = this.createSchedules(dataEntities, objectArray);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            int length = dataEntities.length;
            for (int i = 0; i < length; ++i) {
                scheduleManager.enableJob((String)objectArray[i]);
                scheduleManager.enableSchedule((String)scheduleIds[i]);
            }
        } else {
            for (DynamicObject trigger : triggers) {
                trigger.set("enable", (Object)EnableEnum.DISABLE.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])triggers);
            Object[] objectArray = this.disableJobs(dataEntities);
            Object[] scheduleIds = this.disableSchedules(dataEntities);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            int length = dataEntities.length;
            for (int i = 0; i < length; ++i) {
                scheduleManager.disableJob((String)objectArray[i]);
                scheduleManager.disableSchedule((String)scheduleIds[i]);
            }
        }
    }

    private Object[] disableJobs(DynamicObject[] dataPumps) {
        int length = dataPumps.length;
        DynamicObject[] jobs = new DynamicObject[length];
        for (int i = 0; i < length; ++i) {
            jobs[i] = DataCopyTaskUtil.disableJob((DynamicObject)dataPumps[i]);
        }
        return this.saveSchDymamicObject("sch_job", jobs);
    }

    private Object[] disableSchedules(DynamicObject[] dataPumps) {
        int length = dataPumps.length;
        DynamicObject[] schedules = new DynamicObject[length];
        for (int i = 0; i < length; ++i) {
            schedules[i] = DataCopyTaskUtil.disableSchedule((DynamicObject)dataPumps[i]);
        }
        return this.saveSchDymamicObject("sch_schedule", schedules);
    }

    private Object[] createJobs(DynamicObject[] dataPumps) {
        int length = dataPumps.length;
        DynamicObject[] jobs = new DynamicObject[length];
        for (int i = 0; i < length; ++i) {
            jobs[i] = DataCopyTaskUtil.createJob((DynamicObject)dataPumps[i]);
        }
        return this.saveSchDymamicObject("sch_job", jobs);
    }

    private Object[] createSchedules(DynamicObject[] dataPumps, Object[] jobIds) {
        int length = dataPumps.length;
        DynamicObject[] schedules = new DynamicObject[length];
        for (int i = 0; i < length; ++i) {
            schedules[i] = DataCopyTaskUtil.createSchedule((DynamicObject)dataPumps[i], (Object)jobIds[i]);
        }
        return this.saveSchDymamicObject("sch_schedule", schedules);
    }

    private Object[] saveSchDymamicObject(String entityNumber, DynamicObject[] dataEntities) {
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        DataCopyTaskUtil.check((OperationResult)operationResult);
        return operationResult.getSuccessPkIds().toArray();
    }
}

