/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.util.DataCopyTaskUtil;
import kd.mmc.phm.common.util.DataMapUtils;
import kd.mmc.phm.opplugin.validator.DataPumpSaveValidator;

public class DataPumpSaveOp
extends AbstractOperationServicePlugIn {
    private static final ThreadLocal<DynamicObjectCollection> THREAD_LOCAL = new ThreadLocal();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DataPumpSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject currObj = e.getDataEntities()[0];
        QFilter[] filters = new QFilter("id", "=", currObj.getPkValue()).toArray();
        DynamicObjectCollection oldObjs = QueryServiceHelper.query((String)"phm_datapump", (String)"number, entryentity.data_mapping, entryentity.data_mapping.number", (QFilter[])filters);
        THREAD_LOCAL.set(oldObjs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject dataPump = e.getDataEntities()[0];
        try {
            DynamicObjectCollection savedDynamicObjColl = THREAD_LOCAL.get();
            String number = dataPump.getString("number");
            if (savedDynamicObjColl != null && !savedDynamicObjColl.isEmpty()) {
                number = ((DynamicObject)savedDynamicObjColl.get(0)).getString("number");
                this.deleteTrigger(dataPump, savedDynamicObjColl);
            }
            this.createTrigger(dataPump, number);
        }
        finally {
            THREAD_LOCAL.remove();
        }
    }

    private void createTrigger(DynamicObject dataEntity, String number) {
        DynamicObjectCollection entryCollection = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<Object> mappingIds = new ArrayList<Object>();
        for (DynamicObject entry : entryCollection) {
            mappingIds.add(entry.getDynamicObject("data_mapping").getPkValue());
        }
        Map iscDataCopyMainMap = DataMapUtils.getIscDataCopyMap(mappingIds, (boolean)true);
        Map iscDataCopyNextMap = DataMapUtils.getIscDataCopyMap(mappingIds, (boolean)false);
        HashSet<DynamicObject> triggerSet = new HashSet<DynamicObject>(entryCollection.size());
        for (DynamicObject entry : entryCollection) {
            DynamicObject mapping = entry.getDynamicObject("data_mapping");
            triggerSet.add(this.setTriggerData(dataEntity, mapping, iscDataCopyMainMap, iscDataCopyNextMap, number));
        }
        SaveServiceHelper.save((DynamicObject[])triggerSet.toArray(new DynamicObject[0]));
    }

    private void deleteTrigger(DynamicObject currObj, DynamicObjectCollection savedDynamicObjColl) {
        Map<String, Long> oldMappingMap = this.getDeletedMappingMap(savedDynamicObjColl, currObj);
        if (oldMappingMap.isEmpty()) {
            return;
        }
        String number = ((DynamicObject)savedDynamicObjColl.get(0)).getString("number");
        ArrayList<String> triggerNumbers = new ArrayList<String>(oldMappingMap.size());
        for (Map.Entry<String, Long> entry : oldMappingMap.entrySet()) {
            triggerNumbers.add(number + "_" + entry.getKey());
        }
        DataCopyTaskUtil.deleteTrigger(triggerNumbers);
    }

    private Map<String, Long> getDeletedMappingMap(DynamicObjectCollection oldObjs, DynamicObject currObj) {
        HashMap<String, Long> oldMappingMap = new HashMap<String, Long>(16);
        for (DynamicObject oldObj : oldObjs) {
            String mappingNumber = oldObj.getString("entryentity.data_mapping.number");
            long mappingId = oldObj.getLong("entryentity.data_mapping");
            oldMappingMap.put(mappingNumber, mappingId);
        }
        DynamicObjectCollection entryCollection = currObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCollection) {
            DynamicObject mapping = entry.getDynamicObject("data_mapping");
            long mappingId = mapping.getLong("id");
            if (!oldMappingMap.containsValue(mappingId)) continue;
            oldMappingMap.remove(mapping.getString("number"));
        }
        return oldMappingMap;
    }

    private DynamicObject setTriggerData(DynamicObject dataPump, DynamicObject mapping, Map<Long, List<Object>> iscDataCopyMainMap, Map<Long, List<Object>> iscDataCopyMap, String number) {
        String triggerNumber = number + "_" + mapping.getString("number");
        DynamicObject trigger = DataCopyTaskUtil.getExistedTrigger((String)triggerNumber);
        trigger.set("number", (Object)(dataPump.getString("number") + "_" + mapping.getString("number")));
        trigger.set("name", dataPump.get("name"));
        trigger.set("creator", dataPump.get("creator"));
        trigger.set("createtime", dataPump.get("createtime"));
        trigger.set("modifier", dataPump.get("modifier"));
        trigger.set("modifytime", dataPump.get("modifytime"));
        trigger.set("trigger_type", (Object)"manual");
        trigger.set("enable", (Object)EnableEnum.DISABLE.getValue());
        trigger.set("retry_count_str", (Object)"0");
        trigger.set("thread_ubound", (Object)5);
        trigger.set("batch_size", (Object)3000);
        if (!iscDataCopyMainMap.isEmpty()) {
            trigger.set("data_copy", iscDataCopyMainMap.get(mapping.getLong("id")).get(0));
        }
        ArrayList nextTaskIds = new ArrayList();
        DataCopyTaskUtil.getAllNextTaskId((DynamicObject)trigger, nextTaskIds);
        DeleteServiceHelper.delete((IDataEntityType)trigger.getDynamicObjectType(), (Object[])nextTaskIds.toArray());
        DynamicObjectCollection mainNextTasks = trigger.getDynamicObjectCollection("next_tasks");
        mainNextTasks.clear();
        List<Object> copyTriggerIds = iscDataCopyMap.get(mapping.getLong("id"));
        if (Objects.nonNull(copyTriggerIds)) {
            ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(copyTriggerIds.size());
            int size = copyTriggerIds.size();
            for (int i = 0; i < copyTriggerIds.size(); ++i) {
                DynamicObject newTrigger = (DynamicObject)OrmUtils.clone((Object)trigger, (IDataEntityType)trigger.getDynamicObjectType(), (boolean)false, (boolean)true);
                Object copyTriggerId = copyTriggerIds.get(i);
                newTrigger.set("number", (Object)(dataPump.getString("number") + "_" + copyTriggerId));
                newTrigger.set("name", (Object)(dataPump.get("name") + "_" + size--));
                newTrigger.set("enable", (Object)EnableEnum.ENABLE.getValue());
                newTrigger.set("data_copy_id", copyTriggerId);
                if (i != 0) {
                    DynamicObjectCollection nextTasks = newTrigger.getDynamicObjectCollection("next_tasks");
                    DynamicObject nextTask = nextTasks.addNew();
                    nextTask.set("next_task", ((DynamicObject)tasks.get(i - 1)).getPkValue());
                }
                Object[] savedTriggers = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTrigger});
                tasks.add((DynamicObject)savedTriggers[0]);
            }
            if (!tasks.isEmpty()) {
                DynamicObject mainNextTask = mainNextTasks.addNew();
                mainNextTask.set("next_task", ((DynamicObject)tasks.get(tasks.size() - 1)).getPkValue());
            }
        }
        DynamicObjectCollection eventHandlers = trigger.getDynamicObjectCollection("event_handlers");
        DynamicObject taskSuccessHandlers = eventHandlers.addNew();
        taskSuccessHandlers.set("datacopy_event", (Object)"OnTaskSuccess");
        taskSuccessHandlers.set("target_consumer", (Object)"TargetSystem");
        taskSuccessHandlers.set("event_handler", (Object)"msvc://mmc.phm.ITaskHandleService.afterTask");
        return trigger;
    }
}

