/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.basemanager.ColumnEntry;
import kd.mmc.phm.common.enums.VType;
import kd.mmc.phm.common.util.DBUtils;

public class DataTableSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String PROP_ENTRYENTITY = "entryentity";
    private static final String PROP_FIELDLENGTH = "fieldlength";
    private static final String PROP_FIELDDESCRIPTION = "fielddescription";
    private static final String PROP_FIELDNAME = "fieldname";
    private static final String PROP_FIELDTYPE = "fieldtype";
    private static final String PROP_PRIMARYKEY = "primarykey";
    private static final String PROP_DEFVALUE = "defvalue";
    private static final String DBROUEKEY = "phm";
    private static final String DATATYPE_BIGINT = "BIGINT";
    private static final String DATATYPE_NVARCHAR = "NVARCHAR";
    private static final String DATATYPE_DATETIME = "DATETIME";
    private static final String DATATYPE_DECIMAL = "DECIMAL";
    private static final String DATATYPE_NCLOB = "NCLOB";
    private final StringBuilder errMsg = new StringBuilder();

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ORM orm = ORM.create();
        int size = e.getValidExtDataEntities().size();
        ArrayList<Long> ids = new ArrayList<Long>(size);
        HashMap<String, Integer> rowIndex = new HashMap<String, Integer>(size);
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject obj = dataEntity.getDataEntity();
            ids.add(obj.getLong("id"));
            rowIndex.put(obj.getString("id"), dataEntity.getDataEntityIndex());
        }
        QFilter f = new QFilter("id", "in", ids);
        DynamicObjectCollection entitys = orm.query("phm_datatable", new QFilter[]{f});
        for (DynamicObject entity : entitys) {
            String tableName = entity.getString("number");
            String id = entity.getString("id");
            DynamicObjectCollection colInfos = entity.getDynamicObjectCollection(PROP_ENTRYENTITY);
            if (this.creatTable(tableName, colInfos, Long.parseLong(id))) continue;
            e.cancel = true;
            this.addErrMessage(id, (Integer)rowIndex.get(id), this.errMsg.toString());
        }
    }

    private boolean creatTable(String tableName, DynamicObjectCollection colInfos, long id) {
        try {
            List<ColumnEntry> cols = this.colPackag(colInfos);
            DBRoute dbRoute = new DBRoute(DBROUEKEY);
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)DBROUEKEY, (String)tableName);
            List<String> sqlList = tableSchema == null ? this.getCreatTableSql(tableName, cols) : this.getUpdateTableSql(tableName, cols, tableSchema);
            if (sqlList.size() > 0) {
                for (String sql : sqlList) {
                    this.execute(dbRoute, sql);
                    this.insertDataAndCreateReleation(dbRoute, tableName, id);
                }
            }
            return true;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception e) {
            this.errMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u8868\u521b\u5efa\u6216\u66f4\u65b0\u5931\u8d25\uff1a", (String)"DataTableSubmitOp_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
            this.errMsg.append(e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6570\u636e\u8868\u521b\u5efa\u6216\u66f4\u65b0\u5931\u8d25\uff1a%s", (String)"DataTableSubmitOp_1", (String)"mmc-phm-opplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private void insertDataAndCreateReleation(DBRoute dbRoute, String tableName, long id) {
        if (this.getOption().containsVariable("params")) {
            String paramsJson = this.getOption().getVariableValue("params");
            Map params = (Map)SerializationUtils.fromJsonString((String)paramsJson, HashMap.class);
            this.insertData(dbRoute, tableName, params);
            this.createReleation(params, id);
        }
    }

    private void insertData(DBRoute dbRoute, String tableName, Map<String, Object> params) {
        List sortedColLabels = (List)params.get("sortedColLabels");
        Map colTypes = (Map)params.get("colTypes");
        Map datas = (Map)params.get("datas");
        List rows = (List)datas.get("rows");
        if (rows.isEmpty()) {
            return;
        }
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO ").append(tableName.toUpperCase()).append(" (");
        int size = sortedColLabels.size();
        block2: for (int i = 0; i < size; ++i) {
            String sortedColLabel = (String)sortedColLabels.get(i);
            insertSql.append(sortedColLabel);
            if (i == size - 1) {
                insertSql.append(") VALUES (");
                for (int j = 0; j < size; ++j) {
                    insertSql.append('?');
                    if (j == size - 1) {
                        insertSql.append(')');
                        break block2;
                    }
                    insertSql.append(',');
                }
            }
            insertSql.append(',');
        }
        ArrayList values = Lists.newArrayListWithExpectedSize((int)rows.size());
        for (List row : rows) {
            Object[] value = new Object[size];
            for (int i = 0; i < sortedColLabels.size(); ++i) {
                Object rowData = row.get(i);
                if (rowData instanceof Long) {
                    String colType = (String)colTypes.get(sortedColLabels.get(i));
                    if (VType.TIMESTAMP.name().equals(colType)) {
                        rowData = new Date((Long)rowData);
                    }
                }
                value[i] = rowData;
            }
            values.add(value);
        }
        try {
            DBUtils.executeBatch((String)insertSql.toString(), (List)values);
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, new ErrorCode("SAVE_FAILED", ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25: %s", (String)"DataTableSubmitOp_2", (String)"mmc-phm-opplugin", (Object[])new Object[0])), new Object[]{exception.getMessage()});
        }
    }

    private void createReleation(Map<String, Object> params, long id) {
        String entryIdStr = (String)params.get("entryId");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_eigenvalue_releation"));
        dynamicObject.set("eigenvalueentryid", (Object)Long.parseLong(entryIdStr));
        dynamicObject.set("datatable_id", (Object)id);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void execute(DBRoute dbRoute, String sql) {
        DB.execute((DBRoute)dbRoute, (String)sql);
    }

    private void updatePK(DBRoute dbRoute, String tableName, String pkCols) {
        StringBuilder sb = new StringBuilder();
        String pkName = "pk_" + (tableName.length() > 2 ? tableName.substring(2) : tableName);
        List oldPks = DB.getPrimaryKeys((DBRoute)dbRoute, (String)tableName);
        if (oldPks != null && oldPks.size() > 0) {
            sb.append("alter table ");
            sb.append(tableName);
            sb.append(" drop CONSTRAINT ");
            sb.append(pkName);
            DB.execute((DBRoute)dbRoute, (String)sb.toString());
        }
        sb.setLength(0);
        sb.append("ALTER TABLE ");
        sb.append(tableName);
        sb.append(" ADD CONSTRAINT ");
        sb.append(pkName);
        sb.append(" PRIMARY KEY(");
        sb.append(pkCols);
        sb.append(')');
        DB.execute((DBRoute)dbRoute, (String)sb.toString());
    }

    private String getNewPk(List<ColumnEntry> cols, String tableName) {
        DBRoute dbRoute = new DBRoute(DBROUEKEY);
        StringBuilder pkCol = new StringBuilder();
        List oldPks = DB.getPrimaryKeys((DBRoute)dbRoute, (String)tableName);
        ArrayList<String> newPks = new ArrayList<String>();
        for (ColumnEntry columnEntry : cols) {
            if (!columnEntry.getIsPK().booleanValue()) continue;
            newPks.add(columnEntry.getColName());
        }
        if (!this.compare(oldPks, newPks)) {
            for (String string : newPks) {
                if (pkCol.length() > 0) {
                    pkCol.append(',');
                }
                pkCol.append(string);
            }
        }
        return pkCol.toString();
    }

    private boolean compare(List<String> list1, List<String> list2) {
        if (list1 != null && list2 != null) {
            if (list1.size() != list2.size()) {
                return false;
            }
            for (String str : list1) {
                if (list2.contains(str)) continue;
                return false;
            }
            for (String str : list2) {
                if (list1.contains(str)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<String> getCreatTableSql(String tableName, List<ColumnEntry> cols) {
        StringBuilder sb = new StringBuilder();
        StringBuilder pKCol = new StringBuilder();
        sb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", tableName));
        sb.append(String.format("CREATE TABLE %s (", tableName));
        for (ColumnEntry col : cols) {
            sb.append(this.getColStr(col));
            sb.append(", ");
            String colName = col.getColName().toUpperCase();
            if (!col.getIsPK().booleanValue()) continue;
            if (pKCol.length() != 0) {
                pKCol.append(',');
            }
            pKCol.append(colName);
        }
        if (pKCol.length() > 0) {
            sb.append("CONSTRAINT ");
            String pkName = "pk_" + (tableName.length() > 2 ? tableName.substring(2) : tableName);
            sb.append(pkName);
            sb.append(" PRIMARY KEY(");
            sb.append((CharSequence)pKCol);
            sb.append("));");
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(sb.toString());
        return sqlList;
    }

    private String getColStr(ColumnEntry col) {
        StringBuilder sb = new StringBuilder();
        String tempString = " NOT NULL DEFAULT ";
        String colName = col.getColName().toUpperCase();
        String dataType = col.getColType();
        sb.append(colName);
        sb.append(' ');
        sb.append(col.getColType());
        if (dataType.equalsIgnoreCase(DATATYPE_BIGINT)) {
            sb.append(" NOT NULL DEFAULT ");
            sb.append(col.getDefValue());
        } else if (dataType.equalsIgnoreCase(DATATYPE_NVARCHAR)) {
            sb.append('(');
            sb.append(col.getColLength());
            sb.append(')');
            sb.append(tempString);
            sb.append(col.getDefValue());
        } else if (dataType.equalsIgnoreCase(DATATYPE_DECIMAL)) {
            sb.append("(25,10)");
            sb.append(tempString);
            sb.append(col.getDefValue());
        } else if (dataType.equalsIgnoreCase(DATATYPE_NCLOB)) {
            sb.append(tempString);
            sb.append(col.getDefValue());
        }
        return sb.toString();
    }

    private List<String> getUpdateTableSql(String tableName, List<ColumnEntry> cols, DbMetadataTable tableSchema) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> sqlList = new ArrayList<String>();
        for (ColumnEntry col : cols) {
            String colName = col.getColName();
            if (DataTableSubmitOp.existsFieldInTableSchema(tableSchema, colName) || StringUtils.isEmpty((String)colName)) continue;
            sb.setLength(0);
            sb.append(String.format("ALTER TABLE %s ADD (", tableName));
            sb.append(this.getColStr(col));
            sb.append(')');
            sqlList.add(sb.toString());
        }
        return sqlList;
    }

    private static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((String)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(null));
        }
        return exists;
    }

    private List<ColumnEntry> colPackag(DynamicObjectCollection colInfos) {
        ArrayList<ColumnEntry> cols = new ArrayList<ColumnEntry>();
        for (DynamicObject colObj : colInfos) {
            ColumnEntry col = new ColumnEntry();
            col.setColName(colObj.getString(PROP_FIELDNAME));
            col.setColDescribe(colObj.getString(PROP_FIELDDESCRIPTION));
            col.setColType(colObj.getString(PROP_FIELDTYPE));
            col.setColLength(colObj.getLong(PROP_FIELDLENGTH));
            col.setIsPK(Boolean.valueOf(colObj.getBoolean(PROP_PRIMARYKEY)));
            if (colObj.getString(PROP_DEFVALUE).isEmpty()) {
                if (col.getColType().equalsIgnoreCase(DATATYPE_BIGINT) || col.getColType().equalsIgnoreCase(DATATYPE_DECIMAL)) {
                    col.setDefValue("0");
                } else if (col.getColType().equalsIgnoreCase(DATATYPE_NVARCHAR) || col.getColType().equalsIgnoreCase(DATATYPE_NCLOB)) {
                    col.setDefValue("' '");
                }
            } else if (col.getColType().equalsIgnoreCase(DATATYPE_NVARCHAR)) {
                col.setDefValue("'" + colObj.getString(PROP_DEFVALUE) + "'");
            } else {
                col.setDefValue(colObj.getString(PROP_DEFVALUE));
            }
            cols.add(col);
        }
        return cols;
    }

    private void addErrMessage(String id, int dataIndex, String errMsg) {
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", (Object)id, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u6570\u636e\u8868\u521b\u5efa", (String)"DataTableSubmitOp_3", (String)"mmc-phm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

