/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager;

import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class MetaDataSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRY_DATACONNECTION = "phm_dataconnection";
    private static final String ENTRY_ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String ENTRY_ISC_DATA_SOURCE = "isc_data_source";
    private static final String PROP_ID = "id";
    private static final String PROP_TABLE_NAME = "table_name";
    private static final String PROP_GROUP = "group";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_FULLNAME = "fullname";
    private static final String PROP_FULL_NAME = "full_name";
    private static final String PROP_CREATOR = "creator";
    private static final String PROP_NAME = "name";
    private static final String PROP_CREATETIME = "createtime";
    private static final String PROP_MODIFIER = "modifier";
    private static final String PROP_MODIFYTIME = "modifytime";
    private static final String PROP_TYPE = "type";
    private static final String PROP_SRCFIELD = "srcfield";
    private static final String PROP_PARAM_JST = "param_jst";
    private static final String PROP_RESULT_JST = "result_jst";
    private static final String PROP_PARAM_NUMBER = "param_number";
    private static final String PROP_PARAM_TYPE = "param_type";
    private static final String PROP_PARAM_SCHEMA = "param_schema";
    private static final String PROP_RESULT_NUMBER = "result_number";
    private static final String PROP_RESULT_TYPE = "result_type";
    private static final String PROP_RESULT_SCHEMA = "result_schema";
    private static final LocalMemoryCache cache;

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject meta = dataEntity.getDataEntity();
            DynamicObject metaObj = BusinessDataServiceHelper.loadSingle((Object)meta.getLong(PROP_ID), (String)"phm_metadatamanager");
            OperationResult result = this.createISCMetaDataSchemaByDestTable(metaObj);
            if (result == null) {
                e.setCancel(true);
                this.addErrMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u76ee\u6807\u8868\u96c6\u6210\u5bf9\u8c61\u5931\u8d25,\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff01", (String)"MetaDataSubmitOp_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                return;
            }
            if (result.isSuccess()) {
                List pkId = result.getSuccessPkIds();
                long metaId = Long.parseLong(pkId.get(0).toString());
                metaObj.set("iscschemaid", (Object)metaId);
                SaveServiceHelper.update((DynamicObject)metaObj);
                cache.clear();
                continue;
            }
            e.setCancel(true);
            this.addErrMessage(dataEntity, this.getErrorInfo(result));
        }
    }

    private String getErrorInfo(OperationResult result) {
        List vErr;
        List err = result.getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        if (err.size() > 0) {
            for (OperateErrorInfo errInfo : err) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        if ((vErr = result.getAllErrorOrValidateInfo()).size() > 0) {
            for (IOperateInfo errInfo : vErr) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        return sb.toString();
    }

    private DynamicObject getISCSelfLink() {
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("database_type", "=", (Object)"self");
        return orm.queryOne("isc_database_link", new QFilter[]{f1});
    }

    private OperationResult createISCMetaDataSchemaByDestTable(DynamicObject metaObj) {
        ORM orm = ORM.create();
        DynamicObject tarTable = (DynamicObject)metaObj.get("targetdatatable");
        String table = tarTable.getString(PROP_NUMBER);
        table = table + "@phm";
        DynamicObject currLink = this.getISCSelfLink();
        QFilter f2 = new QFilter("dblink", "=", (Object)currLink.getLong(PROP_ID));
        DynamicObject iscDataSource = orm.queryOne(ENTRY_ISC_DATA_SOURCE, new QFilter[]{f2});
        if (iscDataSource == null) {
            return null;
        }
        String dsId = iscDataSource.getString(PROP_ID);
        return this.createDESTTableISCSchema(metaObj, tarTable, dsId, table);
    }

    private OperationResult createDESTTableISCSchema(DynamicObject meta, DynamicObject tarTable, String dsId, String tableName) {
        ORM orm = ORM.create();
        boolean isExists = this.isExistsMeta(dsId, tableName);
        DynamicObject iscMetaObj = isExists ? this.getSchema(dsId, tableName) : orm.newDynamicObject(ENTRY_ISC_METADATA_SCHEMA);
        iscMetaObj.set(PROP_TYPE, (Object)meta.getString(PROP_TYPE));
        iscMetaObj.set(PROP_GROUP, (Object)dsId);
        iscMetaObj.set("group_id", (Object)dsId);
        iscMetaObj.set(PROP_NUMBER, (Object)tableName);
        if (!StringUtils.isEmpty((String)meta.getString(PROP_FULLNAME))) {
            iscMetaObj.set(PROP_FULL_NAME, (Object)meta.getString(PROP_FULLNAME));
        } else {
            iscMetaObj.set(PROP_FULL_NAME, (Object)tableName);
        }
        iscMetaObj.set(PROP_TABLE_NAME, (Object)tableName);
        iscMetaObj.set(PROP_NAME, (Object)tarTable.getString(PROP_NAME));
        iscMetaObj.set("state", (Object)"S");
        iscMetaObj.set("error_stack", null);
        iscMetaObj.set("error_stack_tag", null);
        iscMetaObj.set("remark", (Object)meta.getString("remarks"));
        iscMetaObj.set("is_init", (Object)Boolean.TRUE);
        DynamicObject temp = (DynamicObject)meta.get(PROP_CREATOR);
        iscMetaObj.set(PROP_CREATOR, (Object)temp.getLong(PROP_ID));
        iscMetaObj.set(PROP_CREATETIME, (Object)meta.getDate(PROP_CREATETIME));
        temp = (DynamicObject)meta.get(PROP_MODIFIER);
        iscMetaObj.set(PROP_MODIFIER, (Object)temp.getLong(PROP_ID));
        iscMetaObj.set(PROP_MODIFYTIME, (Object)meta.getDate(PROP_MODIFYTIME));
        iscMetaObj.set("status", (Object)"A");
        iscMetaObj.set("enable", (Object)"1");
        iscMetaObj.set(PROP_PARAM_JST, (Object)meta.getString(PROP_PARAM_JST));
        iscMetaObj.set("param_jst_tag", (Object)meta.getString("param_jst_tag"));
        iscMetaObj.set(PROP_RESULT_JST, (Object)meta.getString(PROP_RESULT_JST));
        iscMetaObj.set("result_jst_tag", (Object)meta.getString("result_jst_tag"));
        DynamicObjectCollection iscFieldInfos = iscMetaObj.getDynamicObjectCollection("prop_entryentity");
        iscFieldInfos.clear();
        DynamicObjectCollection fields = (DynamicObjectCollection)tarTable.get("entryentity");
        int i = 1;
        for (DynamicObject field : fields) {
            DynamicObject iscField = this.getRowObj(field, iscFieldInfos);
            iscField.set("prop_index", (Object)i);
            iscField.set("prop_name", (Object)field.getString("fieldname"));
            iscField.set("prop_label", (Object)field.getString("fielddescription"));
            iscField.set("data_type", (Object)field.getString("fieldtype"));
            iscField.set("is_primary_key", (Object)field.getString("primarykey"));
            ++i;
        }
        DynamicObjectCollection iscParam = iscMetaObj.getDynamicObjectCollection("param_entryentity");
        DynamicObjectCollection params = (DynamicObjectCollection)meta.get("param");
        i = 1;
        for (DynamicObject p : params) {
            DynamicObject prop = iscParam.addNew();
            prop.set("param_index", (Object)i);
            prop.set(PROP_PARAM_NUMBER, (Object)p.getString(PROP_PARAM_NUMBER));
            prop.set(PROP_PARAM_TYPE, (Object)p.getString(PROP_PARAM_TYPE));
            prop.set(PROP_PARAM_SCHEMA, (Object)p.getString(PROP_PARAM_SCHEMA));
            prop.set("param_remark", (Object)p.getString("param_remarks"));
            ++i;
        }
        i = 1;
        DynamicObjectCollection iscResult = iscMetaObj.getDynamicObjectCollection("result_entryentity");
        DynamicObjectCollection results = (DynamicObjectCollection)meta.get("result");
        for (DynamicObject r : results) {
            DynamicObject prop = iscResult.addNew();
            prop.set("seq", (Object)(++i));
            prop.set("result_index", (Object)i);
            prop.set(PROP_RESULT_NUMBER, (Object)r.getString(PROP_RESULT_NUMBER));
            prop.set(PROP_RESULT_TYPE, (Object)r.getString(PROP_RESULT_TYPE));
            prop.set(PROP_RESULT_SCHEMA, (Object)r.getString(PROP_RESULT_SCHEMA));
            prop.set("result_remark", r.get("result_remarks"));
            ++i;
        }
        return SaveServiceHelper.saveOperate((String)ENTRY_ISC_METADATA_SCHEMA, (DynamicObject[])new DynamicObject[]{iscMetaObj}, (OperateOption)OperateOption.create());
    }

    private DynamicObject getRowObj(DynamicObject field, DynamicObjectCollection fields) {
        String fieldName1 = field.getString("fieldname");
        for (DynamicObject temp : fields) {
            String fieldName = temp.getString("prop_name");
            if (!fieldName.equalsIgnoreCase(fieldName1)) continue;
            return temp;
        }
        return fields.addNew();
    }

    private DynamicObject getSchema(String dsId, String tableName) {
        ORM orm = ORM.create();
        QFilter f1 = new QFilter(PROP_GROUP, "=", (Object)Long.parseLong(dsId));
        QFilter f2 = new QFilter(PROP_TABLE_NAME, "=", (Object)tableName);
        DynamicObject metaObj = orm.queryOne(ENTRY_ISC_METADATA_SCHEMA, PROP_ID, new QFilter[]{f1, f2});
        Long id = metaObj.getLong(PROP_ID);
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTRY_ISC_METADATA_SCHEMA);
    }

    private boolean isExistsMeta(String dsId, String tableName) {
        QFilter f1 = new QFilter(PROP_GROUP, "=", (Object)Long.parseLong(dsId));
        QFilter f2 = new QFilter(PROP_TABLE_NAME, "=", (Object)tableName);
        return QueryServiceHelper.exists((String)ENTRY_ISC_METADATA_SCHEMA, (QFilter[])new QFilter[]{f1, f2});
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u521b\u5efa\u5931\u8d25", (String)"MetaDataSubmitOp_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(128);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_TABLE_SCHEMA", "bd", info);
    }
}

