/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.basemanager.target;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.phm.common.util.ScheduleUtils;

public class TargetPublishOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TargetPublishOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            Object id = dynamicObject.get("id");
            DynamicObject targetdefine = BusinessDataServiceHelper.loadSingle((Object)id, (String)"phm_targetdefine");
            List<String> rates = this.getRate(targetdefine);
            this.creatPlan(rates, targetdefine);
        }
    }

    private void creatPlan(List<String> rates, DynamicObject targetdefine) {
        for (String rate : rates) {
            String rateSign = this.getRateSign(rate);
            OperationResult rateJob = ScheduleUtils.createRateJob((DynamicObject)targetdefine, (String)rateSign);
            if (rateJob.isSuccess()) {
                Object pkid = rateJob.getSuccessPkIds().get(0);
                Date rateStartTime = ScheduleUtils.getRateStartTime((String)rateSign, (Date)new Date());
                ScheduleUtils.createRateSchedule((String)pkid.toString(), (DynamicObject)targetdefine, (String)rateSign, (Date)rateStartTime);
                continue;
            }
            logger.error(ResManager.loadKDString((String)"\u521b\u5efa\u8003\u6838\u9891\u7387\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25", (String)"TargetPublishOp_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
        }
    }

    private String getRateSign(String rate) {
        if ("1".equals(rate)) {
            return "YEAR";
        }
        if ("2".equals(rate)) {
            return "HALFYEAR";
        }
        if ("3".equals(rate)) {
            return "QUARTER";
        }
        if ("4".equals(rate)) {
            return "MONTH";
        }
        if ("5".equals(rate)) {
            return "TENDAYS";
        }
        if ("6".equals(rate)) {
            return "WEEK";
        }
        if ("7".equals(rate)) {
            return "DAY";
        }
        return "";
    }

    private List<String> getRate(DynamicObject targetdefine) {
        String checkrate = targetdefine.getString("checkrate");
        String[] split = checkrate.split(",");
        ArrayList<String> rateList = new ArrayList<String>(split.length);
        for (String rate : split) {
            if (rate.isEmpty()) continue;
            rateList.add(rate);
        }
        return rateList;
    }
}

